/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.sjjt.provisionitem;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class ProvisionItemStrategyService {
    public static BigDecimal calculateTotalTax(long mainId, String dgBill, String zlbBill, List<String> ewblxh, List<String> params) {
        BigDecimal result = BigDecimal.ZERO;
        DynamicObject draftObject = QueryServiceHelper.queryOne((String)dgBill, (String)"sbbid", (QFilter[])new QFilter[]{new QFilter("mainid", "=", (Object)mainId)});
        if (draftObject != null) {
            String sbbid = draftObject.getString("sbbid");
            QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)sbbid);
            QFilter ewbxhFilter = new QFilter("ewblxh", "in", ewblxh);
            DynamicObjectCollection zlbObject = QueryServiceHelper.query((String)zlbBill, (String)StringUtil.join(params, (String)","), (QFilter[])new QFilter[]{sbbidFilter, ewbxhFilter});
            if (zlbObject != null && zlbObject.size() > 0) {
                for (DynamicObject dynamicObject : zlbObject) {
                    for (String param : params) {
                        result = result.add(dynamicObject.getBigDecimal(param));
                    }
                }
            }
        }
        return result;
    }

    public static BigDecimal calculateTax(long mainId, String ... cellNumber) {
        BigDecimal amount = BigDecimal.ZERO;
        QFilter idFilter = new QFilter("entryid", "=", (Object)mainId);
        QFilter cellNumberFilter = new QFilter("cellnumber", "in", (Object)cellNumber);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)MultiTableEnum.TSD001.getDeclareDetailTabled(), (String)"value", (QFilter[])new QFilter[]{idFilter, cellNumberFilter});
        if (CollectionUtils.isNotEmpty((Collection)collection)) {
            amount = collection.stream().map(o -> o.getBigDecimal("value")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        return amount;
    }
}

