/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.taxrefund;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.tcvat.business.service.taxrefund.AccountServiceHelper;
import kd.taxc.tcvat.common.util.ZzsOrgCheckUtil;

public class RefundApplyVerifyService {
    private static final String FAILINFO = "failInfo";
    private static final String CODE = "code";
    private static final String ID = "id";
    private static final Set<String> TSQYLX = new HashSet<String>(Arrays.asList("nlmyy", "zzy", "kxyjhjsfwy", "dlrlrqjsschgyy", "rjhxxjsfwy", "stbhhhjzly", "jtyscchyzy", "pfhlsy", "zshcyy", "jmfwxlhqtfwy", "jy", "wshshgz", "whtyhyly"));

    public static String commonValid(String orgId, String entityName, Date skssqq, Date skssqz) {
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)ID, (Object)orgId));
        TaxResult<Boolean> result = ZzsOrgCheckUtil.licenseCheck(orgId, "tcvat");
        if (result != null && Boolean.TRUE.equals(result.getData())) {
            return result.getMessage();
        }
        Map<String, String> orgEnableMap = ZzsOrgCheckUtil.orgEnable(org);
        if (StringUtils.equalsIgnoreCase((CharSequence)orgEnableMap.get(CODE), (CharSequence)"true")) {
            return orgEnableMap.get(FAILINFO);
        }
        Map<String, String> authMap = ZzsOrgCheckUtil.isTaxPayerAuth(orgId, "tcvat_draft_page_sjjt");
        if (StringUtils.equalsIgnoreCase((CharSequence)authMap.get(CODE), (CharSequence)"true")) {
            return authMap.get(FAILINFO).replace(ResManager.loadKDString((String)"\u8ba1\u7a0e\u548c\u7533\u62a5", (String)"RefundApplyVerifyService_7", (String)"taxc-tcvat", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7559\u62b5\u9000\u7a0e\u7533\u62a5", (String)"RefundApplyVerifyService_8", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        Map<String, String> categoryEnableMap = ZzsOrgCheckUtil.taxCategoryEnable(orgId);
        if (StringUtils.equalsIgnoreCase((CharSequence)categoryEnableMap.get(CODE), (CharSequence)"true")) {
            return categoryEnableMap.get(FAILINFO);
        }
        Map<String, String> singleApplyMap = ZzsOrgCheckUtil.isSingleApply(Long.valueOf(orgId));
        if (StringUtils.equalsIgnoreCase((CharSequence)singleApplyMap.get(CODE), (CharSequence)"true")) {
            return singleApplyMap.get(FAILINFO);
        }
        return RefundApplyVerifyService.validTaxAccount(orgId, skssqq, skssqz);
    }

    public static String validTaxAccount(String orgId, Date skssqq, Date skssqz) {
        Map<String, String> taxLimitCheck = ZzsOrgCheckUtil.checkTaxLimit(Long.valueOf(orgId), skssqq, skssqz);
        if (StringUtils.equalsIgnoreCase((CharSequence)taxLimitCheck.get(CODE), (CharSequence)"true")) {
            return taxLimitCheck.get(FAILINFO);
        }
        Map<String, String> qualifiedMap = RefundApplyVerifyService.isQualified(Long.valueOf(orgId), skssqq, skssqz);
        if (StringUtils.equalsIgnoreCase((CharSequence)qualifiedMap.get(CODE), (CharSequence)"true")) {
            return qualifiedMap.get(FAILINFO);
        }
        return "";
    }

    public static Map<String, String> checkDataInit(Long orgId, DynamicObject accountData) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (null == accountData) {
            String orgName = OrgUtils.getOrgNameById((String)String.valueOf(orgId));
            boolean existTotalData = AccountServiceHelper.existTotalData(orgId);
            if (!existTotalData) {
                map.put(CODE, "true");
                map.put(FAILINFO, String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u5c1a\u672a\u5b8c\u6210\u521d\u59cb\u5316,\u8bf7\u5b8c\u6210\u521d\u59cb\u5316\u540e\u518d\u529e\u7406\u9000\u7a0e\u7533\u8bf7\u3002", (String)"RefundApplyVerifyService_6", (String)"taxc-tcvat", (Object[])new Object[0]), orgName));
                return map;
            }
            map.put(CODE, "true");
            map.put(FAILINFO, String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u5f53\u524d\u7a0e\u671f\u589e\u503c\u7a0e\u7533\u62a5\u8868\u672a\u5ba1\u6279\u901a\u8fc7\uff0c\u8bf7\u5148\u5b8c\u6210\u5ba1\u6279\u3002", (String)"RefundApplyVerifyService_5", (String)"taxc-tcvat", (Object[])new Object[0]), orgName));
            return map;
        }
        return map;
    }

    public static Map<String, String> isQualified(Long orgId, Date skssqq, Date skssqz) {
        String orgName = OrgUtils.getOrgNameById((String)String.valueOf(orgId));
        DynamicObject accountData = AccountServiceHelper.getAccountDataWithDate(orgId, skssqq, skssqz);
        Map<String, String> map = RefundApplyVerifyService.checkDataInit(orgId, accountData);
        if (map.isEmpty()) {
            map.put(CODE, "false");
            map.put(FAILINFO, "");
            BigDecimal bqksqthldtse = accountData.getBigDecimal("bqksqthldtse");
            if (bqksqthldtse.compareTo(BigDecimal.ZERO) <= 0) {
                String nsxydj = accountData.getString("nsxydj");
                if (!"A".equals(nsxydj) && !"B".equals(nsxydj)) {
                    map.put(CODE, "true");
                    map.put(FAILINFO, String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u5f53\u524d\u7eb3\u7a0e\u4fe1\u7528\u7b49\u7ea7\u4e0d\u4e3aA\u6216B\uff0c\u4e0d\u6ee1\u8db3\u7559\u62b5\u9000\u7a0e\u7533\u8bf7\u6761\u4ef6\u3002", (String)"RefundApplyVerifyService_4", (String)"taxc-tcvat", (Object[])new Object[0]), orgName));
                    return map;
                }
                String tsqylx = accountData.getString("tsqylx");
                BigDecimal bqqmldse = accountData.getBigDecimal("amount");
                if (TSQYLX.contains(tsqylx) && bqqmldse.compareTo(BigDecimal.ZERO) < 0) {
                    map.put(CODE, "true");
                    map.put(FAILINFO, ResManager.loadKDString((String)"\u672c\u671f\u671f\u672b\u7559\u62b5\u7a0e\u989d\u4e3a0\uff0c\u65e0\u9700\u529e\u7406\u7559\u62b5\u9000\u7a0e\u7533\u8bf7\u3002", (String)"RefundApplyVerifyService_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                    return map;
                }
                if (("ybqy".equals(tsqylx) || "xxqy".equals(tsqylx) || "wxqy".equals(tsqylx)) && bqqmldse.compareTo(BigDecimal.valueOf(500000L)) < 0) {
                    map.put(CODE, "true");
                    map.put(FAILINFO, String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u4e3a\u4e00\u822c\u4f01\u4e1a\uff0c\u672c\u671f\u589e\u91cf\u7559\u62b5\u7a0e\u989d\u5c0f\u4e8e50\u4e07\u5143\uff0c\u4e0d\u6ee1\u8db3\u7559\u62b5\u9000\u7a0e\u7533\u8bf7\u6761\u4ef6\u3002", (String)"RefundApplyVerifyService_2", (String)"taxc-tcvat", (Object[])new Object[0]), orgName));
                    return map;
                }
                String zlldtserq = accountData.getString("zlldtserq");
                if (("ybqy".equals(tsqylx) || "xxqy".equals(tsqylx) || "wxqy".equals(tsqylx)) && StringUtils.isBlank((CharSequence)zlldtserq)) {
                    map.put(CODE, "true");
                    map.put(FAILINFO, String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7\u4e3a\u4e00\u822c\u4f01\u4e1a\uff0c\u5728%2$s\u7a0e\u671f\u7684\u589e\u91cf\u7559\u62b5\u7a0e\u989d\u5c0f\u4e8e0\uff0c\u4e0d\u6ee1\u8db3\u7559\u62b5\u9000\u7a0e\u7533\u8bf7\u6761\u4ef6\u3002", (String)"RefundApplyVerifyService_1", (String)"taxc-tcvat", (Object[])new Object[0]), orgName, zlldtserq));
                    return map;
                }
                map.put(CODE, "true");
                map.put(FAILINFO, String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u4e0d\u6ee1\u8db3\u7559\u62b5\u9000\u7a0e\u7533\u8bf7\u6761\u4ef6\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u7559\u62b5\u9000\u7a0e\u7ba1\u7406\u53f0\u8d26\u6570\u636e\u3002", (String)"RefundApplyVerifyService_0", (String)"taxc-tcvat", (Object[])new Object[0]), orgName));
                return map;
            }
        }
        return map;
    }
}

