/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.taxrefund;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.util.TaxRefundEngineUtils;
import kd.taxc.tcvat.business.service.taxrefund.AccountServiceHelper;
import kd.taxc.tcvat.business.service.taxrefund.StateInitDataService;
import kd.taxc.tcvat.business.service.taxrefund.TaxRefundAssistService;
import kd.taxc.tcvat.business.service.taxrefund.WriteBackToAccountService;
import kd.taxc.tcvat.common.enums.TaxRefundStatusEnum;

public class TaxRefundAccountService {
    private TaxRefundAssistService taxRefundAssistService = new TaxRefundAssistService();

    public DynamicObject queryTaxRefundAccountByBillNo(String billno) {
        QFilter billnoFilter = new QFilter("billno", "=", (Object)billno);
        return QueryServiceHelper.queryOne((String)"tcvat_tax_refund_manage_a", (String)"ldtssqbbm", (QFilter[])new QFilter[]{billnoFilter});
    }

    public DynamicObject[] getAllTaxRefundFromSkssqqToNow(Long orgId, Date skssqq) {
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("skssqq", ">=", (Object)skssqq);
        return BusinessDataServiceHelper.load((String)"tcvat_tax_refund_manage_a", (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,org,snmzcze,sshydl,skssqq,skssqz,nsxydj,clldse,ktsbl,bqrzxfdzpse,zzszyfpse,amount,bqsqthclldtse,startqmldse,bqksqthldtse,bqsqthzlldtse,sqthxm,ldtssqbbm,tsbljd,zytssj,tsqylx,zzssbbbh,bqdkhgzyjksse,bqjjskwspzse,bqsbdkjxsehj,bqmdtytse,sqmdsedjqs,sqldsets,dqxzkyytcdldtse,ldtsbqkce,sqjckyykcdldtse,jzxqkyykcdldtse,hgzyjksse,ljdkjjkwspzse,ljdkjxse,inputrate,bndzzsysxsehj,sndzzsysxsehj,qygm,summonth,bqksqthzlldse,bqksqthclldse,zlldtserq", (QFilter[])new QFilter[]{q1, q2}, (String)"skssqq");
    }

    public DynamicObject queryTaxRefundAccount(DynamicObject declare) {
        Long orgId = declare.getDynamicObject("org").getLong("id");
        Date skssqq = declare.getDate("skssqq");
        Date skssqz = declare.getDate("skssqz");
        return QueryServiceHelper.queryOne((String)"tcvat_tax_refund_manage_a", (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,org,snmzcze,sshydl,skssqq,skssqz,nsxydj,clldse,ktsbl,bqrzxfdzpse,zzszyfpse,amount,bqsqthclldtse,startqmldse,bqksqthldtse,bqsqthzlldtse,sqthxm,ldtssqbbm,tsbljd,zytssj,tsqylx,zzssbbbh,bqdkhgzyjksse,bqjjskwspzse,bqsbdkjxsehj,bqmdtytse,sqmdsedjqs,sqldsets,dqxzkyytcdldtse,ldtsbqkce,sqjckyykcdldtse,jzxqkyykcdldtse,hgzyjksse,ljdkjjkwspzse,ljdkjxse,inputrate,bndzzsysxsehj,sndzzsysxsehj,qygm,summonth,bqksqthzlldse,bqksqthclldse,zlldtserq", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("skssqq", ">=", (Object)skssqq), new QFilter("skssqz", "<=", (Object)skssqz)});
    }

    public DynamicObject createAccount(DynamicObject account, DynamicObject declare, String operateName) {
        Long orgId = declare.getDynamicObject("org").getLong("id");
        Date skssqq = declare.getDate("skssqq");
        Date skssqz = declare.getDate("skssqz");
        return this.createAccount(account, orgId, skssqq, skssqz, operateName);
    }

    public DynamicObject createAccount(DynamicObject account, Long orgId, Date skssqq, Date skssqz, String operateName) {
        DynamicObject declareDyo;
        boolean existAccountData = TaxRefundAssistService.existAccountData(orgId, skssqq, skssqz);
        String taxlimit = TaxRefundAssistService.getLimit(DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz));
        if (operateName.equals("audit")) {
            account.set("billno", (Object)DeclareServiceHelper.generateSBBNo((String)"tcvat_tax_refund_manage_a"));
            account.set("org", (Object)orgId);
            account.set("creator", (Object)RequestContext.get().getCurrUserId());
            account.set("createtime", (Object)new Date());
            account.set("skssqq", (Object)skssqq);
            account.set("skssqz", (Object)skssqz);
        }
        account.set("billstatus", (Object)"A");
        String sshydl = TaxRefundAssistService.getEnterpriseClass(orgId, skssqq, skssqz);
        account.set("sshydl", (Object)sshydl);
        String nsxydj = TaxRefundAssistService.getEnterpriseCredit(orgId, skssqq);
        account.set("nsxydj", (Object)nsxydj);
        BigDecimal bqqmldse = this.taxRefundAssistService.getBqqmldse(orgId, skssqq, skssqz);
        account.set("amount", (Object)bqqmldse);
        BigDecimal startQmldse = AccountServiceHelper.getInitBqqmldse("tcvat_statet_init", orgId, DateUtils.stringToDate((String)"2019-03-01"));
        account.set("startqmldse", (Object)startQmldse);
        BigDecimal clldse = this.taxRefundAssistService.getClldse(orgId, skssqq, skssqz, startQmldse);
        account.set("clldse", (Object)clldse);
        if (!operateName.equals("audit")) {
            WriteBackToAccountService.writeBack(account, orgId, skssqq, skssqz);
        }
        if (null != (declareDyo = StateInitDataService.getDeclareDyo(orgId, skssqq, skssqz))) {
            String billno = TaxRefundAssistService.getZzsSbbNo(declareDyo);
            account.set("zzssbbbh", (Object)billno);
        }
        BigDecimal bqrzxfdzpse = TaxRefundAssistService.getFbSecondSe(declareDyo, "35");
        account.set("bqrzxfdzpse", (Object)bqrzxfdzpse);
        BigDecimal bqdkhgzyjksse = TaxRefundAssistService.getFbSecondSe(declareDyo, "5");
        account.set("bqdkhgzyjksse", (Object)bqdkhgzyjksse);
        BigDecimal bqjjskwspzse = TaxRefundAssistService.getFbSecondSe(declareDyo, "36");
        account.set("bqjjskwspzse", (Object)bqjjskwspzse);
        BigDecimal bqsbdkjxsehj = StateInitDataService.getZbDyoSe(declareDyo, "jxse");
        account.set("bqsbdkjxsehj", (Object)bqsbdkjxsehj);
        BigDecimal bqmdtytse = StateInitDataService.getZbDyoSe(declareDyo, "mdtytse");
        account.set("bqmdtytse", (Object)bqmdtytse);
        BigDecimal sqmdsedjqs = TaxRefundAssistService.getFbSecondSe(declareDyo, "21");
        account.set("sqmdsedjqs", (Object)sqmdsedjqs);
        BigDecimal sqldsets = TaxRefundAssistService.getFbSecondSe(declareDyo, "22");
        account.set("sqldsets", (Object)sqldsets);
        BigDecimal dqxzkyytcdldtse = TaxRefundAssistService.getFbFiveData(declareDyo, "dqxzkyytcdldtse");
        account.set("dqxzkyytcdldtse", (Object)dqxzkyytcdldtse);
        BigDecimal ldtsbqkce = TaxRefundAssistService.getLdtsbqkce(declareDyo);
        account.set("ldtsbqkce", (Object)ldtsbqkce);
        BigDecimal sqjckyykcdldtse = TaxRefundAssistService.getFbFiveData(declareDyo, "sqjckyykcdldtse");
        account.set("sqjckyykcdldtse", (Object)sqjckyykcdldtse);
        BigDecimal jzxqkyykcdldtse = TaxRefundAssistService.getFbFiveData(declareDyo, "jzxqkyykcdldtse");
        account.set("jzxqkyykcdldtse", (Object)jzxqkyykcdldtse);
        BigDecimal ljydkzzszyfpse = TaxRefundAssistService.getYdkfpse(orgId, skssqq, skssqz, existAccountData, "zzszyfpse", bqrzxfdzpse);
        account.set("zzszyfpse", (Object)ljydkzzszyfpse);
        BigDecimal ljydkhgzyjksse = TaxRefundAssistService.getYdkfpse(orgId, skssqq, skssqz, existAccountData, "hgzyjksse", bqdkhgzyjksse);
        account.set("hgzyjksse", (Object)ljydkhgzyjksse);
        BigDecimal ljydkjjskwspzse = TaxRefundAssistService.getYdkfpse(orgId, skssqq, skssqz, existAccountData, "ljdkjjkwspzse", bqjjskwspzse);
        account.set("ljdkjjkwspzse", (Object)ljydkjjskwspzse);
        BigDecimal ljysbdkjxsehj = TaxRefundAssistService.getYdkfpse(orgId, skssqq, skssqz, existAccountData, "ljdkjxse", bqsbdkjxsehj);
        account.set("ljdkjxse", (Object)ljysbdkjxsehj);
        BigDecimal inputRate = BigDecimal.ZERO;
        if (ljysbdkjxsehj.compareTo(BigDecimal.ZERO) > 0) {
            inputRate = ljydkzzszyfpse.add(ljydkhgzyjksse).add(ljydkjjskwspzse).multiply(BigDecimal.valueOf(100L)).divide(ljysbdkjxsehj, 4, 4);
            account.set("inputrate", (Object)inputRate);
        }
        BigDecimal bndzzsysxsehj = TaxRefundAssistService.getBndzzsysxsehj(orgId, skssqq, skssqz, existAccountData);
        account.set("bndzzsysxsehj", (Object)bndzzsysxsehj);
        int sumMonth = TaxRefundAssistService.getSumMonth(orgId, skssqq, skssqz, taxlimit);
        account.set("summonth", (Object)sumMonth);
        BigDecimal sndzzsysxsehj = TaxRefundAssistService.getSndzzsysxsehj(orgId, skssqq, skssqz, taxlimit, sumMonth, existAccountData);
        account.set("sndzzsysxsehj", (Object)sndzzsysxsehj);
        BigDecimal snmzcze = TaxRefundAssistService.getSnmzcze(orgId, skssqq, skssqz, taxlimit, existAccountData);
        account.set("snmzcze", (Object)snmzcze);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{account});
        this.setEnterPrise(account, orgId);
        this.setBqksqthldtse(account, taxlimit, orgId);
        account.set("modifier", (Object)RequestContext.get().getCurrUserId());
        account.set("modifytime", (Object)new Date());
        return account;
    }

    public void setEnterPrise(DynamicObject account, Long orgId) {
        String qygm = TaxRefundAssistService.getEnterpriseScale(account, orgId);
        account.set("qygm", (Object)qygm);
        String tsqylx = TaxRefundAssistService.getEnterpriseType(account, orgId);
        account.set("tsqylx", (Object)tsqylx);
        BigDecimal ktsbl = TaxRefundAssistService.getKtsbl(account);
        account.set("ktsbl", (Object)ktsbl);
    }

    public void setBqksqthldtse(DynamicObject account, String taxlimit, Long orgId) {
        BigDecimal bqksqthzlldse = TaxRefundAssistService.getBqksqthzlldse(account, taxlimit, orgId);
        account.set("bqksqthzlldse", (Object)bqksqthzlldse);
        BigDecimal bqksqthclldse = TaxRefundAssistService.getBqksqthclldse(account);
        account.set("bqksqthclldse", (Object)bqksqthclldse);
        BigDecimal bqksqthldtse = TaxRefundAssistService.getBqksqthldtse(account);
        account.set("bqksqthldtse", (Object)bqksqthldtse);
    }

    public void createTaxRefundDetail(List<DynamicObject> collection, DynamicObject declare, String taxRefundStatus) {
        TaxRefundStatusEnum enumByTaxRefundStatus = TaxRefundStatusEnum.getEnumByTaxRefundStatus(taxRefundStatus);
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcvat_taxrefund_result"));
        dynamicObject.set("sbbid", (Object)declare.getLong("id"));
        dynamicObject.set("name", (Object)enumByTaxRefundStatus.getTitle().getDescription());
        dynamicObject.set("detail", (Object)enumByTaxRefundStatus.getContent().getDescription());
        collection.add(dynamicObject);
    }

    public void deleteTaxRefundDetail(List<Long> sbbid) {
        DeleteServiceHelper.delete((String)"tcvat_taxrefund_result", (QFilter[])new QFilter[]{new QFilter("sbbid", "in", sbbid)});
    }

    public void deleteTaxRefundAccount(Long id) {
        DeleteServiceHelper.delete((String)"tcvat_tax_refund_manage_a", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
    }

    public void taxRefundRecaleEngine(Date skssqq, Date skssqz, String orgId) throws ExecutionException, TimeoutException, InterruptedException {
        TcvatEngineModel engineModel = new TcvatEngineModel(orgId, DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz));
        List<Long> orgid = Collections.singletonList(Long.parseLong(orgId));
        Map orgRelationMap = TaxOrgTakeRelationServiceHelper.getOrgRelationMapByTaxOrgs(orgid, (Date)DateUtils.trunc((Date)skssqq), (Date)DateUtils.trunc((Date)skssqz));
        engineModel.addCustom("OrgRelationMap", orgRelationMap);
        TaxRefundEngineUtils.execute(RequestContext.getOrCreate(), engineModel);
    }
}

