/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.taxrefund;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.rule.RuleService;
import kd.taxc.tcvat.business.service.taxrefund.AccountServiceHelper;
import kd.taxc.tcvat.business.service.taxrefund.StateInitDataService;
import kd.taxc.tcvat.common.enums.EnterpriseTypeEnum;
import org.apache.commons.collections.CollectionUtils;

public class TaxRefundAssistService {
    private static final Log logger = LogFactory.getLog(TaxRefundAssistService.class);
    private static final String TCVAT_TAX_REFUND_MANAGE_A = "tcvat_tax_refund_manage_a";
    private static final String TPO_TCVAT_ASSIST = "tpo_tcvat_assist";
    private static final String TCVAT_RULE_REFUND = "tcvat_rule_refund";
    private StateInitDataService stateInitDataService = new StateInitDataService();
    private static RuleService ruleService = new RuleService();

    public static String getEnterpriseClass(Long orgId, Date startDate, Date endDate) {
        QFilter q1 = new QFilter("number", "=", (Object)"sshydl");
        QFilter q2 = new QFilter("entryentity.fstatus1", "=", (Object)"1");
        QFilter q3 = new QFilter("entryentity.startdate", "<=", (Object)startDate);
        QFilter q4 = new QFilter("entryentity.enddate", ">=", (Object)endDate).or(QFilter.isNull((String)"entryentity.enddate"));
        DynamicObject single = BusinessDataServiceHelper.loadSingle((String)TPO_TCVAT_ASSIST, (String)MetadataUtil.getAllSubFieldString((String)TPO_TCVAT_ASSIST), (QFilter[])new QFilter[]{q1, q2, q3, q4});
        DynamicObjectCollection entryentity = single.getDynamicObjectCollection("entryentity");
        return entryentity.stream().filter(s -> (Boolean)TaxcMainDataServiceHelper.queryTaxcMainByOrgIdAndWhereJson((Long)orgId, (String)s.getString("wherejson")).getData()).map(s -> s.getString("fvalue1")).findFirst().orElse("");
    }

    public static String getEnterpriseCredit(Long orgId, Date skssqq) {
        return AccountServiceHelper.getCompanyCredit(orgId, skssqq);
    }

    public static String getEnterpriseScale(DynamicObject taxRefundAccount, Long orgId) {
        Date skssqq = taxRefundAccount.getDate("skssqq");
        Date skssqz = taxRefundAccount.getDate("skssqz");
        String sshydl = taxRefundAccount.getString("sshydl");
        QFilter q1 = new QFilter("name", "=", (Object)sshydl);
        QFilter q2 = new QFilter("classtype", "=", (Object)ResManager.loadKDString((String)"\u4f01\u4e1a\u89c4\u6a21\u5212\u5206", (String)"TaxRefundAssistService_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        QFilter q3 = new QFilter("entryentity.fstatus1", "=", (Object)"1");
        QFilter q4 = new QFilter("entryentity.startdate", "<=", (Object)skssqq);
        QFilter q5 = new QFilter("entryentity.enddate", ">=", (Object)skssqz).or(QFilter.isNull((String)"entryentity.enddate"));
        DynamicObject single = BusinessDataServiceHelper.loadSingle((String)TPO_TCVAT_ASSIST, (String)MetadataUtil.getAllSubFieldString((String)TPO_TCVAT_ASSIST), (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
        if (null != single) {
            DynamicObjectCollection entryentity = single.getDynamicObjectCollection("entryentity");
            String value = TaxRefundAssistService.getEnterpriseScaleName(orgId, entryentity, skssqq, skssqz);
            return value;
        }
        return "wxqy";
    }

    private static String getEnterpriseScaleName(Long orgId, DynamicObjectCollection entryentity, Date sdate, Date edate) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter sdateFilter = new QFilter("skssqq", "=", (Object)sdate);
        QFilter edateFilter = new QFilter("skssqz", "=", (Object)edate);
        return entryentity.stream().filter(s -> {
            QFilter whereFilter = FilterBuilderUtils.buildFilter((String)s.getString("wherejson"), (String)TCVAT_TAX_REFUND_MANAGE_A);
            return QueryServiceHelper.exists((String)TCVAT_TAX_REFUND_MANAGE_A, (QFilter[])new QFilter[]{orgFilter, whereFilter, sdateFilter, edateFilter});
        }).map(s -> EnterpriseTypeEnum.getEnumByname(s.getString("fvalue1"))).findFirst().orElseGet(() -> "");
    }

    public static String getEnterpriseType(DynamicObject taxRefundAccount, Long orgId) {
        String qygm = taxRefundAccount.getString("qygm");
        Date startDate = taxRefundAccount.getDate("skssqq");
        Date endDate = taxRefundAccount.getDate("skssqz");
        QFilter q1 = new QFilter("number", "=", (Object)"tdhyfl");
        QFilter q2 = new QFilter("entryentity.fstatus1", "=", (Object)"1");
        QFilter q3 = new QFilter("entryentity.startdate", "<=", (Object)startDate);
        QFilter q4 = new QFilter("entryentity.enddate", ">=", (Object)endDate).or(QFilter.isNull((String)"entryentity.enddate"));
        DynamicObject single = BusinessDataServiceHelper.loadSingle((String)TPO_TCVAT_ASSIST, (String)MetadataUtil.getAllSubFieldString((String)TPO_TCVAT_ASSIST), (QFilter[])new QFilter[]{q1, q2, q3, q4});
        if (null == single) {
            return "ybqy";
        }
        DynamicObjectCollection entryentity = single.getDynamicObjectCollection("entryentity");
        if (entryentity.size() == 0) {
            return "ybqy";
        }
        String value = entryentity.stream().filter(s -> (Boolean)TaxcMainDataServiceHelper.queryTaxcMainByOrgIdAndWhereJson((Long)orgId, (String)s.getString("wherejson")).getData()).map(s -> s.getString("fvalue1")).findFirst().orElse("");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return EnterpriseTypeEnum.getEnumByname(value);
        }
        if (qygm.equals("xxqy") || qygm.equals("wxqy")) {
            return qygm;
        }
        return "ybqy";
    }

    public BigDecimal getBqqmldse(Long orgId, Date skssqq, Date skssqz) {
        return this.stateInitDataService.getQmldtse(orgId, skssqq, skssqz, "qmldse");
    }

    public BigDecimal getClldse(Long orgId, Date skssqq, Date skssqz, BigDecimal startQmldse) {
        if (AccountServiceHelper.isBiggerZeroAccountData(orgId, skssqq) || AccountServiceHelper.isBiggerZeroInitData(orgId, skssqq)) {
            return BigDecimal.ZERO;
        }
        BigDecimal bqqmldse = this.getBqqmldse(orgId, skssqq, skssqz);
        if (bqqmldse.compareTo(startQmldse) >= 0) {
            return startQmldse;
        }
        return bqqmldse;
    }

    public static DynamicObject getTaxRefundApply(Long orgId, Date skssqq, Date skssqz) {
        return BusinessDataServiceHelper.loadSingle((String)"tcvat_tax_refund_apply", (String)"billno,billstatus,auditor,templatetype,templateid,datatype,nsrsbh,nsrmc,taxtype,org,taxsystem,skssqq,skssqz,remarks,modifier,auditdate,createtime,modifytime,creator,type,generatebusinessdoc,entryentity.bqsqthdclldse,entryentity.bqsqthdzlldse,entryentity.sqthxm,entryentity.bljd,entryentity.zytssj,id,entryentity.id,entryentity.seq", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("skssqq", ">=", (Object)skssqq), new QFilter("skssqz", "<=", (Object)skssqz), new QFilter("type", "=", (Object)"tcvat_taxrefund")});
    }

    public static BigDecimal getKtsbl(DynamicObject taxRefundAccount) {
        String tsqylx = taxRefundAccount.getString("tsqylx");
        QFilter q1 = new QFilter("number", "=", (Object)tsqylx);
        QFilter q2 = new QFilter("entryentity.fstatus1", "=", (Object)"1");
        QFilter q5 = new QFilter("classtype", "=", (Object)ResManager.loadKDString((String)"\u53ef\u9000\u7a0e\u6bd4\u4f8b", (String)"TaxRefundAssistService_1", (String)"taxc-tcvat", (Object[])new Object[0]));
        DynamicObject single = QueryServiceHelper.queryOne((String)TPO_TCVAT_ASSIST, (String)"id,entryentity.fvalue1", (QFilter[])new QFilter[]{q1, q2, q5});
        return single == null ? BigDecimal.ZERO : BigDecimalUtil.toBigDecimal((Object)single.getString("entryentity.fvalue1")).multiply(BigDecimal.valueOf(100L));
    }

    public static BigDecimal getBqksqthldtse(DynamicObject account) {
        String nsxydj = account.getString("nsxydj");
        BigDecimal bqksqthzlldse = account.getBigDecimal("bqksqthzlldse");
        BigDecimal bqksqthclldse = account.getBigDecimal("bqksqthclldse");
        if ("A".equals(nsxydj) || "B".equals(nsxydj)) {
            return bqksqthzlldse.add(bqksqthclldse);
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getBqksqthzlldse(DynamicObject account, String taxlimit, Long orgId) {
        BigDecimal bqksqthzlldse;
        Date skssqq = account.getDate("skssqq");
        BigDecimal jxgcbl = account.getBigDecimal("inputrate").divide(BigDecimal.valueOf(100L));
        BigDecimal ktsbl = account.getBigDecimal("ktsbl").divide(BigDecimal.valueOf(100L));
        BigDecimal clldse = account.getBigDecimal("clldse");
        BigDecimal bqqmldse = account.getBigDecimal("amount");
        BigDecimal startQmldse = account.getBigDecimal("startqmldse");
        String tsqylx = account.getString("tsqylx");
        logger.info(orgId + " " + DateUtils.format((Date)skssqq) + " \u5f00\u59cb\u6267\u884c\u8fde\u7eed\u516d\u4e2a\u6708\u8ba1\u7b97");
        account.set("zlldtserq", (Object)"");
        if (tsqylx.equals("ybqy") || tsqylx.equals("xxqy") || tsqylx.equals("wxqy")) {
            BigDecimal increAmount;
            if (AccountServiceHelper.isBiggerZeroAccountData(orgId, skssqq) || AccountServiceHelper.isBiggerZeroInitData(orgId, skssqq)) {
                startQmldse = BigDecimal.ZERO;
            }
            if ((increAmount = bqqmldse.subtract(startQmldse)).compareTo(BigDecimal.valueOf(500000L)) < 0) {
                return BigDecimal.ZERO;
            }
            Map preTaxPeriodMap = DateUtils.getPrePeriodByTaxLimit((Date)skssqq, (String)TaxDeclareHelper.getPreTaxLimitType(taxlimit));
            int deductMonth = 0;
            if (taxlimit.equals("aysb")) {
                deductMonth = 4;
            }
            Date preSkssqq = (Date)preTaxPeriodMap.get("startDate");
            for (int i = 0; i <= deductMonth; ++i) {
                Date startDate = DateUtils.addMonth((Date)preSkssqq, (int)(-i));
                DynamicObject dynamicObject = AccountServiceHelper.getInitBqqmldse(TCVAT_TAX_REFUND_MANAGE_A, orgId, taxlimit, startDate);
                BigDecimal qmldtse = BigDecimal.ZERO;
                if (null == dynamicObject) {
                    dynamicObject = AccountServiceHelper.getInitBqqmldse("tcvat_statet_init", orgId, taxlimit, startDate);
                }
                logger.info(orgId + " " + DateUtils.format((Date)startDate) + " \u7684\u7559\u62b5\u9000\u7a0e\u53f0\u8d26 \u672c\u671f\u671f\u672b\u7559\u62b5\u7a0e\u989d== " + (null == dynamicObject ? "\u7559\u62b5\u9000\u7a0e\u53f0\u8d26\u4e3a\u7a7a" : dynamicObject.getString("amount")));
                if (null != dynamicObject) {
                    logger.info(orgId + " " + DateUtils.format((Date)startDate) + " \u7684\u7559\u62b5\u60c5\u51b5\u521d\u59cb\u5316 \u672c\u671f\u671f\u672b\u7559\u62b5\u7a0e\u989d==" + dynamicObject.getString("amount"));
                    qmldtse = dynamicObject.getBigDecimal("amount");
                }
                increAmount = qmldtse.subtract(startQmldse);
                logger.info(orgId + " " + DateUtils.format((Date)startDate) + " \u7684\u672c\u671f\u671f\u672b\u7559\u62b5\u7a0e\u989d " + qmldtse + " 2019\u5e743\u6708\u671f\u672b\u7559\u62b5\u7a0e\u989d " + startQmldse + " \u589e\u91cf\u7a0e\u989d " + increAmount);
                if (increAmount.compareTo(BigDecimal.ZERO) > 0) continue;
                return BigDecimal.ZERO;
            }
            bqksqthzlldse = bqqmldse.subtract(startQmldse).multiply(jxgcbl).multiply(ktsbl);
            if (bqksqthzlldse.compareTo(BigDecimal.ZERO) > 0) {
                Date enddate;
                Date startdate = preSkssqq;
                if ("aysb".equals(taxlimit)) {
                    startdate = DateUtils.addMonth((Date)startdate, (int)-4);
                    enddate = DateUtils.getLastDateOfMonth((Date)skssqq);
                } else {
                    enddate = DateUtils.getLastDateOfSeason((Date)DateUtils.addMonth((Date)((Date)preTaxPeriodMap.get("endDate")), (int)3));
                }
                account.set("zlldtserq", (Object)(DateUtils.format((Date)startdate, (String)DateUtils.YYYYMMDD_CHINESE) + "-" + DateUtils.format((Date)enddate, (String)DateUtils.YYYYMMDD_CHINESE)));
            }
        } else {
            bqksqthzlldse = bqqmldse.subtract(clldse).multiply(jxgcbl).multiply(ktsbl);
        }
        logger.info(orgId + " " + DateUtils.format((Date)skssqq) + " \u7ed3\u675f\u6267\u884c\u8fde\u7eed\u516d\u4e2a\u6708\u8ba1\u7b97");
        return bqksqthzlldse;
    }

    public static BigDecimal getBqksqthclldse(DynamicObject account) {
        BigDecimal clldse = account.getBigDecimal("clldse");
        BigDecimal jxgcbl = account.getBigDecimal("inputrate").divide(BigDecimal.valueOf(100L));
        BigDecimal ktsbl = account.getBigDecimal("ktsbl").divide(BigDecimal.valueOf(100L));
        String tsqylx = account.getString("tsqylx");
        if (tsqylx.equals("ybqy")) {
            return BigDecimal.ZERO;
        }
        return clldse.multiply(jxgcbl).multiply(ktsbl);
    }

    public static String getZzsSbbNo(DynamicObject declareDyo) {
        return declareDyo.getString("billno");
    }

    public static BigDecimal getFbSecondSe(DynamicObject declareDyo, String ewblxh) {
        return StateInitDataService.getFbSecondDyo(declareDyo, ewblxh);
    }

    public static BigDecimal getLdtsbqkce(DynamicObject declareDyo) {
        if (declareDyo == null) {
            return BigDecimal.ZERO;
        }
        DynamicObject fbDyo = AccountServiceHelper.getFjsfDyo(declareDyo);
        return fbDyo == null ? BigDecimal.ZERO : fbDyo.getBigDecimal("ldtsbqkce");
    }

    public static BigDecimal getFbFiveData(DynamicObject declareDyo, String name) {
        if (declareDyo == null) {
            return BigDecimal.ZERO;
        }
        DynamicObject fbDyo = StateInitDataService.getFbFiveDyo(declareDyo);
        return fbDyo == null ? BigDecimal.ZERO : fbDyo.getBigDecimal(name);
    }

    public static BigDecimal getYdkfpse(Long orgId, Date skssqq, Date skssqz, Boolean existAccountData, String seName, BigDecimal bqse) {
        if (existAccountData.booleanValue()) {
            DynamicObject lastAccountData = AccountServiceHelper.getLastAccountData(orgId, skssqq, skssqz);
            return null == lastAccountData ? bqse : lastAccountData.getBigDecimal(seName).add(bqse);
        }
        DynamicObject totalInitData = AccountServiceHelper.getLastTotalInitData(orgId, skssqq, skssqz);
        return null == totalInitData ? bqse : totalInitData.getBigDecimal(seName).add(bqse);
    }

    public static BigDecimal getBndzzsysxsehj(Long orgId, Date skssqq, Date skssqz, boolean existAccountData) {
        BigDecimal sumFbData = BigDecimal.ZERO;
        BigDecimal LastBndzzsysxsehj = BigDecimal.ZERO;
        if (existAccountData) {
            DynamicObjectCollection fbFirstData;
            DynamicObject auditDeclareDyo;
            DynamicObject lastTotalInitData;
            if (!AccountServiceHelper.isJanuaryOrFirstSeaon(DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz), skssqq) && null != (lastTotalInitData = AccountServiceHelper.getLastAccountData(orgId, skssqq, skssqz))) {
                LastBndzzsysxsehj = lastTotalInitData.getBigDecimal("bndzzsysxsehj");
            }
            if (null != (auditDeclareDyo = StateInitDataService.getAuditDeclareDyo(orgId, skssqq, skssqz)) && CollectionUtils.isNotEmpty((Collection)(fbFirstData = TaxRefundAssistService.getFbFirstData(auditDeclareDyo)))) {
                sumFbData = TaxRefundAssistService.getSumDetailData(fbFirstData);
            }
        } else {
            Date lastDateOfYear;
            Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)skssqq);
            DynamicObject[] currentYearDeclareReportArray = StateInitDataService.getAllDeclareReportByCondition(orgId, firstDateOfYear, lastDateOfYear = DateUtils.getLastDateOfMonth((Date)skssqz));
            List<String> sbbidList = Arrays.stream(currentYearDeclareReportArray).map(c -> c.getString("id")).collect(Collectors.toList());
            DynamicObjectCollection fbFirstData = TaxRefundAssistService.getFbFirstDataBySbbidList(sbbidList);
            if (CollectionUtils.isNotEmpty((Collection)fbFirstData)) {
                sumFbData = TaxRefundAssistService.getSumDetailData(fbFirstData);
            }
        }
        return sumFbData.add(LastBndzzsysxsehj);
    }

    public static int getSumMonth(Long orgId, Date skssqq, Date skssqz, String taxlimit) {
        if (AccountServiceHelper.isJanuaryOrFirstSeaon(taxlimit, skssqq)) {
            return DateUtils.getMonthDiff((Date)skssqq, (Date)skssqz);
        }
        DynamicObject lastAccountData = AccountServiceHelper.getLastAccountData(orgId, skssqq, skssqz);
        if (null != lastAccountData) {
            return lastAccountData.getInt("summonth") + DateUtils.getMonthDiff((Date)skssqq, (Date)skssqz);
        }
        return DateUtils.getMonthDiff((Date)skssqq, (Date)skssqz);
    }

    public static BigDecimal getSndzzsysxsehj(Long orgId, Date skssqq, Date skssqz, String taxlimit, int sumMonth, Boolean existAccountData) {
        if (existAccountData.booleanValue()) {
            if (AccountServiceHelper.isJanuaryOrFirstSeaon(taxlimit, skssqq)) {
                DynamicObject lastAccountData = AccountServiceHelper.getLastAccountData(orgId, skssqq, skssqz);
                return null == lastAccountData ? BigDecimal.ZERO : lastAccountData.getBigDecimal("bndzzsysxsehj").multiply(BigDecimal.valueOf(12L).divide(BigDecimal.valueOf(sumMonth), 2, RoundingMode.HALF_UP));
            }
            DynamicObject lastAccountData = AccountServiceHelper.getLastAccountData(orgId, skssqq, skssqz);
            return null == lastAccountData ? BigDecimal.ZERO : lastAccountData.getBigDecimal("sndzzsysxsehj");
        }
        DynamicObject lastotalInitData = AccountServiceHelper.getLastTotalInitData(orgId, skssqq, skssqz);
        return null == lastotalInitData ? BigDecimal.ZERO : lastotalInitData.getBigDecimal("sndzzsysxsehj");
    }

    public static BigDecimal getSnmzcze(Long orgId, Date skssqq, Date skssqz, String taxlimit, Boolean existAccountData) {
        if (existAccountData.booleanValue()) {
            if (AccountServiceHelper.isJanuaryOrFirstSeaon(taxlimit, skssqq)) {
                return TaxRefundAssistService.calSndmzczeByRule(orgId, skssqq, skssqz);
            }
            DynamicObject lastAccountData = AccountServiceHelper.getLastAccountData(orgId, skssqq, skssqz);
            return null == lastAccountData ? BigDecimal.ZERO : lastAccountData.getBigDecimal("snmzcze");
        }
        DynamicObject lastotalInitData = AccountServiceHelper.getLastTotalInitData(orgId, skssqq, skssqz);
        return null == lastotalInitData ? BigDecimal.ZERO : lastotalInitData.getBigDecimal("snmzcze");
    }

    public static boolean existAccountData(Long orgId, Date skssqq, Date skssqz) {
        DynamicObject lastAccountData = AccountServiceHelper.getLastAccountData(orgId, skssqq, skssqz);
        return null != lastAccountData;
    }

    public static DynamicObjectCollection getFbFirstData(DynamicObject declareDyo) {
        return QueryServiceHelper.query((String)"tcvat_ybnsr_fb1", (String)"id,ewblxh,ewblname,sbbid,kjskzzszyfpxse,kjskzzszyfpxxynse,kjqtfpxse,kjqtfpxxynse,wkjfpxse,wkjfpxxynse,nsjctzdxse,nsjctzxxynse,xse,hjxxynse,jshj,ysfwkcxmbqsjkcje,kchhsmsxse,kchxxynse,rate", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)declareDyo.getString("id"))});
    }

    public static DynamicObjectCollection getFbFirstDataBySbbidList(List<String> sbbidList) {
        return QueryServiceHelper.query((String)"tcvat_ybnsr_fb1", (String)"id,ewblxh,ewblname,sbbid,kjskzzszyfpxse,kjskzzszyfpxxynse,kjqtfpxse,kjqtfpxxynse,wkjfpxse,wkjfpxxynse,nsjctzdxse,nsjctzxxynse,xse,hjxxynse,jshj,ysfwkcxmbqsjkcje,kchhsmsxse,kchxxynse,rate", (QFilter[])new QFilter[]{new QFilter("sbbid", "in", sbbidList)});
    }

    private static BigDecimal getSumDetailData(DynamicObjectCollection fbFirstData) {
        return TaxRefundAssistService.getDetailData(fbFirstData, "1", "9").add(TaxRefundAssistService.getDetailData(fbFirstData, "2", "13")).subtract(TaxRefundAssistService.getDetailData(fbFirstData, "2", "14")).add(TaxRefundAssistService.getDetailData(fbFirstData, "23", "9")).add(TaxRefundAssistService.getDetailData(fbFirstData, "4", "13")).subtract(TaxRefundAssistService.getDetailData(fbFirstData, "4", "14")).add(TaxRefundAssistService.getDetailData(fbFirstData, "5", "13")).subtract(TaxRefundAssistService.getDetailData(fbFirstData, "5", "14")).add(TaxRefundAssistService.getDetailData(fbFirstData, "8", "9")).add(TaxRefundAssistService.getDetailData(fbFirstData, "9", "9")).add(TaxRefundAssistService.getDetailData(fbFirstData, "22", "13")).subtract(TaxRefundAssistService.getDetailData(fbFirstData, "22", "14")).add(TaxRefundAssistService.getDetailData(fbFirstData, "10", "9")).add(TaxRefundAssistService.getDetailData(fbFirstData, "11", "9")).add(TaxRefundAssistService.getDetailData(fbFirstData, "12", "13")).subtract(TaxRefundAssistService.getDetailData(fbFirstData, "12", "14")).add(TaxRefundAssistService.getDetailData(fbFirstData, "13", "13")).subtract(TaxRefundAssistService.getDetailData(fbFirstData, "13", "14")).add(TaxRefundAssistService.getDetailData(fbFirstData, "20", "13")).subtract(TaxRefundAssistService.getDetailData(fbFirstData, "20", "14")).add(TaxRefundAssistService.getDetailData(fbFirstData, "21", "13")).subtract(TaxRefundAssistService.getDetailData(fbFirstData, "21", "14")).add(TaxRefundAssistService.getDetailData(fbFirstData, "16", "9")).add(TaxRefundAssistService.getDetailData(fbFirstData, "17", "13")).add(TaxRefundAssistService.getDetailData(fbFirstData, "18", "9")).add(TaxRefundAssistService.getDetailData(fbFirstData, "19", "13"));
    }

    private static BigDecimal getDetailData(DynamicObjectCollection fbFirstData, String row, String column) {
        String name = "";
        if ("9".equals(column)) {
            name = "xse";
        }
        if ("13".equals(column)) {
            name = "kchhsmsxse";
        }
        if ("14".equals(column)) {
            name = "kchxxynse";
        }
        String finalName = name;
        BigDecimal detaildata = fbFirstData.stream().filter(s -> s.getString("ewblxh").equals(row)).map(k -> k.getBigDecimal(finalName)).reduce(BigDecimal.ZERO, BigDecimal::add);
        return detaildata;
    }

    public static String getLimit(String taxLimit) {
        if ("month".equals(taxLimit)) {
            return "aysb";
        }
        return "ajsb";
    }

    public static BigDecimal calSndmzczeByRule(Long orgid, Date skssqq, Date skssqz) {
        BigDecimal result = BigDecimal.ZERO;
        Map sharingAndOrgRules = RuleUtils.getSharingAndOrgRules((Long)orgid, (RuleTypeEnum)RuleTypeEnum.REFUND, null, (String)"");
        List rules = (List)sharingAndOrgRules.get(RuleTypeEnum.REFUND);
        TcvatEngineModel model = new TcvatEngineModel(String.valueOf(orgid), DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz));
        for (DynamicObject rule : rules) {
            try {
                List<DynamicObject> list = ruleService.calRuleEntryentityEntity(model, "tcvat_taxrefund_detail", rule, rule.getDynamicObjectCollection("entryentity"), "");
                result = list.stream().map(e -> e.getBigDecimal("amount")).reduce(result, BigDecimal::add);
            }
            catch (Exception e2) {
                logger.error("cal Sndmzcze By Rule is error !!!", (Throwable)e2);
            }
        }
        return result;
    }
}

