/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.taxrefund;

import java.util.Date;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

@Deprecated
public class TaxRefundCal {
    private static final String REFUND_ACCOUNT = "tcvat_tax_refund_account";

    public static void taxRefundCal(String orgid, String billstatus) {
        if (StringUtils.isEmpty((CharSequence)String.valueOf(orgid))) {
            return;
        }
        TaxRefundCal.taxCal(orgid, billstatus);
    }

    public static void taxInitCal(String orgid, String billstatus) {
        TaxRefundCal.taxCal(orgid, billstatus);
    }

    private static void taxCal(String orgid, String billstatus) {
        QFilter status;
        boolean data;
        QFilter org = null;
        if (StringUtils.isNotBlank((CharSequence)orgid)) {
            org = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        }
        if (!(data = QueryServiceHelper.exists((String)REFUND_ACCOUNT, (QFilter[])new QFilter[]{org, status = new QFilter("billstatus", "=", (Object)"C")}))) {
            Date endDate;
            status = new QFilter("billstatus", "=", (Object)billstatus);
            DynamicObjectCollection d = QueryServiceHelper.query((String)REFUND_ACCOUNT, (String)" max(taxrefundperiod) as taxrefundperiod", (QFilter[])new QFilter[]{org, status});
            Date startDate = null;
            if (null != d && d.size() > 0) {
                startDate = ((DynamicObject)d.get(0)).getDate("taxrefundperiod");
            }
            if (startDate == null) {
                startDate = DateUtils.stringToDate((String)"2019-02-01");
            }
            if ((endDate = DateUtils.addMonth((Date)DateUtils.getFirstDateOfMonth((Date)new Date()), (int)-1)).getTime() > startDate.getTime()) {
                int month = DateUtils.getMonthDiff((Date)startDate, (Date)endDate);
                for (int i = 1; i <= month; ++i) {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{TaxRefundCal.createObject("", orgid, DateUtils.addMonth((Date)startDate, (int)i), billstatus)});
                }
            }
        }
    }

    public static DynamicObject createObject(String id, String orgid, Date taxrefundperiod, String billstatus) {
        DynamicObject object = null;
        if (StringUtils.isEmpty((CharSequence)id)) {
            object = BusinessDataServiceHelper.newDynamicObject((String)REFUND_ACCOUNT);
            object.set("creator", (Object)RequestContext.get().getUserId());
            object.set("auditor", (Object)RequestContext.get().getUserId());
            object.set("billstatus", (Object)billstatus);
            object.set("org", (Object)orgid);
            object.set("taxrefundperiod", (Object)taxrefundperiod);
            object.set("createtime", (Object)new Date());
            object.set("modifier", (Object)RequestContext.get().getUserId());
            object.set("modifytime", (Object)new Date());
        } else {
            object = BusinessDataServiceHelper.loadSingle((Object)id, (String)REFUND_ACCOUNT);
            object.set("modifier", (Object)RequestContext.get().getUserId());
            object.set("modifytime", (Object)new Date());
        }
        String taxcreditrating = TaxRefundCal.getTaxcreditrating(orgid, taxrefundperiod);
        object.set("taxcreditrating", (Object)taxcreditrating);
        String taxrefundenterprise = TaxRefundCal.getTaxrefundenterprise(orgid, taxrefundperiod);
        object.set("taxrefundenterprise", (Object)taxrefundenterprise);
        double endAmount = TaxRefundCal.getEndamount(orgid, taxrefundperiod);
        object.set("endamount", (Object)endAmount);
        double incrementamount = TaxRefundCal.getIncrementamount(orgid, endAmount);
        object.set("incrementamount", (Object)incrementamount);
        String taxrebatesjudge = TaxRefundCal.getTaxrebatesjudge(orgid, taxrefundperiod, taxrefundenterprise, taxcreditrating, incrementamount);
        object.set("taxrebatesjudge", (Object)taxrebatesjudge);
        double taxspecialtickets = TaxRefundCal.getTaxspecialtickets(orgid, taxrefundperiod);
        object.set("taxspecialtickets", (Object)taxspecialtickets);
        double allspecialtickets = TaxRefundCal.getAllspecialtickets(orgid, taxrefundperiod);
        object.set("allspecialtickets", (Object)allspecialtickets);
        double inputisproportional = TaxRefundCal.getInputisproportional(orgid, taxrefundperiod, taxrebatesjudge, taxspecialtickets, allspecialtickets);
        object.set("inputisproportional", (Object)inputisproportional);
        object.set("taxrefundallowed", (Object)TaxRefundCal.getTaxrefundallowed(taxrefundenterprise, taxrebatesjudge, incrementamount, inputisproportional));
        object.set("actualfundallowed", (Object)"0");
        object.set("thantaxperiod", (Object)DateUtils.stringToDate((String)"2019-03-01"));
        object.set("refundstatus", (Object)"2");
        return object;
    }

    public static double getTaxrefundallowed(String taxrefundenterprise, String taxrebatesjudge, double incrementamount, double inputisproportional) {
        return Double.parseDouble("0");
    }

    public static String getTaxrebatesjudge(String orgid, Date taxrefundperiod, String taxrefundenterprise, String taxcreditrating, double incrementamount) {
        boolean whereA = false;
        boolean whereB = false;
        if (taxcreditrating.equals("A") || taxcreditrating.equals("B")) {
            whereA = true;
        }
        if ("A".equals(taxrefundenterprise)) {
            QFilter org = new QFilter("org", "=", (Object)Long.parseLong(orgid));
            QFilter start = new QFilter("taxrefundperiod", ">=", (Object)DateUtils.addMonth((Date)taxrefundperiod, (int)-5));
            QFilter end = new QFilter("taxrefundperiod", "<=", (Object)DateUtils.addMonth((Date)taxrefundperiod, (int)-1));
            QFilter incremet = new QFilter("incrementamount", ">", (Object)0);
            QFilter status = new QFilter("billstatus", "=", (Object)"C");
            QFilter actualfundallowed = new QFilter("actualfundallowed", "<=", (Object)0);
            DynamicObjectCollection d = QueryServiceHelper.query((String)REFUND_ACCOUNT, (String)" incrementamount ", (QFilter[])new QFilter[]{org, status, start, end, actualfundallowed, incremet});
            if (d.size() == 5 && incrementamount > 500000.0) {
                whereB = true;
            }
        }
        return "3";
    }

    private static String getTaxcreditrating(String orgid, Date taxrefundperiod) {
        Optional<DynamicObject> first;
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgid));
        Date startdate = DateUtils.stringToDate((String)(DateUtils.format((Date)taxrefundperiod, (String)"yyyy") + "-01-01"));
        Date enddate = DateUtils.stringToDate((String)(DateUtils.format((Date)taxrefundperiod, (String)"yyyy") + "-12-31"));
        if (EmptyCheckUtils.isNotEmpty((Object)result.getData()) && (first = ((DynamicObject)result.getData()).getDynamicObjectCollection("taxcreditrating").stream().filter(d -> d.getDate("year") != null && d.getDate("year").compareTo(startdate) >= 0 && d.getDate("year").compareTo(enddate) <= 0).findFirst()).isPresent()) {
            return first.get().getString("creditlevel");
        }
        return "";
    }

    private static double getIncrementamount(String orgid, double endAmount) {
        QFilter org = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        QFilter date = new QFilter("taxrefundperiod", "=", (Object)DateUtils.stringToDate((String)"2019-03-01"));
        DynamicObjectCollection d = QueryServiceHelper.query((String)REFUND_ACCOUNT, (String)" endAmount ", (QFilter[])new QFilter[]{org, date});
        if (d.size() > 0) {
            return endAmount - ((DynamicObject)d.get(0)).getBigDecimal("endAmount").doubleValue();
        }
        return Double.parseDouble("0");
    }

    public static String getTaxrefundenterprise(String orgid, Date taxrefundperiod) {
        QFilter org = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        QFilter date = new QFilter("taxrefundperiod", "=", (Object)DateUtils.addMonth((Date)taxrefundperiod, (int)-1));
        DynamicObjectCollection d = QueryServiceHelper.query((String)REFUND_ACCOUNT, (String)" taxrefundenterprise ", (QFilter[])new QFilter[]{org, date});
        if (d.size() > 0) {
            return ((DynamicObject)d.get(0)).getString("taxrefundenterprise");
        }
        return "A";
    }

    public static double getEndamount(String orgid, Date taxrefundperiod) {
        DynamicObjectCollection fid = TaxRefundCal.getNsrxxId(orgid, taxrefundperiod);
        return Double.parseDouble("0");
    }

    private static DynamicObjectCollection getNsrxxId(String orgid, Date taxrefundperiod) {
        QFilter org = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        QFilter skssqq = new QFilter("skssqq", "<=", (Object)taxrefundperiod);
        QFilter skssqz = new QFilter("skssqz", ">=", (Object)taxrefundperiod);
        QFilter nrxtype = new QFilter("type", "=", (Object)"zzsybnsr");
        return QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{org, skssqq, skssqz, nrxtype});
    }

    public static double getTaxspecialtickets(String orgid, Date taxrefundperiod) {
        DynamicObjectCollection fid = TaxRefundCal.getNsrxxId(orgid, taxrefundperiod);
        return Double.parseDouble("0");
    }

    public static double getAllspecialtickets(String orgid, Date taxrefundperiod) {
        DynamicObjectCollection fid = TaxRefundCal.getNsrxxId(orgid, taxrefundperiod);
        return Double.parseDouble("0");
    }

    public static double getInputisproportional(String orgid, Date taxrefundperiod, String taxrebatesjudge, double taxspecialtickets, double allspecialtickets) {
        if ("1".equals(taxrebatesjudge)) {
            QFilter org = new QFilter("org", "=", (Object)Long.parseLong(orgid));
            QFilter startdate = new QFilter("taxrefundperiod", ">=", (Object)DateUtils.stringToDate((String)"2019-04-01"));
            QFilter date = new QFilter("taxrefundperiod", "<=", (Object)DateUtils.addMonth((Date)taxrefundperiod, (int)-1));
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)REFUND_ACCOUNT, (String)" taxspecialtickets,allspecialtickets", (QFilter[])new QFilter[]{org, date, startdate});
        }
        return Double.parseDouble("0");
    }
}

