/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.transfer.apportion.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.util.RuleConfigUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.engine.task.util.RuleCalcDetailParam;
import kd.taxc.tcvat.business.service.engine.task.util.RuleSettingUtils;
import kd.taxc.tcvat.business.service.transfer.apportion.utils.ApportionRuleSettingTaskUtil;

public class ApportionRuleSettingTask
extends Task<List<DynamicObject>> {
    private DynamicObjectCollection collection;
    private int batchSize = 5;
    private String suffix = "";
    private Map<String, Object> params;

    public ApportionRuleSettingTask(DynamicObjectCollection ruleSetting, Map<String, Object> params, String suffix) {
        this.collection = ruleSetting;
        this.params = params;
        this.suffix = suffix;
    }

    public List<List<DynamicObject>> getValue() {
        return Lists.partition((List)this.collection, (int)this.batchSize);
    }

    public List<DynamicObject> executor(List<DynamicObject> settings) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(settings.size());
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        String taxperiod = (String)this.params.get("startDate");
        Date firstDayOfMonth = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM"));
        Date lastDayOfMonth = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM"));
        String orgId = (String)this.params.get("org");
        for (DynamicObject setting : settings) {
            DynamicObject table = setting.getDynamicObject("table" + this.suffix);
            String entryName = table.getString("name");
            DynamicObject object = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcvat_accdetail_income"));
            Map fieldMap = RuleConfigUtils.get((Long)table.getLong("id"));
            this.setDefaultFilter(fieldMap, filterList, firstDayOfMonth, lastDayOfMonth, orgId, taxperiod);
            RuleCalcDetailParam detailParam = new RuleCalcDetailParam(entryName, this.suffix, null, null, null);
            ApportionRuleSettingTaskUtil.calAmount(setting, filterList, object, list, detailParam, taxperiod, this.params);
        }
        return list;
    }

    private void setDefaultFilter(Map<String, String> fieldMap, List<QFilter> filterList, Date firstDayOfMonth, Date lastDayOfMonth, String orgId, String taxperiod) {
        String org;
        String dataField = fieldMap.get("datastate");
        if (null != dataField) {
            QFilter startFilter = new QFilter(dataField, ">=", (Object)firstDayOfMonth);
            QFilter endFilter = new QFilter(dataField, "<=", (Object)lastDayOfMonth);
            filterList.add(startFilter);
            filterList.add(endFilter);
        }
        if (null != (org = fieldMap.get("orgstate"))) {
            QFilter orgFilter = new QFilter(org, "=", (Object)orgId);
            if (null != this.params.get("ybnsrOrgRelation")) {
                List orglist = (List)this.params.get("ybnsrOrgRelation");
                orgFilter = new QFilter(org, "in", (Object)orglist);
            }
            filterList.add(orgFilter);
        }
        RuleSettingUtils.setTimeFilter(fieldMap, null, filterList, taxperiod);
    }
}

