/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.transfer.apportion.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.fi.GetGLBalanceCommonUtil;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.engine.task.util.NewRuleSettingUtils;
import kd.taxc.tcvat.business.service.engine.task.util.RuleCalcDetailParam;
import org.apache.commons.lang.StringUtils;

public class ApportionRuleSettingTaskUtil {
    private static Log logger = LogFactory.getLog(ApportionRuleSettingTaskUtil.class);

    public static void calAmount(DynamicObject setting, List<QFilter> filterList, DynamicObject object, List<DynamicObject> list, RuleCalcDetailParam detailParam, String taxperiod, Map<String, Object> params) {
        Date firstDayOfMonth = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM"));
        Date lastDayOfMonth = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM"));
        ApportionRuleSettingTaskUtil.calAmount(setting, filterList, object, list, DateUtils.format((Date)firstDayOfMonth), DateUtils.format((Date)lastDayOfMonth), taxperiod, Arrays.asList(taxperiod, taxperiod), detailParam, params);
    }

    public static void calAmount(DynamicObject setting, List<QFilter> filterList, DynamicObject object, List<DynamicObject> list, String startDate, String endDate, String taxperiod, List<String> dateList, RuleCalcDetailParam detailParam, Map<String, Object> params) {
        String selectFieldwithid;
        String entryName = detailParam.getSettingTable();
        String settingSuffix = detailParam.getSettingSuffix();
        String amountField = setting.getDynamicObject("amountfield" + settingSuffix).getString("fieldname");
        String fieldsubname = setting.getDynamicObject("amountfield" + settingSuffix).getString("fieldsubname");
        String conditionjson = setting.getString("conditionjson" + settingSuffix);
        QFilter conditionFilters = null;
        if (StringUtils.isNotBlank((String)conditionjson)) {
            if ((entryName.equals("gl_voucher") || entryName.equals("gl_balance")) && conditionjson.contains("assgrp")) {
                conditionjson = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"RuleFilterService", (String)"setAssgrpConditionJson", (Object[])new Object[]{conditionjson});
            }
            if ((conditionFilters = FilterBuilderUtils.buildFilter((String)conditionjson, (String)entryName)) != null) {
                logger.info("0 \u89c4\u5219\u914d\u7f6e\u6761\u4ef6" + JsonUtil.toJson((Object)conditionFilters.toString()));
                filterList.add(conditionFilters);
            }
        }
        String selectField = amountField;
        if (!entryName.equals(fieldsubname)) {
            selectField = fieldsubname + "." + amountField;
            selectFieldwithid = fieldsubname + ".id as id," + fieldsubname + "." + amountField;
        } else {
            selectFieldwithid = "id," + amountField;
        }
        logger.info("3 \u6570\u636e\u6e90:" + entryName + " \u8fc7\u6ee4\u6761\u4ef6:" + JsonUtil.toJson((Object)filterList.toString()));
        BigDecimal detailTotalAmount = BigDecimal.ZERO;
        boolean isBeginOrEnd = GetGLBalanceCommonUtil.conditionCheck((String)fieldsubname, (String)amountField);
        DynamicObjectCollection accountingList = new DynamicObjectCollection();
        if (isBeginOrEnd) {
            if (taxperiod.equals(dateList.get(0)) && StringUtil.startsWith((CharSequence)amountField, (CharSequence)"begin")) {
                accountingList = GetGLBalanceCommonUtil.queryAccountingList((String)entryName, (String)selectFieldwithid, (String)amountField, (String)startDate, (String)endDate, filterList);
            } else if (taxperiod.equals(dateList.get(dateList.size() - 1)) && StringUtil.startsWith((CharSequence)amountField, (CharSequence)"end")) {
                accountingList = GetGLBalanceCommonUtil.queryAccountingList((String)entryName, (String)selectFieldwithid, (String)amountField, (String)startDate, (String)endDate, filterList);
            }
        } else {
            accountingList = QueryServiceHelper.query((String)entryName, (String)selectFieldwithid, (QFilter[])filterList.toArray(new QFilter[0]));
            isBeginOrEnd = GetGLBalanceCommonUtil.tdmBalanceNew((String)fieldsubname, (String)amountField);
            ApportionRuleSettingTaskUtil.recordAccountDetail(params, accountingList, setting);
        }
        for (DynamicObject dynamicObject : accountingList) {
            detailTotalAmount = detailTotalAmount.add(isBeginOrEnd ? dynamicObject.getBigDecimal(selectField) : NewRuleSettingUtils.getAbsAmount(setting.getBoolean("absolute" + settingSuffix), selectField, dynamicObject));
        }
        detailTotalAmount = isBeginOrEnd ? (setting.getBoolean("absolute" + settingSuffix) ? detailTotalAmount.abs() : detailTotalAmount) : detailTotalAmount;
        BigDecimal taxRate = BigDecimal.ZERO;
        String advanceConfigKey = "entryentity" + settingSuffix + "confjson";
        if (StringUtil.isNotBlank((CharSequence)settingSuffix) && StringUtil.isNotBlank((CharSequence)setting.getString(advanceConfigKey))) {
            taxRate = setting.getBigDecimal(advanceConfigKey);
        }
        detailTotalAmount = ApportionRuleSettingTaskUtil.getAmount(taxRate, setting.getString("datatype" + settingSuffix), detailTotalAmount, setting.getString("datadirection" + settingSuffix));
        object.set("amount", (Object)detailTotalAmount);
        list.add(object);
        filterList.clear();
    }

    private static void recordAccountDetail(Map<String, Object> params, DynamicObjectCollection accountingList, DynamicObject setting) {
        String billno = (String)params.get("billno");
        if (StringUtil.isNotBlank((CharSequence)billno) && billno.startsWith("Transferout")) {
            IAppCache cache = AppCache.get((String)"tcvat");
            ArrayList list = (ArrayList)cache.get(billno, List.class);
            if (list == null || list.isEmpty()) {
                list = new ArrayList();
            }
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            String tableName = setting.getDynamicObjectType().getProperties().stream().filter(s -> s.getName().startsWith("table")).map(s -> s.getName()).findFirst().orElseGet(() -> null);
            if (StringUtil.isEmpty((CharSequence)tableName) || !"table".equals(tableName)) {
                return;
            }
            map.put("ruleId", ((DynamicObject)setting.getParent()).getLong("id"));
            map.put("table", setting.getDynamicObject(tableName).getString("name"));
            map.put("sourceIds", accountingList.stream().map(s -> s.getLong("id")).collect(Collectors.toList()));
            list.add(map);
            cache.put(billno, list);
        }
    }

    public static BigDecimal getAmount(BigDecimal taxRate, String dataType, BigDecimal detailTotalamount, String datadirection) {
        BigDecimal amount = "positive".equals(datadirection) ? detailTotalamount : detailTotalamount.multiply(new BigDecimal(-1));
        if ("zjqs".equals(dataType)) {
            return amount;
        }
        if (BigDecimal.ZERO.compareTo(taxRate) == 0) {
            return BigDecimal.ZERO;
        }
        if ("jsflqs".equals(dataType)) {
            amount = amount.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
            return amount;
        }
        if ("cysldsqs".equals(dataType)) {
            amount = amount.divide(taxRate, 2, RoundingMode.HALF_UP);
            return amount;
        }
        return amount;
    }
}

