/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.control.Button;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;

public class DeductRuleAndDraftUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(DeductRuleAndDraftUpgradeService.class);
    private static final List<String> deductTypeNumberList = new ArrayList<String>(10){
        {
            this.add("VAT_JXDK_BQDK_1");
            this.add("VAT_JXDK_BQDK_5");
            this.add("VAT_JXDK_BQDK_7");
            this.add("VAT_JXDK_BQDK_8");
            this.add("VAT_JXDK_BQDK_9");
            this.add("VAT_JXDK_BQDK_3");
        }
    };

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"deleterule", "deleteybnsr", "deleteybhz"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button source = (Button)evt.getSource();
        this.deleteData(source.getKey());
    }

    public void deleteData(String btnKey) {
        if (Objects.equals("deleterule", btnKey)) {
            DeleteServiceHelper.delete((String)"tcvat_rule_deduct", (QFilter[])new QFilter[]{new QFilter("issystem", "=", (Object)"1")});
        }
        if (Objects.equals("deleteybnsr", btnKey)) {
            DeleteServiceHelper.delete((String)"tcvat_deduct_detail_bill", (QFilter[])new QFilter[]{new QFilter("table", "!=", (Object)1560740606819535872L)});
        }
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        StringBuilder message = new StringBuilder("DeductRuleUpgradeService update start\n");
        long l = System.currentTimeMillis();
        try {
            this.deductRuleUpdate(message);
            this.deductDraftUpdate(message);
            message.append("\nDeductRuleUpgradeService update complete ").append(System.currentTimeMillis() - l).append("ms");
        }
        catch (Exception e) {
            message.append(e.getStackTrace()).append(System.currentTimeMillis() - l).append("ms");
        }
        result.setLog(message.toString());
        return result;
    }

    public void deductDraftUpdate(StringBuilder message) {
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tctb_draft_main") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_deduction_sum_jt") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_deduct_detail_bil")) {
            this.sjjtExecuteYbnsrDraftUpdate(message);
        }
    }

    public void deductRuleUpdate(StringBuilder message) {
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_rule_deduct") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_rule_deduct_entry") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_deduct_tax_entry")) {
            List<Map<String, String>> OrgSumList = this.getNsrxxMap();
            this.executeOtherTypeUpdate(message, OrgSumList);
        }
    }

    private void convertToLong(Map<String, String> map, Row row, String field) {
        map.put(field, row.getString(field));
    }

    private void sjjtExecuteYbnsrDraftUpdate(StringBuilder message) {
        String exists = "select fid from t_tcvat_deduct_detail_bil where ftable = 1467494794577053696";
        List deductDetail = DBUtils.query((String)exists);
        if (!deductDetail.isEmpty()) {
            message.append("The sjjt deduct draft detail already upgraded and does not need to be upgraded \n");
            return;
        }
        String draftSql = "select fserialno from t_tcvat_deduction_sum_jt where forgid in (select forgid from t_tpo_declare_main_tsd where ftemplatetype = 'draft_zzsybnsr_sjjt')";
        DataSet deductDraftList = DB.queryDataSet((String)"TaxCategoryUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)draftSql);
        if (deductDraftList.isEmpty()) {
            deductDraftList.close();
            return;
        }
        this.updateDeductDraft();
        ArrayList<Object[]> countParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> invoiceamountParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> taxamountParamList = new ArrayList<Object[]>();
        this.updateExecute(countParamList, invoiceamountParamList, taxamountParamList, 961640097369875456L, "VAT_JXDK_BQDK_1", 0);
        this.updateExecute(countParamList, invoiceamountParamList, taxamountParamList, 1376129725579325440L, "VAT_JXDK_BQDK_1", 1);
        this.updateExecute(countParamList, invoiceamountParamList, taxamountParamList, 961640097369875456L, "VAT_JXDK_BQDK_1", 2);
        this.updateExecute(countParamList, invoiceamountParamList, taxamountParamList, 961641829533496320L, "VAT_JXDK_BQDK_5", 0);
        this.updateExecute(countParamList, invoiceamountParamList, taxamountParamList, 961642468384760832L, "VAT_JXDK_BQDK_3", 0);
        String customDetailSql = "select ftaxaccountserialno,forgid,ftax_period,fcustom_declaration_no,ftotal_tax_amount,feffective_tax_amount,funit_price from t_tcvat_customs_detail where ftaxaccountserialno in (select fserialno from t_tcvat_deduction_sum_jt where forgid in (select forgid from t_tpo_declare_main_tsd where ftemplatetype = 'draft_zzsybnsr_sjjt'))";
        DataSet customDetailList = DB.queryDataSet((String)"TaxCategoryUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)customDetailSql);
        if (!customDetailList.isEmpty()) {
            ArrayList<HashMap<String, String>> customDetailSumList = new ArrayList<HashMap<String, String>>(500);
            while (customDetailList.hasNext()) {
                HashMap<String, String> map = new HashMap<String, String>(8);
                Row row = customDetailList.next();
                map.put("FTAXACCOUNTSERIALNO", row.getString("FTAXACCOUNTSERIALNO"));
                this.convertToLong(map, row, "FORGID");
                map.put("FCUSTOM_DECLARATION_NO", row.getString("FCUSTOM_DECLARATION_NO"));
                map.put("FTAX_PERIOD", row.getString("FTAX_PERIOD"));
                map.put("FEFFECTIVE_TAX_AMOUNT", row.getString("FEFFECTIVE_TAX_AMOUNT"));
                map.put("FUNIT_PRICE", row.getString("FUNIT_PRICE"));
                customDetailSumList.add(map);
            }
            Map<String, List<Map>> ftaxaccountserialno = customDetailSumList.stream().collect(Collectors.groupingBy(d -> String.valueOf(d.get("FTAXACCOUNTSERIALNO"))));
            long[] customCountDetailFid = DB.genLongIds(null, (int)ftaxaccountserialno.size());
            long[] customAmountDetailFid = DB.genLongIds(null, (int)ftaxaccountserialno.size());
            long[] customTaxAmountDetailFid = DB.genLongIds(null, (int)ftaxaccountserialno.size());
            int index = 0;
            for (List list : ftaxaccountserialno.values()) {
                BigDecimal count = new BigDecimal(list.size());
                BigDecimal amount = BigDecimal.ZERO;
                BigDecimal taxAmount = BigDecimal.ZERO;
                for (Map map : list) {
                    amount = amount.add(new BigDecimal((String)map.get("FUNIT_PRICE")));
                    taxAmount = taxAmount.add(new BigDecimal((String)map.get("FEFFECTIVE_TAX_AMOUNT")));
                }
                DynamicObject customRuleObject = this.getRuleDynamicObject("VAT_JXDK_BQDK_7");
                DynamicObject rule = (DynamicObject)customRuleObject.getDynamicObjectCollection("entryentity").get(0);
                DynamicObject rule1 = (DynamicObject)customRuleObject.getDynamicObjectCollection("entryentity1").get(0);
                DynamicObject rule11 = (DynamicObject)customRuleObject.getDynamicObjectCollection("entryentity11").get(0);
                Long orgid = Long.valueOf((String)list.get(0).get("FORGID"));
                Date skssqq = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)((String)list.get(0).get("FTAX_PERIOD"))));
                Date skssqz = DateUtils.getLastDateOfMonth2((Date)DateUtils.stringToDate((String)((String)list.get(0).get("FTAX_PERIOD"))));
                String serialno = String.valueOf(list.get(0).get("FTAXACCOUNTSERIALNO"));
                invoiceamountParamList.add(new Object[]{customAmountDetailFid[index], skssqq, skssqz, rule.getString("filtercondition"), rule.getString("bizname"), amount, BigDecimal.ZERO, "0", "positive", "zjjs", rule.getLong("amountfield"), orgid, "amount", serialno, rule.getLong("table")});
                taxamountParamList.add(new Object[]{customTaxAmountDetailFid[index], skssqq, skssqz, rule1.getString("filtercondition1"), rule1.getString("bizname1"), taxAmount, BigDecimal.ZERO, "0", "positive", "zjjs", rule1.getLong("amountfield1"), orgid, "taxamount", serialno, rule1.getLong("table1")});
                countParamList.add(new Object[]{customCountDetailFid[index], skssqq, skssqz, rule11.getString("filtercondition11"), rule11.getString("bizname11"), count, BigDecimal.ZERO, "0", "positive", "zjjs", rule11.getLong("amountfield11"), orgid, "count", serialno, rule11.getLong("table11")});
                ++index;
            }
        }
        customDetailList.close();
        String dkdjDetailSql = "select  forgid,fcount,famount,ftaxamount,fserialno,ftaxperiod from t_tcvat_deduction_sum_jt where fdeductiontype = '1377424673628775424' and forgid in (select forgid from t_tpo_declare_main_tsd where ftemplatetype = 'draft_zzsybnsr_sjjt')";
        DataSet dkdjDetailList = DB.queryDataSet((String)"TaxCategoryUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)dkdjDetailSql);
        if (!dkdjDetailList.isEmpty()) {
            ArrayList<HashMap<String, String>> dkdjDetailSumList = new ArrayList<HashMap<String, String>>(500);
            while (dkdjDetailList.hasNext()) {
                HashMap<String, String> map = new HashMap<String, String>(8);
                Row row = dkdjDetailList.next();
                map.put("FSERIALNO", row.getString("FSERIALNO"));
                this.convertToLong(map, row, "FORGID");
                map.put("FTAXPERIOD", row.getString("FTAXPERIOD"));
                map.put("FAMOUNT", row.getString("FAMOUNT"));
                map.put("FTAXAMOUNT", row.getString("FTAXAMOUNT"));
                map.put("FCOUNT", row.getString("FCOUNT"));
                dkdjDetailSumList.add(map);
            }
            long[] dkdjCountDetailFid = DB.genLongIds(null, (int)dkdjDetailSumList.size());
            long[] dkdjTaxAmountDetailFid = DB.genLongIds(null, (int)dkdjDetailSumList.size());
            int seq = 0;
            for (Map map : dkdjDetailSumList) {
                DynamicObject customRuleObject = this.getRuleDynamicObject("VAT_JXDK_BQDK_9");
                DynamicObject rule1 = (DynamicObject)customRuleObject.getDynamicObjectCollection("entryentity1").get(0);
                DynamicObject rule11 = (DynamicObject)customRuleObject.getDynamicObjectCollection("entryentity11").get(0);
                Long orgid = Long.valueOf((String)map.get("FORGID"));
                Date skssqq = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)String.valueOf(map.get("FTAXPERIOD")), (String)"yyyy-MM"));
                Date skssqz = DateUtils.getLastDateOfMonth2((Date)DateUtils.stringToDate((String)String.valueOf(map.get("FTAXPERIOD")), (String)"yyyy-MM"));
                String serialno = String.valueOf(map.get("FSERIALNO"));
                BigDecimal taxAmount = new BigDecimal((String)map.get("FTAXAMOUNT"));
                BigDecimal count = new BigDecimal((String)map.get("FCOUNT"));
                taxamountParamList.add(new Object[]{dkdjTaxAmountDetailFid[seq], skssqq, skssqz, rule1.getString("filtercondition1"), rule1.getString("bizname1"), taxAmount, BigDecimal.ZERO, "0", "positive", "zjjs", rule1.getLong("amountfield1"), orgid, "taxamount", serialno, rule1.getLong("table1")});
                countParamList.add(new Object[]{dkdjCountDetailFid[seq], skssqq, skssqz, rule11.getString("filtercondition11"), rule11.getString("bizname11"), count, BigDecimal.ZERO, "0", "positive", "zjjs", rule11.getLong("amountfield11"), orgid, "count", serialno, rule11.getLong("table11")});
                ++seq;
            }
        }
        dkdjDetailList.close();
        String ybnsrDeductSql = "INSERT INTO t_tcvat_deduct_detail_bil(FID,FSKSSQQ,FSKSSQZ,FFILTERCONDITION,FBIZNAME,FAMOUNT,FFETCHAMOUNT,FABSOLUTE,FDATADIRECTION,FDATATYPE,FAMOUNTFIELD,FORGID,FTYPE,FTAXACCOUNTSERIALNO,FTABLE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try (TXHandle h = TX.required();){
            try {
                if (countParamList.size() > 0) {
                    DBUtils.executeBatch((String)ybnsrDeductSql, countParamList);
                }
                if (invoiceamountParamList.size() > 0) {
                    DBUtils.executeBatch((String)ybnsrDeductSql, invoiceamountParamList);
                }
                if (taxamountParamList.size() > 0) {
                    DBUtils.executeBatch((String)ybnsrDeductSql, taxamountParamList);
                }
                message.append("YbnsrDraftUpdate SUCCESS").append('\n');
            }
            catch (Throwable t) {
                h.markRollback();
                message.append("YbnsrDraftUpdate FAILURE:").append(t).append('\n');
                LOGGER.info("YbnsrDraftUpdate FAILURE:", (Object)t);
            }
        }
    }

    private void updateDeductDraft() {
        String updateSql = "update t_tcvat_deduction_sum_jt set fdescription = ? , fdeductiontype = ? where fdeductiontype = ? ";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        paramsList.add(new Object[]{ResManager.loadKDString((String)"\u672c\u671f\u8ba4\u8bc1\u76f8\u7b26\u7684\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", (String)"DeductRuleAndDraftUpgradeService_0", (String)"taxc-tcvat", (Object[])new Object[0]), "1376813763545544704", "1"});
        paramsList.add(new Object[]{ResManager.loadKDString((String)"\u672c\u671f\u8ba4\u8bc1\u76f8\u7b26\u7684\u901a\u884c\u8d39\u53d1\u7968", (String)"DeductRuleAndDraftUpgradeService_1", (String)"taxc-tcvat", (Object[])new Object[0]), "1377423028203316224", "2"});
        paramsList.add(new Object[]{ResManager.loadKDString((String)"\u672c\u671f\u8ba4\u8bc1\u76f8\u7b26\u7684\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968", (String)"DeductRuleAndDraftUpgradeService_2", (String)"taxc-tcvat", (Object[])new Object[0]), "1377423719802102784", "9"});
        paramsList.add(new Object[]{ResManager.loadKDString((String)"\u6d77\u5173\u8fdb\u53e3\u589e\u503c\u7a0e\u4e13\u7528\u7f34\u6b3e\u4e66", (String)"DeductRuleAndDraftUpgradeService_3", (String)"taxc-tcvat", (Object[])new Object[0]), "1377424194228324352", "21"});
        paramsList.add(new Object[]{ResManager.loadKDString((String)"\u52a0\u8ba1\u6263\u9664\u519c\u4ea7\u54c1\u8fdb\u9879\u7a0e\u989d", (String)"DeductRuleAndDraftUpgradeService_4", (String)"taxc-tcvat", (Object[])new Object[0]), "1377424982371600384", "6"});
        paramsList.add(new Object[]{ResManager.loadKDString((String)"\u5176\u4ed6", (String)"DeductRuleAndDraftUpgradeService_5", (String)"taxc-tcvat", (Object[])new Object[0]), "0", "8"});
        paramsList.add(new Object[]{ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u6263\u7a0e\u51ed\u8bc1", (String)"DeductRuleAndDraftUpgradeService_6", (String)"taxc-tcvat", (Object[])new Object[0]), "1377425530827072512", "7"});
        paramsList.add(new Object[]{ResManager.loadKDString((String)"\u4ee3\u6263\u4ee3\u7f34\u7a0e\u6536\u7f34\u6b3e\u51ed\u8bc1", (String)"DeductRuleAndDraftUpgradeService_7", (String)"taxc-tcvat", (Object[])new Object[0]), "1377424673628775424", "5"});
        paramsList.add(new Object[]{ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968\u6216\u8005\u9500\u552e\u53d1\u7968", (String)"DeductRuleAndDraftUpgradeService_8", (String)"taxc-tcvat", (Object[])new Object[0]), "1377424440996005888", "4"});
        DBUtils.executeBatch((String)updateSql, paramsList);
    }

    private void updateExecute(List<Object[]> countParamList, List<Object[]> invoiceamountParamList, List<Object[]> taxamountParamList, Long baseInvoiceTypeId, String deductType, int index) {
        String specialDetailSql = "select forgid,ftaxaccountserialno,ftaxperiod,fdeductiontype,fbaseinvoicetype,famount,ftaxamount from t_tcvat_deduction_detail ";
        DataSet draftDetailList = DB.queryDataSet((String)"TaxCategoryUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)specialDetailSql);
        if (draftDetailList.isEmpty()) {
            draftDetailList.close();
            return;
        }
        ArrayList<HashMap<String, String>> draftDetailListSumList = new ArrayList<HashMap<String, String>>(500);
        while (draftDetailList.hasNext()) {
            HashMap<String, String> map = new HashMap<String, String>(8);
            Row row = draftDetailList.next();
            map.put("FTAXACCOUNTSERIALNO", row.getString("FTAXACCOUNTSERIALNO"));
            map.put("FAMOUNT", row.getString("FAMOUNT"));
            map.put("FTAXAMOUNT", row.getString("FTAXAMOUNT"));
            map.put("FDEDUCTIONTYPE", row.getString("FDEDUCTIONTYPE"));
            map.put("FTAXPERIOD", row.getString("FTAXPERIOD"));
            this.convertToLong(map, row, "FBASEINVOICETYPE");
            this.convertToLong(map, row, "FORGID");
            draftDetailListSumList.add(map);
        }
        draftDetailList.close();
        Map<String, List<Map>> ftaxaccountserialno = draftDetailListSumList.stream().collect(Collectors.groupingBy(d -> String.valueOf(d.get("FTAXACCOUNTSERIALNO"))));
        long[] countDetailFid = DB.genLongIds(null, (int)ftaxaccountserialno.size());
        long[] amountDetailFid = DB.genLongIds(null, (int)ftaxaccountserialno.size());
        long[] taxAmountDetailFid = DB.genLongIds(null, (int)ftaxaccountserialno.size());
        int i = 0;
        for (List<Map> invoiceList : ftaxaccountserialno.values()) {
            if (invoiceList.size() == 0) continue;
            BigDecimal count = new BigDecimal(invoiceList.size());
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal taxAmount = BigDecimal.ZERO;
            for (Map invoiceMap : invoiceList) {
                amount = amount.add(new BigDecimal((String)invoiceMap.get("FAMOUNT")));
                taxAmount = taxAmount.add(new BigDecimal((String)invoiceMap.get("FTAXAMOUNT")));
            }
            DynamicObject ruleDynamicObject = this.getRuleDynamicObject(deductType);
            DynamicObject rule = (DynamicObject)ruleDynamicObject.getDynamicObjectCollection("entryentity").get(index);
            DynamicObject rule1 = (DynamicObject)ruleDynamicObject.getDynamicObjectCollection("entryentity1").get(index);
            DynamicObject rule11 = (DynamicObject)ruleDynamicObject.getDynamicObjectCollection("entryentity11").get(index);
            Long orgid = Long.valueOf((String)invoiceList.get(0).get("FORGID"));
            String serialno = (String)invoiceList.get(0).get("FTAXACCOUNTSERIALNO");
            String taxperiod = (String)invoiceList.get(0).get("FTAXPERIOD");
            Date skssqq = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM"));
            Date skssqz = DateUtils.getLastDateOfMonth2((Date)DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM"));
            invoiceamountParamList.add(new Object[]{amountDetailFid[i], skssqq, skssqz, rule.getString("filtercondition"), rule.getString("bizname"), amount, BigDecimal.ZERO, "0", "positive", "zjjs", rule.getLong("amountfield"), orgid, "amount", serialno, rule.getLong("table")});
            taxamountParamList.add(new Object[]{taxAmountDetailFid[i], skssqq, skssqz, rule1.getString("filtercondition1"), rule1.getString("bizname1"), taxAmount, BigDecimal.ZERO, "0", "positive", "zjjs", rule1.getLong("amountfield1"), orgid, "taxamount", serialno, rule1.getLong("table1")});
            countParamList.add(new Object[]{countDetailFid[i], skssqq, skssqz, rule11.getString("filtercondition11"), rule11.getString("bizname11"), count, BigDecimal.ZERO, "0", "positive", "zjjs", rule11.getLong("amountfield11"), orgid, "count", serialno, rule11.getLong("table11")});
            ++i;
        }
    }

    private void executeOtherTypeUpdate(StringBuilder message, List<Map<String, String>> OrgSumList) {
        String exists = "select fdeducttype from t_tcvat_rule_deduct where fdeducttype = 1376813763545544704 and fissystem = '1' and forgid != 100000";
        List DeductRuleList = DBUtils.query((String)exists);
        if (!DeductRuleList.isEmpty()) {
            message.append("The VAT_JXDK_BQDK rule already exists and does not need to be upgraded \n");
            return;
        }
        long[] fidArray = DB.genLongIds((String)"tcvat_rule_deduct", (int)(OrgSumList.size() * 6));
        if (OrgSumList.size() == 0 || fidArray.length == 0) {
            message.append("orgList is empty, does not need to be upgraded \n");
            return;
        }
        String[] batchRuleNumber = this.generateBatchRuleNumber("tcvat_rule_deduct", String.valueOf(OrgSumList.get(0).get("FORGID")), fidArray.length);
        if (null == batchRuleNumber) {
            message.append("RuleNumber generate failed, upgraded fail \n");
            return;
        }
        ArrayList<Object[]> mainTableParamList = new ArrayList<Object[]>(OrgSumList.size());
        ArrayList<Object[]> mainTable_LparamList = new ArrayList<Object[]>(OrgSumList.size() * 2);
        ArrayList<Object[]> amountRuleparamList = new ArrayList<Object[]>(OrgSumList.size() * 6);
        ArrayList<Object[]> taxRuleparamList = new ArrayList<Object[]>(OrgSumList.size() * 5);
        ArrayList<Object[]> numRuleparamList = new ArrayList<Object[]>(OrgSumList.size() * 5);
        String mainTable = "INSERT INTO t_tcvat_rule_deduct(FID,FMASTERID,FORGID,FSTATUS,FNAME,FNUMBER,FRULETYPE,FCREATETIME,FINVOICE,FENABLE,FMODIFIERID,FMODIFYTIME,FDEDUCTTYPE,FTAXPAYERTYPE,FCREATORID,FJZJT,FRULEPURPOSE,FISSYSTEM) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        String mainTable_L = "INSERT INTO t_tcvat_rule_deduct_l(FID,FPKID,FLOCALEID,FNAME) VALUES (?,?,?,?)";
        String amountRuleEntrty = "INSERT INTO t_tcvat_rule_deduct_entry(FABSOLUTE,FID,FBIZNAME,FFILTERCONDITION,FENTRYID,FDATATYPE,FAMOUNTFIELD,FENTRYENTITYCONFJSON,FSEQ,FFCONDITIONJSON,FDATADIRECTION,FTABLE,FENTRYENTITYCONF) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
        String taxRuleEntrty = "INSERT INTO t_tcvat_deduct_tax_entry(FABSOLUTE,FID,FBIZNAME,FFILTERCONDITION,FCONDITIONJSON,FENTRYID,FDATATYPE,FAMOUNTFIELD,FENTRYENTITYCONF,FSEQ,FDATADIRECTION,FTABLE,FENTRYENTITYCONFJSON) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
        String numRuleEntrty = "INSERT INTO t_tcvat_deduct_num_entry(FID,FTABLE,FENTRYID,FBIZNAME,FDATADIRECTION,FCONDITIONJSON,FDATATYPE,FSEQ,FABSOLUTE,FFILTERCONDITION,FAMOUNTFIELD) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
        int index = 0;
        for (int i = 0; i < OrgSumList.size(); ++i) {
            Map<String, String> selectFieldMap = OrgSumList.get(i);
            for (String deductTypeNumber : deductTypeNumberList) {
                DynamicObject ruleDynamicObject = this.getRuleDynamicObject(deductTypeNumber);
                long fid = fidArray[index];
                String fnumber = batchRuleNumber[index];
                mainTableParamList.add(new Object[]{fid, fid, Long.valueOf(selectFieldMap.get("FORGID")), "A", " ", fnumber, "private", new Date(), "0", "0", 13466739, new Date(), ruleDynamicObject.getLong("deducttype"), "ybnsr", 13466739, "0", ",sjjt,", "1"});
                long[] fpkid = DBUtils.getLongIds((String)"tcvat_rule_deduct", (int)2);
                mainTable_LparamList.add(new Object[]{fid, String.valueOf(fpkid[0]), "zh_CN", ResManager.loadKDString((String)ruleDynamicObject.getString("name"), (String)"DeductRuleAndDraftUpgradeService_31", (String)"taxc-tcvat", (Object[])new Object[0])});
                mainTable_LparamList.add(new Object[]{fid, String.valueOf(fpkid[1]), "zh_TW", ResManager.loadKDString((String)ruleDynamicObject.getString("name"), (String)"DeductRuleAndDraftUpgradeService_31", (String)"taxc-tcvat", (Object[])new Object[0])});
                long[] amountRulepkid = DBUtils.getLongIds((String)"tcvat_rule_deduct", (int)3);
                for (int j = 0; j < ruleDynamicObject.getDynamicObjectCollection("entryentity").size(); ++j) {
                    DynamicObject object = (DynamicObject)ruleDynamicObject.getDynamicObjectCollection("entryentity").get(j);
                    amountRuleparamList.add(new Object[]{"0", fid, object.getString("bizname"), object.getString("filtercondition"), amountRulepkid[j], "zjqs", object.getLong("amountfield"), " ", 1, object.getString("conditionjson"), object.getString("datadirection"), object.getLong("table"), " "});
                }
                long[] taxRulepkid = DBUtils.getLongIds((String)"tcvat_rule_deduct", (int)3);
                for (int j = 0; j < ruleDynamicObject.getDynamicObjectCollection("entryentity1").size(); ++j) {
                    DynamicObject object = (DynamicObject)ruleDynamicObject.getDynamicObjectCollection("entryentity1").get(j);
                    taxRuleparamList.add(new Object[]{"0", fid, object.getString("bizname1"), object.getString("filtercondition1"), object.getString("conditionjson1"), taxRulepkid[j], "zjqs", object.getLong("amountfield1"), "rate", 1, object.getString("datadirection1"), object.getLong("table1"), "0.00"});
                }
                long[] numRulepkid = DBUtils.getLongIds((String)"tcvat_rule_deduct", (int)3);
                for (int j = 0; j < ruleDynamicObject.getDynamicObjectCollection("entryentity11").size(); ++j) {
                    DynamicObject object = (DynamicObject)ruleDynamicObject.getDynamicObjectCollection("entryentity11").get(j);
                    numRuleparamList.add(new Object[]{fid, object.getLong("table11"), numRulepkid[j], object.getString("bizname11"), object.getString("datadirection11"), object.getString("conditionjson11"), "zjjs", 1, "0", object.getString("filtercondition11"), object.getLong("amountfield11")});
                }
                ++index;
            }
        }
        try (TXHandle h = TX.required();){
            try {
                if (mainTableParamList.size() > 0) {
                    DBUtils.executeBatch((String)mainTable, mainTableParamList);
                }
                if (mainTable_LparamList.size() > 0) {
                    DBUtils.executeBatch((String)mainTable_L, mainTable_LparamList);
                }
                if (amountRuleparamList.size() > 0) {
                    DBUtils.executeBatch((String)amountRuleEntrty, amountRuleparamList);
                }
                if (taxRuleparamList.size() > 0) {
                    DBUtils.executeBatch((String)taxRuleEntrty, taxRuleparamList);
                }
                if (numRuleparamList.size() > 0) {
                    DBUtils.executeBatch((String)numRuleEntrty, numRuleparamList);
                }
                message.append("ruleUpgrade SUCCESS").append('\n');
            }
            catch (Throwable t) {
                h.markRollback();
                message.append("YbnsrDraftUpdate FAILD:").append(t).append('\n');
                LOGGER.info("ruleUpgrade FAILURE", (Object)t);
            }
        }
    }

    private List<Map<String, String>> getNsrxxMap() {
        String orgSql = "select forgid from t_tctb_tax_main";
        DataSet OrgList = DB.queryDataSet((String)"TaxCategoryUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)orgSql);
        ArrayList<Map<String, String>> OrgSumList = new ArrayList<Map<String, String>>(500);
        while (OrgList.hasNext()) {
            HashMap<String, String> map = new HashMap<String, String>(8);
            Row row = OrgList.next();
            this.convertToLong(map, row, "FORGID");
            OrgSumList.add(map);
        }
        OrgList.close();
        return OrgSumList;
    }

    protected String[] generateBatchRuleNumber(String entityName, String orgid, int count) {
        if (!this.metaIsExist(entityName).booleanValue()) {
            return null;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        CodeRuleServiceHelper.getNumber((String)entityName, (DynamicObject)dynamicObject, (String)orgid);
        return CodeRuleServiceHelper.getBatchNumber((String)entityName, (DynamicObject)dynamicObject, (String)orgid, (int)count);
    }

    protected Boolean metaIsExist(String entityName) {
        try {
            MetadataUtil.getEntityById((String)entityName);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Boolean.FALSE;
        }
    }

    public DynamicObject getRuleDynamicObject(String deductTypeNumber) {
        if (deductTypeNumber.equals("VAT_JXDK_BQDK_1")) {
            DynamicObject mainObject0 = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_rule_deduct");
            mainObject0.set("id", (Object)1624659188489887744L);
            mainObject0.set("number", (Object)"VAT-RULE-INPUT-006104");
            mainObject0.set("name", (Object)ResManager.loadKDString((String)"\u672c\u671f\u8ba4\u8bc1\u76f8\u7b26\u7684\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", (String)"DeductRuleAndDraftUpgradeService_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            mainObject0.set("status", (Object)"A");
            mainObject0.set("creator", (Object)13466739L);
            mainObject0.set("modifier", (Object)13466739L);
            mainObject0.set("enable", (Object)"1");
            mainObject0.set("createtime", (Object)DateUtils.stringToDate((String)"2023-02-20 13:42:31", (String)"yyyy-MM-dd HH:mm:ss"));
            mainObject0.set("modifytime", (Object)DateUtils.stringToDate((String)"2023-02-20 14:27:47", (String)"yyyy-MM-dd HH:mm:ss"));
            mainObject0.set("masterid", (Object)1624659188489887744L);
            mainObject0.set("ruletype", (Object)"private");
            mainObject0.set("org", (Object)100000L);
            mainObject0.set("rulepurpose", (Object)",sjjt,");
            mainObject0.set("issystem", (Object)"0");
            mainObject0.set("deducttype", (Object)1376813763545544704L);
            mainObject0.set("jzjt", (Object)"0");
            mainObject0.set("invoice", (Object)"0");
            mainObject0.set("taxpayertype", (Object)"ybnsr");
            mainObject0.set("creator_id", (Object)13466739L);
            mainObject0.set("modifier_id", (Object)13466739L);
            mainObject0.set("org_id", (Object)100000L);
            mainObject0.set("deducttype_id", (Object)1376813763545544704L);
            DynamicObjectCollection entryentity0 = new DynamicObjectCollection();
            DynamicObjectCollection entryentity0Collection = mainObject0.getDynamicObjectCollection("entryentity");
            DynamicObject entryentity00 = entryentity0Collection.addNew();
            entryentity00.set("id", (Object)1624659188489887745L);
            entryentity00.set("seq", (Object)1);
            entryentity00.set("datadirection", (Object)"positive");
            entryentity00.set("bizname", (Object)ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", (String)"DeductRuleAndDraftUpgradeService_9", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity00.set("datatype", (Object)"zjqs");
            entryentity00.set("conditionjson", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"32JIC/5G0W6G\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"32JIC/5G2ZNI\"}],\"CompareType\":\"17\",\"Id\":\"32JIC/5G2ZNH\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"32JIC/5G2ZNJ\"}],\"CompareType\":\"105\",\"Id\":\"32JIC/5G0W6H\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"32JIC/5G2ZNK\"}],\"CompareType\":\"105\",\"Id\":\"32JIC/5G0W6I\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}");
            entryentity00.set("filtercondition", (Object)ResManager.loadKDString((String)"\u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14            \u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  ", (String)"DeductRuleAndDraftUpgradeService_10", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity00.set("amountfield", (Object)1467494794627385364L);
            entryentity00.set("table", (Object)1467494794577053696L);
            entryentity00.set("absolute", (Object)"false");
            entryentity00.set("entryentityconfjson", (Object)"0");
            entryentity00.set("entryentityconf", (Object)"");
            entryentity00.set("amountfield_id", (Object)1341339526118830101L);
            entryentity00.set("table_id", (Object)1467494794577053696L);
            entryentity0.add((Object)entryentity00);
            DynamicObject entryentity01 = entryentity0Collection.addNew();
            entryentity01.set("id", (Object)1624659188489887746L);
            entryentity01.set("seq", (Object)2);
            entryentity01.set("datadirection", (Object)"positive");
            entryentity01.set("bizname", (Object)ResManager.loadKDString((String)"\u5168\u7535\u4e13\u7968", (String)"DeductRuleAndDraftUpgradeService_43", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity01.set("datatype", (Object)"zjqs");
            entryentity01.set("conditionjson", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1376129725579325440\",\"Id\":\"33ZEGUV03WGQ\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09\",\"Id\":\"33ZEGUV03VTF\"}],\"CompareType\":\"67\",\"Id\":\"33ZEGUV03WGP\",\"Logic\":\"0\",\"FieldName\":\"invoice_type.name\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"33ZEGUV03WGR\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"33ZEGUV03VTH\"}],\"CompareType\":\"17\",\"Id\":\"33ZEGUV03VTG\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"33ZEGUV03VTI\"}],\"CompareType\":\"105\",\"Id\":\"33ZEGUV03WGS\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"33ZEGUV3R=+Z\"}],\"CompareType\":\"105\",\"Id\":\"33ZEGUV03WGT\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}");
            entryentity01.set("filtercondition", (Object)ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b.\u540d\u79f0 \u7b49\u4e8e \u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09  \u5e76\u4e14            \u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14    \u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38", (String)"DeductRuleAndDraftUpgradeService_44", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity01.set("amountfield", (Object)1407439936369483814L);
            entryentity01.set("table", (Object)1407439936361095168L);
            entryentity01.set("absolute", (Object)"false");
            entryentity01.set("entryentityconfjson", (Object)"0");
            entryentity01.set("entryentityconf", (Object)"");
            entryentity01.set("amountfield_id", (Object)1407439936369483814L);
            entryentity01.set("table_id", (Object)1407439936361095168L);
            entryentity0.add((Object)entryentity01);
            DynamicObject entryentity02 = entryentity0Collection.addNew();
            entryentity02.set("id", (Object)1624659188489887747L);
            entryentity02.set("seq", (Object)3);
            entryentity02.set("datadirection", (Object)"reverse");
            entryentity02.set("bizname", (Object)ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u8ba1\u7b97\u62b5\u6263-\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u4e13\u7968", (String)"DeductRuleAndDraftUpgradeService_45", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity02.set("datatype", (Object)"zjqs");
            entryentity02.set("conditionjson", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"4\",\"Id\":\"32JJ+VGSNXV9\"},{\"_Type_\":\"FilterValue\",\"Value\":\"27\",\"Id\":\"32JJ+VGSLUD9\"}],\"CompareType\":\"17\",\"Id\":\"32JJ+VGSLUD8\",\"Logic\":\"0\",\"FieldName\":\"datasources\"}]}");
            entryentity02.set("filtercondition", (Object)ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90 \u5728\u2026\u2026\u4e2d \u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968;\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u589e\u503c\u7a0e\u5168\u7535\u4e13\u7968  ", (String)"DeductRuleAndDraftUpgradeService_46", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity02.set("amountfield", (Object)1624630098651225100L);
            entryentity02.set("table", (Object)1624630098433121280L);
            entryentity02.set("absolute", (Object)"false");
            entryentity02.set("entryentityconfjson", (Object)"0");
            entryentity02.set("entryentityconf", (Object)"");
            entryentity02.set("amountfield_id", (Object)1624630098651225100L);
            entryentity02.set("table_id", (Object)1624630098433121280L);
            entryentity0.add((Object)entryentity02);
            DynamicObjectCollection entryentity10 = new DynamicObjectCollection();
            DynamicObjectCollection entryentity10Collection = mainObject0.getDynamicObjectCollection("entryentity1");
            DynamicObject entryentity100 = entryentity10Collection.addNew();
            entryentity100.set("id", (Object)1624659188489763842L);
            entryentity100.set("seq", (Object)1);
            entryentity100.set("bizname1", (Object)ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", (String)"DeductRuleAndDraftUpgradeService_9", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity100.set("table1", (Object)1467494794577053696L);
            entryentity100.set("amountfield1", (Object)1467494794627385388L);
            entryentity100.set("absolute1", (Object)"false");
            entryentity100.set("datatype1", (Object)"zjqs");
            entryentity100.set("datadirection1", (Object)"positive");
            entryentity100.set("filtercondition1", (Object)ResManager.loadKDString((String)"\u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14            \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  \u5e76\u4e14    \u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  ", (String)"DeductRuleAndDraftUpgradeService_47", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity100.set("conditionjson1", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"32JJ3YCR0NB+\"}],\"CompareType\":\"105\",\"Id\":\"32JJ3YCR2QT/\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"32JJ3YCR0NB/\"}],\"CompareType\":\"105\",\"Id\":\"32JJ3YCR2QT0\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"32JJ3YCR0NB0\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"32JJ3YCR2QT2\"}],\"CompareType\":\"17\",\"Id\":\"32JJ3YCR2QT1\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"}]}");
            entryentity100.set("entryentity1confjson", (Object)"0");
            entryentity100.set("entryentity1conf", (Object)"");
            entryentity100.set("table1_id", (Object)1467494794577053696L);
            entryentity100.set("amountfield1_id", (Object)1467494794627385388L);
            entryentity10.add((Object)entryentity100);
            DynamicObject entryentity101 = entryentity10Collection.addNew();
            entryentity101.set("id", (Object)1624659188489763843L);
            entryentity101.set("seq", (Object)2);
            entryentity101.set("bizname1", (Object)ResManager.loadKDString((String)"\u5168\u7535\u4e13\u7968", (String)"DeductRuleAndDraftUpgradeService_43", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity101.set("table1", (Object)1407439936361095168L);
            entryentity101.set("amountfield1", (Object)1407439936369483798L);
            entryentity101.set("absolute1", (Object)"false");
            entryentity101.set("datatype1", (Object)"zjqs");
            entryentity101.set("datadirection1", (Object)"positive");
            entryentity101.set("filtercondition1", (Object)ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b.\u540d\u79f0 \u7b49\u4e8e \u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09  \u5e76\u4e14            \u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14    \u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38", (String)"DeductRuleAndDraftUpgradeService_44", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity101.set("conditionjson1", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1376129725579325440\",\"Id\":\"33ZEGUV03WGQ\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09\",\"Id\":\"33ZEGUV03VTF\"}],\"CompareType\":\"67\",\"Id\":\"33ZEGUV03WGP\",\"Logic\":\"0\",\"FieldName\":\"invoice_type.name\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"33ZEGUV03WGR\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"33ZEGUV03VTH\"}],\"CompareType\":\"17\",\"Id\":\"33ZEGUV03VTG\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"33ZEGUV03VTI\"}],\"CompareType\":\"105\",\"Id\":\"33ZEGUV03WGS\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"33ZEGUV3R=+Z\"}],\"CompareType\":\"105\",\"Id\":\"33ZEGUV03WGT\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}");
            entryentity101.set("entryentity1confjson", (Object)"0");
            entryentity101.set("entryentity1conf", (Object)"");
            entryentity101.set("table1_id", (Object)1407439936361095168L);
            entryentity101.set("amountfield1_id", (Object)1407439936369483798L);
            entryentity10.add((Object)entryentity101);
            DynamicObject entryentity102 = entryentity10Collection.addNew();
            entryentity102.set("id", (Object)1624659188489763844L);
            entryentity102.set("seq", (Object)3);
            entryentity102.set("bizname1", (Object)ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u8ba1\u7b97\u62b5\u6263-\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u4e13\u7968", (String)"DeductRuleAndDraftUpgradeService_45", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity102.set("table1", (Object)1624630098433121280L);
            entryentity102.set("amountfield1", (Object)1637677098460306432L);
            entryentity102.set("absolute1", (Object)"false");
            entryentity102.set("datatype1", (Object)"zjqs");
            entryentity102.set("datadirection1", (Object)"reverse");
            entryentity102.set("filtercondition1", (Object)ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90 \u5728\u2026\u2026\u4e2d \u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968;\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u589e\u503c\u7a0e\u5168\u7535\u4e13\u7968  ", (String)"DeductRuleAndDraftUpgradeService_46", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity102.set("conditionjson1", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"4\",\"Id\":\"32JJ7O44Y=YA\"},{\"_Type_\":\"FilterValue\",\"Value\":\"27\",\"Id\":\"32JJ7O45+DDC\"}],\"CompareType\":\"17\",\"Id\":\"32JJ7O45+DDB\",\"Logic\":\"0\",\"FieldName\":\"datasources\"}]}");
            entryentity102.set("entryentity1confjson", (Object)"0");
            entryentity102.set("entryentity1conf", (Object)"");
            entryentity102.set("table1_id", (Object)1624630098433121280L);
            entryentity102.set("amountfield1_id", (Object)1637677098460306432L);
            entryentity10.add((Object)entryentity102);
            DynamicObjectCollection entryentity110 = new DynamicObjectCollection();
            DynamicObjectCollection entryentity110Collection = mainObject0.getDynamicObjectCollection("entryentity11");
            DynamicObject entryentity1100 = entryentity110Collection.addNew();
            entryentity1100.set("id", (Object)1624659188489887748L);
            entryentity1100.set("seq", (Object)1);
            entryentity1100.set("bizname11", (Object)ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", (String)"DeductRuleAndDraftUpgradeService_9", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity1100.set("table11", (Object)1467494794577053696L);
            entryentity1100.set("amountfield11", (Object)1467494794627385353L);
            entryentity1100.set("absolute11", (Object)"false");
            entryentity1100.set("datatype11", (Object)"zjjs");
            entryentity1100.set("datadirection11", (Object)"positive");
            entryentity1100.set("filtercondition11", (Object)ResManager.loadKDString((String)"\u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14            \u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  ", (String)"DeductRuleAndDraftUpgradeService_48", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity1100.set("conditionjson11", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"32JJBLI8NP4Z\"}],\"CompareType\":\"105\",\"Id\":\"32JJBLI8LLOY\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"32JJBLI8NP5+\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"32JJBLI8LLP+\"}],\"CompareType\":\"17\",\"Id\":\"32JJBLI8LLOZ\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"32JJBLI8LLP/\"}],\"CompareType\":\"105\",\"Id\":\"32JJBLI8NP5/\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}");
            entryentity1100.set("table11_id", (Object)1467494794577053696L);
            entryentity1100.set("amountfield11_id", (Object)1467494794627385353L);
            entryentity110.add((Object)entryentity1100);
            DynamicObject entryentity1101 = entryentity110Collection.addNew();
            entryentity1101.set("id", (Object)1624659188489887749L);
            entryentity1101.set("seq", (Object)2);
            entryentity1101.set("bizname11", (Object)ResManager.loadKDString((String)"\u5168\u7535\u4e13\u7968", (String)"DeductRuleAndDraftUpgradeService_43", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity1101.set("table11", (Object)1407439936361095168L);
            entryentity1101.set("amountfield11", (Object)1407439936369483823L);
            entryentity1101.set("absolute11", (Object)"false");
            entryentity1101.set("datatype11", (Object)"zjjs");
            entryentity1101.set("datadirection11", (Object)"positive");
            entryentity1101.set("filtercondition11", (Object)ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b.\u540d\u79f0 \u7b49\u4e8e \u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09  \u5e76\u4e14            \u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14    \u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38", (String)"DeductRuleAndDraftUpgradeService_44", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity1101.set("conditionjson11", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1376129725579325440\",\"Id\":\"33ZEGUV03WGQ\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09\",\"Id\":\"33ZEGUV03VTF\"}],\"CompareType\":\"67\",\"Id\":\"33ZEGUV03WGP\",\"Logic\":\"0\",\"FieldName\":\"invoice_type.name\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"33ZEGUV03WGR\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"33ZEGUV03VTH\"}],\"CompareType\":\"17\",\"Id\":\"33ZEGUV03VTG\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"33ZEGUV03VTI\"}],\"CompareType\":\"105\",\"Id\":\"33ZEGUV03WGS\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"33ZEGUV3R=+Z\"}],\"CompareType\":\"105\",\"Id\":\"33ZEGUV03WGT\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}");
            entryentity1101.set("table11_id", (Object)1407439936361095168L);
            entryentity1101.set("amountfield11_id", (Object)1407439936369483823L);
            entryentity110.add((Object)entryentity1101);
            DynamicObject entryentity1102 = entryentity110Collection.addNew();
            entryentity1102.set("id", (Object)1624659188489887750L);
            entryentity1102.set("seq", (Object)3);
            entryentity1102.set("bizname11", (Object)ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u8ba1\u7b97\u62b5\u6263-\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u4e13\u7968", (String)"DeductRuleAndDraftUpgradeService_45", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity1102.set("table11", (Object)1624630098433121280L);
            entryentity1102.set("amountfield11", (Object)1624630098651225104L);
            entryentity1102.set("absolute11", (Object)"false");
            entryentity1102.set("datatype11", (Object)"zjqs");
            entryentity1102.set("datadirection11", (Object)"reverse");
            entryentity1102.set("filtercondition11", (Object)ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90 \u5728\u2026\u2026\u4e2d \u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968;\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u589e\u503c\u7a0e\u5168\u7535\u4e13\u7968  ", (String)"DeductRuleAndDraftUpgradeService_46", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity1102.set("conditionjson11", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"4\",\"Id\":\"32JJV+KYQ=JX\"},{\"_Type_\":\"FilterValue\",\"Value\":\"27\",\"Id\":\"32JJV+KYSD/Z\"}],\"CompareType\":\"17\",\"Id\":\"32JJV+KYSD/Y\",\"Logic\":\"0\",\"FieldName\":\"datasources\"}]}");
            entryentity1102.set("table11_id", (Object)1624630098433121280L);
            entryentity1102.set("amountfield11_id", (Object)1624630098651225104L);
            entryentity110.add((Object)entryentity1102);
            return mainObject0;
        }
        if (deductTypeNumber.equals("VAT_JXDK_BQDK_5")) {
            DynamicObject mainObject1 = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_rule_deduct");
            mainObject1.set("id", (Object)1624667222519816192L);
            mainObject1.set("number", (Object)"VAT-RULE-INPUT-006106");
            mainObject1.set("name", (Object)ResManager.loadKDString((String)"\u672c\u671f\u8ba4\u8bc1\u76f8\u7b26\u7684\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968", (String)"DeductRuleAndDraftUpgradeService_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            mainObject1.set("status", (Object)"A");
            mainObject1.set("creator", (Object)13466739L);
            mainObject1.set("modifier", (Object)13466739L);
            mainObject1.set("enable", (Object)"1");
            mainObject1.set("createtime", (Object)DateUtils.stringToDate((String)"2023-02-20 14:39:23", (String)"yyyy-MM-dd HH:mm:ss"));
            mainObject1.set("modifytime", (Object)DateUtils.stringToDate((String)"2023-02-20 14:43:45", (String)"yyyy-MM-dd HH:mm:ss"));
            mainObject1.set("masterid", (Object)1624667222519816192L);
            mainObject1.set("ruletype", (Object)"private");
            mainObject1.set("org", (Object)100000L);
            mainObject1.set("rulepurpose", (Object)",sjjt,");
            mainObject1.set("issystem", (Object)"0");
            mainObject1.set("deducttype", (Object)1377423719802102784L);
            mainObject1.set("jzjt", (Object)"0");
            mainObject1.set("invoice", (Object)"0");
            mainObject1.set("taxpayertype", (Object)"ybnsr");
            mainObject1.set("creator_id", (Object)13466739L);
            mainObject1.set("modifier_id", (Object)13466739L);
            mainObject1.set("org_id", (Object)100000L);
            mainObject1.set("deducttype_id", (Object)1377423719802102784L);
            DynamicObjectCollection entryentity1 = new DynamicObjectCollection();
            DynamicObjectCollection entryentity1Collection = mainObject1.getDynamicObjectCollection("entryentity");
            DynamicObject entryentity1010 = entryentity1Collection.addNew();
            entryentity1010.set("id", (Object)1624667222519816193L);
            entryentity1010.set("seq", (Object)1);
            entryentity1010.set("datadirection", (Object)"positive");
            entryentity1010.set("bizname", (Object)ResManager.loadKDString((String)"\u8fdb\u9879\u62b5\u6263\u91d1\u989d\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleAndDraftUpgradeService_49", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity1010.set("datatype", (Object)"zjqs");
            entryentity1010.set("conditionjson", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"32JM+U+EQKD0\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"32JM+U+EOGY0\"}],\"CompareType\":\"17\",\"Id\":\"32JM+U+EOGY/\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"32JM+U+EOGY1\"}],\"CompareType\":\"105\",\"Id\":\"32JM+U+EQKD1\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"32JM+U+EOGY2\"}],\"CompareType\":\"105\",\"Id\":\"32JM+U+EQKD2\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}");
            entryentity1010.set("filtercondition", (Object)ResManager.loadKDString((String)"\u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14            \u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  ", (String)"DeductRuleAndDraftUpgradeService_10", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity1010.set("amountfield", (Object)1381723694149174305L);
            entryentity1010.set("table", (Object)1381723694140785664L);
            entryentity1010.set("absolute", (Object)"false");
            entryentity1010.set("entryentityconfjson", (Object)"0");
            entryentity1010.set("entryentityconf", (Object)"");
            entryentity1010.set("amountfield_id", (Object)1381723694149174305L);
            entryentity1010.set("table_id", (Object)1381723694140785664L);
            entryentity1.add((Object)entryentity1010);
            DynamicObjectCollection entryentity11 = new DynamicObjectCollection();
            DynamicObjectCollection entryentity11Collection = mainObject1.getDynamicObjectCollection("entryentity1");
            DynamicObject entryentity11011 = entryentity11Collection.addNew();
            entryentity11011.set("id", (Object)1624667222519692290L);
            entryentity11011.set("seq", (Object)1);
            entryentity11011.set("bizname1", (Object)ResManager.loadKDString((String)"\u7a0e\u989d\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleAndDraftUpgradeService_50", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity11011.set("table1", (Object)1381723694140785664L);
            entryentity11011.set("amountfield1", (Object)1381723694149174324L);
            entryentity11011.set("absolute1", (Object)"false");
            entryentity11011.set("datatype1", (Object)"zjqs");
            entryentity11011.set("datadirection1", (Object)"positive");
            entryentity11011.set("filtercondition1", (Object)ResManager.loadKDString((String)"\u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14            \u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  ", (String)"DeductRuleAndDraftUpgradeService_10", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity11011.set("conditionjson1", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"32JM+U+EQKD0\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"32JM+U+EOGY0\"}],\"CompareType\":\"17\",\"Id\":\"32JM+U+EOGY/\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"32JM+U+EOGY1\"}],\"CompareType\":\"105\",\"Id\":\"32JM+U+EQKD1\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"32JM+U+EOGY2\"}],\"CompareType\":\"105\",\"Id\":\"32JM+U+EQKD2\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}");
            entryentity11011.set("entryentity1confjson", (Object)"0");
            entryentity11011.set("entryentity1conf", (Object)"");
            entryentity11011.set("table1_id", (Object)1381723694140785664L);
            entryentity11011.set("amountfield1_id", (Object)1381723694149174324L);
            entryentity11.add((Object)entryentity11011);
            DynamicObjectCollection entryentity111 = new DynamicObjectCollection();
            DynamicObjectCollection entryentity111Collection = mainObject1.getDynamicObjectCollection("entryentity11");
            DynamicObject entryentity1110 = entryentity111Collection.addNew();
            entryentity1110.set("id", (Object)1624667222519816194L);
            entryentity1110.set("seq", (Object)1);
            entryentity1110.set("bizname11", (Object)ResManager.loadKDString((String)"\u4efd\u6570\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleAndDraftUpgradeService_51", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity1110.set("table11", (Object)1381723694140785664L);
            entryentity1110.set("amountfield11", (Object)1381723694149174329L);
            entryentity1110.set("absolute11", (Object)"false");
            entryentity1110.set("datatype11", (Object)"zjjs");
            entryentity1110.set("datadirection11", (Object)"positive");
            entryentity1110.set("filtercondition11", (Object)ResManager.loadKDString((String)"\u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14            \u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  ", (String)"DeductRuleAndDraftUpgradeService_10", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity1110.set("conditionjson11", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"32JM23BH0W0T\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"32JM23BH2ZHV\"}],\"CompareType\":\"17\",\"Id\":\"32JM23BH2ZHU\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"32JM23BH2ZHW\"}],\"CompareType\":\"105\",\"Id\":\"32JM23BH0W0U\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"32JM23BH2ZHX\"}],\"CompareType\":\"105\",\"Id\":\"32JM23BH0W0V\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}");
            entryentity1110.set("table11_id", (Object)1381723694140785664L);
            entryentity1110.set("amountfield11_id", (Object)1381723694149174329L);
            entryentity111.add((Object)entryentity1110);
            return mainObject1;
        }
        if (deductTypeNumber.equals("VAT_JXDK_BQDK_7")) {
            DynamicObject mainObject2 = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_rule_deduct");
            mainObject2.set("id", (Object)1624676553378209792L);
            mainObject2.set("number", (Object)"VAT-RULE-INPUT-006107");
            mainObject2.set("name", (Object)ResManager.loadKDString((String)"\u6d77\u5173\u8fdb\u53e3\u589e\u503c\u7a0e\u4e13\u7528\u7f34\u6b3e\u4e66", (String)"DeductRuleAndDraftUpgradeService_3", (String)"taxc-tcvat", (Object[])new Object[0]));
            mainObject2.set("status", (Object)"A");
            mainObject2.set("creator", (Object)13466739L);
            mainObject2.set("modifier", (Object)13466739L);
            mainObject2.set("enable", (Object)"1");
            mainObject2.set("createtime", (Object)DateUtils.stringToDate((String)"2023-02-20 14:44:06", (String)"yyyy-MM-dd HH:mm:ss"));
            mainObject2.set("modifytime", (Object)DateUtils.stringToDate((String)"2023-02-20 15:02:17", (String)"yyyy-MM-dd HH:mm:ss"));
            mainObject2.set("masterid", (Object)1624676553378209792L);
            mainObject2.set("ruletype", (Object)"private");
            mainObject2.set("org", (Object)100000L);
            mainObject2.set("rulepurpose", (Object)",sjjt,");
            mainObject2.set("issystem", (Object)"0");
            mainObject2.set("deducttype", (Object)1377424194228324352L);
            mainObject2.set("jzjt", (Object)"0");
            mainObject2.set("invoice", (Object)"0");
            mainObject2.set("taxpayertype", (Object)"ybnsr");
            mainObject2.set("creator_id", (Object)13466739L);
            mainObject2.set("modifier_id", (Object)13466739L);
            mainObject2.set("org_id", (Object)100000L);
            mainObject2.set("deducttype_id", (Object)1377424194228324352L);
            DynamicObjectCollection entryentity2 = new DynamicObjectCollection();
            DynamicObjectCollection entryentity2Collection = mainObject2.getDynamicObjectCollection("entryentity");
            DynamicObject entryentity20 = entryentity2Collection.addNew();
            entryentity20.set("id", (Object)1624676553378209793L);
            entryentity20.set("seq", (Object)1);
            entryentity20.set("datadirection", (Object)"positive");
            entryentity20.set("bizname", (Object)ResManager.loadKDString((String)"\u8fdb\u9879\u62b5\u6263\u91d1\u989d\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleAndDraftUpgradeService_49", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity20.set("datatype", (Object)"zjqs");
            entryentity20.set("conditionjson", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"34+22QA0NP8Y\"}],\"CompareType\":\"17\",\"Id\":\"34+22QA0NPY6\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"34+22QA0NP8Z\"}],\"CompareType\":\"105\",\"Id\":\"34+22QA0NPY7\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"(\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\",\"Id\":\"34+22QA0NP9+\"}],\"CompareType\":\"1103\",\"Id\":\"34+22QA0NPY8\",\"Logic\":\"1\",\"FieldName\":\"manage_status\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\")\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"34+22QA0NP9/\"}],\"CompareType\":\"105\",\"Id\":\"34+22QA0NPY9\",\"Logic\":\"0\",\"FieldName\":\"manage_status\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"34+22QA0NP90\"}],\"CompareType\":\"105\",\"Id\":\"34+22QA0NPY=\",\"Logic\":\"0\",\"FieldName\":\"delete\"}]}");
            entryentity20.set("filtercondition", (Object)ResManager.loadKDString((String)"\u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1  \u5e76\u4e14            \u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14      ( \u7ba1\u7406\u72b6\u6001 \u4e3a \u4e3a\u7a7a  \u6216\u8005     \u7ba1\u7406\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38 ) \u5e76\u4e14            \u53ef\u7528\u72b6\u6001 \u7b49\u4e8e \u53ef\u7528", (String)"DeductRuleAndDraftUpgradeService_52", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity20.set("amountfield", (Object)1624673217690181688L);
            entryentity20.set("table", (Object)1624673217673404416L);
            entryentity20.set("absolute", (Object)"false");
            entryentity20.set("entryentityconfjson", (Object)"0");
            entryentity20.set("entryentityconf", (Object)"");
            entryentity20.set("amountfield_id", (Object)1624673217690181688L);
            entryentity20.set("table_id", (Object)1624673217673404416L);
            entryentity2.add((Object)entryentity20);
            DynamicObjectCollection entryentity12 = new DynamicObjectCollection();
            DynamicObjectCollection entryentity12Collection = mainObject2.getDynamicObjectCollection("entryentity1");
            DynamicObject entryentity120 = entryentity12Collection.addNew();
            entryentity120.set("id", (Object)1624676553378085890L);
            entryentity120.set("seq", (Object)1);
            entryentity120.set("bizname1", (Object)ResManager.loadKDString((String)"\u7a0e\u989d\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleAndDraftUpgradeService_50", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity120.set("table1", (Object)1624673217673404416L);
            entryentity120.set("amountfield1", (Object)1624673217690181660L);
            entryentity120.set("absolute1", (Object)"false");
            entryentity120.set("datatype1", (Object)"zjqs");
            entryentity120.set("datadirection1", (Object)"positive");
            entryentity120.set("filtercondition1", (Object)ResManager.loadKDString((String)"\u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1  \u5e76\u4e14            \u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14      ( \u7ba1\u7406\u72b6\u6001 \u4e3a \u4e3a\u7a7a  \u6216\u8005     \u7ba1\u7406\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38 ) \u5e76\u4e14            \u53ef\u7528\u72b6\u6001 \u7b49\u4e8e \u53ef\u7528", (String)"DeductRuleAndDraftUpgradeService_52", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity120.set("conditionjson1", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"34+22QA0NP8Y\"}],\"CompareType\":\"17\",\"Id\":\"34+22QA0NPY6\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"34+22QA0NP8Z\"}],\"CompareType\":\"105\",\"Id\":\"34+22QA0NPY7\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"(\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\",\"Id\":\"34+22QA0NP9+\"}],\"CompareType\":\"1103\",\"Id\":\"34+22QA0NPY8\",\"Logic\":\"1\",\"FieldName\":\"manage_status\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\")\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"34+22QA0NP9/\"}],\"CompareType\":\"105\",\"Id\":\"34+22QA0NPY9\",\"Logic\":\"0\",\"FieldName\":\"manage_status\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"34+22QA0NP90\"}],\"CompareType\":\"105\",\"Id\":\"34+22QA0NPY=\",\"Logic\":\"0\",\"FieldName\":\"delete\"}]}");
            entryentity120.set("entryentity1confjson", (Object)"0");
            entryentity120.set("entryentity1conf", (Object)"");
            entryentity120.set("table1_id", (Object)1624673217673404416L);
            entryentity120.set("amountfield1_id", (Object)1624673217690181660L);
            entryentity12.add((Object)entryentity120);
            DynamicObjectCollection entryentity112 = new DynamicObjectCollection();
            DynamicObjectCollection entryentity112Collection = mainObject2.getDynamicObjectCollection("entryentity11");
            DynamicObject entryentity1120 = entryentity112Collection.addNew();
            entryentity1120.set("id", (Object)1624676553378209794L);
            entryentity1120.set("seq", (Object)1);
            entryentity1120.set("bizname11", (Object)ResManager.loadKDString((String)"\u4efd\u6570\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleAndDraftUpgradeService_51", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity1120.set("table11", (Object)1624673217673404416L);
            entryentity1120.set("amountfield11", (Object)1624673217690181632L);
            entryentity1120.set("absolute11", (Object)"false");
            entryentity1120.set("datatype11", (Object)"zjjs");
            entryentity1120.set("datadirection11", (Object)"positive");
            entryentity1120.set("filtercondition11", (Object)ResManager.loadKDString((String)"\u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1  \u5e76\u4e14            \u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14      ( \u7ba1\u7406\u72b6\u6001 \u4e3a \u4e3a\u7a7a  \u6216\u8005     \u7ba1\u7406\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38 ) \u5e76\u4e14            \u53ef\u7528\u72b6\u6001 \u7b49\u4e8e \u53ef\u7528", (String)"DeductRuleAndDraftUpgradeService_52", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity1120.set("conditionjson11", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"34+22QA0NP8Y\"}],\"CompareType\":\"17\",\"Id\":\"34+22QA0NPY6\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"34+22QA0NP8Z\"}],\"CompareType\":\"105\",\"Id\":\"34+22QA0NPY7\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"(\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\",\"Id\":\"34+22QA0NP9+\"}],\"CompareType\":\"1103\",\"Id\":\"34+22QA0NPY8\",\"Logic\":\"1\",\"FieldName\":\"manage_status\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\")\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"34+22QA0NP9/\"}],\"CompareType\":\"105\",\"Id\":\"34+22QA0NPY9\",\"Logic\":\"0\",\"FieldName\":\"manage_status\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"34+22QA0NP90\"}],\"CompareType\":\"105\",\"Id\":\"34+22QA0NPY=\",\"Logic\":\"0\",\"FieldName\":\"delete\"}]}");
            entryentity1120.set("table11_id", (Object)1624673217673404416L);
            entryentity1120.set("amountfield11_id", (Object)1624673217690181632L);
            entryentity112.add((Object)entryentity1120);
            return mainObject2;
        }
        if (deductTypeNumber.equals("VAT_JXDK_BQDK_8")) {
            DynamicObject mainObject3 = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_rule_deduct");
            mainObject3.set("id", (Object)1624677511264844800L);
            mainObject3.set("number", (Object)"VAT-RULE-INPUT-006108");
            mainObject3.set("name", (Object)ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968\u6216\u8005\u9500\u552e\u53d1\u7968", (String)"DeductRuleAndDraftUpgradeService_8", (String)"taxc-tcvat", (Object[])new Object[0]));
            mainObject3.set("status", (Object)"A");
            mainObject3.set("creator", (Object)13466739L);
            mainObject3.set("modifier", (Object)13466739L);
            mainObject3.set("enable", (Object)"1");
            mainObject3.set("createtime", (Object)DateUtils.stringToDate((String)"2023-02-20 15:02:26", (String)"yyyy-MM-dd HH:mm:ss"));
            mainObject3.set("modifytime", (Object)DateUtils.stringToDate((String)"2023-02-20 15:06:49", (String)"yyyy-MM-dd HH:mm:ss"));
            mainObject3.set("masterid", (Object)1624677511264844800L);
            mainObject3.set("ruletype", (Object)"private");
            mainObject3.set("org", (Object)100000L);
            mainObject3.set("rulepurpose", (Object)",sjjt,");
            mainObject3.set("issystem", (Object)"0");
            mainObject3.set("deducttype", (Object)1377424440996005888L);
            mainObject3.set("jzjt", (Object)"0");
            mainObject3.set("invoice", (Object)"0");
            mainObject3.set("taxpayertype", (Object)"ybnsr");
            mainObject3.set("creator_id", (Object)13466739L);
            mainObject3.set("modifier_id", (Object)13466739L);
            mainObject3.set("org_id", (Object)100000L);
            mainObject3.set("deducttype_id", (Object)1377424440996005888L);
            DynamicObjectCollection entryentity3 = new DynamicObjectCollection();
            DynamicObjectCollection entryentity3Collection = mainObject3.getDynamicObjectCollection("entryentity");
            DynamicObject entryentity30 = entryentity3Collection.addNew();
            entryentity30.set("id", (Object)1624677511264844801L);
            entryentity30.set("seq", (Object)1);
            entryentity30.set("datadirection", (Object)"positive");
            entryentity30.set("bizname", (Object)ResManager.loadKDString((String)"\u8fdb\u9879\u62b5\u6263\u91d1\u989d\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleAndDraftUpgradeService_49", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity30.set("datatype", (Object)"zjqs");
            entryentity30.set("conditionjson", (Object)"");
            entryentity30.set("filtercondition", (Object)"");
            entryentity30.set("amountfield", (Object)1624630098651225100L);
            entryentity30.set("table", (Object)1624630098433121280L);
            entryentity30.set("absolute", (Object)"false");
            entryentity30.set("entryentityconfjson", (Object)"0");
            entryentity30.set("entryentityconf", (Object)"");
            entryentity30.set("amountfield_id", (Object)1624630098651225100L);
            entryentity30.set("table_id", (Object)1624630098433121280L);
            entryentity3.add((Object)entryentity30);
            DynamicObjectCollection entryentity13 = new DynamicObjectCollection();
            DynamicObjectCollection entryentity13Collection = mainObject3.getDynamicObjectCollection("entryentity1");
            DynamicObject entryentity130 = entryentity13Collection.addNew();
            entryentity130.set("id", (Object)1624677511264968706L);
            entryentity130.set("seq", (Object)1);
            entryentity130.set("bizname1", (Object)ResManager.loadKDString((String)"\u7a0e\u989d\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleAndDraftUpgradeService_50", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity130.set("table1", (Object)1624630098433121280L);
            entryentity130.set("amountfield1", (Object)1624630098651225101L);
            entryentity130.set("absolute1", (Object)"false");
            entryentity130.set("datatype1", (Object)"zjqs");
            entryentity130.set("datadirection1", (Object)"positive");
            entryentity130.set("filtercondition1", (Object)"");
            entryentity130.set("conditionjson1", (Object)"");
            entryentity130.set("entryentity1confjson", (Object)"0");
            entryentity130.set("entryentity1conf", (Object)"");
            entryentity130.set("table1_id", (Object)1624630098433121280L);
            entryentity130.set("amountfield1_id", (Object)1624630098651225101L);
            entryentity13.add((Object)entryentity130);
            DynamicObjectCollection entryentity113 = new DynamicObjectCollection();
            DynamicObjectCollection entryentity113Collection = mainObject3.getDynamicObjectCollection("entryentity11");
            DynamicObject entryentity1130 = entryentity113Collection.addNew();
            entryentity1130.set("id", (Object)1624677511264844802L);
            entryentity1130.set("seq", (Object)1);
            entryentity1130.set("bizname11", (Object)ResManager.loadKDString((String)"\u4efd\u6570\u53d6\u6570\u914d\u7f6e\uff08\u6765\u6e90\u53d1\u7968\uff09", (String)"DeductRuleAndDraftUpgradeService_53", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity1130.set("table11", (Object)1624630098433121280L);
            entryentity1130.set("amountfield11", (Object)1624630098651225104L);
            entryentity1130.set("absolute11", (Object)"false");
            entryentity1130.set("datatype11", (Object)"zjjs");
            entryentity1130.set("datadirection11", (Object)"positive");
            entryentity1130.set("filtercondition11", (Object)ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90 \u5728\u2026\u2026\u4e2d \u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968;\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968;\u589e\u503c\u7a0e\u5168\u7535\u666e\u7968;\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u589e\u503c\u7a0e\u5168\u7535\u4e13\u7968  ", (String)"DeductRuleAndDraftUpgradeService_54", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity1130.set("conditionjson11", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"32JO0LY68AOW\"},{\"_Type_\":\"FilterValue\",\"Value\":\"4\",\"Id\":\"32JO0LY6687W\"},{\"_Type_\":\"FilterValue\",\"Value\":\"26\",\"Id\":\"32JO0LY68AOX\"},{\"_Type_\":\"FilterValue\",\"Value\":\"27\",\"Id\":\"32JO0LY6687X\"}],\"CompareType\":\"17\",\"Id\":\"32JO0LY6687V\",\"Logic\":\"0\",\"FieldName\":\"datasources\"}]}");
            entryentity1130.set("table11_id", (Object)1624630098433121280L);
            entryentity1130.set("amountfield11_id", (Object)1624630098651225104L);
            entryentity113.add((Object)entryentity1130);
            DynamicObject entryentity1131 = entryentity113Collection.addNew();
            entryentity1131.set("id", (Object)1624678835968778240L);
            entryentity1131.set("seq", (Object)2);
            entryentity1131.set("bizname11", (Object)ResManager.loadKDString((String)"\u4efd\u6570\u53d6\u6570\u914d\u7f6e\uff08\u624b\u5de5\u65b0\u589e\uff09", (String)"DeductRuleAndDraftUpgradeService_55", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity1131.set("table11", (Object)1624630098433121280L);
            entryentity1131.set("amountfield11", (Object)1624630098651225088L);
            entryentity1131.set("absolute11", (Object)"false");
            entryentity1131.set("datatype11", (Object)"zjjs");
            entryentity1131.set("datadirection11", (Object)"positive");
            entryentity1131.set("filtercondition11", (Object)ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90 \u7b49\u4e8e \u624b\u5de5\u65b0\u589e  ", (String)"DeductRuleAndDraftUpgradeService_56", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity1131.set("conditionjson11", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"xz\",\"Id\":\"32JO8SIRENY8\"}],\"CompareType\":\"105\",\"Id\":\"32JO8SIRGRD9\",\"Logic\":\"0\",\"FieldName\":\"datasources\"}]}");
            entryentity1131.set("table11_id", (Object)1624630098433121280L);
            entryentity1131.set("amountfield11_id", (Object)1624630098651225088L);
            entryentity113.add((Object)entryentity1131);
            return mainObject3;
        }
        if (deductTypeNumber.equals("VAT_JXDK_BQDK_9")) {
            DynamicObject mainObject5 = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_rule_deduct");
            mainObject5.set("id", (Object)1624682001225333760L);
            mainObject5.set("number", (Object)"VAT-RULE-INPUT-006109");
            mainObject5.set("name", (Object)ResManager.loadKDString((String)"\u4ee3\u6263\u4ee3\u7f34\u7a0e\u6536\u7f34\u6b3e\u51ed\u8bc1", (String)"DeductRuleAndDraftUpgradeService_7", (String)"taxc-tcvat", (Object[])new Object[0]));
            mainObject5.set("status", (Object)"A");
            mainObject5.set("creator", (Object)13466739L);
            mainObject5.set("modifier", (Object)13466739L);
            mainObject5.set("enable", (Object)"1");
            mainObject5.set("createtime", (Object)DateUtils.stringToDate((String)"2023-02-20 15:11:09", (String)"yyyy-MM-dd HH:mm:ss"));
            mainObject5.set("modifytime", (Object)DateUtils.stringToDate((String)"2023-02-20 15:27:08", (String)"yyyy-MM-dd HH:mm:ss"));
            mainObject5.set("masterid", (Object)1624682001225333760L);
            mainObject5.set("ruletype", (Object)"private");
            mainObject5.set("org", (Object)100000L);
            mainObject5.set("rulepurpose", (Object)",sjjt,");
            mainObject5.set("issystem", (Object)"0");
            mainObject5.set("deducttype", (Object)1377424673628775424L);
            mainObject5.set("jzjt", (Object)"0");
            mainObject5.set("invoice", (Object)"0");
            mainObject5.set("taxpayertype", (Object)"ybnsr");
            mainObject5.set("creator_id", (Object)13466739L);
            mainObject5.set("modifier_id", (Object)13466739L);
            mainObject5.set("org_id", (Object)100000L);
            mainObject5.set("deducttype_id", (Object)1377424673628775424L);
            DynamicObjectCollection entryentity5 = new DynamicObjectCollection();
            DynamicObjectCollection entryentity5Collection = mainObject5.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection entryentity15 = new DynamicObjectCollection();
            DynamicObjectCollection entryentity15Collection = mainObject5.getDynamicObjectCollection("entryentity1");
            DynamicObject entryentity150 = entryentity15Collection.addNew();
            entryentity150.set("id", (Object)1624682001233722368L);
            entryentity150.set("seq", (Object)1);
            entryentity150.set("bizname1", (Object)ResManager.loadKDString((String)"\u7a0e\u989d\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleAndDraftUpgradeService_50", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity150.set("table1", (Object)1057932119981961216L);
            entryentity150.set("amountfield1", (Object)1057932120015515672L);
            entryentity150.set("absolute1", (Object)"false");
            entryentity150.set("datatype1", (Object)"zjqs");
            entryentity150.set("datadirection1", (Object)"positive");
            entryentity150.set("filtercondition1", (Object)ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u7a0e\u79cd\u540d\u79f0 \u7b49\u4e8e \u589e\u503c\u7a0e    ", (String)"DeductRuleAndDraftUpgradeService_57", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity150.set("conditionjson1", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"33T8HEV2N=LY\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u589e\u503c\u7a0e\",\"Id\":\"33T8HEV//X2O\"}],\"CompareType\":\"67\",\"Id\":\"33T8HEV//WEE\",\"Logic\":\"0\",\"FieldName\":\"taxcategory.name\"}]}");
            entryentity150.set("entryentity1confjson", (Object)"0");
            entryentity150.set("entryentity1conf", (Object)"");
            entryentity150.set("table1_id", (Object)1057932119981961216L);
            entryentity150.set("amountfield1_id", (Object)1057932120015515672L);
            entryentity15.add((Object)entryentity150);
            DynamicObjectCollection entryentity115 = new DynamicObjectCollection();
            DynamicObjectCollection entryentity115Collection = mainObject5.getDynamicObjectCollection("entryentity11");
            DynamicObject entryentity1150 = entryentity115Collection.addNew();
            entryentity1150.set("id", (Object)1624682001233846274L);
            entryentity1150.set("seq", (Object)1);
            entryentity1150.set("bizname11", (Object)ResManager.loadKDString((String)"\u4efd\u6570\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleAndDraftUpgradeService_51", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity1150.set("table11", (Object)1057932119981961216L);
            entryentity1150.set("amountfield11", (Object)1057932120015515657L);
            entryentity1150.set("absolute11", (Object)"false");
            entryentity1150.set("datatype11", (Object)"zjjs");
            entryentity1150.set("datadirection11", (Object)"positive");
            entryentity1150.set("filtercondition11", (Object)ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u7a0e\u79cd\u540d\u79f0 \u7b49\u4e8e \u589e\u503c\u7a0e    ", (String)"DeductRuleAndDraftUpgradeService_57", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity1150.set("conditionjson11", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"33T8HEV2N=LY\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u589e\u503c\u7a0e\",\"Id\":\"33T8HEV//X2O\"}],\"CompareType\":\"67\",\"Id\":\"33T8HEV//WEE\",\"Logic\":\"0\",\"FieldName\":\"taxcategory.name\"}]}");
            entryentity1150.set("table11_id", (Object)1057932119981961216L);
            entryentity1150.set("amountfield11_id", (Object)1057932120015515657L);
            entryentity115.add((Object)entryentity1150);
            return mainObject5;
        }
        if (deductTypeNumber.equals("VAT_JXDK_BQDK_3")) {
            DynamicObject mainObject0 = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_rule_deduct");
            mainObject0.set("id", (Object)1624663785220455424L);
            mainObject0.set("number", (Object)"VAT-RULE-INPUT-006105");
            mainObject0.set("name", (Object)ResManager.loadKDString((String)"\u672c\u671f\u8ba4\u8bc1\u76f8\u7b26\u7684\u901a\u884c\u8d39\u53d1\u7968", (String)"DeductRuleAndDraftUpgradeService_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            mainObject0.set("status", (Object)"A");
            mainObject0.set("creator", (Object)13466739L);
            mainObject0.set("modifier", (Object)13466739L);
            mainObject0.set("enable", (Object)"1");
            mainObject0.set("createtime", (Object)DateUtils.stringToDate((String)"2023-02-20 13:57:24", (String)"yyyy-MM-dd HH:mm:ss"));
            mainObject0.set("modifytime", (Object)DateUtils.stringToDate((String)"2023-02-20 14:36:55", (String)"yyyy-MM-dd HH:mm:ss"));
            mainObject0.set("masterid", (Object)1624663785220455424L);
            mainObject0.set("ruletype", (Object)"private");
            mainObject0.set("org", (Object)100000L);
            mainObject0.set("rulepurpose", (Object)",sjjt,");
            mainObject0.set("issystem", (Object)"0");
            mainObject0.set("deducttype", (Object)1377423028203316224L);
            mainObject0.set("jzjt", (Object)"0");
            mainObject0.set("invoice", (Object)"0");
            mainObject0.set("taxpayertype", (Object)"ybnsr");
            mainObject0.set("creator_id", (Object)13466739L);
            mainObject0.set("modifier_id", (Object)13466739L);
            mainObject0.set("org_id", (Object)100000L);
            mainObject0.set("deducttype_id", (Object)1377423028203316224L);
            DynamicObjectCollection entryentity0 = new DynamicObjectCollection();
            DynamicObjectCollection entryentity0Collection = mainObject0.getDynamicObjectCollection("entryentity");
            DynamicObject entryentity00 = entryentity0Collection.addNew();
            entryentity00.set("id", (Object)1624663785220455425L);
            entryentity00.set("seq", (Object)1);
            entryentity00.set("datadirection", (Object)"positive");
            entryentity00.set("bizname", (Object)ResManager.loadKDString((String)"\u8fdb\u9879\u62b5\u6263\u91d1\u989d\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleAndDraftUpgradeService_49", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity00.set("datatype", (Object)"zjqs");
            entryentity00.set("conditionjson", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"32JL69TVIA2Z\"}],\"CompareType\":\"105\",\"Id\":\"32JL69TVG7MY\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"32JL69TVIA3+\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"32JL69TVG7N+\"}],\"CompareType\":\"17\",\"Id\":\"32JL69TVG7MZ\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"32JL69TVG7N/\"}],\"CompareType\":\"105\",\"Id\":\"32JL69TVIA3/\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}");
            entryentity00.set("filtercondition", (Object)ResManager.loadKDString((String)"\u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14            \u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  ", (String)"DeductRuleAndDraftUpgradeService_48", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity00.set("amountfield", (Object)1381723198575378456L);
            entryentity00.set("table", (Object)1381723198575378432L);
            entryentity00.set("absolute", (Object)"false");
            entryentity00.set("entryentityconfjson", (Object)"0");
            entryentity00.set("entryentityconf", (Object)"");
            entryentity00.set("amountfield_id", (Object)1381723198575378456L);
            entryentity00.set("table_id", (Object)1381723198575378432L);
            entryentity0.add((Object)entryentity00);
            DynamicObjectCollection entryentity10 = new DynamicObjectCollection();
            DynamicObjectCollection entryentity10Collection = mainObject0.getDynamicObjectCollection("entryentity1");
            DynamicObject entryentity100 = entryentity10Collection.addNew();
            entryentity100.set("id", (Object)1624663785220579330L);
            entryentity100.set("seq", (Object)1);
            entryentity100.set("bizname1", (Object)ResManager.loadKDString((String)"\u7a0e\u989d\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleAndDraftUpgradeService_50", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity100.set("table1", (Object)1381723198575378432L);
            entryentity100.set("amountfield1", (Object)1381723198575378476L);
            entryentity100.set("absolute1", (Object)"false");
            entryentity100.set("datatype1", (Object)"zjqs");
            entryentity100.set("datadirection1", (Object)"positive");
            entryentity100.set("filtercondition1", (Object)ResManager.loadKDString((String)"\u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14            \u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  ", (String)"DeductRuleAndDraftUpgradeService_48", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity100.set("conditionjson1", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"32JL9OT=B2GL\"}],\"CompareType\":\"105\",\"Id\":\"32JL9OT=D5YM\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"32JL9OT=B2GM\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"32JL9OT=D5YO\"}],\"CompareType\":\"17\",\"Id\":\"32JL9OT=D5YN\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"32JL9OT=D5YP\"}],\"CompareType\":\"105\",\"Id\":\"32JL9OT=B2GN\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}");
            entryentity100.set("entryentity1confjson", (Object)"0");
            entryentity100.set("entryentity1conf", (Object)"");
            entryentity100.set("table1_id", (Object)1381723198575378432L);
            entryentity100.set("amountfield1_id", (Object)1381723198575378476L);
            entryentity10.add((Object)entryentity100);
            DynamicObjectCollection entryentity110 = new DynamicObjectCollection();
            DynamicObjectCollection entryentity110Collection = mainObject0.getDynamicObjectCollection("entryentity11");
            DynamicObject entryentity1100 = entryentity110Collection.addNew();
            entryentity1100.set("id", (Object)1624663785220455426L);
            entryentity1100.set("seq", (Object)1);
            entryentity1100.set("bizname11", (Object)ResManager.loadKDString((String)"\u4efd\u6570\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleAndDraftUpgradeService_51", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity1100.set("table11", (Object)1381723198575378432L);
            entryentity1100.set("amountfield11", (Object)1381723198575378443L);
            entryentity1100.set("absolute11", (Object)"false");
            entryentity1100.set("datatype11", (Object)"zjjs");
            entryentity1100.set("datadirection11", (Object)"positive");
            entryentity1100.set("filtercondition11", (Object)ResManager.loadKDString((String)"\u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14            \u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  ", (String)"DeductRuleAndDraftUpgradeService_48", (String)"taxc-tcvat", (Object[])new Object[0]));
            entryentity1100.set("conditionjson11", (Object)"{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"32JLF3Z0G7T8\"}],\"CompareType\":\"105\",\"Id\":\"32JLF3Z0E4B7\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"32JLF3Z0G7T9\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"32JLF3Z0E4B9\"}],\"CompareType\":\"17\",\"Id\":\"32JLF3Z0E4B8\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"32JLF3Z0E4B=\"}],\"CompareType\":\"105\",\"Id\":\"32JLF3Z0G7T=\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}");
            entryentity1100.set("table11_id", (Object)1381723198575378432L);
            entryentity1100.set("amountfield11_id", (Object)1381723198575378443L);
            entryentity110.add((Object)entryentity1100);
            return mainObject0;
        }
        return new DynamicObject();
    }
}

