/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.control.Button;
import kd.bos.form.control.CodeEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;

public class DeductRuleUpgradeDataService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(DeductRuleUpgradeDataService.class);
    private static final String DELETERULE = "deleterule";
    private static final String TAXC = "taxc";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{DELETERULE});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button source = (Button)evt.getSource();
        if (Objects.equals(DELETERULE, source.getKey())) {
            this.deleteData();
        }
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\uff1a\u8fdb\u9879\u62b5\u6263\u89c4\u5219\u4e2d\u5f00\u653e\u4ee3\u6263\u4ee3\u7f34\u89c4\u5219\u914d\u7f6e \u9884\u5236\u6570\u636e\u5904\u7406\u6210\u529f\uff01", (String)"DeductRuleUpgradeDataService_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        try {
            LOGGER.info("\u5f00\u59cb\u6267\u884c\u589e\u503c\u7a0e\uff1a\u8fdb\u9879\u62b5\u6263\u89c4\u5219\u4e2d\u5f00\u653e\u4ee3\u6263\u4ee3\u7f34\u9884\u5236\u89c4\u5219\u914d\u7f6e===>>>>>>");
            List orgList = this.getOrgList();
            if (CollectionUtils.isEmpty((Collection)orgList)) {
                result.setLog(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u53ef\u7528\u7684\u7ec4\u7ec7\uff01", (String)"DeductRuleUpgradeDataService_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                return result;
            }
            if (!DB.exitsTable((DBRoute)DBRoute.of((String)TAXC), (String)"t_tcvat_rule_deduct")) {
                result.setLog(ResManager.loadKDString((String)"\u8868\u8fd8\u672a\u751f\u6210\uff01", (String)"DeductRuleUpgradeDataService_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                result.setSuccess(false);
                return result;
            }
            String ruleData = this.addRuleData(orgList, "private");
            result.setLog(ruleData);
        }
        catch (Exception e) {
            result.setLog(ResManager.loadKDString((String)"\u8fdb\u9879\u62b5\u6263\u9884\u5236\u89c4\u5219\u6570\u636e\u5931\u8d25\uff01", (String)"DeductRuleUpgradeDataService_3", (String)"taxc-tcvat", (Object[])new Object[0]));
            LOGGER.error("DeductRuleUpgrade FAILURE", (Throwable)e);
            result.setSuccess(false);
        }
        return result;
    }

    private String addRuleData(List<Long> orgList, String ruletype) {
        StringBuilder sb = new StringBuilder();
        String nameStr = ResManager.loadKDString((String)"\u4ee3\u6263\u4ee3\u7f34\u7a0e\u6536\u7f34\u6b3e\u51ed\u8bc1\uff08\u7533\u62a5\uff09", (String)"DeductRuleUpgradeDataService_4", (String)"taxc-tcvat", (Object[])new Object[0]);
        String nameExists = "select fid from t_tcvat_rule_deduct_l where fname = '" + nameStr + "'";
        List rules = DBUtils.query((String)nameExists);
        if (CollectionUtils.isNotEmpty((Collection)rules)) {
            Set ids = rules.stream().flatMap(map -> map.values().stream()).collect(Collectors.toSet());
            String ruleexists = "select fid from t_tcvat_rule_deduct where fid in (" + StringUtil.join(ids, (String)",") + ") and fenable = '1' and fruletype = '" + ruletype + "' and fdeducttype =1377424673628775424 and fjzjt ='0' and ftaxpayertype='ybnsr' and frulepurpose = ',nssb,' and fissystem = '1'";
            List list = DBUtils.query((String)ruleexists);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                LOGGER.info("\u89c4\u5219\u9884\u5236\u914d\u7f6e\u6570\u636e\u5df2\u7ecf\u5b58\u5728\uff0c{}", (Object)ruletype);
                return ResManager.loadKDString((String)"\u89c4\u5219\u9884\u5236\u914d\u7f6e\u6570\u636e\u5df2\u7ecf\u5b58\u5728", (String)"DeductRuleUpgradeDataService_5", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object[]> paramsL = new ArrayList<Object[]>();
        ArrayList<Object[]> paramsdeduct = new ArrayList<Object[]>();
        ArrayList<Object[]> paramstax = new ArrayList<Object[]>();
        ArrayList<Object[]> paramsnum = new ArrayList<Object[]>();
        Date date = new Date();
        Long userid = RequestContext.get().getCurrUserId();
        this.dealDatas(ruletype, date, userid, orgList, params, paramsL, paramstax, paramsnum);
        this.dealTxfDatas(ruletype, date, userid, orgList, params, paramsL, paramsdeduct, paramstax, paramsnum);
        int txf = this.insertDatas(params, paramsL, paramsdeduct, paramstax, paramsnum);
        this.dealZzsDatas(ruletype, date, userid, orgList, params, paramsL, paramsdeduct, paramstax, paramsnum);
        int zzs = this.insertDatas(params, paramsL, paramsdeduct, paramstax, paramsnum);
        this.dealJdcDatas(ruletype, date, userid, orgList, params, paramsL, paramsdeduct, paramstax, paramsnum);
        int jdc = this.insertDatas(params, paramsL, paramsdeduct, paramstax, paramsnum);
        int lkys = 0;
        this.dealHgjkDatas(ruletype, date, userid, orgList, params, paramsL, paramsdeduct, paramstax, paramsnum);
        int hgjk = this.insertDatas(params, paramsL, paramsdeduct, paramstax, paramsnum);
        this.dealNcpsgDatas(ruletype, date, userid, orgList, params, paramsL, paramsdeduct, paramstax, paramsnum);
        int ncpsg = this.insertDatas(params, paramsL, paramsdeduct, paramstax, paramsnum);
        return sb.append(ruletype).append(ResManager.loadKDString((String)"\u4e2dinsert \u9884\u5236\u901a\u884c\u8d39\u53d1\u7968", (String)"DeductRuleUpgradeDataService_6", (String)"taxc-tcvat", (Object[])new Object[0])).append(txf).append(ResManager.loadKDString((String)"\u9884\u5236\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", (String)"DeductRuleUpgradeDataService_7", (String)"taxc-tcvat", (Object[])new Object[0])).append(zzs).append(ResManager.loadKDString((String)"\u673a\u52a8\u8f66\u9500\u552e", (String)"DeductRuleUpgradeDataService_8", (String)"taxc-tcvat", (Object[])new Object[0])).append(jdc).append(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93", (String)"DeductRuleUpgradeDataService_9", (String)"taxc-tcvat", (Object[])new Object[0])).append(lkys).append(ResManager.loadKDString((String)"\u6d77\u5173\u8fdb\u53e3\u589e\u503c\u7a0e", (String)"DeductRuleUpgradeDataService_10", (String)"taxc-tcvat", (Object[])new Object[0])).append(hgjk).append(ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u6536\u8d2d", (String)"DeductRuleUpgradeDataService_11", (String)"taxc-tcvat", (Object[])new Object[0])).append(ncpsg).toString();
    }

    private void dealHgjkDatas(String ruletype, Date date, Long userid, List<Long> orgList, List<Object[]> params, List<Object[]> paramsL, List<Object[]> paramsdeduct, List<Object[]> paramstax, List<Object[]> paramsnum) {
        long[] ids = DBUtils.getLongIds((String)"tcvat_rule_deduct", (int)orgList.size());
        String[] ruleNumber = DeclareServiceHelper.batchGenerateSBBNos((String)"tcvat_rule_deduct", (String)orgList.get(0).toString(), (int)orgList.size());
        for (int i = 0; i < orgList.size(); ++i) {
            Object[] param = new Object[]{ids[i], ruleNumber[i], "A", userid, userid, "1", date, date, ids[i], ruletype, orgList.get(i), 1377424194228324352L, "0", "0", "ybnsr", ",nssb,", "1"};
            params.add(param);
            long[] idsL = DBUtils.getLongIds((String)"tcvat_rule_deduct", (int)5);
            Object[] paramL1 = new Object[]{idsL[0], ids[i], "zh_TW", ResManager.loadKDString((String)"\u6d77\u95dc\u7e73\u6b3e\u66f8(\u7533\u5831)", (String)"DeductRuleUpgradeDataService_12", (String)"taxc-tcvat", (Object[])new Object[0])};
            paramsL.add(paramL1);
            Object[] paramL2 = new Object[]{idsL[1], ids[i], "zh_CN", ResManager.loadKDString((String)"\u6d77\u5173\u7f34\u6b3e\u4e66(\u7533\u62a5)", (String)"DeductRuleUpgradeDataService_13", (String)"taxc-tcvat", (Object[])new Object[0])};
            paramsL.add(paramL2);
            Object[] paramLded1 = new Object[]{ids[i], idsL[2], 1, "positive", ResManager.loadKDString((String)"\u8fdb\u9879\u62b5\u6263\u91d1\u989d\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleUpgradeDataService_14", (String)"taxc-tcvat", (Object[])new Object[0]), "zjqs", "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"3J3/P0QDE/SU\"}],\"CompareType\":\"17\",\"Id\":\"3J3/P0Q=UR23\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3J3/P0QDE/SV\"}],\"CompareType\":\"105\",\"Id\":\"3J3/P0QDG59M\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"(\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\",\"Id\":\"3J3/P0QDE/SW\"}],\"CompareType\":\"1103\",\"Id\":\"3J3/P0QDG59N\",\"Logic\":\"1\",\"FieldName\":\"manage_status\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\")\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3J3/P0QDE/SX\"}],\"CompareType\":\"105\",\"Id\":\"3J3/P0QDG59O\",\"Logic\":\"0\",\"FieldName\":\"manage_status\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3J3/P0QDE/SY\"}],\"CompareType\":\"105\",\"Id\":\"3J3/P0QDG59P\",\"Logic\":\"0\",\"FieldName\":\"delete\"}]}", ResManager.loadKDString((String)"\u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1  \u5e76\u4e14            \u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14      ( \u7ba1\u7406\u72b6\u6001 \u4e3a \u4e3a\u7a7a  \u6216\u8005     \u7ba1\u7406\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38 ) \u5e76\u4e14            \u53ef\u7528\u72b6\u6001 \u7b49\u4e8e \u53ef\u7528  ", (String)"DeductRuleUpgradeDataService_15", (String)"taxc-tcvat", (Object[])new Object[0]), 1624673217690181688L, 1624673217673404416L, "0", "0", ""};
            paramsdeduct.add(paramLded1);
            Object[] paramLtax1 = new Object[]{ids[i], idsL[3], 1, ResManager.loadKDString((String)"\u7a0e\u989d\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleUpgradeDataService_16", (String)"taxc-tcvat", (Object[])new Object[0]), 1624673217673404416L, 1624673217690181660L, "0", "zjqs", "positive", ResManager.loadKDString((String)"\u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1  \u5e76\u4e14            \u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14      ( \u7ba1\u7406\u72b6\u6001 \u4e3a \u4e3a\u7a7a  \u6216\u8005     \u7ba1\u7406\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38 ) \u5e76\u4e14            \u53ef\u7528\u72b6\u6001 \u7b49\u4e8e \u53ef\u7528  ", (String)"DeductRuleUpgradeDataService_15", (String)"taxc-tcvat", (Object[])new Object[0]), "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"3J3/Y5+61+62\"}],\"CompareType\":\"17\",\"Id\":\"3J3/Y5+6+UP=\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3J3/Y5+61+63\"}],\"CompareType\":\"105\",\"Id\":\"3J3/Y5+6+UPA\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"(\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\",\"Id\":\"3J3/Y5+61+64\"}],\"CompareType\":\"1103\",\"Id\":\"3J3/Y5+6+UPB\",\"Logic\":\"1\",\"FieldName\":\"manage_status\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\")\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3J3/Y5+61+65\"}],\"CompareType\":\"105\",\"Id\":\"3J3/Y5+6+UPC\",\"Logic\":\"0\",\"FieldName\":\"manage_status\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3J3/Y5+61+66\"}],\"CompareType\":\"105\",\"Id\":\"3J3/Y5+6+UPD\",\"Logic\":\"0\",\"FieldName\":\"delete\"}]}", "0"};
            paramstax.add(paramLtax1);
            Object[] paramLnum1 = new Object[]{ids[i], idsL[4], 1, ResManager.loadKDString((String)"\u4efd\u6570\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleUpgradeDataService_17", (String)"taxc-tcvat", (Object[])new Object[0]), 1624673217673404416L, 1624673217690181632L, "0", "zjjs", "positive", ResManager.loadKDString((String)"\u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1  \u5e76\u4e14            \u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14      ( \u7ba1\u7406\u72b6\u6001 \u4e3a \u4e3a\u7a7a  \u6216\u8005     \u7ba1\u7406\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38 ) \u5e76\u4e14            \u53ef\u7528\u72b6\u6001 \u7b49\u4e8e \u53ef\u7528  ", (String)"DeductRuleUpgradeDataService_15", (String)"taxc-tcvat", (Object[])new Object[0]), "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"3J3038QGP7ZD\"}],\"CompareType\":\"17\",\"Id\":\"3J3038QGN2GL\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3J3038QGP7ZE\"}],\"CompareType\":\"105\",\"Id\":\"3J3038QGN2GM\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"(\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\",\"Id\":\"3J3038QGP7ZF\"}],\"CompareType\":\"1103\",\"Id\":\"3J3038QGN2GN\",\"Logic\":\"1\",\"FieldName\":\"manage_status\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\")\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3J3038QGP7ZG\"}],\"CompareType\":\"105\",\"Id\":\"3J3038QGN2GO\",\"Logic\":\"0\",\"FieldName\":\"manage_status\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3J3038QGP7ZH\"}],\"CompareType\":\"105\",\"Id\":\"3J3038QGN2GP\",\"Logic\":\"0\",\"FieldName\":\"delete\"}]}"};
            paramsnum.add(paramLnum1);
        }
    }

    private void dealNcpsgDatas(String ruletype, Date date, Long userid, List<Long> orgList, List<Object[]> params, List<Object[]> paramsL, List<Object[]> paramsdeduct, List<Object[]> paramstax, List<Object[]> paramsnum) {
        long[] ids = DBUtils.getLongIds((String)"tcvat_rule_deduct", (int)orgList.size());
        String[] ruleNumber = DeclareServiceHelper.batchGenerateSBBNos((String)"tcvat_rule_deduct", (String)orgList.get(0).toString(), (int)orgList.size());
        for (int i = 0; i < orgList.size(); ++i) {
            Object[] param = new Object[]{ids[i], ruleNumber[i], "A", userid, userid, "1", date, date, ids[i], ruletype, orgList.get(i), 1377424440996005888L, "0", "0", "ybnsr", ",nssb,", "1"};
            params.add(param);
            long[] idsL = DBUtils.getLongIds((String)"tcvat_rule_deduct", (int)6);
            Object[] paramL1 = new Object[]{idsL[0], ids[i], "zh_TW", ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968\u6216\u8005\u9500\u552e\u53d1\u7968", (String)"DeductRuleUpgradeDataService_18", (String)"taxc-tcvat", (Object[])new Object[0])};
            paramsL.add(paramL1);
            Object[] paramL2 = new Object[]{idsL[1], ids[i], "zh_CN", ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968\u6216\u8005\u9500\u552e\u53d1\u7968", (String)"DeductRuleUpgradeDataService_18", (String)"taxc-tcvat", (Object[])new Object[0])};
            paramsL.add(paramL2);
            Object[] paramLded1 = new Object[]{ids[i], idsL[2], 1, "positive", ResManager.loadKDString((String)"\u8fdb\u9879\u62b5\u6263\u91d1\u989d\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleUpgradeDataService_14", (String)"taxc-tcvat", (Object[])new Object[0]), "zjqs", "", "", 1624630098651225100L, 1624630098433121280L, "0", "", ""};
            paramsdeduct.add(paramLded1);
            Object[] paramLtax1 = new Object[]{ids[i], idsL[3], 1, ResManager.loadKDString((String)"\u7a0e\u989d\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleUpgradeDataService_16", (String)"taxc-tcvat", (Object[])new Object[0]), 1624630098433121280L, 1624630098651225101L, "0", "zjqs", "positive", "", "", "0"};
            paramstax.add(paramLtax1);
            Object[] paramLnum1 = new Object[]{ids[i], idsL[4], 1, ResManager.loadKDString((String)"\u4efd\u6570\u53d6\u6570\u914d\u7f6e\uff08\u6765\u6e90\u53d1\u7968\uff09", (String)"DeductRuleUpgradeDataService_19", (String)"taxc-tcvat", (Object[])new Object[0]), 1624630098433121280L, 1624630098651225104L, "0", "zjjs", "positive", ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90 \u5728\u2026\u2026\u4e2d \u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968;\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968;\u589e\u503c\u7a0e\u5168\u7535\u666e\u7968;\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u589e\u503c\u7a0e\u5168\u7535\u4e13\u7968", (String)"DeductRuleUpgradeDataService_20", (String)"taxc-tcvat", (Object[])new Object[0]), "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"32JO0LY68AOW\"},{\"_Type_\":\"FilterValue\",\"Value\":\"4\",\"Id\":\"32JO0LY6687W\"},{\"_Type_\":\"FilterValue\",\"Value\":\"26\",\"Id\":\"32JO0LY68AOX\"},{\"_Type_\":\"FilterValue\",\"Value\":\"27\",\"Id\":\"32JO0LY6687X\"}],\"CompareType\":\"17\",\"Id\":\"32JO0LY6687V\",\"Logic\":\"0\",\"FieldName\":\"datasources\"}]}"};
            Object[] paramLnum2 = new Object[]{ids[i], idsL[5], 1, ResManager.loadKDString((String)"\u4efd\u6570\u53d6\u6570\u914d\u7f6e\uff08\u624b\u5de5\u65b0\u589e\uff09", (String)"DeductRuleUpgradeDataService_21", (String)"taxc-tcvat", (Object[])new Object[0]), 1624630098433121280L, 1624630098651225088L, "0", "zjjs", "positive", ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90 \u7b49\u4e8e \u624b\u5de5\u65b0\u589e", (String)"DeductRuleUpgradeDataService_22", (String)"taxc-tcvat", (Object[])new Object[0]), "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"xz\",\"Id\":\"32JO8SIRENY8\"}],\"CompareType\":\"105\",\"Id\":\"32JO8SIRGRD9\",\"Logic\":\"0\",\"FieldName\":\"datasources\"}]}"};
            paramsnum.add(paramLnum1);
            paramsnum.add(paramLnum2);
        }
    }

    private int insertDatas(List<Object[]> params, List<Object[]> paramsL, List<Object[]> paramsdeduct, List<Object[]> paramstax, List<Object[]> paramsnum) {
        String insert = "INSERT INTO t_tcvat_rule_deduct (fid,fnumber,fstatus,fcreatorid,fmodifierid, fenable,fcreatetime,fmodifytime,fmasterid,fruletype,forgid,fdeducttype,fjzjt,finvoice,ftaxpayertype,frulepurpose,fissystem) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        int[] ints = DBUtils.executeBatch((String)insert, params);
        String insertl = "INSERT INTO t_tcvat_rule_deduct_l (fpkid,fid,flocaleid,fname) VALUES (?,?,?,?)";
        int[] intsL = DBUtils.executeBatch((String)insertl, paramsL);
        String insertded = "INSERT INTO t_tcvat_rule_deduct_entry (fid,fentryid,fseq,fdatadirection,fbizname,fdatatype,ffconditionjson,ffiltercondition,famountfield,ftable,fabsolute,fentryentityconfjson,fentryentityconf) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
        int[] intsded = DBUtils.executeBatch((String)insertded, paramsdeduct);
        String inserttax = "INSERT INTO t_tcvat_deduct_tax_entry (fid,fentryid,fseq,fbizname,ftable,famountfield,fabsolute,fdatatype,fdatadirection,ffiltercondition,fconditionjson,fentryentityconfjson) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
        int[] intstax = DBUtils.executeBatch((String)inserttax, paramstax);
        String insertnum = "INSERT INTO t_tcvat_deduct_num_entry (fid,fentryid,fseq,fbizname,ftable,famountfield,fabsolute,fdatatype,fdatadirection,ffiltercondition,fconditionjson) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
        int[] intsnum = DBUtils.executeBatch((String)insertnum, paramsnum);
        params.clear();
        paramsL.clear();
        paramsdeduct.clear();
        paramstax.clear();
        paramsnum.clear();
        return ints.length;
    }

    private void dealJdcDatas(String ruletype, Date date, Long userid, List<Long> orgList, List<Object[]> params, List<Object[]> paramsL, List<Object[]> paramsdeduct, List<Object[]> paramstax, List<Object[]> paramsnum) {
        long[] ids = DBUtils.getLongIds((String)"tcvat_rule_deduct", (int)orgList.size());
        String[] ruleNumber = DeclareServiceHelper.batchGenerateSBBNos((String)"tcvat_rule_deduct", (String)orgList.get(0).toString(), (int)orgList.size());
        for (int i = 0; i < orgList.size(); ++i) {
            Object[] param = new Object[]{ids[i], ruleNumber[i], "A", userid, userid, "1", date, date, ids[i], ruletype, orgList.get(i), 1377423719802102784L, "0", "0", "ybnsr", ",nssb,", "1"};
            params.add(param);
            long[] idsL = DBUtils.getLongIds((String)"tcvat_rule_deduct", (int)5);
            Object[] paramL1 = new Object[]{idsL[0], ids[i], "zh_TW", ResManager.loadKDString((String)"\u672c\u671f\u8a8d\u8b49\u76f8\u7b26\u4e14\u62b5\u6263\u7684\u6a5f\u52d5\u8eca\u767c\u7968(\u7533\u5831)", (String)"DeductRuleUpgradeDataService_36", (String)"taxc-tcvat", (Object[])new Object[0])};
            paramsL.add(paramL1);
            Object[] paramL2 = new Object[]{idsL[1], ids[i], "zh_CN", ResManager.loadKDString((String)"\u672c\u671f\u8ba4\u8bc1\u76f8\u7b26\u4e14\u62b5\u6263\u7684\u673a\u52a8\u8f66\u53d1\u7968(\u7533\u62a5)", (String)"DeductRuleUpgradeDataService_37", (String)"taxc-tcvat", (Object[])new Object[0])};
            paramsL.add(paramL2);
            Object[] paramLded = new Object[]{ids[i], idsL[2], 1, "positive", ResManager.loadKDString((String)"\u8fdb\u9879\u62b5\u6263\u91d1\u989d\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleUpgradeDataService_14", (String)"taxc-tcvat", (Object[])new Object[0]), "zjqs", "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"3IHUT/=2W3D6\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"3IHUT/=2W20O\"}],\"CompareType\":\"17\",\"Id\":\"3IHUT/=/8NV5\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3IHUT/=2W20P\"}],\"CompareType\":\"105\",\"Id\":\"3IHUT/=2W3D7\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3IHUT/=2W20Q\"}],\"CompareType\":\"105\",\"Id\":\"3IHUT/=2W3D8\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}", ResManager.loadKDString((String)"\u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14            \u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  ", (String)"DeductRuleUpgradeDataService_38", (String)"taxc-tcvat", (Object[])new Object[0]), 1381723694149174305L, 1381723694140785664L, "0", "0", ""};
            paramsdeduct.add(paramLded);
            Object[] paramLtax = new Object[]{ids[i], idsL[3], 1, ResManager.loadKDString((String)"\u7a0e\u989d\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleUpgradeDataService_16", (String)"taxc-tcvat", (Object[])new Object[0]), 1381723694140785664L, 1381723694149174324L, "0", "zjqs", "positive", ResManager.loadKDString((String)"\u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14            \u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  ", (String)"DeductRuleUpgradeDataService_38", (String)"taxc-tcvat", (Object[])new Object[0]), "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"3IHUX=524KC2\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"3IHUX=524J/L\"}],\"CompareType\":\"17\",\"Id\":\"3IHUX=524J/K\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3IHUX=524J/M\"}],\"CompareType\":\"105\",\"Id\":\"3IHUX=524KC3\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3IHUX=524J/N\"}],\"CompareType\":\"105\",\"Id\":\"3IHUX=524KC4\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}", "0"};
            paramstax.add(paramLtax);
            Object[] paramLnum = new Object[]{ids[i], idsL[4], 1, ResManager.loadKDString((String)"\u4efd\u6570\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleUpgradeDataService_17", (String)"taxc-tcvat", (Object[])new Object[0]), 1381723694140785664L, 1381723694149174329L, "0", "zjjs", "positive", ResManager.loadKDString((String)"\u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14            \u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  ", (String)"DeductRuleUpgradeDataService_38", (String)"taxc-tcvat", (Object[])new Object[0]), "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"3IHV/KAA59N0\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"3IHV/KAA58=J\"}],\"CompareType\":\"17\",\"Id\":\"3IHV/KAA58=I\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3IHV/KAA58=K\"}],\"CompareType\":\"105\",\"Id\":\"3IHV/KAA59N1\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3IHV/KADSNH0\"}],\"CompareType\":\"105\",\"Id\":\"3IHV/KAA59N2\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}"};
            paramsnum.add(paramLnum);
        }
    }

    private void dealZzsDatas(String ruletype, Date date, Long userid, List<Long> orgList, List<Object[]> params, List<Object[]> paramsL, List<Object[]> paramsdeduct, List<Object[]> paramstax, List<Object[]> paramsnum) {
        long[] ids = DBUtils.getLongIds((String)"tcvat_rule_deduct", (int)orgList.size());
        String[] ruleNumber = DeclareServiceHelper.batchGenerateSBBNos((String)"tcvat_rule_deduct", (String)orgList.get(0).toString(), (int)orgList.size());
        for (int i = 0; i < orgList.size(); ++i) {
            Object[] param = new Object[]{ids[i], ruleNumber[i], "A", userid, userid, "1", date, date, ids[i], ruletype, orgList.get(i), 1376813763545544704L, "0", "0", "ybnsr", ",nssb,", "1"};
            params.add(param);
            long[] idsL = DBUtils.getLongIds((String)"tcvat_rule_deduct", (int)11);
            Object[] paramL1 = new Object[]{idsL[0], ids[i], "zh_TW", ResManager.loadKDString((String)"\u672c\u671f\u8a8d\u8b49\u76f8\u7b26\u4e14\u62b5\u6263\u7684\u589e\u503c\u7a05\u5c08\u7528\u767c\u7968(\u7533\u5831)", (String)"DeductRuleUpgradeDataService_39", (String)"taxc-tcvat", (Object[])new Object[0])};
            paramsL.add(paramL1);
            Object[] paramL2 = new Object[]{idsL[1], ids[i], "zh_CN", ResManager.loadKDString((String)"\u672c\u671f\u8ba4\u8bc1\u76f8\u7b26\u4e14\u62b5\u6263\u7684\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968(\u7533\u62a5)", (String)"DeductRuleUpgradeDataService_40", (String)"taxc-tcvat", (Object[])new Object[0])};
            paramsL.add(paramL2);
            Object[] paramLded1 = new Object[]{ids[i], idsL[2], 1, "positive", ResManager.loadKDString((String)"\u6570\u7535\u4e13\u7968", (String)"DeductRuleUpgradeDataService_41", (String)"taxc-tcvat", (Object[])new Object[0]), "zjqs", "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1376129725579325440\",\"Id\":\"3IHF05J3W898\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09\",\"Id\":\"3IHF05J3WAMI\"}],\"CompareType\":\"67\",\"Id\":\"3IHF05J08U1Q\",\"Logic\":\"0\",\"FieldName\":\"invoice_type.name\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"3IHF05J3W899\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"3IHF05J3WAMK\"}],\"CompareType\":\"17\",\"Id\":\"3IHF05J3WAMJ\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3IHF05J3WAML\"}],\"CompareType\":\"105\",\"Id\":\"3IHF05J3W89=\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3IHF05J3WAMM\"}],\"CompareType\":\"105\",\"Id\":\"3IHF05J3W89A\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}", ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b.\u540d\u79f0 \u7b49\u4e8e \u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09  \u5e76\u4e14            \u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14    \u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  ", (String)"DeductRuleUpgradeDataService_42", (String)"taxc-tcvat", (Object[])new Object[0]), 1407439936369483814L, 1407439936361095168L, "0", "0", ""};
            Object[] paramLded2 = new Object[]{ids[i], idsL[3], 2, "positive", ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", (String)"DeductRuleUpgradeDataService_43", (String)"taxc-tcvat", (Object[])new Object[0]), "zjqs", "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"3IHF76ID23JY\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"3IHF76ID206O\"}],\"CompareType\":\"17\",\"Id\":\"3IHF76ID206N\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3IHF76ID206P\"}],\"CompareType\":\"105\",\"Id\":\"3IHF76ID23JZ\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3IHF76ID206Q\"}],\"CompareType\":\"105\",\"Id\":\"3IHF76ID23K+\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}", ResManager.loadKDString((String)"\u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14            \u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  ", (String)"DeductRuleUpgradeDataService_38", (String)"taxc-tcvat", (Object[])new Object[0]), 1467494794627385364L, 1467494794577053696L, "0", "0", ""};
            Object[] paramLded3 = new Object[]{ids[i], idsL[4], 3, "reverse", ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u8ba1\u7b97\u62b5\u6263-\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u4e13\u7968", (String)"DeductRuleUpgradeDataService_44", (String)"taxc-tcvat", (Object[])new Object[0]), "zjqs", "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"4\",\"Id\":\"3IHFB1TCZPVF\"},{\"_Type_\":\"FilterValue\",\"Value\":\"27\",\"Id\":\"3IHFB1TCZT7R\"}],\"CompareType\":\"17\",\"Id\":\"3IHFB1TCZT7Q\",\"Logic\":\"0\",\"FieldName\":\"datasources\"}]}", ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90 \u5728\u2026\u2026\u4e2d \u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968;\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u589e\u503c\u7a0e\u5168\u7535\u4e13\u7968  ", (String)"DeductRuleUpgradeDataService_45", (String)"taxc-tcvat", (Object[])new Object[0]), 1624630098651225100L, 1624630098433121280L, "0", "0", ""};
            paramsdeduct.add(paramLded1);
            paramsdeduct.add(paramLded2);
            paramsdeduct.add(paramLded3);
            Object[] paramLtax1 = new Object[]{ids[i], idsL[5], 1, ResManager.loadKDString((String)"\u6570\u7535\u4e13\u7968", (String)"DeductRuleUpgradeDataService_41", (String)"taxc-tcvat", (Object[])new Object[0]), 1407439936361095168L, 1407439936369483798L, "0", "zjqs", "positive", ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b.\u540d\u79f0 \u7b49\u4e8e \u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09  \u5e76\u4e14            \u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14    \u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  ", (String)"DeductRuleUpgradeDataService_42", (String)"taxc-tcvat", (Object[])new Object[0]), "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1376129725579325440\",\"Id\":\"3IHFJA/VB6OX\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09\",\"Id\":\"3IHFJA/VB=15\"}],\"CompareType\":\"67\",\"Id\":\"3IHFJA/VB6OW\",\"Logic\":\"0\",\"FieldName\":\"invoice_type.name\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"3IHFJA/VB6OY\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"3IHFJA/VB=17\"}],\"CompareType\":\"17\",\"Id\":\"3IHFJA/VB=16\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3IHFJA/YZP8O\"}],\"CompareType\":\"105\",\"Id\":\"3IHFJA/YZLWD\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3IHFJA/YZP8P\"}],\"CompareType\":\"105\",\"Id\":\"3IHFJA/YZLWE\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}", "0"};
            Object[] paramLtax2 = new Object[]{ids[i], idsL[6], 2, ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", (String)"DeductRuleUpgradeDataService_43", (String)"taxc-tcvat", (Object[])new Object[0]), 1467494794577053696L, 1467494794627385388L, "0", "zjqs", "positive", ResManager.loadKDString((String)"\u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14            \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  \u5e76\u4e14    \u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  ", (String)"DeductRuleUpgradeDataService_46", (String)"taxc-tcvat", (Object[])new Object[0]), "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3IHFOYJUW8R=\"}],\"CompareType\":\"105\",\"Id\":\"3IHFOYJUW5D/\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3IHFOYJUW8RA\"}],\"CompareType\":\"105\",\"Id\":\"3IHFOYJUW5D0\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"3IHFOYJUW8RB\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"3IHFOYJUW5D2\"}],\"CompareType\":\"17\",\"Id\":\"3IHFOYJUW5D1\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"}]}", "0"};
            Object[] paramLtax3 = new Object[]{ids[i], idsL[7], 3, ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u8ba1\u7b97\u62b5\u6263-\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u4e13\u7968", (String)"DeductRuleUpgradeDataService_44", (String)"taxc-tcvat", (Object[])new Object[0]), 1624630098433121280L, 1637677098460306432L, "0", "zjqs", "reverse", ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90 \u5728\u2026\u2026\u4e2d \u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968;\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u589e\u503c\u7a0e\u5168\u7535\u4e13\u7968  ", (String)"DeductRuleUpgradeDataService_45", (String)"taxc-tcvat", (Object[])new Object[0]), "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"4\",\"Id\":\"3IHFTAHMDVR2\"},{\"_Type_\":\"FilterValue\",\"Value\":\"27\",\"Id\":\"3IHFTAHMDSCT\"}],\"CompareType\":\"17\",\"Id\":\"3IHFTAHISC6=\",\"Logic\":\"0\",\"FieldName\":\"datasources\"}]}", "0"};
            paramstax.add(paramLtax1);
            paramstax.add(paramLtax2);
            paramstax.add(paramLtax3);
            Object[] paramLnum1 = new Object[]{ids[i], idsL[8], 1, ResManager.loadKDString((String)"\u6570\u7535\u4e13\u7968", (String)"DeductRuleUpgradeDataService_41", (String)"taxc-tcvat", (Object[])new Object[0]), 1407439936361095168L, 1407439936369483823L, "0", "zjjs", "positive", ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b.\u540d\u79f0 \u7b49\u4e8e \u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09  \u5e76\u4e14            \u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14    \u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  ", (String)"DeductRuleUpgradeDataService_42", (String)"taxc-tcvat", (Object[])new Object[0]), "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1376129725579325440\",\"Id\":\"3IKDUV1CQ78T\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09\",\"Id\":\"3IKDUV1CQ8LA\"}],\"CompareType\":\"67\",\"Id\":\"3IKDUV1=2T1=\",\"Logic\":\"0\",\"FieldName\":\"invoice_type.name\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"3IKDUV1CQ78U\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"3IKDUV1CQ8LC\"}],\"CompareType\":\"17\",\"Id\":\"3IKDUV1CQ8LB\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3IKDUV1CQ8LD\"}],\"CompareType\":\"105\",\"Id\":\"3IKDUV1CQ78V\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3IKDUV1CQ8LE\"}],\"CompareType\":\"105\",\"Id\":\"3IKDUV1CQ78W\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}"};
            Object[] paramLnum2 = new Object[]{ids[i], idsL[9], 2, ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", (String)"DeductRuleUpgradeDataService_43", (String)"taxc-tcvat", (Object[])new Object[0]), 1467494794577053696L, 1467494794627385353L, "0", "zjjs", "positive", ResManager.loadKDString((String)"\u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14            \u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  ", (String)"DeductRuleUpgradeDataService_47", (String)"taxc-tcvat", (Object[])new Object[0]), "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3IKDZU2MC+Y9\"}],\"CompareType\":\"105\",\"Id\":\"3IKDZU2MC09S\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"3IKDZU2MC+Y=\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"3IKDZU2MC09U\"}],\"CompareType\":\"17\",\"Id\":\"3IKDZU2MC09T\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3IKDZU2MC09V\"}],\"CompareType\":\"105\",\"Id\":\"3IKDZU2MC+YA\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}"};
            Object[] paramLnum3 = new Object[]{ids[i], idsL[10], 3, ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u8ba1\u7b97\u62b5\u6263-\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u4e13\u7968", (String)"DeductRuleUpgradeDataService_44", (String)"taxc-tcvat", (Object[])new Object[0]), 1624630098433121280L, 1624630098651225104L, "0", "zjjs", "reverse", ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90 \u5728\u2026\u2026\u4e2d \u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968;\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u589e\u503c\u7a0e\u5168\u7535\u4e13\u7968  ", (String)"DeductRuleUpgradeDataService_45", (String)"taxc-tcvat", (Object[])new Object[0]), "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"4\",\"Id\":\"3IKE0NJTQZGB\"},{\"_Type_\":\"FilterValue\",\"Value\":\"27\",\"Id\":\"3IKE0NJTQY3V\"}],\"CompareType\":\"17\",\"Id\":\"3IKE0NJTQY3U\",\"Logic\":\"0\",\"FieldName\":\"datasources\"}]}"};
            paramsnum.add(paramLnum1);
            paramsnum.add(paramLnum2);
            paramsnum.add(paramLnum3);
        }
    }

    private void dealTxfDatas(String ruletype, Date date, Long userid, List<Long> orgList, List<Object[]> params, List<Object[]> paramsL, List<Object[]> paramsdeduct, List<Object[]> paramstax, List<Object[]> paramsnum) {
        long[] ids = DBUtils.getLongIds((String)"tcvat_rule_deduct", (int)orgList.size());
        String[] ruleNumber = DeclareServiceHelper.batchGenerateSBBNos((String)"tcvat_rule_deduct", (String)orgList.get(0).toString(), (int)orgList.size());
        for (int i = 0; i < orgList.size(); ++i) {
            Object[] param = new Object[]{ids[i], ruleNumber[i], "A", userid, userid, "1", date, date, ids[i], ruletype, orgList.get(i), 1377423028203316224L, "0", "0", "ybnsr", ",nssb,", "1"};
            params.add(param);
            long[] idsL = DBUtils.getLongIds((String)"tcvat_rule_deduct", (int)5);
            Object[] paramL1 = new Object[]{idsL[0], ids[i], "zh_TW", ResManager.loadKDString((String)"\u672c\u671f\u8a8d\u8b49\u76f8\u7b26\u4e14\u62b5\u6263\u7684\u901a\u884c\u8cbb\u767c\u7968(\u7533\u5831)", (String)"DeductRuleUpgradeDataService_48", (String)"taxc-tcvat", (Object[])new Object[0])};
            paramsL.add(paramL1);
            Object[] paramL2 = new Object[]{idsL[1], ids[i], "zh_CN", ResManager.loadKDString((String)"\u672c\u671f\u8ba4\u8bc1\u76f8\u7b26\u4e14\u62b5\u6263\u7684\u901a\u884c\u8d39\u53d1\u7968(\u7533\u62a5)", (String)"DeductRuleUpgradeDataService_49", (String)"taxc-tcvat", (Object[])new Object[0])};
            paramsL.add(paramL2);
            Object[] paramLded = new Object[]{ids[i], idsL[2], 1, "positive", ResManager.loadKDString((String)"\u8fdb\u9879\u62b5\u6263\u91d1\u989d\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleUpgradeDataService_14", (String)"taxc-tcvat", (Object[])new Object[0]), "zjqs", "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3IH/MDT4G0HW\"}],\"CompareType\":\"105\",\"Id\":\"3IH/MDT4FZ4L\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"3IH/MDT4G0HX\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"3IH/MDT4FZ4N\"}],\"CompareType\":\"17\",\"Id\":\"3IH/MDT4FZ4M\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3IH/MDT4FZ4O\"}],\"CompareType\":\"105\",\"Id\":\"3IH/MDT4G0HY\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}", ResManager.loadKDString((String)"\u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14            \u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  ", (String)"DeductRuleUpgradeDataService_47", (String)"taxc-tcvat", (Object[])new Object[0]), 1381723198575378456L, 1381723198575378432L, "0", "0", ""};
            paramsdeduct.add(paramLded);
            Object[] paramLtax = new Object[]{ids[i], idsL[3], 1, ResManager.loadKDString((String)"\u7a0e\u989d\u914d\u7f6e\u53d6\u6570", (String)"DeductRuleUpgradeDataService_50", (String)"taxc-tcvat", (Object[])new Object[0]), 1381723198575378432L, 1381723198575378476L, "0", "zjqs", "positive", ResManager.loadKDString((String)"\u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14            \u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  ", (String)"DeductRuleUpgradeDataService_47", (String)"taxc-tcvat", (Object[])new Object[0]), "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3IKFQ26PWM=+\"}],\"CompareType\":\"105\",\"Id\":\"3IKFQ26PWNMH\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"3IKFQ26PWM=/\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"3IKFQ26PWNMJ\"}],\"CompareType\":\"17\",\"Id\":\"3IKFQ26PWNMI\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3IKFQ26PWNMK\"}],\"CompareType\":\"105\",\"Id\":\"3IKFQ26PWM=0\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}", "0"};
            paramstax.add(paramLtax);
            Object[] paramLnum = new Object[]{ids[i], idsL[4], 1, ResManager.loadKDString((String)"\u4efd\u6570\u53d6\u6570\u914d\u7f6e", (String)"DeductRuleUpgradeDataService_17", (String)"taxc-tcvat", (Object[])new Object[0]), 1381723198575378432L, 1381723198575378443L, "0", "zjjs", "positive", ResManager.loadKDString((String)"\u62b5\u6263\u7528\u9014 \u7b49\u4e8e \u62b5\u6263  \u5e76\u4e14            \u8ba4\u8bc1\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u52fe\u9009\u8ba4\u8bc1;\u626b\u63cf\u8ba4\u8bc1  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  ", (String)"DeductRuleUpgradeDataService_47", (String)"taxc-tcvat", (Object[])new Object[0]), "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3IKFTRE3141O\"}],\"CompareType\":\"105\",\"Id\":\"3IKFTRE312Q5\",\"Logic\":\"0\",\"FieldName\":\"deduction_purpose\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"3IKFTRE6OJ96\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"3IKFTRE6OHXO\"}],\"CompareType\":\"17\",\"Id\":\"3IKFTRE312Q6\",\"Logic\":\"0\",\"FieldName\":\"authenticate_flag\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3IKFTRE==Y36\"}],\"CompareType\":\"105\",\"Id\":\"3IKFTRE6OJ97\",\"Logic\":\"0\",\"FieldName\":\"invoice_status\"}]}"};
            paramsnum.add(paramLnum);
        }
    }

    private void dealDatas(String ruletype, Date date, Long userid, List<Long> orgList, List<Object[]> params, List<Object[]> paramsL, List<Object[]> paramstax, List<Object[]> paramsnum) {
        long[] ids = DBUtils.getLongIds((String)"tcvat_rule_deduct", (int)orgList.size());
        String[] ruleNumber = DeclareServiceHelper.batchGenerateSBBNos((String)"tcvat_rule_deduct", (String)orgList.get(0).toString(), (int)orgList.size());
        for (int i = 0; i < orgList.size(); ++i) {
            Object[] param = new Object[]{ids[i], ruleNumber[i], "A", userid, userid, "1", date, date, ids[i], ruletype, orgList.get(i), 1377424673628775424L, "0", "0", "ybnsr", ",nssb,", "1"};
            params.add(param);
            long[] idsL = DBUtils.getLongIds((String)"tcvat_rule_deduct", (int)4);
            Object[] paramL1 = new Object[]{idsL[0], ids[i], "zh_TW", ResManager.loadKDString((String)"\u4ee3\u6263\u4ee3\u7e73\u7a05\u6536\u7e73\u6b3e\u6191\u8b49\uff08\u7533\u5831\uff09", (String)"DeductRuleUpgradeDataService_51", (String)"taxc-tcvat", (Object[])new Object[0])};
            paramsL.add(paramL1);
            Object[] paramL2 = new Object[]{idsL[1], ids[i], "zh_CN", ResManager.loadKDString((String)"\u4ee3\u6263\u4ee3\u7f34\u7a0e\u6536\u7f34\u6b3e\u51ed\u8bc1\uff08\u7533\u62a5\uff09", (String)"DeductRuleUpgradeDataService_4", (String)"taxc-tcvat", (Object[])new Object[0])};
            paramsL.add(paramL2);
            Object[] paramLtax = new Object[]{ids[i], idsL[2], 1, ResManager.loadKDString((String)"\u7a0e\u989d\u914d\u7f6e\u53d6\u6570", (String)"DeductRuleUpgradeDataService_50", (String)"taxc-tcvat", (Object[])new Object[0]), 1057932119981961216L, 1057932120015515672L, "0", "zjqs", "positive", ResManager.loadKDString((String)"\u660e\u7ec6\u884c.\u7a0e\u79cd.\u540d\u79f0 \u7b49\u4e8e \u589e\u503c\u7a0e  ", (String)"DeductRuleUpgradeDataService_52", (String)"taxc-tcvat", (Object[])new Object[0]), "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3IFT1W2J34QP\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u589e\u503c\u7a0e\",\"Id\":\"3IFT1W2J6ZIC\"}],\"CompareType\":\"67\",\"Id\":\"3IFT1W2FGQJ6\",\"Logic\":\"0\",\"FieldName\":\"taxcategory.name\"}]}", "0"};
            paramstax.add(paramLtax);
            Object[] paramLnum = new Object[]{ids[i], idsL[3], 1, ResManager.loadKDString((String)"\u4efd\u6570\u914d\u7f6e\u53d6\u6570", (String)"DeductRuleUpgradeDataService_53", (String)"taxc-tcvat", (Object[])new Object[0]), 1057932119981961216L, 1057932120015515657L, "0", "zjjs", "positive", ResManager.loadKDString((String)"\u660e\u7ec6\u884c.\u7a0e\u79cd.\u540d\u79f0 \u7b49\u4e8e \u589e\u503c\u7a0e  ", (String)"DeductRuleUpgradeDataService_52", (String)"taxc-tcvat", (Object[])new Object[0]), "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3IFT4ME=/97X\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u589e\u503c\u7a0e\",\"Id\":\"3IFT4ME=32/J\"}],\"CompareType\":\"67\",\"Id\":\"3IFT4ME=/97W\",\"Logic\":\"0\",\"FieldName\":\"taxcategory.name\"}]}"};
            paramsnum.add(paramLnum);
        }
    }

    private void deleteData() {
        int delete = this.deleteTemplate(ResManager.loadKDString((String)"\u4ee3\u6263\u4ee3\u7f34\u7a0e\u6536\u7f34\u6b3e\u51ed\u8bc1\uff08\u7533\u62a5\uff09", (String)"DeductRuleUpgradeDataService_4", (String)"taxc-tcvat", (Object[])new Object[0]), 1377424673628775424L);
        int deletetxf = this.deleteTemplate(ResManager.loadKDString((String)"\u672c\u671f\u8ba4\u8bc1\u76f8\u7b26\u4e14\u62b5\u6263\u7684\u901a\u884c\u8d39\u53d1\u7968(\u7533\u62a5)", (String)"DeductRuleUpgradeDataService_49", (String)"taxc-tcvat", (Object[])new Object[0]), 1377423028203316224L);
        int deletezzs = this.deleteTemplate(ResManager.loadKDString((String)"\u672c\u671f\u8ba4\u8bc1\u76f8\u7b26\u4e14\u62b5\u6263\u7684\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968(\u7533\u62a5)", (String)"DeductRuleUpgradeDataService_40", (String)"taxc-tcvat", (Object[])new Object[0]), 1376813763545544704L);
        int deletejdc = this.deleteTemplate(ResManager.loadKDString((String)"\u672c\u671f\u8ba4\u8bc1\u76f8\u7b26\u4e14\u62b5\u6263\u7684\u673a\u52a8\u8f66\u53d1\u7968(\u7533\u62a5)", (String)"DeductRuleUpgradeDataService_37", (String)"taxc-tcvat", (Object[])new Object[0]), 1377423719802102784L);
        int deletelkys = 0;
        int deletehgjk = this.deleteTemplate(ResManager.loadKDString((String)"\u6d77\u5173\u7f34\u6b3e\u4e66(\u7533\u62a5)", (String)"DeductRuleUpgradeDataService_13", (String)"taxc-tcvat", (Object[])new Object[0]), 1377424194228324352L);
        int deletencpsg = this.deleteTemplate(ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968\u6216\u8005\u9500\u552e\u53d1\u7968", (String)"DeductRuleUpgradeDataService_18", (String)"taxc-tcvat", (Object[])new Object[0]), 1377424440996005888L);
        if (this.getView() != null) {
            CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("ksqltext");
            codeSQLshow.setText(String.format(ResManager.loadKDString((String)"\u89c4\u5219\u9884\u5236\u914d\u7f6e\u6570\u636e\u7684\u4e2a\u6570\u4e3a%1$s,txf=%2$s,zzs=%3$s,jdc=%4$s,lkys=%5$s,hgjk=%6$s,ncpsg=%7$s", (String)"DeductRuleUpgradeDataService_54", (String)"taxc-tcvat", (Object[])new Object[0]), delete, deletetxf, deletezzs, deletejdc, deletelkys, deletehgjk, deletencpsg));
        }
    }

    private int deleteTemplate(String name, long deducttype) {
        QFilter filter = new QFilter("name", "=", (Object)name).and("enable", "=", (Object)Character.valueOf('1')).and("deducttype", "=", (Object)deducttype).and("jzjt", "=", (Object)Character.valueOf('0')).and("taxpayertype", "=", (Object)"ybnsr").and("rulepurpose", "=", (Object)",nssb,").and("issystem", "=", (Object)Character.valueOf('1'));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tcvat_rule_deduct", (String)"id", (QFilter[])new QFilter[]{filter});
        Set ids = query.stream().map(one -> one.getLong("id")).collect(Collectors.toSet());
        int delete = 0;
        if (CollectionUtils.isNotEmpty(ids)) {
            LOGGER.info("\u5373\u5c06\u79fb\u9664\u7684\u89c4\u5219\u9884\u5236\u914d\u7f6e\u6570\u636e\u4e3a{}", ids);
            delete = DeleteServiceHelper.delete((String)"tcvat_rule_deduct", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            LOGGER.info("\u79fb\u9664\u7684\u89c4\u5219\u9884\u5236\u914d\u7f6e\u6570\u636e\u7684\u4e2a\u6570\u4e3a{},\u6210\u529f\u79fb\u9664\u7684\u4e2a\u6570\u4e3a{}", (Object)ids.size(), (Object)delete);
        }
        return delete;
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }
}

