/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.control.Button;
import kd.bos.form.control.CodeEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;

public class DeductRuleUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(DeductRuleUpgradeService.class);

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"deleterule", "deleteybnsr", "deleteybhz"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button source = (Button)evt.getSource();
        StringBuilder message = new StringBuilder("DeductRuleUpgradeService update start\n");
        if (Objects.equals("deleterule", source.getKey())) {
            message.append("DeleteServiceHelper.delete(\"tcvat_rule_deduct\", new QFilter[]{new QFilter(\"deducttype\", QCP.equals,1377425530827072512L)})");
        }
        if (Objects.equals("deleteybnsr", source.getKey())) {
            message.append("DeleteServiceHelper.delete(\"tcvat_deduct_detail_bill\", null);");
        }
        if (Objects.equals("deleteybhz", source.getKey())) {
            message.append("DeleteServiceHelper.delete(\"tcvat_ybhz_deduct_detail\",null);");
        }
        CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("ksqltext");
        codeSQLshow.setText(message.toString());
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        StringBuilder message = new StringBuilder("DeductRuleUpgradeService update start\n");
        long l = System.currentTimeMillis();
        try {
            if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tctb_draft_main") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_deduction_summary") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_deduct_count_det")) {
                this.executeYbnsrDraftUpdate(message);
            }
            if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tctb_draft_main") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_hz_deduction_sum") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_hz_deduct_cou_det")) {
                this.executeHzDraftUpdate(message);
            }
            message.append("\nDeductRuleUpgradeService update complete ").append(System.currentTimeMillis() - l).append("ms");
        }
        catch (Exception e) {
            message.append(e.getStackTrace()).append(System.currentTimeMillis() - l).append("ms");
        }
        result.setLog(message.toString());
        return result;
    }

    private void executeHzDraftUpdate(StringBuilder message) {
        String exists = "select fid from t_tcvat_ybhz_deduct_det";
        List deductDetail = DBUtils.query((String)exists);
        if (!deductDetail.isEmpty()) {
            message.append("The hz deduct draft detail already upgraded and does not need to be upgraded \n");
            return;
        }
        String draftSql = "select fid,fserialno,forgid,fstartdate,fenddate,ftaxpayertype from t_tcvat_hz_deduction_sum where forgid in (select forgid from t_tctb_draft_main where ftemplatetype in ('draft_zzsybnsr_ybhz','draft_zzsybnsr_yz_zjg'))";
        DataSet data = DB.queryDataSet((String)"TaxCategoryUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)draftSql);
        if (data.isEmpty()) {
            data.close();
            return;
        }
        ArrayList<HashMap<String, String>> deductionSumList = new ArrayList<HashMap<String, String>>(500);
        while (data.hasNext()) {
            HashMap<String, String> map = new HashMap<String, String>(8);
            Row row = data.next();
            map.put("FSERIALNO", row.getString("FSERIALNO"));
            this.convertToLong(map, row, "FID");
            this.convertToLong(map, row, "FORGID");
            map.put("FSTARTDATE", row.getString("FSTARTDATE"));
            map.put("FENDDATE", row.getString("FENDDATE"));
            map.put("FTAXPAYERTYPE", row.getString("FTAXPAYERTYPE"));
            deductionSumList.add(map);
        }
        data.close();
        Map<String, Map> idToDeductMap = deductionSumList.stream().collect(Collectors.toMap(k -> String.valueOf(k.get("FID")), v -> v, (k1, k2) -> k1));
        String draftDetailSql = "select finvoicetype,fcount,finvoiceamount,ftaxamount,fpid,fbaseinvoicetype from t_tcvat_hz_deduct_cou_det";
        DataSet draftDetailList = DB.queryDataSet((String)"TaxCategoryUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)draftDetailSql);
        ArrayList draftDetailListSumList = new ArrayList(500);
        while (draftDetailList.hasNext()) {
            HashMap<String, String> map = new HashMap<String, String>(8);
            Row row = draftDetailList.next();
            map.put("FINVOICETYPE", row.getString("FINVOICETYPE"));
            map.put("FCOUNT", row.getString("FCOUNT"));
            map.put("FINVOICEAMOUNT", row.getString("FINVOICEAMOUNT"));
            map.put("FTAXAMOUNT", row.getString("FTAXAMOUNT"));
            map.put("FPID", row.getString("FPID"));
            map.put("FBASEINVOICETYPE", row.getString("FBASEINVOICETYPE"));
            draftDetailListSumList.add(map);
        }
        draftDetailList.close();
        String hzDeductSql = "INSERT INTO t_tcvat_ybhz_deduct_det(FID,FSTARTDATE,FENDDATE,FFILTERCONDITION,FBIZNAME,FAMOUNT,FFETCHAMOUNT,FABSOLUTE,FDATADIRECTION,FDATATYPE,FAMOUNTFIELD,FORGID,FTYPE,FTAXACCOUNTSERIALNO,FTABLE,FDECLARETYPE,FSUBORG,FTAXPAYERTYPE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        ArrayList<Object[]> countParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> invoiceamountParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> taxamountParamList = new ArrayList<Object[]>();
        for (int i = 0; i < draftDetailListSumList.size(); ++i) {
            Map stringObjectMap = (Map)draftDetailListSumList.get(i);
            Map deductAccount = idToDeductMap.get(String.valueOf(stringObjectMap.get("FPID")));
            if (null == deductAccount) continue;
            String serialno = (String)deductAccount.get("FSERIALNO");
            Long orgid = Long.valueOf((String)deductAccount.get("FORGID"));
            Date skssqq = DateUtils.stringToDate((String)((String)deductAccount.get("FSTARTDATE")));
            Date skssqz = DateUtils.stringToDate((String)((String)deductAccount.get("FENDDATE")));
            String taxpayertype = (String)deductAccount.get("FTAXPAYERTYPE");
            String invoiceType = (String)stringObjectMap.get("FINVOICETYPE");
            invoiceTypeEnum invoiceEnum = invoiceTypeEnum.getByInvoiceType(invoiceType);
            if (null == invoiceEnum) continue;
            String assignSql = "select fid,flevelname,fassignorg from t_tcvat_ybhz_assign where fid in (select fid from t_tcvat_ybhz_policy_conf where forgid = ? and fstartdate = ? and fenddate = ?)";
            DataSet assignList = DBUtils.queryDataSet((String)"TaxCategoryUpgradeService", (String)assignSql, (Object[])new Object[]{orgid, skssqq, skssqz});
            if (assignList.isEmpty()) {
                assignList.close();
                return;
            }
            ArrayList<HashMap<String, String>> assignListSumList = new ArrayList<HashMap<String, String>>(500);
            while (assignList.hasNext()) {
                HashMap<String, String> map = new HashMap<String, String>(8);
                Row row = assignList.next();
                this.convertToLong(map, row, "FID");
                this.convertToLong(map, row, "FASSIGNORG");
                map.put("FLEVELNAME", row.getString("FLEVELNAME"));
                assignListSumList.add(map);
            }
            assignList.close();
            if (assignListSumList.size() == 0) continue;
            Map stringObjectMap1 = (Map)assignListSumList.get(0);
            Long fid = Long.valueOf((String)stringObjectMap1.get("FID"));
            long[] countDetailFid = DBUtils.getLongIds(null, (int)assignListSumList.size());
            long[] amountDetailFid = DBUtils.getLongIds(null, (int)assignListSumList.size());
            long[] taxAmountDetailFid = DBUtils.getLongIds(null, (int)assignListSumList.size());
            for (int j = 0; j < assignListSumList.size(); ++j) {
                BigDecimal taxamount;
                BigDecimal invoiceamount;
                BigDecimal count;
                Map objectMap = (Map)assignListSumList.get(j);
                if (fid.compareTo(Long.valueOf((String)objectMap.get("FID"))) != 0) continue;
                Long suborg = Long.valueOf((String)objectMap.get("FASSIGNORG"));
                String levelname = (String)objectMap.get("FLEVELNAME");
                if (orgid.compareTo(suborg) == 0) {
                    suborg = orgid;
                    count = new BigDecimal((String)stringObjectMap.get("FCOUNT"));
                    invoiceamount = new BigDecimal((String)stringObjectMap.get("FINVOICEAMOUNT"));
                    taxamount = new BigDecimal((String)stringObjectMap.get("FTAXAMOUNT"));
                } else {
                    count = BigDecimal.ZERO;
                    invoiceamount = BigDecimal.ZERO;
                    taxamount = BigDecimal.ZERO;
                }
                countParamList.add(new Object[]{countDetailFid[j], skssqq, skssqz, invoiceEnum.getFilterCondition(), invoiceEnum.getBizName(), count, BigDecimal.ZERO, "0", "positive", "zjjs", invoiceEnum.getAmountfieldid(), orgid, "count", serialno, invoiceEnum.getTableid(), levelname, suborg, taxpayertype});
                invoiceamountParamList.add(new Object[]{amountDetailFid[j], skssqq, skssqz, invoiceEnum.getFilterCondition(), invoiceEnum.getBizName(), invoiceamount, BigDecimal.ZERO, "0", "positive", "zjjs", invoiceEnum.getAmountfieldid(), orgid, "amount", serialno, invoiceEnum.getTableid(), levelname, suborg, taxpayertype});
                taxamountParamList.add(new Object[]{taxAmountDetailFid[j], skssqq, skssqz, invoiceEnum.getFilterCondition(), invoiceEnum.getBizName(), taxamount, BigDecimal.ZERO, "0", "positive", "zjjs", invoiceEnum.getAmountfieldid(), orgid, "taxamount", serialno, invoiceEnum.getTableid(), levelname, suborg, taxpayertype});
                if (!"10".equals(invoiceType)) continue;
                long id = DBUtils.getLongId(null);
                invoiceTypeEnum invoiceEnum_1 = invoiceTypeEnum.AIR_1;
                countParamList.add(new Object[]{id, skssqq, skssqz, invoiceEnum_1.getFilterCondition(), invoiceEnum_1.getBizName(), BigDecimal.ZERO, BigDecimal.ZERO, "0", "positive", "zjjs", invoiceEnum_1.getAmountfieldid(), orgid, "count", serialno, invoiceEnum_1.getTableid(), levelname, suborg, taxpayertype});
            }
        }
        try (TXHandle h = TX.required();){
            try {
                if (countParamList.size() > 0) {
                    DBUtils.executeBatch((String)hzDeductSql, countParamList);
                }
                if (invoiceamountParamList.size() > 0) {
                    DBUtils.executeBatch((String)hzDeductSql, invoiceamountParamList);
                }
                if (taxamountParamList.size() > 0) {
                    DBUtils.executeBatch((String)hzDeductSql, taxamountParamList);
                }
                message.append("HzDraftUpdate SUCCESS").append('\n');
            }
            catch (Throwable t) {
                h.markRollback();
                message.append("HzDraftUpdate FAILURE:").append(t).append('\n');
                LOGGER.info("HzDraftUpdate FAILURE:", (Object)t);
            }
        }
    }

    private void executeYbnsrDraftUpdate(StringBuilder message) {
        String exists = "select fid from t_tcvat_deduct_detail_bil";
        List deductDetail = DBUtils.query((String)exists);
        if (!deductDetail.isEmpty()) {
            message.append("The deduct draft detail already upgraded and does not need to be upgraded \n");
            return;
        }
        String draftSql = "select fid,fserialno,forgid,ftaxperiod from t_tcvat_deduction_summary where forgid in (select forgid from t_tctb_draft_main where ftemplatetype = 'draft_zzsybnsr')";
        DataSet data = DB.queryDataSet((String)"TaxCategoryUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)draftSql);
        if (data.isEmpty()) {
            data.close();
            return;
        }
        ArrayList<HashMap<String, String>> deductionSumList = new ArrayList<HashMap<String, String>>(500);
        while (data.hasNext()) {
            HashMap<String, String> map = new HashMap<String, String>(8);
            Row row = data.next();
            this.convertToLong(map, row, "FID");
            this.convertToLong(map, row, "FORGID");
            map.put("FSERIALNO", row.getString("FSERIALNO"));
            map.put("FTAXPERIOD", row.getString("FTAXPERIOD"));
            deductionSumList.add(map);
        }
        data.close();
        Map<String, Map> idToDeductMap = deductionSumList.stream().collect(Collectors.toMap(k -> String.valueOf(k.get("FID")), v -> v, (k1, k2) -> k1));
        String draftDetailSql = "select finvoicetype,fcount,finvoiceamount,ftaxamount,fpid,fbaseinvoicetype from t_tcvat_deduct_count_det";
        DataSet draftDetailList = DB.queryDataSet((String)"TaxCategoryUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)draftDetailSql);
        if (draftDetailList.isEmpty()) {
            draftDetailList.close();
            return;
        }
        ArrayList<HashMap<String, String>> draftDetailListSumList = new ArrayList<HashMap<String, String>>(500);
        while (draftDetailList.hasNext()) {
            HashMap<String, String> map = new HashMap<String, String>(8);
            Row row = draftDetailList.next();
            map.put("FINVOICETYPE", row.getString("FINVOICETYPE"));
            map.put("FCOUNT", row.getString("FCOUNT"));
            map.put("FINVOICEAMOUNT", row.getString("FINVOICEAMOUNT"));
            map.put("FTAXAMOUNT", row.getString("FTAXAMOUNT"));
            this.convertToLong(map, row, "FPID");
            map.put("FBASEINVOICETYPE", row.getString("FBASEINVOICETYPE"));
            draftDetailListSumList.add(map);
        }
        draftDetailList.close();
        String ybnsrDeductSql = "INSERT INTO t_tcvat_deduct_detail_bil(FID,FSKSSQQ,FSKSSQZ,FFILTERCONDITION,FBIZNAME,FAMOUNT,FFETCHAMOUNT,FABSOLUTE,FDATADIRECTION,FDATATYPE,FAMOUNTFIELD,FORGID,FTYPE,FTAXACCOUNTSERIALNO,FTABLE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        ArrayList<Object[]> countParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> invoiceamountParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> taxamountParamList = new ArrayList<Object[]>();
        long[] countDetailFid = DB.genLongIds(null, (int)draftDetailListSumList.size());
        long[] amountDetailFid = DB.genLongIds(null, (int)draftDetailListSumList.size());
        long[] taxAmountDetailFid = DB.genLongIds(null, (int)draftDetailListSumList.size());
        for (int i = 0; i < draftDetailListSumList.size(); ++i) {
            Map stringObjectMap = (Map)draftDetailListSumList.get(i);
            Map deductAccount = idToDeductMap.get(String.valueOf(stringObjectMap.get("FPID")));
            if (null == deductAccount) continue;
            String serialno = (String)deductAccount.get("FSERIALNO");
            Long orgid = Long.valueOf((String)deductAccount.get("FORGID"));
            String taxperiod = (String)deductAccount.get("FTAXPERIOD");
            Date skssqq = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM"));
            Date skssqz = DateUtils.getLastDateOfMonth2((Date)DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM"));
            BigDecimal count = new BigDecimal((String)stringObjectMap.get("FCOUNT"));
            BigDecimal invoiceamount = new BigDecimal((String)stringObjectMap.get("FINVOICEAMOUNT"));
            BigDecimal taxamount = new BigDecimal((String)stringObjectMap.get("FTAXAMOUNT"));
            String invoiceType = (String)stringObjectMap.get("FINVOICETYPE");
            invoiceTypeEnum invoiceEnum = invoiceTypeEnum.getByInvoiceType(invoiceType);
            if (null == invoiceEnum) continue;
            countParamList.add(new Object[]{countDetailFid[i], skssqq, skssqz, invoiceEnum.getFilterCondition(), invoiceEnum.getBizName(), count, BigDecimal.ZERO, "0", "positive", "zjjs", invoiceEnum.getAmountfieldid(), orgid, "count", serialno, invoiceEnum.getTableid()});
            invoiceamountParamList.add(new Object[]{amountDetailFid[i], skssqq, skssqz, invoiceEnum.getFilterCondition(), invoiceEnum.getBizName(), invoiceamount, BigDecimal.ZERO, "0", "positive", "zjjs", invoiceEnum.getAmountfieldid(), orgid, "amount", serialno, invoiceEnum.getTableid()});
            taxamountParamList.add(new Object[]{taxAmountDetailFid[i], skssqq, skssqz, invoiceEnum.getFilterCondition(), invoiceEnum.getBizName(), taxamount, BigDecimal.ZERO, "0", "positive", "zjjs", invoiceEnum.getAmountfieldid(), orgid, "taxamount", serialno, invoiceEnum.getTableid()});
            if (!"10".equals(invoiceType)) continue;
            long id = DBUtils.getLongId(null);
            invoiceEnum = invoiceTypeEnum.AIR_1;
            countParamList.add(new Object[]{id, skssqq, skssqz, invoiceEnum.getFilterCondition(), invoiceEnum.getBizName(), BigDecimal.ZERO, BigDecimal.ZERO, "0", "positive", "zjjs", invoiceEnum.getAmountfieldid(), orgid, "count", serialno, invoiceEnum.getTableid()});
        }
        try (TXHandle h = TX.required();){
            try {
                if (countParamList.size() > 0) {
                    DBUtils.executeBatch((String)ybnsrDeductSql, countParamList);
                }
                if (invoiceamountParamList.size() > 0) {
                    DBUtils.executeBatch((String)ybnsrDeductSql, invoiceamountParamList);
                }
                if (taxamountParamList.size() > 0) {
                    DBUtils.executeBatch((String)ybnsrDeductSql, taxamountParamList);
                }
                message.append("YbnsrDraftUpdate SUCCESS").append('\n');
            }
            catch (Throwable t) {
                h.markRollback();
                message.append("YbnsrDraftUpdate FAILURE:").append(t).append('\n');
                LOGGER.info("YbnsrDraftUpdate FAILURE:", (Object)t);
            }
        }
    }

    private void convertToLong(Map<String, String> map, Row row, String field) {
        map.put(field, row.getString(field));
    }

    protected Boolean metaIsExist(String entityName) {
        try {
            MetadataUtil.getEntityById((String)entityName);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Boolean.FALSE;
        }
    }

    public static enum invoiceTypeEnum {
        ORDINARY("1", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u7535\u5b50\u666e\u901a\u53d1\u7968", (String)"DeductRuleUpgradeService_2", (String)"taxc-tcvat", (Object[])new Object[0]), "DeductRuleUpgradeService_2", "taxc-tcvat"), new MultiLangEnumBridge(ResManager.loadKDString((String)"\u53ef\u7528\u72b6\u6001 \u7b49\u4e8e \u53ef\u7528  \u5e76\u4e14            \u65c5\u5ba2\u8fd0\u8f93\u62b5\u6263 \u7b49\u4e8e \u5df2\u62b5\u6263  \u5e76\u4e14    \u53d1\u7968\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38  \u5e76\u4e14    \u53d1\u7968\u7c7b\u578b\u540d\u79f0 \u7b49\u4e8e \u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968  ", (String)"DeductRuleUpgradeService_3", (String)"taxc-tcvat", (Object[])new Object[0]), "DeductRuleUpgradeService_3", "taxc-tcvat"), 1341331302799962112L, 1341331302841905186L),
        TRAIN("9", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u706b\u8f66\u7968(\u542b\u9ad8\u94c1)", (String)"DeductRuleUpgradeService_34", (String)"taxc-tcvat", (Object[])new Object[0]), "DeductRuleUpgradeService_34", "taxc-tcvat"), new MultiLangEnumBridge(ResManager.loadKDString((String)"\u53ef\u7528\u72b6\u6001 \u7b49\u4e8e \u53ef\u7528  \u5e76\u4e14            \u65c5\u5ba2\u8fd0\u8f93\u62b5\u6263 \u7b49\u4e8e \u5df2\u62b5\u6263  ", (String)"DeductRuleUpgradeService_17", (String)"taxc-tcvat", (Object[])new Object[0]), "DeductRuleUpgradeService_17", "taxc-tcvat"), 1560742903603629056L, 1560742903628794891L),
        AIR("10", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u98de\u673a\u884c\u7a0b\u5355\u98de\u673a\u7968\u4ef7", (String)"DeductRuleUpgradeService_35", (String)"taxc-tcvat", (Object[])new Object[0]), "DeductRuleUpgradeService_35", "taxc-tcvat"), new MultiLangEnumBridge(ResManager.loadKDString((String)"\u53ef\u7528\u72b6\u6001 \u7b49\u4e8e \u53ef\u7528  \u5e76\u4e14            \u65c5\u5ba2\u8fd0\u8f93\u62b5\u6263 \u7b49\u4e8e \u5df2\u62b5\u6263  ", (String)"DeductRuleUpgradeService_17", (String)"taxc-tcvat", (Object[])new Object[0]), "DeductRuleUpgradeService_17", "taxc-tcvat"), 1560778065032899584L, 1560778072599424015L),
        AIR_1("10_1", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u98de\u673a\u884c\u7a0b\u5355\u71c3\u6cb9\u9644\u52a0\u8d39", (String)"DeductRuleUpgradeService_36", (String)"taxc-tcvat", (Object[])new Object[0]), "DeductRuleUpgradeService_36", "taxc-tcvat"), new MultiLangEnumBridge(ResManager.loadKDString((String)"\u53ef\u7528\u72b6\u6001 \u7b49\u4e8e \u53ef\u7528  \u5e76\u4e14            \u65c5\u5ba2\u8fd0\u8f93\u62b5\u6263 \u7b49\u4e8e \u5df2\u62b5\u6263  ", (String)"DeductRuleUpgradeService_17", (String)"taxc-tcvat", (Object[])new Object[0]), "DeductRuleUpgradeService_17", "taxc-tcvat"), 1560778065032899584L, 1560778072599424015L),
        CAR("16", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u516c\u8def\u6c7d\u8f66\u7968", (String)"DeductRuleUpgradeService_37", (String)"taxc-tcvat", (Object[])new Object[0]), "DeductRuleUpgradeService_37", "taxc-tcvat"), new MultiLangEnumBridge(ResManager.loadKDString((String)"\u53ef\u7528\u72b6\u6001 \u7b49\u4e8e \u53ef\u7528  \u5e76\u4e14            \u65c5\u5ba2\u8fd0\u8f93\u62b5\u6263 \u7b49\u4e8e \u5df2\u62b5\u6263  \u5e76\u4e14    \u53d1\u7968\u7c7b\u578b\u540d\u79f0 \u7b49\u4e8e \u6c7d\u8f66\u7968  ", (String)"DeductRuleUpgradeService_38", (String)"taxc-tcvat", (Object[])new Object[0]), "DeductRuleUpgradeService_38", "taxc-tcvat"), 1560740606819535872L, 1560740606878256139L),
        SHIP("20", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u8f6e\u8239\u7968", (String)"DeductRuleUpgradeService_39", (String)"taxc-tcvat", (Object[])new Object[0]), "DeductRuleUpgradeService_39", "taxc-tcvat"), new MultiLangEnumBridge(ResManager.loadKDString((String)"\u53ef\u7528\u72b6\u6001 \u7b49\u4e8e \u53ef\u7528  \u5e76\u4e14            \u65c5\u5ba2\u8fd0\u8f93\u62b5\u6263 \u7b49\u4e8e \u5df2\u62b5\u6263  \u5e76\u4e14    \u53d1\u7968\u7c7b\u578b\u540d\u79f0 \u7b49\u4e8e \u8f6e\u8239\u7968  ", (String)"DeductRuleUpgradeService_40", (String)"taxc-tcvat", (Object[])new Object[0]), "DeductRuleUpgradeService_40", "taxc-tcvat"), 1560740606819535872L, 1560740606878256139L);

        private String invoiceType;
        private MultiLangEnumBridge bizName;
        private MultiLangEnumBridge filterCondition;
        private Long tableid;
        private Long amountfieldid;

        private invoiceTypeEnum(String invoiceType, MultiLangEnumBridge bizName, MultiLangEnumBridge filterCondition, Long tableid, Long amountfieldid) {
            this.invoiceType = invoiceType;
            this.bizName = bizName;
            this.filterCondition = filterCondition;
            this.tableid = tableid;
            this.amountfieldid = amountfieldid;
        }

        public String getInvoiceType() {
            return this.invoiceType;
        }

        public String getBizName() {
            return this.bizName.loadKDString();
        }

        public String getFilterCondition() {
            return this.filterCondition.loadKDString();
        }

        public Long getTableid() {
            return this.tableid;
        }

        public Long getAmountfieldid() {
            return this.amountfieldid;
        }

        public static invoiceTypeEnum getByInvoiceType(String type) {
            for (invoiceTypeEnum value : invoiceTypeEnum.values()) {
                if (!type.equals(value.getInvoiceType())) continue;
                return value;
            }
            return null;
        }
    }
}

