/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public class DraftSjjtYnseUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(DraftSjjtYnseUpgradeService.class);

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        List<Map<String, Object>> ybnsrHzJtQueryResult;
        String ybnsrJtQuerySql = "select a.fid as fid,b.fsbbid as fsbbid from t_tpo_declare_main_tsd a left join t_tcvat_dg_ybnsr b on a.fid=b.fid where a.ftemplatetype in ('draft_zzsybnsr_sjjt') and b.fsbbid is not null and b.fsbbid !='' and b.fsbbid !=' '";
        String ybnsrHzJtQuerySql = "select a.fid as fid,b.fsbbid as fsbbid from t_tpo_declare_main_tsd a left join t_tcvat_dg_ybnsr_ybhz b on a.fid=b.fid where a.ftemplatetype in ('draft_zzsybnsr_ybhz_sjjt','draft_zzsybnsr_hz_zjg_sjjt','draft_zzsybnsr_yz_zjg_sjjt','draft_zzsybnsr_yz_fzjg_Sjjt')  and b.fsbbid is not null and b.fsbbid !='' and b.fsbbid !=' '";
        String ybnsrZlbQuerySql = "select fsbbid,fybxm,fjzjtxm,fewblxh from t_tcvat_zlb_ybnsr where fsbbid in (%s) and fewblxh in ('34','42','50','58')";
        String ybnsrHzZlbQuerySql = "select fsbbid,fybxm,fjzjtxm,fewblxh from t_tcvat_zlb_ybnsr_ybhz where fsbbid in (%s) and fewblxh in ('31')";
        String updateSql = "update t_tpo_declare_main_tsd set fjtynsesum = ? where fid=?;";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        List<Map<String, Object>> ybnsrJtQueryResult = this.queryMaps(ybnsrJtQuerySql);
        if (ybnsrJtQueryResult != null && ybnsrJtQueryResult.size() > 0) {
            String fsbbids = ybnsrJtQueryResult.stream().map(a -> (String)a.get("FSBBID")).map(a -> "'" + a + "'").collect(Collectors.joining(","));
            Map<Object, Object> fidMap = ybnsrJtQueryResult.stream().collect(Collectors.toMap(k -> k.get("FSBBID"), v -> v.get("FID"), (n, o) -> o));
            ybnsrZlbQuerySql = String.format(ybnsrZlbQuerySql, fsbbids);
            List<Map<String, Object>> ybnsrZlbQueryResult = this.queryMaps(ybnsrZlbQuerySql);
            Map<Object, List<Map>> sbbGroup = ybnsrZlbQueryResult.stream().collect(Collectors.groupingBy(a -> a.get("FSBBID")));
            for (Map.Entry<Object, List<Map>> entry : sbbGroup.entrySet()) {
                String string = (String)entry.getKey();
                Object fid = fidMap.get(string);
                BigDecimal fjtynsesum = entry.getValue().stream().map(a -> {
                    if ("34".equals(a.get("FEWBLXH"))) {
                        return BigDecimalUtil.addObjects((Object[])new Object[]{a.get("FYBXM"), a.get("FJZJTXM")});
                    }
                    return (BigDecimal)a.get("FYBXM");
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                paramList.add(new Object[]{fjtynsesum, fid});
            }
        }
        if ((ybnsrHzJtQueryResult = this.queryMaps(ybnsrHzJtQuerySql)) != null && ybnsrHzJtQueryResult.size() > 0) {
            String fsbbids = ybnsrHzJtQueryResult.stream().map(a -> a.get("FSBBID")).map(a -> "'" + a + "'").collect(Collectors.joining(","));
            Map<Object, Object> fidMap = ybnsrHzJtQueryResult.stream().collect(Collectors.toMap(k -> k.get("FSBBID"), v -> v.get("FID"), (n, o) -> o));
            ybnsrHzZlbQuerySql = String.format(ybnsrHzZlbQuerySql, fsbbids);
            List<Map<String, Object>> ybnsrHzZlbQueryResult = this.queryMaps(ybnsrHzZlbQuerySql);
            Map<Object, List<Map>> sbbGroup = ybnsrHzZlbQueryResult.stream().collect(Collectors.groupingBy(a -> a.get("FSBBID")));
            for (Map.Entry<Object, List<Map>> entry : sbbGroup.entrySet()) {
                String fsbbid = (String)entry.getKey();
                Object fid = fidMap.get(fsbbid);
                BigDecimal fjtynsesum = entry.getValue().stream().map(a -> BigDecimalUtil.addObjects((Object[])new Object[]{a.get("FYBXM"), a.get("FJZJTXM")})).reduce(BigDecimal.ZERO, BigDecimal::add);
                paramList.add(new Object[]{fjtynsesum, fid});
            }
        }
        if (paramList.size() == 0) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                Long l = System.currentTimeMillis();
                this.addLog(INFO, updateSql);
                this.addLog(INFO, String.format("The params size %d", paramList.size()));
                List partition = Lists.partition(paramList, (int)200);
                for (List list : partition) {
                    DBUtils.executeBatch((String)updateSql, (List)list);
                }
                Long l2 = System.currentTimeMillis();
                this.addLog(INFO, String.format("The result, use time %d", l2 - l));
            }
            catch (Throwable t) {
                h.markRollback();
                LOGGER.error(ERROR_INFO, t);
                throw t;
            }
        }
    }

    private List<Map<String, Object>> queryMaps(String sql) {
        this.addLog(INFO, sql);
        long l = System.currentTimeMillis();
        List preProjects = DBUtils.query((String)sql);
        long l1 = System.currentTimeMillis();
        this.addLog(INFO, String.format("The result size is %d, use time %d", preProjects.size(), l1 - l));
        return preProjects;
    }
}

