/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class HZRateToDecimalUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(HZRateToDecimalUpgradeService.class);

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "HZRateToDecimalUpgradeService DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("HZRateToDecimalUpgradeService DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        boolean isExist;
        if (this.isUpgraded()) {
            LOGGER.error("HZRateToDecimalUpgradeService already upgraded");
            this.addLog(INFO, "HZRateToDecimalUpgradeService already upgraded");
            return;
        }
        String selectFb5UpdateSql = "select fid from t_tctb_declare_main where fnsrtype in ('zzsybnsr_hz_zjg','zzsybnsr_ybhz','zzsybnsr_yz_zjg','zzsybnsr_yz_fzjg')";
        String selectFpUpdateSql = "select fid from t_tctb_declare_main where fnsrtype in ('zzsybnsr_ybhz') or ftemplateid in (%s)";
        String selectEjfpUpdateSql = "select fid from t_tctb_declare_main where ftemplateid in (%s)";
        String selectTemplateidSql = "select fid from t_bdtaxr_template_main  where fnumber in (%s)";
        String updateFb5TcvatSbFjsf = "update t_tcvat_sb_fjsf set fsl = fsl / 100,fjzbl = fjzbl / 100 where fsbbid in (%s)";
        String updateFpTcvatYbqyhzsbFpb = "update t_tcvat_ybqyhzsb_fpb set ffixratio = ffixratio /100 ,flwfpbl = flwfpbl / 100,fjzjtfpbl = fjzjtfpbl / 100,fysfwfpbl = fysfwfpbl / 100,fysfwjzjtfpbl = fysfwjzjtfpbl / 100 where fsbbid in (%s)";
        String updateFpTcvatYbqyhzsbFzjg = "update t_tcvat_ybqyhzsb_fzjg set ffpbl = ffpbl / 100,fjzjtfpbl = fjzjtfpbl / 100,fysfwfpbl = fysfwfpbl / 100,fysfwjzjtfpbl = fysfwjzjtfpbl / 100 where fsbbid in (%s)";
        String updateEjfpTcvatYbhzYzZfjgfpb = "update t_tcvat_ybhz_yz_zfjgfpb set ffpbl = ffpbl / 100,ffpl = ffpl / 100 where fsbbid in (%s)";
        DBRoute dbRoute = DBRoute.of((String)"taxc");
        boolean bl = isExist = DB.exitsTable((DBRoute)dbRoute, (String)"t_tctb_declare_main") && DB.exitsTable((DBRoute)dbRoute, (String)"t_bdtaxr_template_main") && DB.exitsTable((DBRoute)dbRoute, (String)"t_tcvat_sb_fjsf") && DB.exitsTable((DBRoute)dbRoute, (String)"t_tcvat_ybqyhzsb_fpb") && DB.exitsTable((DBRoute)dbRoute, (String)"t_tcvat_ybqyhzsb_fzjg") && DB.exitsTable((DBRoute)dbRoute, (String)"t_tcvat_ybhz_yz_zfjgfpb");
        if (!isExist) {
            LOGGER.error("any table not exist!");
            this.addLog(ERROR, "any table not exist!");
            return;
        }
        List<String> shandongTemplateIds = this.getIds(this.getSql(selectTemplateidSql, Arrays.asList("'VAT-HOYZ-202201-SHANDONG'", "'VAT-BOYZ-202201-SHANDONG'")));
        List<String> shandongFzjgTemplateIds = this.getIds(this.getSql(selectTemplateidSql, Collections.singletonList("'VAT-BOYZ-202201-SHANDONG'")));
        List<String> fb5UpdateDeclareIds = this.getIds(selectFb5UpdateSql);
        List<String> fpUpdateDeclareIds = this.getIds(this.getSql(selectFpUpdateSql, shandongFzjgTemplateIds));
        List<String> ejfpUpdateDeclareIds = this.getIds(this.getSql(selectEjfpUpdateSql, shandongTemplateIds));
        try (TXHandle h = TX.requiresNew();){
            try {
                List partition;
                if (!CollectionUtils.isEmpty(fb5UpdateDeclareIds)) {
                    partition = Lists.partition(fb5UpdateDeclareIds, (int)500);
                    this.addLog(INFO, "upgrade fb5");
                    this.addLog(INFO, updateFb5TcvatSbFjsf + ":" + fb5UpdateDeclareIds.size());
                    LOGGER.info("upgrade fb5");
                    LOGGER.info(updateFb5TcvatSbFjsf + ":" + fb5UpdateDeclareIds.size());
                    for (List ids : partition) {
                        DBUtils.execute((String)this.getSql(updateFb5TcvatSbFjsf, ids));
                    }
                    LOGGER.info("upgrade fb5 end");
                }
                if (!CollectionUtils.isEmpty(fpUpdateDeclareIds)) {
                    partition = Lists.partition(fpUpdateDeclareIds, (int)500);
                    for (List ids : partition) {
                        DBUtils.execute((String)this.getSql(updateFpTcvatYbqyhzsbFpb, ids));
                        DBUtils.execute((String)this.getSql(updateFpTcvatYbqyhzsbFzjg, ids));
                    }
                }
                if (!CollectionUtils.isEmpty(ejfpUpdateDeclareIds)) {
                    partition = Lists.partition(ejfpUpdateDeclareIds, (int)500);
                    for (List ids : partition) {
                        DBUtils.execute((String)this.getSql(updateEjfpTcvatYbhzYzZfjgfpb, ids));
                    }
                }
                this.saveUpgradeLog();
            }
            catch (Exception e) {
                this.addLog(ERROR, "HZRateToDecimalUpgradeService DATA UPGRADE FAIL");
                LOGGER.error("HZRateToDecimalUpgradeService DATA UPGRADE FAIL");
                this.addLog(ERROR, e.toString());
                LOGGER.error((Throwable)e);
                h.markRollback();
            }
        }
    }

    private void saveUpgradeLog() {
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_bdtaxr_plugin_upgrade")) {
            return;
        }
        String insertSql = "insert into t_bdtaxr_plugin_upgrade (FID,FTABLE,FKEY,FTYPE,FCREATETIME,FSUCCESS,FLOG) values (%s, %s, %s, %s, %s, %s, %s)";
        DBUtils.execute((String)String.format(insertSql, DB.genLongId((String)"t_bdtaxr_plugin_upgrade"), "'HZRateToDecimalUpgradeService'", "'HZRateToDecimalUpgradeService'", "'HZRateToDecimalUpgradeService'", "'" + DateUtils.getDateTime() + "'", "'1'", "'HZRateToDecimalUpgradeService'"));
    }

    private boolean isUpgraded() {
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_bdtaxr_plugin_upgrade")) {
            return false;
        }
        String isExistSql = "select fid from t_bdtaxr_plugin_upgrade where ftype = 'HZRateToDecimalUpgradeService'";
        return !CollectionUtils.isEmpty((Collection)DBUtils.query((String)isExistSql));
    }

    private String getSql(String sql, List<String> params) {
        return String.format(sql, String.join((CharSequence)",", params));
    }

    private List<String> getIds(String sql) {
        List resultList = DBUtils.query((String)sql);
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return new ArrayList<String>();
        }
        return resultList.stream().map(r -> "'" + r.get("FID") + "'").collect(Collectors.toList());
    }

    private void deleteUpgradeLog() {
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_bdtaxr_plugin_upgrade")) {
            return;
        }
        String delSql = "delete from t_bdtaxr_plugin_upgrade where ftype = 'HZRateToDecimalUpgradeService'";
        DBUtils.execute((String)delSql);
    }
}

