/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.Base39Coder;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.tcvat.common.enums.InvoiceTypeEntityMappingEnum;
import org.apache.commons.collections.CollectionUtils;

public class InvoiceTypeUpgradeService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(InvoiceTypeUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        StringBuilder message = new StringBuilder(ResManager.loadKDString((String)"\u66f4\u65b0TCVAT\u53d1\u7968\u7c7b\u578b\u8fc7\u7a0b", (String)"InvoiceTypeUpgradeService_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        Boolean isExist = InvoiceTypeUpgradeService.metaIsExist("bd_invoicetype");
        if (isExist.booleanValue()) {
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("issystem", "=", (Object)"1")});
            Map<String, String> invoiceTypeMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(o -> o.getString("number"), o -> o.getString("id")));
            Map<String, String> invoiceTypeNameMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(o -> o.getString("number"), o -> o.getString("name")));
            this.update(invoiceTypeMap);
            this.dealIncomeData(invoiceTypeMap, invoiceTypeNameMap);
            this.dealPrepayData(invoiceTypeMap, invoiceTypeNameMap);
            result.setLog(ResManager.loadKDString((String)message.toString(), (String)"InvoiceTypeUpgradeService_0", (String)"InvoiceTypeUpgradeService_1", (Object[])new Object[0]));
        }
        return result;
    }

    private void update(Map<String, String> invoiceTypeMap) {
        try (TXHandle h = TX.required();){
            try {
                for (InvoiceTypeEntityMappingEnum value : InvoiceTypeEntityMappingEnum.values()) {
                    Boolean isExist = InvoiceTypeUpgradeService.metaIsExist(value.getInvoiceEntity());
                    if (!isExist.booleanValue()) continue;
                    for (String invoiceType : Arrays.asList(value.getInvoiceType().split(","))) {
                        if (!invoiceTypeMap.containsKey(invoiceType)) continue;
                        QFilter qFilter = new QFilter(value.getFieldName(), "=", (Object)invoiceType);
                        DataSet invoiceTypesDataSet = QueryServiceHelper.queryDataSet((String)"InvoiceTypeUpgradeService_update", (String)value.getInvoiceEntity(), (String)"id", (QFilter[])new QFilter[]{qFilter}, null);
                        if (invoiceTypesDataSet.isEmpty()) continue;
                        for (Row row : invoiceTypesDataSet) {
                            StringBuilder updateSql = new StringBuilder();
                            updateSql.append("update ").append(value.getTableName()).append(" set fbaseinvoicetype=").append('\'').append(invoiceTypeMap.get(invoiceType)).append('\'').append(" where fid=").append('\'').append(row.getString("id")).append('\'').append(';');
                            DBUtils.execute((String)updateSql.toString());
                        }
                        invoiceTypesDataSet.close();
                    }
                }
            }
            catch (Throwable e) {
                h.markRollback();
                LOGGER.error("update error", e);
                if (h != null) {
                    if (var3_3 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return;
            }
        }
    }

    private void dealPrepayData(Map<String, String> invoiceTypeMap, Map<String, String> invoiceTypeNameMap) {
        try (TXHandle h = TX.required();){
            try {
                DynamicObject[] incomeObjects;
                QFilter qFilter = new QFilter("entryentity.filtercondition", "like", (Object)ResManager.loadKDString((String)"%\u53d1\u7968\u7c7b\u578b%", (String)"InvoiceTypeUpgradeService_2", (String)"taxc-tcvat", (Object[])new Object[0])).or(new QFilter("deductionentry.deductionconditionjson", "like", (Object)ResManager.loadKDString((String)"%\u53d1\u7968\u7c7b\u578b%", (String)"InvoiceTypeUpgradeService_2", (String)"taxc-tcvat", (Object[])new Object[0])));
                Boolean isExist = InvoiceTypeUpgradeService.metaIsExist("tcvat_rule_prepay");
                if (isExist.booleanValue() && (incomeObjects = BusinessDataServiceHelper.load((String)"tcvat_rule_prepay", (String)"id,entryentity.filtercondition,entryentity.conditionjson,deductionentry.deductionfiltercondition,deductionentry.deductionconditionjson", (QFilter[])new QFilter[]{qFilter})) != null && incomeObjects.length > 0) {
                    Arrays.stream(incomeObjects).forEach(o -> {
                        DynamicObjectCollection dynamicObjectCollection1;
                        DynamicObjectCollection dynamicObjectCollection = o.getDynamicObjectCollection("entryentity");
                        if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
                            this.dealEntryData(invoiceTypeMap, dynamicObjectCollection, "filtercondition", "conditionjson", invoiceTypeNameMap);
                        }
                        if ((dynamicObjectCollection1 = o.getDynamicObjectCollection("deductionentry")) != null && dynamicObjectCollection1.size() > 0) {
                            this.dealEntryData(invoiceTypeMap, dynamicObjectCollection1, "deductionfiltercondition", "deductionconditionjson", invoiceTypeNameMap);
                        }
                    });
                    SaveServiceHelper.update((DynamicObject[])incomeObjects);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                LOGGER.error("dealPrepayData error", e);
                if (h != null) {
                    if (var4_4 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return;
            }
        }
    }

    private void dealIncomeData(Map<String, String> invoiceTypeMap, Map<String, String> invoiceTypeNameMap) {
        try (TXHandle h = TX.required();){
            try {
                DynamicObject[] incomeObjects;
                QFilter qFilter = new QFilter("entryentity.filtercondition", "like", (Object)ResManager.loadKDString((String)"%\u53d1\u7968\u7c7b\u578b%", (String)"InvoiceTypeUpgradeService_2", (String)"taxc-tcvat", (Object[])new Object[0])).or(new QFilter("invoiceentity.invoicefiltercondition", "like", (Object)ResManager.loadKDString((String)"%\u53d1\u7968\u7c7b\u578b%", (String)"InvoiceTypeUpgradeService_2", (String)"taxc-tcvat", (Object[])new Object[0])));
                Boolean isExist = InvoiceTypeUpgradeService.metaIsExist("tcvat_rule_income");
                if (isExist.booleanValue() && (incomeObjects = BusinessDataServiceHelper.load((String)"tcvat_rule_income", (String)"id,entryentity.filtercondition,entryentity.conditionjson,invoiceentity.invoicefiltercondition,invoiceentity.invoiceconditionjson", (QFilter[])new QFilter[]{qFilter})) != null && incomeObjects.length > 0) {
                    Arrays.stream(incomeObjects).forEach(o -> {
                        DynamicObjectCollection dynamicObjectCollection1;
                        DynamicObjectCollection dynamicObjectCollection = o.getDynamicObjectCollection("entryentity");
                        if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
                            this.dealEntryData(invoiceTypeMap, dynamicObjectCollection, "filtercondition", "conditionjson", invoiceTypeNameMap);
                        }
                        if ((dynamicObjectCollection1 = o.getDynamicObjectCollection("invoiceentity")) != null && dynamicObjectCollection1.size() > 0) {
                            this.dealEntryData(invoiceTypeMap, dynamicObjectCollection1, "invoicefiltercondition", "invoiceconditionjson", invoiceTypeNameMap);
                        }
                    });
                    SaveServiceHelper.update((DynamicObject[])incomeObjects);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                LOGGER.error("dealIncomeData error", e);
                if (h != null) {
                    if (var4_4 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return;
            }
        }
    }

    private void dealEntryData(Map<String, String> invoiceTypeMap, DynamicObjectCollection dynamicObjectCollection, String filterConditionFieldName, String conditionJsonFieldName, Map<String, String> invoiceTypeNameMap) {
        try {
            dynamicObjectCollection.stream().forEach(e -> {
                String filterCondition = e.getString(filterConditionFieldName);
                if (StringUtils.isNotEmpty((CharSequence)filterCondition) && filterCondition.contains(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b", (String)"InvoiceTypeUpgradeService_3", (String)"taxc-tcvat", (Object[])new Object[0]))) {
                    String conditionJson = e.getString(conditionJsonFieldName);
                    HashMap conditionMap = (HashMap)JsonUtil.fromJson((String)conditionJson, Map.class);
                    List simpleFilterRows = (List)conditionMap.get("FilterRow");
                    ArrayList types = new ArrayList();
                    simpleFilterRows.forEach(s -> {
                        if ("type".equals(s.get("FieldName"))) {
                            s.put("FieldName", "baseinvoicetype.number");
                            ArrayList baseDataIds = new ArrayList();
                            List values = (List)s.get("Value");
                            values.stream().forEach(v -> {
                                HashMap<String, String> map = new HashMap<String, String>();
                                map.put("Id", Base39Coder.toString((long)IDService.get().genLongId()));
                                map.put("Value", (String)invoiceTypeMap.get(v.get("Value")));
                                types.add(invoiceTypeNameMap.get(v.get("Value")));
                                baseDataIds.add(map);
                            });
                            s.put("BaseDataIds", baseDataIds);
                        }
                    });
                    conditionMap.put("FilterRow", simpleFilterRows);
                    e.set(conditionJsonFieldName, (Object)JsonUtil.toJson((Object)conditionMap));
                    if (CollectionUtils.isNotEmpty(types)) {
                        String[] filterConditions = e.getString(filterConditionFieldName).split(ResManager.loadKDString((String)"  \u5e76\u4e14      ", (String)"InvoiceTypeUpgradeService_4", (String)"taxc-tcvat", (Object[])new Object[0]));
                        ArrayList newFilterConditions = new ArrayList();
                        Arrays.asList(filterConditions).forEach(f -> {
                            if (f.contains(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b", (String)"InvoiceTypeUpgradeService_3", (String)"taxc-tcvat", (Object[])new Object[0]))) {
                                Object[] tempFilterConditions = f.split(" ");
                                tempFilterConditions[0] = ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u540d\u79f0", (String)"InvoiceTypeUpgradeService_5", (String)"taxc-tcvat", (Object[])new Object[0]);
                                tempFilterConditions[2] = String.join((CharSequence)";", types);
                                newFilterConditions.add(StringUtils.join((Object[])tempFilterConditions, (String)" "));
                            } else {
                                newFilterConditions.add(f);
                            }
                        });
                        if (CollectionUtils.isNotEmpty(newFilterConditions)) {
                            if (newFilterConditions.size() > 1) {
                                e.set(filterConditionFieldName, (Object)StringUtils.join((Object[])newFilterConditions.toArray(), (String)ResManager.loadKDString((String)"  \u5e76\u4e14      ", (String)"InvoiceTypeUpgradeService_4", (String)"taxc-tcvat", (Object[])new Object[0])));
                            } else {
                                e.set(filterConditionFieldName, newFilterConditions.toArray()[0]);
                            }
                        }
                    }
                }
            });
        }
        catch (Exception e2) {
            LOGGER.error("dealEntryData error", (Throwable)e2);
            return;
        }
    }

    private static Boolean metaIsExist(String entityName) {
        try {
            MetadataUtil.getEntityById((String)entityName);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Boolean.FALSE;
        }
    }
}

