/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.tcvat.common.util.UUID;

public class JzjtJxseHzDraftUpgradeService
extends AbstractUpgradeFormPlugin {
    private Log LOGGER = LogFactory.getLog(JzjtJxseHzDraftUpgradeService.class);
    private String TAXC = "taxc";
    private static final String TCVAT_DEDUCTION_SUMMARY = "tcvat_hz_deduction_sum";
    private static final String TCVAT_DEDUCTION_SUMMARY_SJJT = "tcvat_hz_deduction_sum_jt";
    public static final String TCVAT_DEDUCT_INPUT_AUTH = "tcvat_hz_deduct_inpu_au";
    private static final String T_TCVAT_DEDUCTION_SUMMARY = "t_tcvat_hz_deduction_sum";
    private static final String T_TCVAT_DEDUCTION_SUMMARY_SJJT = "t_tcvat_hz_deduct_sum_jt";
    private static final String T_TCVAT_JZJT_JXSE_SUMMARY = "t_tcvat_hz_jzjt_jxse_sum";
    private static final String T_TCVAT_JZJT_JXSE_SUMMARY_SJJT = "t_tcvat_hz_jzjt_jxse_sjjt";
    public static final String YBHZ_HZ_POLICY_CONFIRM = "tcvat_ybhz_policy_confirm";
    private static final Set<String> HZ_TAXPAYER_TYPE = Sets.newHashSet((Object[])new String[]{"zzsybnsr_yz_zjg", "zzsybnsr_ybhz", "zzsybnsr_hz_zjg"});
    private static final String DEDUCT_FIELDS = "org,startdate,enddate,taxpayertype,serialno,deductiontype,count,amount,taxamount,inputtaxamount,description";
    private static final String DEDUCT_FIELDS_JT = "org,startdate,enddate,taxpayertype,serialno,deductiontype,count,amount,taxamount,inputtaxamount,description,suborg,declaretype,levelname";
    private static final String QUERY_TIGHT_RANGE_DRAFT = "select distinct a.forgid  as forgid,a.fstartdate as fstartdate,a.fenddate  as fenddate,a.ftaxpayertype as ftaxpayertype from %s a left join %s b on a.forgid =b.forgid and a.ftaxpayertype =b.ftaxpayertype  and a.fstartdate =b.fstartdate and a.fenddate =b.fenddate  where b.fid is null and a.forgid > 0";
    private static final String QUERY_TIGHT_RANGE_DRAFT_JT = "select distinct a.forgid  as forgid,a.fstartdate as fstartdate,a.fenddate  as fenddate,a.ftaxpayertype as ftaxpayertype,a.fsuborgid as fsuborgid,a.fdeclaretype as fdeclaretype,a.flevelname as flevelname from %s a left join %s b on a.forgid =b.forgid and a.ftaxpayertype =b.ftaxpayertype  and a.fstartdate =b.fstartdate and a.fenddate =b.fenddate  where b.fid is null and a.forgid > 0";
    private static final String QUERY_JZJT_JXSE_DRAFT = "SELECT distinct forgid,fstartdate,fenddate,ftaxpayertype FROM %s WHERE forgid in (%s)";
    private static final String INSERTMAINTABLE_SQL = "INSERT INTO %s (fid,forgid,fserialno,fruleid,fstartdate,fenddate,ftaxpayertype,fsuborgid,fdeclaretype,flevelname,fbizname,fjzjtlx,finputtax,fjzjtamount,famountsum,fsplitrate,fjzjtjxtax,fcreaterid,fmodifierid) VALUES  (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\uff1a\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d\u6c47\u603b\u5e95\u7a3f\u5347\u7ea7\u5904\u7406\u6210\u529f\uff01", (String)"JzjtJxseHzDraftUpgradeService_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        try {
            this.LOGGER.info("\u5f00\u59cb\u6267\u884c\u589e\u503c\u7a0e\uff1a\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d\u5e95\u7a3f\u5347\u7ea7\u5904\u7406===>>>>>>");
            List<String> tables = Arrays.asList(T_TCVAT_DEDUCTION_SUMMARY, T_TCVAT_DEDUCTION_SUMMARY_SJJT, T_TCVAT_JZJT_JXSE_SUMMARY, T_TCVAT_JZJT_JXSE_SUMMARY_SJJT);
            for (String table : tables) {
                if (DB.exitsTable((DBRoute)DBRoute.of((String)this.TAXC), (String)table)) continue;
                result.setLog("Not exist table,no run process," + JsonUtil.toJson(tables));
                return result;
            }
            List<String> metas = Arrays.asList(TCVAT_DEDUCTION_SUMMARY, YBHZ_HZ_POLICY_CONFIRM, TCVAT_DEDUCT_INPUT_AUTH, TCVAT_DEDUCTION_SUMMARY_SJJT);
            for (String meta : metas) {
                if (this.metaIsExist(meta).booleanValue()) continue;
                this.LOGGER.info(">>>>>>\u5143\u6570\u636e\u4e0d\u5b58\u5728");
                result.setLog("Not exist metadata,no run process," + JsonUtil.toJson(metas));
                return result;
            }
            this.LOGGER.info(">>>>>>\u5f00\u59cb\u5347\u7ea7");
            this.update(T_TCVAT_JZJT_JXSE_SUMMARY, T_TCVAT_DEDUCTION_SUMMARY, TCVAT_DEDUCTION_SUMMARY);
            this.update(T_TCVAT_JZJT_JXSE_SUMMARY_SJJT, T_TCVAT_DEDUCTION_SUMMARY_SJJT, TCVAT_DEDUCTION_SUMMARY_SJJT);
        }
        catch (Exception e) {
            result.setLog(ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d\u6c47\u603b\u5e95\u7a3f\u5347\u7ea7\u5904\u7406\u5931\u8d25\uff01", (String)"JzjtJxseHzDraftUpgradeService_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.LOGGER.error("JzjtJxseHzDraftUpgradeService FAILURE", (Throwable)e);
            result.setSuccess(false);
            result.setErrorInfo(this.getStackTraceMessage(e));
        }
        return result;
    }

    private void update(String jzjtDraftTable, String deductionDraftTable, String deductionSummaryKey) {
        List<Map<String, Object>> range = deductionDraftTable.equals(T_TCVAT_DEDUCTION_SUMMARY_SJJT) ? JzjtJxseHzDraftUpgradeService.query("taxc", String.format(QUERY_TIGHT_RANGE_DRAFT_JT, deductionDraftTable, jzjtDraftTable)) : JzjtJxseHzDraftUpgradeService.query("taxc", String.format(QUERY_TIGHT_RANGE_DRAFT, deductionDraftTable, jzjtDraftTable));
        if (range.size() == 0) {
            return;
        }
        Map<Long, List<Map<String, Object>>> rangeGroup = range.stream().collect(Collectors.groupingBy(a -> (Long)a.get("FORGID")));
        ArrayList<Long> orgs = new ArrayList<Long>(rangeGroup.keySet());
        List partition = Lists.partition(orgs, (int)50);
        for (List orgPart : partition) {
            this.batchUpdate(orgPart, rangeGroup, jzjtDraftTable, deductionDraftTable, deductionSummaryKey);
        }
    }

    private void batchUpdate(List<Long> orgPart, Map<Long, List<Map<String, Object>>> rangeGroup, String jzjtDraftTable, String deductionDraftTable, String deductionSummaryKey) {
        QFilter[] filters;
        boolean isSjjt = deductionDraftTable.equals(T_TCVAT_DEDUCTION_SUMMARY_SJJT);
        String fileds = isSjjt ? DEDUCT_FIELDS_JT : DEDUCT_FIELDS;
        DynamicObjectCollection deductionDrafts = QueryServiceHelper.query((String)deductionSummaryKey, (String)fileds, (QFilter[])(filters = new QFilter[]{new QFilter("org", "in", orgPart), new QFilter("taxpayertype", "in", HZ_TAXPAYER_TYPE)}));
        if (deductionDrafts.size() == 0) {
            return;
        }
        Map<Object, Object> policyConfirmGroup = new HashMap();
        if (!isSjjt) {
            QFilter[] filters1 = new QFilter[]{new QFilter("orgid", "in", orgPart), new QFilter("draftpurpose", "=", (Object)"nssb")};
            DynamicObjectCollection policyConfirm = QueryServiceHelper.query((String)YBHZ_HZ_POLICY_CONFIRM, (String)"orgid,startdate,enddate,hzentryentity.assignorg assignorg,hzentryentity.levelname levelname", (QFilter[])filters1);
            policyConfirmGroup = policyConfirm.stream().collect(Collectors.groupingBy(a -> a.get("orgid") + "_" + DateUtils.format((Date)a.getDate("startdate"), (String)"yyyy-MM-dd") + "_" + DateUtils.format((Date)a.getDate("enddate"), (String)"yyyy-MM-dd")));
        }
        Map<String, List<DynamicObject>> deductionGroup = deductionDrafts.stream().collect(Collectors.groupingBy(a -> a.get("org") + "_" + DateUtils.format((Date)a.getDate("startdate"), (String)"yyyy-MM-dd") + "_" + DateUtils.format((Date)a.getDate("enddate"), (String)"yyyy-MM-dd") + "_" + a.get("taxpayertype")));
        String orgstr = orgPart.stream().map(a -> a.toString()).collect(Collectors.joining(","));
        List<Map<String, Object>> jzjtDgList = JzjtJxseHzDraftUpgradeService.query("taxc", String.format(QUERY_JZJT_JXSE_DRAFT, jzjtDraftTable, orgstr));
        Map<String, List<Map>> jzjtGroup = jzjtDgList.stream().collect(Collectors.groupingBy(a -> a.get("FORGID") + "_" + DateUtils.format((Date)((Date)a.get("FSTARTDATE")), (String)"yyyy-MM-dd") + "_" + DateUtils.format((Date)((Date)a.get("FENDDATE")), (String)"yyyy-MM-dd") + "_" + a.get("FTAXPAYERTYPE")));
        ArrayList<Object[]> paramList0 = new ArrayList<Object[]>(256);
        for (Map.Entry<String, List<DynamicObject>> entry : deductionGroup.entrySet()) {
            List<DynamicObject> jxdkDrafts;
            BigDecimal inputtaxamountSum;
            String key = entry.getKey();
            if (jzjtGroup.containsKey(key) || (inputtaxamountSum = (jxdkDrafts = entry.getValue()).stream().map(a -> a.getBigDecimal("inputtaxamount").setScale(2, RoundingMode.HALF_UP)).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(BigDecimal.ZERO) == 0) continue;
            if (isSjjt) {
                Map<Object, List<DynamicObject>> suborgGroup = jxdkDrafts.stream().collect(Collectors.groupingBy(a -> a.get("suborg")));
                BigDecimal inputtaxamountSumTemp = BigDecimal.ZERO;
                int i = 0;
                for (Map.Entry<Object, List<DynamicObject>> suborgEntry : suborgGroup.entrySet()) {
                    List<DynamicObject> value = suborgEntry.getValue();
                    BigDecimal inputtaxamountSumSub = value.stream().map(a -> a.getBigDecimal("inputtaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
                    inputtaxamountSumTemp = inputtaxamountSumTemp.add(inputtaxamountSumSub);
                    DynamicObjectCollection detailDatas = this.queryDkDetail(value);
                    this.buildParams(jzjtDraftTable, deductionDraftTable, paramList0, value, (List<DynamicObject>)detailDatas, inputtaxamountSumSub, null);
                    if (i + 1 == suborgGroup.size()) {
                        BigDecimal difference = inputtaxamountSum.subtract(inputtaxamountSumTemp);
                        Object[] objects = (Object[])paramList0.get(paramList0.size() - 1);
                        objects[12] = difference.add((BigDecimal)objects[12]);
                        objects[16] = difference.add((BigDecimal)objects[16]);
                    }
                    ++i;
                }
                continue;
            }
            Object org = jxdkDrafts.get(0).get("org");
            Date startdate = jxdkDrafts.get(0).getDate("startdate");
            Date enddate = jxdkDrafts.get(0).getDate("enddate");
            String pcKey = org + "_" + DateUtils.format((Date)startdate, (String)"yyyy-MM-dd") + "_" + DateUtils.format((Date)enddate, (String)"yyyy-MM-dd");
            List policyRs = policyConfirmGroup.getOrDefault(pcKey, new ArrayList());
            Map<String, String> orgToLeveMap = policyRs.stream().collect(Collectors.toMap(k -> k.get("assignorg").toString(), v -> v.getString("levelname"), (k1, k2) -> k1));
            DynamicObjectCollection detailDatas = this.queryDkDetail(jxdkDrafts);
            Map<Object, List<DynamicObject>> detailGroup = detailDatas.stream().collect(Collectors.groupingBy(a -> a.get("suborg")));
            BigDecimal preInputtaxamountSum = BigDecimal.ZERO;
            for (Map.Entry<Object, List<DynamicObject>> suborgEntry : detailGroup.entrySet()) {
                String suborg = suborgEntry.getKey().toString();
                String level = orgToLeveMap.get(suborg);
                List<DynamicObject> details = suborgEntry.getValue();
                BigDecimal bigDecimal = this.buildParams(jzjtDraftTable, deductionDraftTable, paramList0, jxdkDrafts, details, inputtaxamountSum, level);
                preInputtaxamountSum = preInputtaxamountSum.add(bigDecimal);
            }
            this.buildAdjRecordParams(jzjtDraftTable, deductionDraftTable, paramList0, jxdkDrafts, inputtaxamountSum, preInputtaxamountSum);
        }
        try (TXHandle h = TX.requiresNew((String)"JzjtJxseHzDraftUpgradeService");){
            try {
                if (EmptyCheckUtils.isNotEmpty(paramList0)) {
                    String sql = String.format(INSERTMAINTABLE_SQL, jzjtDraftTable);
                    DBUtils.executeBatch((String)"taxc", (String)sql, paramList0);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                this.LOGGER.error("save error", e);
                throw e;
            }
        }
    }

    private BigDecimal buildParams(String jzjtDraftTable, String deductionDraftTable, List<Object[]> paramList0, List<DynamicObject> jxdkDrafts, List<DynamicObject> detailDatas, BigDecimal inputtaxamountSum, String level) {
        String jzjtBizname = ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u7684\u8fdb\u9879\u7a0e\u989d", (String)"JzjtJxseHzDraftUpgradeService_2", (String)"taxc-tcvat", (Object[])new Object[0]);
        String wfhfBizname = ResManager.loadKDString((String)"\u65e0\u6cd5\u5212\u5206\u7684\u8fdb\u9879\u7a0e\u989d", (String)"JzjtJxseHzDraftUpgradeService_3", (String)"taxc-tcvat", (Object[])new Object[0]);
        String sgtzBizname = ResManager.loadKDString((String)"\u624b\u5de5\u8c03\u6574", (String)"JzjtJxseHzDraftUpgradeService_4", (String)"taxc-tcvat", (Object[])new Object[0]);
        BigDecimal wfhfJxse = BigDecimal.ZERO;
        BigDecimal wfhfJzjtJxse = BigDecimal.ZERO;
        BigDecimal jzjtJzjtJxse = BigDecimal.ZERO;
        DynamicObject wfhfOne = null;
        for (DynamicObject detailData : detailDatas) {
            String consumertype = detailData.getString("consumertype");
            if ("5".equals(consumertype)) {
                wfhfJxse = wfhfJxse.add(detailData.getBigDecimal("currentsigntaxamount"));
                wfhfJzjtJxse = wfhfJzjtJxse.add(detailData.getBigDecimal("jzjsjxse"));
                wfhfOne = detailData;
                continue;
            }
            if (!"4".equals(consumertype)) continue;
            jzjtJzjtJxse = jzjtJzjtJxse.add(detailData.getBigDecimal("jzjsjxse"));
        }
        wfhfJzjtJxse = wfhfJzjtJxse.setScale(2, RoundingMode.HALF_UP);
        jzjtJzjtJxse = jzjtJzjtJxse.setScale(2, RoundingMode.HALF_UP);
        long[] ids = DB.genLongIds((String)jzjtDraftTable, (int)3);
        Object org = jxdkDrafts.get(0).get("org");
        Object startdate = jxdkDrafts.get(0).get("startdate");
        Object enddate = jxdkDrafts.get(0).get("enddate");
        Object taxpayertype = jxdkDrafts.get(0).get("taxpayertype");
        BigDecimal jzjtxse = wfhfOne != null ? wfhfOne.getBigDecimal("jzjtxse") : BigDecimal.ZERO;
        BigDecimal xsehe = wfhfOne != null ? wfhfOne.getBigDecimal("xsehe") : BigDecimal.ZERO;
        BigDecimal hfbl = wfhfOne != null ? wfhfOne.getBigDecimal("hfbl") : BigDecimal.ZERO;
        String uuid = UUID.randomUUID();
        String uuid1 = UUID.randomUUID();
        String uuid2 = UUID.randomUUID();
        Object suborg = org;
        Object declaretype = "";
        Object levelname = "";
        boolean isSjjt = deductionDraftTable.equals(T_TCVAT_DEDUCTION_SUMMARY_SJJT);
        if (isSjjt) {
            suborg = jxdkDrafts.get(0).get("suborg");
            declaretype = jxdkDrafts.get(0).get("declaretype");
            levelname = jxdkDrafts.get(0).get("levelname");
        } else {
            if (detailDatas.size() > 0) {
                suborg = detailDatas.get(0).get("suborg");
                declaretype = Objects.equals(suborg, org) ? "2" : "1";
                levelname = "2".equals(declaretype) ? "1" : "2";
            }
            levelname = level == null ? levelname : level;
        }
        paramList0.add(new Object[]{ids[0], org, uuid, 0L, startdate, enddate, taxpayertype, suborg, declaretype, levelname, jzjtBizname, "jzjt", jzjtJzjtJxse, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, jzjtJzjtJxse, 0L, 0L});
        paramList0.add(new Object[]{ids[1], org, uuid1, 0L, startdate, enddate, taxpayertype, suborg, declaretype, levelname, wfhfBizname, "wfhf", wfhfJxse, jzjtxse, xsehe, hfbl, wfhfJzjtJxse, 0L, 0L});
        if (isSjjt) {
            BigDecimal adjAmount = inputtaxamountSum.subtract(wfhfJzjtJxse).subtract(jzjtJzjtJxse);
            paramList0.add(new Object[]{ids[2], org, uuid2, 0L, startdate, enddate, taxpayertype, suborg, declaretype, levelname, sgtzBizname, "jzjt", adjAmount, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, adjAmount, 0L, 0L});
        }
        return wfhfJzjtJxse.add(jzjtJzjtJxse);
    }

    private void buildAdjRecordParams(String jzjtDraftTable, String deductionDraftTable, List<Object[]> paramList0, List<DynamicObject> jxdkDrafts, BigDecimal inputtaxamountSum, BigDecimal preInputtaxamountSum) {
        String sgtzBizname = ResManager.loadKDString((String)"\u624b\u5de5\u8c03\u6574", (String)"JzjtJxseHzDraftUpgradeService_4", (String)"taxc-tcvat", (Object[])new Object[0]);
        boolean isSjjt = deductionDraftTable.equals(T_TCVAT_DEDUCTION_SUMMARY_SJJT);
        if (!isSjjt) {
            BigDecimal adjAmount = inputtaxamountSum.subtract(preInputtaxamountSum).setScale(2, RoundingMode.HALF_UP);
            long[] ids = DB.genLongIds((String)jzjtDraftTable, (int)3);
            Object org = jxdkDrafts.get(0).get("org");
            Object startdate = jxdkDrafts.get(0).get("startdate");
            Object enddate = jxdkDrafts.get(0).get("enddate");
            Object taxpayertype = jxdkDrafts.get(0).get("taxpayertype");
            String uuid2 = UUID.randomUUID();
            Object suborg = org;
            String declaretype = "2";
            String levelname = "1";
            paramList0.add(new Object[]{ids[2], org, uuid2, 0L, startdate, enddate, taxpayertype, suborg, declaretype, levelname, sgtzBizname, "jzjt", adjAmount, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, adjAmount, 0L, 0L});
        }
    }

    private DynamicObjectCollection queryDkDetail(List<DynamicObject> jxdkDrafts) {
        Set serialno = jxdkDrafts.stream().map(a -> a.getString("serialno")).collect(Collectors.toSet());
        return QueryServiceHelper.query((String)TCVAT_DEDUCT_INPUT_AUTH, (String)"org,suborg,type,startdate,enddate,consumertype,currentsigntaxamount,jzjtxse,jzjsjxse,xsehe,hfbl", (QFilter[])new QFilter[]{new QFilter("taxaccountserialno", "in", serialno)});
    }

    public static List<Map<String, Object>> query(String dbKey, String sql) {
        ArrayList<Map<String, Object>> list = new ArrayList(10);
        try (TXHandle h = TX.required();){
            try {
                list = (List)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)sql, rs -> {
                    ArrayList list1 = new ArrayList(16);
                    while (rs.next()) {
                        HashMap<String, Object> hm = new HashMap<String, Object>();
                        hm.put("FORGID", rs.getLong("FORGID"));
                        hm.put("FSTARTDATE", rs.getDate("FSTARTDATE"));
                        hm.put("FENDDATE", rs.getDate("FENDDATE"));
                        hm.put("FTAXPAYERTYPE", rs.getString("FTAXPAYERTYPE"));
                        list1.add(hm);
                    }
                    return list1;
                });
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
        return list;
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return this.LOGGER;
    }
}

