/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.control.Button;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class NcpAndHyncpmcUpgradeDataService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(NcpAndHyncpmcUpgradeDataService.class);
    private static final String RESET = "reset";
    private static final String TAXC = "taxc";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{RESET});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button source = (Button)evt.getSource();
        if (Objects.equals(RESET, source.getKey())) {
            DBUtils.execute((String)"delete from t_tcvat_ncp_declare_name where fnumber like 'CPMC%' or fnumber like 'HYCP%';");
            DBUtils.execute((String)"delete from t_tcvat_ncp_declare_name_l where fid in (select fid from t_tcvat_ncp_declare_name where fnumber like 'CPMC%' or fnumber like 'HYCP%');");
        }
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        try {
            LOGGER.info("\u5f00\u59cb\u6267\u884c\u519c\u4ea7\u54c1\u540d\u79f0\u5347\u7ea7===>>>>>>");
            if (!DB.exitsTable((DBRoute)DBRoute.of((String)TAXC), (String)"t_tcvat_ncp_declare_name")) {
                result.setLog(ResManager.loadKDString((String)"\u8868\u8fd8\u672a\u751f\u6210\uff01", (String)"NcpAndHyncpmcUpgradeDataService_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                result.setSuccess(true);
                return result;
            }
            this.updateData();
        }
        catch (Exception e) {
            result.setLog(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u5931\u8d25\uff01%s", (String)"NcpAndHyncpmcUpgradeDataService_1", (String)"taxc-tcvat", (Object[])new Object[0]), e));
            LOGGER.error("ncpmc FAILURE", (Throwable)e);
        }
        return result;
    }

    private void updateData() {
        String existsSql = "select fid from t_tcvat_ncp_declare_name where fnumber like 'CPMC%' or fnumber like 'HYCP%';";
        List existsList = DBUtils.query((String)existsSql);
        if (existsList.size() > 0) {
            return;
        }
        String assistSql = "select fentryid,fvalue,fid from  t_tpo_tcvat_assistentry where fid in (1639737114872632320,1639737498240406528);";
        List assistDataList = DBUtils.query((String)assistSql);
        if (CollectionUtils.isNotEmpty((Collection)assistDataList)) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(assistDataList.size());
            ArrayList<Object[]> paramsL = new ArrayList<Object[]>(assistDataList.size());
            int cpmcNumber = 1;
            int hycpNumber = 1;
            int languageIdIndex = 0;
            long[] idsL = DBUtils.getLongIds((String)"t_tcvat_ncp_declare_name", (int)assistDataList.size());
            Date startDate = DateUtils.stringToDate2((String)"2000-01-01");
            for (Map stringObjectMap : assistDataList) {
                String number = null;
                String nameType = null;
                if ("1639737114872632320".equals(String.valueOf(stringObjectMap.get("FID")))) {
                    number = String.format("CPMC-%03d", cpmcNumber);
                    ++cpmcNumber;
                    nameType = "cpmc";
                }
                if ("1639737498240406528".equals(String.valueOf(stringObjectMap.get("FID")))) {
                    number = String.format("HYCP-%03d", hycpNumber);
                    nameType = "hyncmpc";
                    ++hycpNumber;
                }
                if (null == nameType) continue;
                Object[] param = new Object[]{stringObjectMap.get("FENTRYID"), number, stringObjectMap.get("FVALUE"), 0L, "A", "1", startDate, stringObjectMap.get("FENTRYID"), nameType};
                params.add(param);
                Object[] paraml = new Object[]{idsL[languageIdIndex], stringObjectMap.get("FENTRYID"), "zh_CN", stringObjectMap.get("FVALUE")};
                ++languageIdIndex;
                paramsL.add(paraml);
            }
            String insert = "INSERT INTO t_tcvat_ncp_declare_name (fid,fnumber,fname,forgid,fstatus,fenable,fstartdate,fmasterid,fnametype) VALUES (?,?,?,?,?,?,?,?,?);";
            DBUtils.executeBatch((String)insert, params);
            String insertL = "INSERT INTO t_tcvat_ncp_declare_name_l (fpkid,fid,flocaleid,fname) VALUES (?,?,?,?);";
            DBUtils.executeBatch((String)insertL, paramsL);
        }
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }
}

