/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;

public class PartialPrepayRuleUpgradeService
implements IUpgradeService {
    private static Log LOGGER = LogFactory.getLog(PartialPrepayRuleUpgradeService.class);
    private Map<String, String> projectTypeMap = new HashMap<String, String>(){
        {
            this.put("1758774247469373440", ResManager.loadKDString((String)"\u5efa\u7b51\u670d\u52a1\u9884\u7f34\u7a0e\u6b3e#\u5efa\u7bc9\u670d\u52d9\u9810\u7e73\u7a05\u6b3e", (String)"PartialPrepayRuleUpgradeService_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("1758774247469373441", ResManager.loadKDString((String)"\u9500\u552e\u4e0d\u52a8\u4ea7\u9884\u7f34\u7a0e\u6b3e#\u92b7\u552e\u4e0d\u52d5\u7522\u9810\u7e73\u7a05\u6b3e", (String)"PartialPrepayRuleUpgradeService_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("1758774247469373442", ResManager.loadKDString((String)"\u51fa\u79df\u4e0d\u52a8\u4ea7\u9884\u7f34\u7a0e\u6b3e#\u51fa\u79df\u4e0d\u52d5\u7522\u9810\u7e73\u7a05\u6b3e", (String)"PartialPrepayRuleUpgradeService_2", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    };

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        StringBuilder message = new StringBuilder("PartialPrepayRule update start\n");
        long l = System.currentTimeMillis();
        try {
            this.partialPrepayRuleUpdate(message);
            message.append("\nPartialPrepayRule update complete ").append(System.currentTimeMillis() - l).append("ms");
        }
        catch (Exception e) {
            message.append(e.getStackTrace()).append(System.currentTimeMillis() - l).append("ms");
        }
        result.setLog(message.toString());
        return result;
    }

    public void partialPrepayRuleUpdate(StringBuilder message) {
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_rule_perpre") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tctb_tax_main")) {
            List<Map<String, String>> OrgSumList = this.getNsrxxMap();
            this.executeUpdate(message, OrgSumList);
        }
    }

    private void executeUpdate(StringBuilder message, List<Map<String, String>> OrgSumList) {
        String exists = "select fid from t_tcvat_rule_perpre where  fissystem = '1' and forgid != 100000";
        List DeductRuleList = DBUtils.query((String)exists);
        if (!DeductRuleList.isEmpty()) {
            message.append("The system rule already exists and does not need to be upgraded \n");
            return;
        }
        if (OrgSumList.size() == 0) {
            message.append("orgList is empty, does not need to be upgraded \n");
            return;
        }
        long[] fidArray = DB.genLongIds((String)"t_tcvat_rule_perpre", (int)(OrgSumList.size() * 3));
        String[] batchRuleNumber = this.generateBatchRuleNumber("tcvat_rule_perpre", String.valueOf(OrgSumList.get(0).get("FORGID")), fidArray.length);
        if (null == batchRuleNumber) {
            message.append("RuleNumber generate failed, upgraded fail \n");
            return;
        }
        ArrayList<Object[]> mainTableParamList = new ArrayList<Object[]>(OrgSumList.size() * 3);
        ArrayList<Object[]> mainTable_LparamList = new ArrayList<Object[]>(OrgSumList.size() * 2);
        ArrayList<Object[]> amountRuleparamList = new ArrayList<Object[]>(OrgSumList.size() * 3);
        String mainTable = "INSERT INTO t_tcvat_rule_perpre (fid, fnumber, fname, fstatus, fcreatorid, fmodifierid, fenable, fcreatetime, fmodifytime, fmasterid, fruletype, forgid, frulepurpose, fperpreproduct, ftaxpayertype, fissystem) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        String mainTable_L = "INSERT INTO t_tcvat_rule_perpre_l (FID,FPKID,FLOCALEID,FNAME) VALUES (?,?,?,?)";
        String amountRuleEntrty = "INSERT INTO t_tcvat_perpre_bqfse (fid, fentryid, fseq, fdatadirection, fbizname, fdatatype, ffconditionjson, ffiltercondition, famountfield, ftable, fabsolute) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
        int index = 0;
        for (int i = 0; i < OrgSumList.size(); ++i) {
            Map<String, String> selectFieldMap = OrgSumList.get(i);
            for (Map.Entry<String, String> entry : this.projectTypeMap.entrySet()) {
                long fid = fidArray[index];
                String fnumber = batchRuleNumber[index];
                mainTableParamList.add(new Object[]{fid, fnumber, " ", "A", 13466739L, 13466739L, "1", new Date(), new Date(), fid, "private", Long.valueOf(selectFieldMap.get("FORGID")), ",nssb,", Long.valueOf(entry.getKey()), "ybnsr", "1"});
                long[] fpkid = DBUtils.getLongIds((String)"t_tcvat_rule_perpre", (int)2);
                String[] nameArray = entry.getValue().split("#");
                mainTable_LparamList.add(new Object[]{fid, String.valueOf(fpkid[0]), "zh_CN", nameArray[0]});
                mainTable_LparamList.add(new Object[]{fid, String.valueOf(fpkid[1]), "zh_TW", nameArray[1]});
                long amountRulepkid = DBUtils.getLongId((String)"t_tcvat_rule_perpre");
                amountRuleparamList.add(new Object[]{fid, amountRulepkid, 1, "positive", nameArray[0], "zjqs", "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3R6OG30QM/TK\"}],\"CompareType\":\"105\",\"Id\":\"3R6OG30QO+JT\",\"Logic\":\"0\",\"FieldName\":\"taxtypes\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"3R6OG30QM/TL\"}],\"CompareType\":\"105\",\"Id\":\"3R6OG30QO+JU\",\"Logic\":\"0\",\"FieldName\":\"paystatus\"}]}", ResManager.loadKDString((String)"\u7a0e\u79cd \u7b49\u4e8e \u589e\u503c\u7a0e  \u5e76\u4e14            \u7f34\u6b3e\u72b6\u6001 \u7b49\u4e8e \u25cf \u5df2\u7f34\u6b3e  ", (String)"PartialPerpayRulePlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]), 1650823470306648091L, 1650823470264705024L, "0"});
                ++index;
            }
        }
        try (TXHandle h = TX.required();){
            try {
                if (mainTableParamList.size() > 0) {
                    DBUtils.executeBatch((String)mainTable, mainTableParamList);
                }
                if (mainTable_LparamList.size() > 0) {
                    DBUtils.executeBatch((String)mainTable_L, mainTable_LparamList);
                }
                if (amountRuleparamList.size() > 0) {
                    DBUtils.executeBatch((String)amountRuleEntrty, amountRuleparamList);
                }
                message.append("PartialPrepayRule SUCCESS").append('\n');
            }
            catch (Throwable t) {
                h.markRollback();
                message.append("PartialPrepayRule FAILD:").append(t).append('\n');
                LOGGER.info("PartialPrepayRule FAILURE", (Object)t);
            }
        }
    }

    private List<Map<String, String>> getNsrxxMap() {
        String orgSql = "select forgid from t_tctb_tax_main";
        DataSet OrgList = DB.queryDataSet((String)"TaxCategoryUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)orgSql);
        ArrayList<Map<String, String>> OrgSumList = new ArrayList<Map<String, String>>(500);
        while (OrgList.hasNext()) {
            HashMap<String, String> map = new HashMap<String, String>(8);
            Row row = OrgList.next();
            map.put("FORGID", row.getString("FORGID"));
            OrgSumList.add(map);
        }
        OrgList.close();
        return OrgSumList;
    }

    protected String[] generateBatchRuleNumber(String entityName, String orgid, int count) {
        if (!this.metaIsExist(entityName).booleanValue()) {
            return null;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        CodeRuleServiceHelper.getNumber((String)entityName, (DynamicObject)dynamicObject, (String)orgid);
        return CodeRuleServiceHelper.getBatchNumber((String)entityName, (DynamicObject)dynamicObject, (String)orgid, (int)count);
    }

    protected Boolean metaIsExist(String entityName) {
        try {
            MetadataUtil.getEntityById((String)entityName);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Boolean.FALSE;
        }
    }
}

