/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;

public class PrepayInvoiceDeductUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(PrepayInvoiceDeductUpgradeService.class);

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        if (!(DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_rim_invoice") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_rim_inv_ordinary") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_rim_inv_special") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_rim_inv_electric"))) {
            LOGGER.error("table not exists");
            return;
        }
        String sql1 = "update t_rim_inv_ordinary s set favail_deduct=ftotal_amount, fremain_deduct=ftotal_amount where ftotal_deduct=0 and fremain_deduct=0 and exists (select m.fserial_no from t_rim_invoice m where m.fserial_no=s.fserial_no and m.fproject!=0)";
        String sql2 = "update t_rim_inv_special s set favail_deduct=ftotal_amount, fremain_deduct=ftotal_amount where ftotal_deduct=0 and fremain_deduct=0 and exists (select m.fserial_no from t_rim_invoice m where m.fserial_no=s.fserial_no and m.fproject!=0)";
        String sql3 = "update t_rim_inv_electric s set favail_deduct=ftotal_amount, fremain_deduct=ftotal_amount where ftotal_deduct=0 and fremain_deduct=0 and exists (select m.fserial_no from t_rim_invoice m where m.fserial_no=s.fserial_no and m.fproject!=0)";
        DB.execute((DBRoute)DBRoute.of((String)"taxc"), (String)sql1);
        DB.execute((DBRoute)DBRoute.of((String)"taxc"), (String)sql2);
        DB.execute((DBRoute)DBRoute.of((String)"taxc"), (String)sql3);
    }
}

