/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class ProjectInfoUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(ProjectInfoUpgradeService.class);
    private static final String SUCCESS_INFO = ProjectInfoUpgradeService.getMsgA();
    private static final String ERROR_INFO = ProjectInfoUpgradeService.getMsgB();
    private static final String BD_PROJECT = "bd_project";
    private static final String BD_PROJECTKIND = "bd_projectkind";
    private static final String T_BD_PROJECT = "t_bd_project";
    private static final String T_BD_PROJECT_U_INSERT = "INSERT INTO t_bd_project_u (fdataid,fcreateorgid,fuseorgid) VALUES(?,NULL,?);";
    private static final String PREPAY_PROJECT_L_UPDATE = "update t_tcvat_prepay_project_l set fname=?  where fid = ? and flocaleid = ?;";
    private static final String PREPAY_PROJECT_UPDATE = "update t_tcvat_prepay_project set fbaseproject=?  where fid = ?;";
    private static final String QUERY_PRE_PROJECT = "select fid,fnumber,fbaseproject,faddress,forg from t_tcvat_prepay_project where fbaseproject = 0 or fbaseproject is null";
    private static final String QUERY_PROJECT_LANGUAGE = "select b.fid,b.fpkid,b.flocaleid,b.fname from t_tcvat_prepay_project a left join t_tcvat_prepay_project_l b on a.fid=b.fid  where a.fbaseproject = 0 or a.fbaseproject is null";
    private static String kindid = "1199996127005427712";
    private static final String QUERY_PROJECT_KIND = "select a.fid,b.fname,b.flocaleid from t_bd_projectkind a left join t_bd_projectkind_l b on a.fid=b.fid  where a.fid=" + kindid + " ";
    private static final String QUERY_BD_PROJECT = "select a.fid,a.fnumber,b.fname,b.ffullname,b.fproaddress,b.flocaleid from t_bd_project a left join t_bd_project_l b on a.fid = b.fid";

    private static String getYjxm() {
        return ResManager.loadKDString((String)"\u9884\u7f34\u9879\u76ee", (String)"ProjectInfoUpgradeService_0", (String)"taxc-tcvat", (Object[])new Object[0]);
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        for (String number : Arrays.asList(BD_PROJECT, BD_PROJECTKIND)) {
            Boolean isExist = this.metaIsExist(number);
            if (isExist.booleanValue()) continue;
            this.addLog(ERROR, String.format("The %s is not exist!", number));
            return;
        }
        this.addLog(INFO, QUERY_PRE_PROJECT);
        long l = System.currentTimeMillis();
        List preProjects = DBUtils.query((String)QUERY_PRE_PROJECT);
        long l1 = System.currentTimeMillis();
        this.addLog(INFO, String.format("The result size is %d, use time %d", preProjects.size(), l1 - l));
        if (EmptyCheckUtils.isNotEmpty((Object)preProjects)) {
            this.addLog(INFO, QUERY_PROJECT_LANGUAGE);
            List preProjectNames = DBUtils.query((String)QUERY_PROJECT_LANGUAGE);
            long l11 = System.currentTimeMillis();
            this.addLog(INFO, String.format("The result size is %d, use time %d", preProjectNames.size(), l11 - l));
            this.addLog(INFO, QUERY_BD_PROJECT);
            List bdProjects = DBUtils.query((String)"sys", (String)QUERY_BD_PROJECT);
            long l2 = System.currentTimeMillis();
            this.addLog(INFO, String.format("The result size is %d, use time %d", bdProjects.size(), l2 - l11));
            this.addLog(INFO, QUERY_PROJECT_KIND);
            List bdProjectKind = DBUtils.query((String)"sys", (String)QUERY_PROJECT_KIND);
            long l3 = System.currentTimeMillis();
            this.addLog(INFO, String.format("The result size is %d, use time %d", bdProjectKind.size(), l3 - l2));
            Long projectKindId = Long.valueOf(kindid);
            DynamicObject object = null;
            if (EmptyCheckUtils.isNotEmpty((Object)bdProjectKind)) {
                this.addLog(INFO, String.format("Exist t_bd_projectkind record,id is %d", projectKindId));
            } else {
                this.addLog(INFO, String.format("Not exist t_bd_projectkind record,create id %d", projectKindId));
                object = this.buildProjectKind(projectKindId);
            }
            Map<Object, List<Map>> preProjectNamesGroup = preProjectNames.stream().collect(Collectors.groupingBy(a -> a.get("FID")));
            Map<Object, List<Map>> bdProjectsGroup = bdProjects.stream().collect(Collectors.groupingBy(a -> a.get("FNUMBER")));
            long l33 = System.currentTimeMillis();
            List bdprojectids = bdProjects.stream().map(a -> a.get("FID")).collect(Collectors.toList());
            this.addLog(INFO, "BusinessDataServiceHelper load bd_project");
            DynamicObject[] bd_projects = BusinessDataServiceHelper.load((Object[])bdprojectids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)BD_PROJECT));
            this.addLog(INFO, String.format("The result size is %d, use time %d", bd_projects.length, System.currentTimeMillis() - l33));
            Map<Object, List<DynamicObject>> bdprojectidsGroup = Arrays.stream(bd_projects).collect(Collectors.groupingBy(a -> a.get("id")));
            ArrayList<Object[]> langParamsList = new ArrayList<Object[]>(preProjects.size() * 2);
            ArrayList<Object[]> project_uList = new ArrayList<Object[]>(preProjects.size());
            ArrayList<Object[]> preProjectUpdateList = new ArrayList<Object[]>(preProjects.size());
            ArrayList<DynamicObject> bdProjectList = new ArrayList<DynamicObject>(preProjects.size());
            ArrayList<DynamicObject> bdProjectUpdateList = new ArrayList<DynamicObject>(preProjects.size());
            for (Map preProject : preProjects) {
                Long bdProjectId;
                Object fnumber = preProject.get("FNUMBER");
                Object fid = preProject.get("FID");
                Object faddress = preProject.get("FADDRESS");
                List<Map> list = bdProjectsGroup.get(fnumber);
                if (EmptyCheckUtils.isNotEmpty(list)) {
                    bdProjectId = (Long)list.get(0).get("FID");
                    Map<Object, List<Map>> localMap = list.stream().collect(Collectors.groupingBy(a -> a.get("FLOCALEID")));
                    for (Map.Entry<Object, List<Map>> entry : localMap.entrySet()) {
                        Object localId = entry.getKey();
                        Object fname = entry.getValue().get(0).get("FNAME");
                        langParamsList.add(new Object[]{fname, fid, localId});
                    }
                    List<DynamicObject> projectList = bdprojectidsGroup.get(bdProjectId);
                    if (EmptyCheckUtils.isNotEmpty(projectList)) {
                        projectList.get(0).set("proaddress", faddress);
                        bdProjectUpdateList.add(projectList.get(0));
                    }
                } else {
                    bdProjectId = DBUtils.getLongId((String)T_BD_PROJECT);
                    DynamicObject bdProject = this.buildBdProject(bdProjectId, projectKindId, preProject, preProjectNamesGroup.get(fid));
                    bdProjectList.add(bdProject);
                    project_uList.add(new Object[]{bdProjectId, preProject.get("FORG")});
                }
                preProjectUpdateList.add(new Object[]{bdProjectId, fid});
            }
            try (TXHandle h = TX.requiresNew();){
                try {
                    if (object != null) {
                        long l4 = System.currentTimeMillis();
                        this.addLog(INFO, String.format("Start save ProjectKind size is %d", 1));
                        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
                        long lx = System.currentTimeMillis();
                        this.addLog(INFO, String.format("Save ProjectKind use time %d", lx - l4));
                    }
                    if (EmptyCheckUtils.isNotEmpty(bdProjectList)) {
                        long l4 = System.currentTimeMillis();
                        this.addLog(INFO, String.format("Start save BdProject size is %d", bdProjectList.size()));
                        Object[] save1 = SaveServiceHelper.save((DynamicObject[])bdProjectList.toArray(new DynamicObject[bdProjectList.size()]));
                        long lx = System.currentTimeMillis();
                        this.addLog(INFO, String.format("Save BdProject use time %d", lx - l4));
                    }
                    if (EmptyCheckUtils.isNotEmpty(project_uList)) {
                        long l4 = System.currentTimeMillis();
                        this.addLog(INFO, String.format("Start Update BdProject_U size is %d", project_uList.size()));
                        DBUtils.executeBatch((String)"sys", (String)T_BD_PROJECT_U_INSERT, project_uList);
                        long lx = System.currentTimeMillis();
                        this.addLog(INFO, String.format("Update BdProject_U use time %d", lx - l4));
                    }
                    if (EmptyCheckUtils.isNotEmpty(bdProjectUpdateList)) {
                        long l4 = System.currentTimeMillis();
                        this.addLog(INFO, String.format("Start Update BdProject's proaddress  size is %d", bdProjectUpdateList.size()));
                        SaveServiceHelper.save((DynamicObject[])bdProjectUpdateList.toArray(new DynamicObject[bdProjectUpdateList.size()]));
                        long lx = System.currentTimeMillis();
                        this.addLog(INFO, String.format("Update BdProject's proaddress use time %d", lx - l4));
                    }
                }
                catch (Throwable t) {
                    h.markRollback();
                    LOGGER.error(ERROR_INFO, t);
                    throw new RuntimeException(t);
                }
            }
            h = TX.requiresNew();
            var30_26 = null;
            try {
                try {
                    if (EmptyCheckUtils.isNotEmpty(langParamsList)) {
                        long l4 = System.currentTimeMillis();
                        this.addLog(INFO, String.format("Start Update PreProjectLanguage size is %d", langParamsList.size()));
                        DBUtils.executeBatch((String)PREPAY_PROJECT_L_UPDATE, langParamsList);
                        long lx = System.currentTimeMillis();
                        this.addLog(INFO, String.format("Update PreProjectLanguage use time %d", lx - l4));
                    }
                    if (EmptyCheckUtils.isNotEmpty(preProjectUpdateList)) {
                        long l4 = System.currentTimeMillis();
                        this.addLog(INFO, String.format("Start Update PreProject size is %d", preProjectUpdateList.size()));
                        DBUtils.executeBatch((String)PREPAY_PROJECT_UPDATE, preProjectUpdateList);
                        long lx = System.currentTimeMillis();
                        this.addLog(INFO, String.format("Update PreProject use time %d", lx - l4));
                    }
                }
                catch (Throwable t) {
                    h.markRollback();
                    LOGGER.error(ERROR_INFO, t);
                    throw new RuntimeException(t);
                }
            }
            catch (Throwable throwable) {
                var30_26 = throwable;
                throw throwable;
            }
            finally {
                if (h != null) {
                    if (var30_26 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var30_26.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
    }

    private DynamicObject buildBdProject(Long bdProjectId, Long projectKindId, Map<String, Object> preProject, List<Map<String, Object>> maps) {
        Optional<Map> first;
        String name_zh_CN = " ";
        if (EmptyCheckUtils.isNotEmpty(maps) && (first = maps.stream().filter(a -> Objects.equals(a.get("FLOCALEID"), "zh_CN")).findFirst()).isPresent()) {
            name_zh_CN = (String)first.get().get("FNAME");
        }
        DynamicObject object = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)BD_PROJECT));
        object.set("id", (Object)bdProjectId);
        object.set("masterid", (Object)bdProjectId);
        object.set("name", (Object)name_zh_CN);
        object.set("fullname", (Object)name_zh_CN);
        object.set("number", preProject.get("FNUMBER"));
        object.set("longnumber", preProject.get("FNUMBER"));
        object.set("createorg", preProject.get("FORG"));
        object.set("org", preProject.get("FORG"));
        object.set("useorg", preProject.get("FORG"));
        object.set("parent", (Object)0L);
        object.set("group", (Object)projectKindId);
        object.set("isleaf", (Object)Boolean.TRUE);
        object.set("enable", (Object)"1");
        object.set("level", (Object)1L);
        object.set("status", (Object)"C");
        object.set("ctrlstrategy", (Object)"5");
        object.set("createtime", (Object)new Date());
        object.set("proaddress", preProject.get("FADDRESS"));
        return object;
    }

    private DynamicObject buildProjectKind(Long projectKindId) {
        DynamicObject object = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)BD_PROJECTKIND));
        object.set("createorg", (Object)100000L);
        object.set("org", (Object)100000L);
        object.set("parent", (Object)0L);
        object.set("ctrlstrategy", (Object)"5");
        object.set("number", (Object)"PRE_PROJECT_KIND");
        object.set("name", (Object)ProjectInfoUpgradeService.getYjxm());
        object.set("description", (Object)ResManager.loadKDString((String)"\u7a0e\u52a1\u4e91-\u589e\u503c\u7a0e-\u9884\u7f34\u9879\u76ee\u9ed8\u8ba4\u4f7f\u7528\u7684\u9879\u76ee\u5206\u7c7b", (String)"ProjectInfoUpgradeService_1", (String)"taxc-tcvat", (Object[])new Object[0]));
        object.set("id", (Object)projectKindId);
        object.set("masterid", (Object)projectKindId);
        object.set("enable", (Object)"1");
        object.set("level", (Object)1L);
        object.set("status", (Object)"C");
        object.set("longnumber", (Object)"PRE_PROJECT_KIND");
        object.set("isleaf", (Object)Boolean.TRUE);
        object.set("createtime", (Object)new Date());
        return object;
    }
}

