/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.tcvat.common.enums.DiffRuleTypeEnum;
import org.apache.commons.collections4.CollectionUtils;

public class SjjtYbnsrDiffDraftUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(SjjtYbnsrDiffDraftUpgradeService.class);

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "YbnsrDiffDraftUpgradeService DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            DBRoute taxc = DBRoute.of((String)"taxc");
            if (DB.exitsTable((DBRoute)taxc, (String)"t_tcvat_diffdeduct_sjjt") && DB.exitsTable((DBRoute)taxc, (String)"t_tcvat_sjkce_summ_sjjt")) {
                this.update();
            }
        }
        catch (Throwable t) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("YbnsrDiffDraftUpgradeService DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        String queryDraftSql = "select fid,fserialno,forgid,ftaxperiod,fdeductamount,fdifftypeid,fdeadline,fruleid from t_tcvat_diffdeduct_sjjt where frowno not in ('VAT_CEKCLX_008','VAT_CEKCLX_009') and fdeductamount is not null and fdeductamount != 0  and fjzjt = '1'";
        String insertSummarySql = "INSERT INTO t_tcvat_sjkce_summ_sjjt(fid,fserialno,forgid,ftaxperiod,fdeductamount,fdifftypeid,fdeadline,fruleid) VALUES (?,?,?,?,?,?,?,?)";
        String updateDraftSql = "update t_tcvat_diffdeduct_sjjt set fdeductamount = 0 where fid in (select fid from t_tcvat_diffdeduct where frowno not in ('VAT_CEKCLX_008','VAT_CEKCLX_009') and fdeductamount is not null and fdeductamount != 0  and fjzjt = '1')";
        List draftList = DBUtils.query((String)queryDraftSql);
        if (CollectionUtils.isEmpty((Collection)draftList)) {
            return;
        }
        try (TXHandle h = TX.required();){
            try {
                DBUtils.executeBatch((String)insertSummarySql, this.packageParamsList(draftList));
                DBUtils.execute((String)updateDraftSql);
            }
            catch (Throwable t) {
                h.markRollback();
                LOGGER.info("YbnsrDiffDraftUpgradeService FAILURE", (Object)t);
            }
        }
    }

    private List<Object[]> packageParamsList(List<Map<String, Object>> draftList) {
        ArrayList updateList = new ArrayList();
        Map<String, List<Map>> map = draftList.stream().collect(Collectors.groupingBy(d -> String.valueOf(d.get("FDEADLINE")) + d.get("FORGID") + d.get("FDIFFTYPEID")));
        map.forEach((k, allTimeDraft) -> {
            if (k.startsWith("aysb")) {
                List<Map<String, Object>> monthList = this.groupByMonth((List<Map<String, Object>>)allTimeDraft);
                updateList.addAll(monthList);
            } else {
                List<Map<String, Object>> seasonList = this.groupBySeason((List<Map<String, Object>>)allTimeDraft);
                updateList.addAll(seasonList);
            }
        });
        Map<String, List<Map>> updateMap = updateList.stream().collect(Collectors.groupingBy(d -> String.valueOf(d.get("FDEADLINE")) + d.get("FORGID") + d.get("FTAXPERIOD")));
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        List<DiffRuleTypeEnum> ybnsrDiffTypeList = DiffRuleTypeEnum.getYbnsrDiffTypeList();
        updateMap.forEach((k, v) -> {
            ArrayList<DiffRuleTypeEnum> upgradeType = new ArrayList<DiffRuleTypeEnum>(8);
            for (Map draftMap : v) {
                paramsList.add(new Object[]{DB.genLongId((String)"t_tcvat_sjkce_summ_sjjt"), draftMap.get("FSERIALNO"), draftMap.get("FORGID"), draftMap.get("FTAXPERIOD"), draftMap.get("FDEDUCTAMOUNT"), draftMap.get("FDIFFTYPEID"), draftMap.get("FDEADLINE"), draftMap.get("FRULEID")});
                upgradeType.add(DiffRuleTypeEnum.getEnumById(draftMap.get("FDIFFTYPEID")));
            }
            Map temp = (Map)v.get(0);
            for (DiffRuleTypeEnum typeEnum : ybnsrDiffTypeList) {
                if (upgradeType.contains((Object)typeEnum)) continue;
                paramsList.add(new Object[]{DB.genLongId((String)"t_tcvat_sjkce_summ_sjjt"), "", temp.get("FORGID"), temp.get("FTAXPERIOD"), BigDecimal.ZERO, typeEnum.getId(), temp.get("FDEADLINE"), 0L});
            }
        });
        return paramsList;
    }

    private List<Map<String, Object>> groupByMonth(List<Map<String, Object>> allTimeDraft) {
        if (allTimeDraft.size() == 1) {
            return allTimeDraft;
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map<String, List<Map>> periodMap = allTimeDraft.stream().collect(Collectors.groupingBy(d -> String.valueOf(d.get("FTAXPERIOD"))));
        periodMap.forEach((k, v) -> {
            Map first = (Map)v.get(0);
            v.stream().map(x -> (BigDecimal)x.get("FDEDUCTAMOUNT")).reduce(BigDecimal::add).ifPresent(sum -> first.put("FDEDUCTAMOUNT", sum));
            result.add(first);
        });
        return result;
    }

    private List<Map<String, Object>> groupBySeason(List<Map<String, Object>> allTimeDraft) {
        ArrayList<Map<String, Object>> seasonList = new ArrayList<Map<String, Object>>();
        ArrayList<Object> pool = new ArrayList<Object>();
        for (Map<String, Object> map : allTimeDraft) {
            if (!this.firstMonthInSeason(map) || pool.contains(map.get("FTAXPERIOD"))) continue;
            seasonList.add(this.sumSeasonMap(map, allTimeDraft));
            pool.add(map.get("FTAXPERIOD"));
        }
        return seasonList;
    }

    private Map<String, Object> sumSeasonMap(Map<String, Object> firstMonthDraft, List<Map<String, Object>> alltimeDraft) {
        alltimeDraft.stream().filter(draft -> this.aseason(firstMonthDraft, (Map<String, Object>)draft)).map(d -> (BigDecimal)d.get("FDEDUCTAMOUNT")).reduce(BigDecimal::add).ifPresent(bigDecimal -> firstMonthDraft.put("FDEDUCTAMOUNT", bigDecimal));
        return firstMonthDraft;
    }

    private boolean aseason(Map<String, Object> firstMonthDraft, Map<String, Object> draft) {
        String firstMonthDraftPeriod = (String)firstMonthDraft.get("FTAXPERIOD");
        String otherPeriod = (String)draft.get("FTAXPERIOD");
        int firstYear = Integer.parseInt(firstMonthDraftPeriod.substring(0, 4));
        int otherYear = Integer.parseInt(otherPeriod.substring(0, 4));
        int firstMonth = Integer.parseInt(firstMonthDraftPeriod.substring(6));
        int otherMonth = Integer.parseInt(otherPeriod.substring(6));
        return firstYear == otherYear && otherMonth - firstMonth >= 0 && otherMonth - firstMonth <= 2;
    }

    private boolean firstMonthInSeason(Map<String, Object> map) {
        String ftaxperiod = (String)map.get("FTAXPERIOD");
        return ftaxperiod.endsWith("-01") || ftaxperiod.endsWith("-04") || ftaxperiod.endsWith("-07") || ftaxperiod.endsWith("-10");
    }
}

