/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class TaxProjectUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(TaxProjectUpgradeService.class);
    private static final String TAX_PROJECT = "bastax_taxproject";
    private static final String TCVAT_PREPAY_PROJECT_INFO = "tcvat_prepay_project_info";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        this.addLog(INFO, "\n-------------------------------------------");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, "\n-------------------------------------------");
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        for (String number : Arrays.asList(TCVAT_PREPAY_PROJECT_INFO, TAX_PROJECT)) {
            Boolean isExist = this.metaIsExist(number);
            if (isExist.booleanValue()) continue;
            this.addLog(ERROR, String.format("The %s is not exist!", number));
            return;
        }
        DynamicObject[] projectInfos = BusinessDataServiceHelper.load((String)TCVAT_PREPAY_PROJECT_INFO, (String)"id,taxorg,org,baseproject,baseprojectname,proaddress,status", (QFilter[])QFilter.isNotNull((String)"org").toArray());
        Map<String, List<DynamicObject>> collect = Arrays.stream(projectInfos).collect(Collectors.groupingBy(a -> a.getString("org.id")));
        this.addLog(INFO, String.format("Query TcvatPreProject, total size is %d ", projectInfos.length));
        List idList = Arrays.stream(projectInfos).map(a -> a.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection taxprojects = QueryServiceHelper.query((String)TAX_PROJECT, (String)"id,number,org,taxorg", (QFilter[])new QFilter("id", "in", idList).toArray());
        Map<String, List<String>> updatedIds = taxprojects.stream().map(a -> a.getString("id")).collect(Collectors.groupingBy(a -> a));
        ArrayList saveLists = new ArrayList(collect.size());
        for (List<DynamicObject> list : collect.values()) {
            ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(list.size());
            for (DynamicObject dynamicObject : list) {
                if (updatedIds.containsKey(dynamicObject.getString("id"))) continue;
                DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)TAX_PROJECT);
                object.set("id", dynamicObject.get("id"));
                object.set("masterid", dynamicObject.get("id"));
                object.set("number", dynamicObject.get("number"));
                object.set("name", dynamicObject.get("name"));
                object.set("org", dynamicObject.get("org"));
                object.set("taxorg", dynamicObject.get("taxorg"));
                object.set("baseproject", dynamicObject.get("baseproject.id"));
                object.set("status", dynamicObject.get("status"));
                object.set("enable", (Object)"1");
                object.set("swqsytfl", (Object)"");
                object.set("syslzsl", (Object)BigDecimal.ZERO);
                dynamicObjects.add(object);
            }
            if (!EmptyCheckUtils.isNotEmpty(dynamicObjects)) continue;
            saveLists.add(dynamicObjects);
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                Integer count = saveLists.stream().map(a -> a.size()).reduce(0, (a, b) -> a + b);
                this.addLog(INFO, String.format("Save TaxProject total size is %d ", count));
                if (EmptyCheckUtils.isNotEmpty(saveLists)) {
                    for (List list : saveLists) {
                        List ids = list.stream().map(a -> a.getLong("id")).collect(Collectors.toList());
                        String idStr = ids.stream().map(a -> String.valueOf(a)).collect(Collectors.joining(","));
                        List partition = Lists.partition((List)list, (int)200);
                        for (List objectList : partition) {
                            SaveServiceHelper.save((DynamicObject[])objectList.toArray(new DynamicObject[objectList.size()]));
                        }
                        this.addLog(INFO, String.format("Save TaxProject, size %d, ids:%s", list.size(), idStr));
                    }
                }
            }
            catch (Throwable t) {
                h.markRollback();
                LOGGER.error(ERROR_INFO, t);
                throw new KDException(new ErrorCode("taxc.tcvat.taxprojectupd", "upgrade error!"), new Object[]{t});
            }
        }
    }
}

