/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TcvatHistoryRecordEntryentityconfUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(TcvatHistoryRecordEntryentityconfUpgradeService.class);
    public static final String HISTORY_ENTRY = "tctb_history_record";
    private static final String RECORD = "record_tag";
    public static final int PAGESIZE = 600;

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        Boolean isExist = this.metaIsExist(HISTORY_ENTRY);
        if (!isExist.booleanValue()) {
            this.addLog(ERROR, String.format("The %s is not exist!", HISTORY_ENTRY));
            return;
        }
        long lastId = 0L;
        DynamicObject[] collection = this.getCollection(lastId);
        while (null != collection && collection.length > 0) {
            for (DynamicObject dynamicObject : collection) {
                JSONObject object;
                JSONArray incomeRules;
                String record = dynamicObject.getString(RECORD);
                if (StringUtil.isBlank((CharSequence)record) || !record.contains("INCOME") || (incomeRules = (object = JSONObject.parseObject((String)record)).getJSONArray("INCOME")) == null || incomeRules.size() <= 0 || object.getString("INCOME").contains("entryentityconfjson")) continue;
                for (int i = 0; i < incomeRules.size(); ++i) {
                    JSONObject jsonObject = incomeRules.getJSONObject(i);
                    if (jsonObject.getJSONObject("taxrate") == null) continue;
                    String taxrateStr = jsonObject.getJSONObject("taxrate").getString("number").replace("%", "");
                    BigDecimal taxrate = new BigDecimal(taxrateStr).divide(new BigDecimal(100));
                    for (Object entryentity : jsonObject.getJSONArray("entryentity")) {
                        ((JSONObject)entryentity).put("entryentityconf", (Object)"rate");
                        ((JSONObject)entryentity).put("entryentityconfjson", (Object)taxrate);
                    }
                }
                String s = SerializationUtils.toJsonString((Object)object);
                dynamicObject.set(RECORD, (Object)s);
            }
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])collection);
                }
                catch (Exception e) {
                    h.markRollback();
                    this.addLog(ERROR, String.format("first id:%s update error!", String.valueOf(lastId)));
                    LOGGER.error((Throwable)e);
                }
            }
            if (collection.length != 600) break;
            lastId = collection[collection.length - 1].getLong("id");
            collection = this.getCollection(lastId);
        }
    }

    public DynamicObject[] getCollection(long lastId) {
        QFilter q1 = new QFilter("id", ">", (Object)lastId);
        QFilter q2 = new QFilter("type", "=", (Object)"tcvat_rule");
        DynamicObject[] load = BusinessDataServiceHelper.load((String)HISTORY_ENTRY, (String)"id,record_tag", (QFilter[])new QFilter[]{q1, q2}, (String)"id", (int)0, (int)600);
        return load;
    }
}

