/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TcvatIncomeInvoiceUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(TcvatIncomeInvoiceUpgradeService.class);
    public static final String T_TCVAT_INCOME_INVOICE = "t_tcvat_income_invoice";
    public static final String T_TCVAT_HZ_INCOME_INVOICE = "t_tcvat_hz_income_invoice";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        boolean isExist1 = DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)T_TCVAT_INCOME_INVOICE);
        boolean isExist2 = DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)T_TCVAT_HZ_INCOME_INVOICE);
        if (!isExist1 || !isExist2) {
            this.addLog(ERROR, "T_TCVAT_INCOME_INVOICE or T_TCVAT_HZ_INCOME_INVOICE Table Or Column Not Exist !");
            return;
        }
        this.updateIncomeInvoice();
        this.updateHzIncomeInvoice();
    }

    public void updateIncomeInvoice() {
        ArrayList<Object[]> amountparamList = new ArrayList<Object[]>();
        ArrayList<Object[]> taxparamList = new ArrayList<Object[]>();
        List<Map<String, Object>> invoiceentity = this.getIncomeInvoice();
        long[] longs = DB.genLongIds((String)T_TCVAT_INCOME_INVOICE, (int)invoiceentity.size());
        if (null != invoiceentity && invoiceentity.size() > 0) {
            for (int i = 0; i < invoiceentity.size(); ++i) {
                Map<String, Object> map = invoiceentity.get(i);
                String fid = String.valueOf(map.get("FID"));
                String ffiltercondition = String.valueOf(map.get("FFILTERCONDITION"));
                String fconditionjson = String.valueOf(map.get("FCONDITIONJSON"));
                String ftable = String.valueOf(map.get("FTABLE"));
                long famountfield = this.getAmountField(ftable);
                List<String> condition = this.condition(ftable, ffiltercondition, fconditionjson);
                Object[] amountobjects = new Object[]{condition.get(0), condition.get(1), famountfield, Long.valueOf(fid)};
                Object[] taxobjects = new Object[]{longs[i], condition.get(0), condition.get(1), famountfield, Long.valueOf(fid)};
                amountparamList.add(amountobjects);
                taxparamList.add(taxobjects);
            }
        }
        if (amountparamList.size() > 0) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    DBUtils.executeBatch((String)"update t_tcvat_income_invoice set ftype='5',ffiltercondition=?, fconditionjson=?, famountfield=?, fdatatype='zjqs',fdatadirection='positive',ffetchamount=finvoiceamount where fid=?;", amountparamList);
                    DBUtils.executeBatch((String)"insert into t_tcvat_income_invoice(fid,ffiltercondition,fconditionjson,ftype,famountfield,ffetchamount,fdatatype,fdatadirection,fabsolute,ftaxruleid,ftaxrate,ftaxperiod,ftaxamount,ftaxaccountserialno,ftaxaccountid,ftable,forgid,fmodifydate,fmodifierid,fmaingoodsname,finvoicetype,finvoiceno,finvoicedata,finvoicecode,finvoiceamount,fdifferenceinvoice,fcreaterid,fcreatedate) select ?,?,?,'6',?,finvoiceamount,'zjqs','positive','0',ftaxruleid,ftaxrate,ftaxperiod,ftaxamount,ftaxaccountserialno,ftaxaccountid,ftable,forgid,fmodifydate,fmodifierid,fmaingoodsname,finvoicetype,finvoiceno,finvoicedata,finvoicecode,finvoiceamount,fdifferenceinvoice,fcreaterid,fcreatedate from t_tcvat_income_invoice where fid = ?;", taxparamList);
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                    h.markRollback();
                }
            }
        }
    }

    public void updateHzIncomeInvoice() {
        ArrayList<Object[]> amountparamList = new ArrayList<Object[]>();
        ArrayList<Object[]> taxparamList = new ArrayList<Object[]>();
        List<Map<String, Object>> invoiceentity = this.getHzIncomeInvoice();
        long[] longs = DB.genLongIds((String)T_TCVAT_HZ_INCOME_INVOICE, (int)invoiceentity.size());
        if (null != invoiceentity && invoiceentity.size() > 0) {
            for (int i = 0; i < invoiceentity.size(); ++i) {
                Map<String, Object> map = invoiceentity.get(i);
                String fid = String.valueOf(map.get("FID"));
                String ffiltercondition = String.valueOf(map.get("FFILTERCONDITION"));
                String fconditionjson = String.valueOf(map.get("FCONDITIONJSON"));
                String ftable = String.valueOf(map.get("FTABLE"));
                long famountfield = this.getAmountField(ftable);
                List<String> condition = this.condition(ftable, ffiltercondition, fconditionjson);
                Object[] amountobjects = new Object[]{condition.get(0), condition.get(1), famountfield, Long.valueOf(fid)};
                Object[] taxobjects = new Object[]{longs[i], condition.get(0), condition.get(1), famountfield, Long.valueOf(fid)};
                amountparamList.add(amountobjects);
                taxparamList.add(taxobjects);
            }
        }
        if (amountparamList.size() > 0) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    DBUtils.executeBatch((String)"update t_tcvat_hz_income_invoice set ftype='5',ffiltercondition=?, fconditionjson=?, famountfield=?, fdatatype='zjqs',fdatadirection='positive',ffetchamount=finvoiceamount where fid=?;", amountparamList);
                    DBUtils.executeBatch((String)"insert into t_tcvat_hz_income_invoice(fid,ffiltercondition,fconditionjson,ftype,famountfield,fdatatype,fdatadirection,fabsolute,ffetchamount,ftaxaccountserialno,forgid,fsuborgid,finvoiceamount,ftaxamount,ftaxrate,fstartdate,fenddate,ftaxpayertype,ftable,fdifferenceinvoice) select ?,?,?,'6',?,'zjqs','positive','0',finvoiceamount,ftaxaccountserialno,forgid,fsuborgid,finvoiceamount,ftaxamount,ftaxrate,fstartdate,fenddate,ftaxpayertype,ftable,fdifferenceinvoice from t_tcvat_hz_income_invoice where fid = ?;", taxparamList);
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                    h.markRollback();
                }
            }
        }
    }

    public long getAmountField(String table) {
        if ("1543335746595744768".equals(table)) {
            return 1543335746671242291L;
        }
        if ("1163062995127970816".equals(table)) {
            return 1163062995136359509L;
        }
        return 0L;
    }

    public List<Map<String, Object>> getIncomeInvoice() {
        String sql = "select fid, ffiltercondition, fconditionjson,finvoiceamount,ftable from t_tcvat_income_invoice where fdatatype = '' or fdatatype = ' ' or fdatatype is null;";
        List query = DBUtils.query((String)sql);
        return query;
    }

    public List<Map<String, Object>> getHzIncomeInvoice() {
        String sql = "select fid, ffiltercondition, fconditionjson,finvoiceamount,ftable from t_tcvat_hz_income_invoice where fdatatype = '' or fdatatype = ' ' or fdatatype is null;";
        List query = DBUtils.query((String)sql);
        return query;
    }

    public List<String> condition(String table, String ffiltercondition, String fconditionjson) {
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtil.isNotBlank((CharSequence)ffiltercondition)) {
            String str = "";
            if ("1163062995127970816".equals(table)) {
                ffiltercondition = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b.\u540d\u79f0 \u5728\u2026\u2026\u4e2d \u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968;\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968;\u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09  \u5e76\u4e14            \u53d1\u7968\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u6b63\u5e38;\u7ea2\u51b2  \u5e76\u4e14    %s", (String)"TcvatIncomeInvoiceUpgradeService_0", (String)"taxc-tcvat", (Object[])new Object[0]), ffiltercondition);
                str = "{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"961639304377984000\",\"Id\":\"3QKIGEK3=SEJ\"},{\"_Type_\":\"FilterValue\",\"Value\":\"961640097369875456\",\"Id\":\"3QKIGEK38PMS\"},{\"_Type_\":\"FilterValue\",\"Value\":\"1376129725579325440\",\"Id\":\"3QKIGEK3=SEK\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968\",\"Id\":\"3QKIGEK38PMQ\"},{\"_Type_\":\"FilterValue\",\"Value\":\"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\",\"Id\":\"3QKIGEK3=SEI\"},{\"_Type_\":\"FilterValue\",\"Value\":\"\u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09\",\"Id\":\"3QKIGEK38PMR\"}],\"CompareType\":\"17\",\"Id\":\"3QKIGEK3=SEH\",\"Logic\":\"0\",\"FieldName\":\"baseinvoicetype.name\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3QKIGEK3=SEL\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"3QKIGEK38PMU\"}],\"CompareType\":\"17\",\"Id\":\"3QKIGEK38PMT\",\"Logic\":\"0\",\"FieldName\":\"invoicestatus\"},";
            } else if ("1543335746595744768".equals(table)) {
                ffiltercondition = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u6b63\u5e38;\u7ea2\u51b2  \u5e76\u4e14            %s", (String)"TcvatIncomeInvoiceUpgradeService_1", (String)"taxc-tcvat", (Object[])new Object[0]), ffiltercondition);
                str = "{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3QRZOZ8Z3HB+\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"3QRZOZ8Z5KT0\"}],\"CompareType\":\"17\",\"Id\":\"3QRZOZ8Z5KT/\",\"Logic\":\"0\",\"FieldName\":\"invoicestatus\"},";
            }
            String str1 = fconditionjson.substring(0, fconditionjson.indexOf("[") + 1);
            String str2 = fconditionjson.substring(fconditionjson.indexOf("[") + 1);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(str1);
            stringBuilder.append(str);
            stringBuilder.append(str2);
            fconditionjson = stringBuilder.toString();
        } else if ("1163062995127970816".equals(table)) {
            ffiltercondition = ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b.\u540d\u79f0 \u5728\u2026\u2026\u4e2d \u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968;\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968;\u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09  \u5e76\u4e14            \u53d1\u7968\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u6b63\u5e38;\u7ea2\u51b2  ", (String)"TcvatIncomeInvoiceUpgradeService_2", (String)"taxc-tcvat", (Object[])new Object[0]);
            fconditionjson = "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"961639304377984000\",\"Id\":\"3PKLSCPZ04=T\"},{\"_Type_\":\"FilterValue\",\"Value\":\"961640097369875456\",\"Id\":\"3PKLSCPZ272K\"},{\"_Type_\":\"FilterValue\",\"Value\":\"1376129725579325440\",\"Id\":\"3PKLSCPZ04=U\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968\",\"Id\":\"3PKLSCPZ272I\"},{\"_Type_\":\"FilterValue\",\"Value\":\"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\",\"Id\":\"3PKLSCPZ04=S\"},{\"_Type_\":\"FilterValue\",\"Value\":\"\u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09\",\"Id\":\"3PKLSCPZ272J\"}],\"CompareType\":\"17\",\"Id\":\"3PKLSCPZ04=R\",\"Logic\":\"0\",\"FieldName\":\"baseinvoicetype.name\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3PKLSCPZ04=V\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"3PKLSCPZ272M\"}],\"CompareType\":\"17\",\"Id\":\"3PKLSCPZ272L\",\"Logic\":\"0\",\"FieldName\":\"invoicestatus\"}]}";
        } else if ("1543335746595744768".equals(table)) {
            ffiltercondition = ResManager.loadKDString((String)"\u53d1\u7968\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u6b63\u5e38;\u7ea2\u51b2  ", (String)"TcvatIncomeInvoiceUpgradeService_3", (String)"taxc-tcvat", (Object[])new Object[0]);
            fconditionjson = "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3QS+AHVRXY4U\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"3QS+AHVRVUOU\"}],\"CompareType\":\"17\",\"Id\":\"3QS+AHVRVUOT\",\"Logic\":\"0\",\"FieldName\":\"invoicestatus\"}]}";
        }
        result.add(ffiltercondition);
        result.add(fconditionjson);
        return result;
    }
}

