/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.tcvat.common.enums.DiffRuleTypeEnum;
import kd.taxc.tcvat.common.enums.RuleTypeStrategyEnum;
import org.apache.commons.collections4.CollectionUtils;

public class YbnsrDiffRuleUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(YbnsrDiffRuleUpgradeService.class);

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "YbnsrDiffRuleUpgradeService DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            DBRoute taxc = DBRoute.of((String)"taxc");
            if (DB.exitsTable((DBRoute)taxc, (String)"t_tcvat_rule_diff") && DB.exitsTable((DBRoute)taxc, (String)"t_tcvat_rule_diff_l") && DB.exitsTable((DBRoute)taxc, (String)"t_tcvat_rule_entry") && DB.exitsTable((DBRoute)taxc, (String)"t_tcvat_rule_diff_entry") && DB.exitsTable((DBRoute)taxc, (String)"t_tcvat_rule_diff_entry1") && DB.exitsTable((DBRoute)taxc, (String)"t_tcvat_all_rule_config") && DB.exitsTable((DBRoute)taxc, (String)"t_tcvat_all_rule_config_l")) {
                this.update();
            }
        }
        catch (Throwable t) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("YbnsrDiffRuleUpgradeService DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        String queryRuleSql = "select fid,fnumber,forgid,fruletype,ftaxpayertype,fqzkce,fdifftype,fdeductproject,fdeductiontype,frulepurpose,fjzjt from t_tcvat_rule_diff where ftaxpayertype in ('ybnsr') and fenable = '1' and (fdeductproject is null or fdeductproject = '' or fdeductproject = ' ')";
        String updateRuleSql = "update t_tcvat_rule_diff set fdeductproject = ? where fid = ?";
        String updateAllRuleSql = "update t_tcvat_all_rule_config set fdeductproject = ? where fid = ?";
        String insertRuleSql = "INSERT INTO t_tcvat_rule_diff(FID,FNUMBER,fstatus,fenable,FORGID,FRULETYPE,FTAXPAYERTYPE,FDIFFTYPE,FDEDUCTPROJECT,FDEDUCTIONTYPE,FRULEPURPOSE,fcreatorid,fmodifierid,fcreatetime,fmodifytime,fminswitch) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        String insertRuleLSql = "INSERT INTO t_tcvat_rule_diff_l(FID,FPKID,FLOCALEID,FNAME) VALUES (?,?,?,?)";
        String insertRuleEntrySql = "INSERT INTO t_tcvat_rule_diff_entry1(FID,fentryid,FBIZNAME,FTABLE,FAMOUNTFIELD,FABSOLUTE,FDATATYPE,FDATADIRECTION,FFILTERCONDITION,FCONDITIONJSON) VALUES (?,?,?,?,?,?,?,?,?,?)";
        String insertAllRuleSql = "INSERT INTO t_tcvat_all_rule_config(FID,FNUMBER,fstatus,fenable,FORG,FRULETYPE,FTAXPAYERTYPE,FDIFFTYPE,FDEDUCTPROJECT,FRULEPURPOSE,FISSYSTEM,FGROUPID,fcreatorid,fmodifierid,fcreatetime,fmodifytime) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        String insertAllRuleLSql = "INSERT INTO t_tcvat_all_rule_config_l(FID,FPKID,FLOCALEID,FNAME) VALUES (?,?,?,?)";
        String queryRuleEntrySql = "select fid,fentryid,fseq,fbizname,ftable,famountfield,fabsolute,fdatatype,fdatadirection,ffiltercondition,ffconditionjson from t_tcvat_rule_entry where fid in (select fid from t_tcvat_rule_diff where ftaxpayertype in ('ybnsr') and fenable = '1' and (fdeductproject is null or fdeductproject = '' or fdeductproject = ' '))";
        String queryDiffRuleEntrySql = "select fid,fentryid,fseq,fbizname,ftable,famountfield,fabsolute,fdatatype,fdatadirection,ffiltercondition,fconditionjson from t_tcvat_rule_diff_entry where fid in (select fid from t_tcvat_rule_diff where ftaxpayertype in ('ybnsr') and fenable = '1' and (fdeductproject is null or fdeductproject = '' or fdeductproject = ' '))";
        String queryDiffTypeSql = "select fentryid,fvalue,fnumber from t_tpo_tcvat_bizdefentry where fnumber in ('VAT_CEKCLX_001','VAT_CEKCLX_002','VAT_CEKCLX_003','VAT_CEKCLX_004','VAT_CEKCLX_005','VAT_CEKCLX_006','VAT_CEKCLX_007','VAT_CEKCLX_008')";
        String updateXgmRuleSql = "update t_tcvat_rule_diff set fdeductproject = 'bqfse' where ftaxpayertype in ('xgmnsr') and fenable = '1' and (fdeductproject is null or fdeductproject = '' or fdeductproject = ' ')";
        String updateAllXgmRuleSql = "update t_tcvat_all_rule_config set fdeductproject = 'bqfse' where ftaxpayertype in ('xgmnsr') and fenable = '1' and (fdeductproject is null or fdeductproject = '' or fdeductproject = ' ')";
        List ruleList = DBUtils.query((String)queryRuleSql);
        if (CollectionUtils.isEmpty((Collection)ruleList)) {
            return;
        }
        List ruleEntryList = DBUtils.query((String)queryRuleEntrySql);
        List ruleDiffEntryList = DBUtils.query((String)queryDiffRuleEntrySql);
        List diffTypeList = DBUtils.query((String)queryDiffTypeSql);
        ArrayList<Map<String, Object>> newDeductRules = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> newDeductRuleEntryList = new ArrayList<Map<String, Object>>();
        this.doUpdateNoTaxDiffRules(ruleList);
        this.doUpdateNotJzjtRules(ruleList);
        this.doUpdateJzjtRules(ruleList, ruleEntryList, ruleDiffEntryList, newDeductRules, newDeductRuleEntryList);
        try (TXHandle h = TX.required();){
            try {
                DBUtils.execute((String)updateXgmRuleSql);
                DBUtils.executeBatch((String)updateRuleSql, this.packageUpdateParamsList(ruleList));
                if (CollectionUtils.isNotEmpty(newDeductRules)) {
                    DBUtils.executeBatch((String)insertRuleSql, this.packageInsertParamsList(newDeductRules));
                    DBUtils.executeBatch((String)insertRuleLSql, this.packageInsertLParamsList(newDeductRules, diffTypeList, "tcvat_rule_diff"));
                }
                if (CollectionUtils.isNotEmpty(newDeductRuleEntryList)) {
                    DBUtils.executeBatch((String)insertRuleEntrySql, this.packageInsertEntryParamsList(newDeductRuleEntryList));
                }
                DBUtils.execute((String)updateAllXgmRuleSql);
                DBUtils.executeBatch((String)updateAllRuleSql, this.packageUpdateParamsList(ruleList));
                if (CollectionUtils.isNotEmpty(newDeductRules)) {
                    DBUtils.executeBatch((String)insertAllRuleSql, this.packageInsertAllParamsList(newDeductRules));
                    DBUtils.executeBatch((String)insertAllRuleLSql, this.packageInsertLParamsList(newDeductRules, diffTypeList, "tcvat_all_rule_config"));
                }
            }
            catch (Throwable t) {
                h.markRollback();
                LOGGER.info("YbnsrDiffRuleUpgradeService FAILURE", (Object)t);
            }
        }
    }

    private List<Object[]> packageUpdateParamsList(List<Map<String, Object>> ruleList) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(ruleList.size());
        for (Map<String, Object> ruleMap : ruleList) {
            paramsList.add(new Object[]{ruleMap.get("FDEDUCTPROJECT"), ruleMap.get("FID")});
        }
        return paramsList;
    }

    private List<Object[]> packageInsertAllParamsList(List<Map<String, Object>> ruleList) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(ruleList.size());
        long currUserId = RequestContext.getOrCreate().getCurrUserId();
        for (Map<String, Object> ruleMap : ruleList) {
            paramsList.add(new Object[]{ruleMap.get("FID"), ruleMap.get("FNUMBER"), "A", "1", ruleMap.get("FORGID"), ruleMap.get("FRULETYPE"), ruleMap.get("FTAXPAYERTYPE"), ruleMap.get("FDIFFTYPE"), ruleMap.get("FDEDUCTPROJECT"), ruleMap.get("FRULEPURPOSE"), "1", RuleTypeStrategyEnum.DIFF.getGroupId(), currUserId, currUserId, new Date(), new Date()});
        }
        return paramsList;
    }

    private List<Object[]> packageInsertParamsList(List<Map<String, Object>> ruleList) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(ruleList.size());
        long currUserId = RequestContext.getOrCreate().getCurrUserId();
        for (Map<String, Object> ruleMap : ruleList) {
            paramsList.add(new Object[]{ruleMap.get("FID"), ruleMap.get("FNUMBER"), "A", "1", ruleMap.get("FORGID"), ruleMap.get("FRULETYPE"), ruleMap.get("FTAXPAYERTYPE"), ruleMap.get("FDIFFTYPE"), ruleMap.get("FDEDUCTPROJECT"), ruleMap.get("FDEDUCTIONTYPE"), ruleMap.get("FRULEPURPOSE"), currUserId, currUserId, new Date(), new Date(), "1"});
        }
        return paramsList;
    }

    private List<Object[]> packageInsertLParamsList(List<Map<String, Object>> ruleList, List<Map<String, Object>> diffTypeList, String tableName) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(ruleList.size());
        for (Map<String, Object> ruleMap : ruleList) {
            String diffName = diffTypeList.stream().filter(d -> d.get("FENTRYID").equals(ruleMap.get("FDIFFTYPE"))).findFirst().orElseGet(HashMap::new).get("FVALUE").toString();
            paramsList.add(new Object[]{ruleMap.get("FID"), DB.genStringId((String)tableName), "zh_CN", diffName.concat(ResManager.loadKDString((String)"_\u5b9e\u9645\u6263\u9664\u989d", (String)"DiffRuleUpgradeService_0", (String)"taxc-tcvat", (Object[])new Object[0]))});
        }
        return paramsList;
    }

    private List<Object[]> packageInsertEntryParamsList(List<Map<String, Object>> ruleList) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(ruleList.size());
        for (Map<String, Object> ruleMap : ruleList) {
            paramsList.add(new Object[]{ruleMap.get("FID"), DB.genLongId((String)"t_tcvat_rule_diff_entry1"), ruleMap.get("FBIZNAME"), ruleMap.get("FTABLE"), ruleMap.get("FAMOUNTFIELD"), ruleMap.get("FABSOLUTE"), ruleMap.get("FDATATYPE"), ruleMap.get("FDATADIRECTION"), ruleMap.get("FFILTERCONDITION"), ruleMap.get("FCONDITIONJSON")});
        }
        return paramsList;
    }

    private Boolean isExistsEntry(Object fid, List<Map<String, Object>> ruleDiffEntryList) {
        Optional<Map> op = ruleDiffEntryList.stream().filter(r -> fid.equals(r.get("FID"))).findFirst();
        return op.isPresent();
    }

    private void doGenerateRuleByPurpose(Map<Object, List<Map<String, Object>>> rulePurposeMap, List<Map<String, Object>> ruleEntryList, List<Map<String, Object>> ruleDiffEntryList, List<Map<String, Object>> deductRules, List<Map<String, Object>> entryList) {
        HashMap currentRuleMap = new HashMap();
        rulePurposeMap.forEach((k, v) -> {
            String rulePurpose = String.valueOf(k).replace(",", "").trim();
            if (rulePurpose.equals("nssb") || rulePurpose.equals("sjjt")) {
                Map rule = (Map)v.get(0);
                Map<String, Object> newRule = this.doNewRule(rule);
                deductRules.add(newRule);
                currentRuleMap.put(rulePurpose, newRule);
                v.forEach(x -> this.doAddRuleEntry(ruleEntryList, ruleDiffEntryList, entryList, (Map<String, Object>)x, newRule));
            }
        });
        rulePurposeMap.forEach((k, v) -> {
            String rulePurpose = String.valueOf(k).replace(",", "");
            if (rulePurpose.contains("nssbsjjt") || rulePurpose.contains("sjjtnssb")) {
                Map<String, Object> newSjjtRule;
                Map<String, Object> newNssbRule;
                if (currentRuleMap.containsKey("nssb")) {
                    newNssbRule = (Map<String, Object>)currentRuleMap.get("nssb");
                } else {
                    newNssbRule = this.doNewRule((Map)v.get(0));
                    newNssbRule.put("FRULEPURPOSE", ",nssb,");
                    deductRules.add(newNssbRule);
                }
                v.forEach(x -> this.doAddRuleEntry(ruleEntryList, ruleDiffEntryList, entryList, (Map<String, Object>)x, newNssbRule));
                if (currentRuleMap.containsKey("sjjt")) {
                    newSjjtRule = (Map<String, Object>)currentRuleMap.get("sjjt");
                } else {
                    newSjjtRule = this.doNewRule((Map)v.get(0));
                    newSjjtRule.put("FRULEPURPOSE", ",sjjt,");
                    deductRules.add(newSjjtRule);
                }
                v.forEach(x -> this.doAddRuleEntry(ruleEntryList, ruleDiffEntryList, entryList, (Map<String, Object>)x, newSjjtRule));
            }
        });
    }

    private void doAddRuleEntry(List<Map<String, Object>> ruleEntryList, List<Map<String, Object>> ruleDiffEntryList, List<Map<String, Object>> entryList, Map<String, Object> rule, Map<String, Object> newRule) {
        if ("1".equals(rule.get("FQZKCE"))) {
            List<Map<String, Object>> currentRuleEntry = ruleEntryList.stream().filter(r -> r.get("FID").equals(rule.get("FID"))).collect(Collectors.toList());
            this.copyEntry(entryList, currentRuleEntry, newRule.get("FID"));
        } else {
            List<Map<String, Object>> currentRuleEntry = ruleDiffEntryList.stream().filter(r -> r.get("FID").equals(rule.get("FID"))).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(currentRuleEntry)) {
                this.copyEntry(entryList, currentRuleEntry, newRule.get("FID"));
            }
        }
    }

    private Map<String, Object> doNewRule(Map<String, Object> rule) {
        long id = DBUtils.getLongId((String)"t_tcvat_rule_diff");
        HashMap<String, Object> result = new HashMap<String, Object>();
        rule.forEach(result::put);
        result.put("FID", id);
        result.put("FNUMBER", this.getNumber());
        result.put("FDEDUCTPROJECT", "bqsjkce");
        return result;
    }

    private Object getNumber() {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tcvat_rule_diff");
        DynamicObject newKceRule = new DynamicObject((DynamicObjectType)entityType);
        return CodeRuleServiceHelper.getNumber((String)"tcvat_rule_diff", (DynamicObject)newKceRule, null);
    }

    private void copyEntry(List<Map<String, Object>> target, List<Map<String, Object>> source, Object id) {
        source.forEach(s -> {
            HashMap<String, Object> entry = new HashMap<String, Object>();
            s.forEach(entry::put);
            entry.put("FID", id);
            target.add(entry);
        });
    }

    private void doUpdateJzjtRules(List<Map<String, Object>> ruleList, List<Map<String, Object>> ruleEntryList, List<Map<String, Object>> ruleDiffEntryList, List<Map<String, Object>> deductRules, List<Map<String, Object>> entryList) {
        List<Map> jzjtRules = ruleList.stream().filter(o -> o.get("FJZJT").equals("1") && !"VAT_CEKCLX_008".equals(DiffRuleTypeEnum.getNumberById(o.get("FDIFFTYPE")))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(jzjtRules)) {
            return;
        }
        jzjtRules.forEach(j -> j.put("FDEDUCTPROJECT", "bqfse"));
        List notEmptyRules = jzjtRules.stream().filter(j -> "1".equals(j.get("FQZKCE")) || this.isExistsEntry(j.get("FID"), ruleDiffEntryList) != false).collect(Collectors.toList());
        Map<String, List<Map>> group = notEmptyRules.stream().collect(Collectors.groupingBy(n -> n.get("FORGID") + "#" + n.get("FRULETYPE") + "#" + n.get("FDIFFTYPE")));
        group.forEach((k, v) -> {
            Map<Object, List<Map<String, Object>>> rulePurposeMap = v.stream().collect(Collectors.groupingBy(r -> r.get("FRULEPURPOSE")));
            if (rulePurposeMap.size() == 1) {
                Map<String, Object> newRule = this.doNewRule((Map)v.get(0));
                deductRules.add(newRule);
                v.forEach(x -> this.doAddRuleEntry(ruleEntryList, ruleDiffEntryList, entryList, (Map<String, Object>)x, newRule));
            } else {
                this.doGenerateRuleByPurpose(rulePurposeMap, ruleEntryList, ruleDiffEntryList, deductRules, entryList);
            }
        });
    }

    private void doUpdateNotJzjtRules(Collection<Map<String, Object>> ruleList) {
        List<Map> notJzjtRules = ruleList.stream().filter(o -> o.get("FJZJT").equals("0") && !"VAT_CEKCLX_008".equals(DiffRuleTypeEnum.getNumberById(o.get("FDIFFTYPE")))).collect(Collectors.toList());
        notJzjtRules.forEach(j -> j.put("FDEDUCTPROJECT", "bqfse"));
    }

    private void doUpdateNoTaxDiffRules(List<Map<String, Object>> ruleList) {
        List<Map> noTaxDiffRules = ruleList.stream().filter(r -> "VAT_CEKCLX_008".equals(DiffRuleTypeEnum.getNumberById(r.get("FDIFFTYPE")))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(noTaxDiffRules)) {
            return;
        }
        noTaxDiffRules.forEach(n -> n.put("FDEDUCTPROJECT", "fseandkce"));
    }
}

