/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class YbnsrZbJbrsfzEnpUpdService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(YbnsrZbJbrsfzEnpUpdService.class);
    private static final String querySql = "select fid,fjbrysfzjhm,fjbrysfzjhm_enp from t_tcvat_ybnsr_zb where (fjbrysfzjhm is null or fjbrysfzjhm=' ') and (fjbrysfzjhm_enp is not null and fjbrysfzjhm_enp != ' ')";
    private static final String updateSql = "update t_tcvat_ybnsr_zb set fjbrysfzjhm = ? where fid = ?";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        try (TXHandle h = TX.requiresNew();){
            try {
                List entrys = DBUtils.query((String)querySql);
                if (EmptyCheckUtils.isNotEmpty((Object)entrys)) {
                    ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
                    for (Map entry : entrys) {
                        Object fid = entry.get("FID");
                        String fjbrysfzjhm_enp = (String)entry.get("FJBRYSFZJHM_ENP");
                        String fjbrysfzjhm = EncrypterFactory.getEncrypter().decode(fjbrysfzjhm_enp);
                        paramList.add(new Object[]{fjbrysfzjhm, fid});
                    }
                    if (EmptyCheckUtils.isNotEmpty(paramList)) {
                        DBUtils.executeBatch((String)"taxc", (String)updateSql, paramList);
                    }
                }
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
    }
}

