/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.wfrecord;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.taxc.bdtaxr.common.dto.BaseRowModel;
import kd.taxc.bdtaxr.common.dto.MultipleSheetPropety;
import kd.taxc.bdtaxr.common.dto.Sheet;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.util.bean.BeanUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.file.ExportExcelUtils;
import kd.taxc.tcvat.business.dao.wfrecord.TcvatWfRecordDao;
import kd.taxc.tcvat.common.dto.wfrecord.AccInvCompareResultDto;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class TcvatWfRecordService {
    private static final Log logger = LogFactory.getLog(TcvatWfRecordService.class);
    public static final String ACC_INV_COMPARE_REUSLT = "tcvat_acc_inv_comp";
    public static final String IN_ACC_INV_COMPARE_REUSLT = "tcvat_in_accinv_comp";
    public static final List<String> SUFFIX_LIST = Arrays.asList("", "1", "2", "3", "4");
    private static final Map<String, String> entryNameMap = new HashMap<String, String>(){
        {
            this.put("tcvat_acc_inv_comp#entryentity", ResManager.loadKDString((String)"\u672c\u671f\u5f00\u7968\uff0c\u672c\u671f\u786e\u8ba4\u6536\u5165", (String)"TcvatWfRecordService_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("tcvat_acc_inv_comp#entryentity1", ResManager.loadKDString((String)"\u5f80\u671f\u5f00\u7968\uff0c\u672c\u671f\u786e\u8ba4\u6536\u5165", (String)"TcvatWfRecordService_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("tcvat_acc_inv_comp#entryentity2", ResManager.loadKDString((String)"\u672c\u671f\u5f00\u7968\uff0c\u5f80\u671f\u786e\u8ba4\u6536\u5165", (String)"TcvatWfRecordService_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("tcvat_acc_inv_comp#entryentity3", ResManager.loadKDString((String)"\u672c\u671f\u672a\u5f00\u7968\uff0c\u672c\u671f\u786e\u8ba4\u6536\u5165", (String)"TcvatWfRecordService_3", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("tcvat_acc_inv_comp#entryentity4", ResManager.loadKDString((String)"\u672c\u671f\u5f00\u7968\uff0c\u672c\u671f\u672a\u786e\u8ba4\u6536\u5165", (String)"TcvatWfRecordService_4", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("tcvat_in_accinv_comp#entryentity", ResManager.loadKDString((String)"\u672c\u671f\u5df2\u6536\u7968\uff0c\u672c\u671f\u5df2\u5165\u8d26", (String)"TcvatWfRecordService_5", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("tcvat_in_accinv_comp#entryentity1", ResManager.loadKDString((String)"\u672c\u671f\u672a\u6536\u7968\uff0c\u672c\u671f\u5df2\u5165\u8d26", (String)"TcvatWfRecordService_6", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.put("tcvat_in_accinv_comp#entryentity2", ResManager.loadKDString((String)"\u672c\u671f\u5df2\u6536\u7968\uff0c\u672c\u671f\u672a\u5165\u8d26", (String)"TcvatWfRecordService_7", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    };
    private static final Map<String, String> pluginNameMap = new HashMap<String, String>(){
        {
            this.put("tcvat_acc_inv_comp#entryentity3", "kd.taxc.tcvat.common.dto.wfrecord.AccInvCompareVoucherExportDto");
            this.put("tcvat_acc_inv_comp#entryentity4", "kd.taxc.tcvat.common.dto.wfrecord.AccInvCompareInvoiceExportDto");
            this.put("tcvat_in_accinv_comp#entryentity", "kd.taxc.tcvat.common.dto.wfrecord.InAccInvCompareEntryExportDto");
            this.put("tcvat_in_accinv_comp#entryentity1", "kd.taxc.tcvat.common.dto.wfrecord.InAccInvCompareVoucherExportDto");
            this.put("tcvat_in_accinv_comp#entryentity2", "kd.taxc.tcvat.common.dto.wfrecord.InAccInvCompareInvoiceExportDto");
        }
    };
    private TcvatWfRecordDao wfRecordDao = new TcvatWfRecordDao();

    public AccInvCompareResultDto generateResult(AccInvCompareResultDto dto) {
        Long orgId = (Long)dto.getOrgId();
        Date startDate = (Date)dto.getStartDate();
        Date endDate = (Date)dto.getEndDate();
        Long writeoffTypeId = dto.getWriteoffTypeId();
        Date wfStartDate = dto.getWfStartDate();
        Date wfEndDate = dto.getWfEndDate();
        if (ObjectUtils.anyNull((Object[])new Object[]{orgId, startDate, endDate, writeoffTypeId, wfStartDate, wfEndDate})) {
            return dto;
        }
        ArrayList<QFilter> defaultFilters = new ArrayList<QFilter>();
        defaultFilters.add(new QFilter("taxorg", "=", (Object)orgId));
        defaultFilters.add(new QFilter("writeofftypeid", "=", (Object)writeoffTypeId));
        defaultFilters.add(new QFilter("createtime", ">=", (Object)wfStartDate).and(new QFilter("createtime", "<=", (Object)DateUtils.getDayLast((Date)wfEndDate))));
        QFilter bqPzjzDateFilter = new QFilter("entry.pzjzdate", ">=", (Object)startDate).and(new QFilter("entry.pzjzdate", "<=", (Object)DateUtils.getDayLast((Date)endDate)));
        QFilter bqInvoiceDateFilter = new QFilter("entry.invoicedate", ">=", (Object)startDate).and(new QFilter("entry.invoicedate", "<=", (Object)DateUtils.getDayLast((Date)endDate)));
        QFilter notSingleWfFilter = new QFilter("entry.billid", ">", (Object)0L).and(new QFilter("entry.assbillid", ">", (Object)0L));
        ArrayList<Object> filterList = new ArrayList<QFilter>(defaultFilters);
        filterList.add(bqInvoiceDateFilter);
        filterList.add(bqPzjzDateFilter);
        filterList.add(notSingleWfFilter);
        DynamicObjectCollection entry = this.wfRecordDao.queryWfEntryData(filterList);
        dto.setEntry(entry);
        QFilter wqInvoiceDateFilter = new QFilter("entry.invoicedate", "<", (Object)startDate);
        filterList = new ArrayList(defaultFilters);
        filterList.add(wqInvoiceDateFilter);
        filterList.add(bqPzjzDateFilter);
        filterList.add(notSingleWfFilter);
        DynamicObjectCollection entry1 = this.wfRecordDao.queryWfEntryData(filterList);
        dto.setEntry1(entry1);
        QFilter wqPzjzDateFilter = new QFilter("entry.pzjzdate", "<", (Object)startDate);
        filterList = new ArrayList(defaultFilters);
        filterList.add(bqInvoiceDateFilter);
        filterList.add(wqPzjzDateFilter);
        filterList.add(notSingleWfFilter);
        DynamicObjectCollection entry2 = this.wfRecordDao.queryWfEntryData(filterList);
        dto.setEntry2(entry2);
        DynamicObject writeOffType = this.wfRecordDao.loadWriteOffTypeById(writeoffTypeId);
        ArrayList<QFilter> billFilters = new ArrayList<QFilter>();
        TaxResult accountingOrgId = OrgRelationDataServiceHelper.getAccountingOrgIdByTaxcOrgId((Long)orgId);
        List data = (List)accountingOrgId.getData();
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            orgFilter.or(new QFilter("org", "in", (Object)data));
        }
        billFilters.add(orgFilter);
        billFilters.add(new QFilter("voucherdate", ">=", (Object)startDate).and(new QFilter("voucherdate", "<=", (Object)DateUtils.getDayLast((Date)endDate))));
        this.analysisFilter(writeOffType, billFilters, "tdm_recording_voucher_new");
        DynamicObjectCollection entry3 = this.collectVoucherData(Boolean.FALSE, "id,voucherdate as pzjzdate,vouchercode as kjpzh,voucherrow as pzhh,billno as subbillno,balance,debitlocalcurrency,creditlocalcurrency,writeoff,0.0 as je,0.0 as nowriteoff,verifymatch", billFilters, writeoffTypeId, wfEndDate);
        dto.setEntry3(entry3);
        ArrayList<QFilter> invoiceFilters = new ArrayList<QFilter>();
        invoiceFilters.add(new QFilter("taxorg", "=", (Object)orgId));
        invoiceFilters.add(new QFilter("issuetime", ">=", (Object)startDate).and(new QFilter("issuetime", "<=", (Object)DateUtils.getDayLast((Date)endDate))));
        this.analysisFilter(writeOffType, invoiceFilters, "sim_vatinvoice");
        DynamicObjectCollection entry4 = this.collectInvoiceData(invoiceFilters, writeoffTypeId, wfEndDate);
        dto.setEntry4(entry4);
        return dto;
    }

    public AccInvCompareResultDto generateInResult(AccInvCompareResultDto dto) {
        Long orgId = (Long)dto.getOrgId();
        Date startDate = (Date)dto.getStartDate();
        Date endDate = (Date)dto.getEndDate();
        Long writeoffTypeId = dto.getWriteoffTypeId();
        Date wfStartDate = dto.getWfStartDate();
        Date wfEndDate = dto.getWfEndDate();
        if (ObjectUtils.anyNull((Object[])new Object[]{orgId, startDate, endDate, writeoffTypeId, wfStartDate, wfEndDate})) {
            return dto;
        }
        ArrayList<QFilter> defaultFilters = new ArrayList<QFilter>();
        defaultFilters.add(new QFilter("taxorg", "=", (Object)orgId));
        defaultFilters.add(new QFilter("writeofftypeid", "=", (Object)writeoffTypeId));
        defaultFilters.add(new QFilter("createtime", ">=", (Object)wfStartDate).and(new QFilter("createtime", "<=", (Object)DateUtils.getDayLast((Date)wfEndDate))));
        QFilter voucherdateFilter = new QFilter("entry.voucherdate", ">=", (Object)startDate).and(new QFilter("entry.voucherdate", "<=", (Object)DateUtils.getDayLast((Date)endDate)));
        QFilter notSingleWfFilter = new QFilter("entry.billid", ">", (Object)0L).and(new QFilter("entry.assbillid", ">", (Object)0L));
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(defaultFilters);
        filterList.add(voucherdateFilter);
        filterList.add(notSingleWfFilter);
        DynamicObjectCollection entry = this.wfRecordDao.queryInWfEntryData(filterList);
        dto.setEntry(entry);
        DynamicObject writeOffType = this.wfRecordDao.loadWriteOffTypeById(writeoffTypeId);
        ArrayList<QFilter> billFilters = new ArrayList<QFilter>();
        billFilters.add(new QFilter("org", "=", (Object)orgId));
        billFilters.add(new QFilter("voucherdate", ">=", (Object)startDate).and(new QFilter("voucherdate", "<=", (Object)DateUtils.getDayLast((Date)endDate))));
        this.analysisFilter(writeOffType, billFilters, "tdm_recording_voucher_new");
        DynamicObjectCollection entry1 = this.collectVoucherData(Boolean.TRUE, "id,voucherdate,vouchercode,voucherrow,billno as subbillno,balance,debitlocalcurrency,creditlocalcurrency,writeoff,0.0 as je,0.0 as nowriteoff,verifymatch", billFilters, writeoffTypeId, wfEndDate);
        dto.setEntry1(entry1);
        ArrayList<QFilter> invoiceFilters = new ArrayList<QFilter>();
        invoiceFilters.add(new QFilter("tax_org", "=", (Object)orgId));
        invoiceFilters.add(new QFilter("original_time", ">=", (Object)startDate).and(new QFilter("original_time", "<=", (Object)DateUtils.getDayLast((Date)endDate))));
        this.analysisFilter(writeOffType, invoiceFilters, "rim_invoice");
        DynamicObjectCollection entry2 = this.collectInInvoiceData(invoiceFilters, writeoffTypeId, wfEndDate);
        dto.setEntry2(entry2);
        return dto;
    }

    public String exportAccInvCompareResult(String entity, List<String> suffixList, Long id) {
        String urls;
        DynamicObject accInvComp = this.wfRecordDao.loadAccInvCompareResult(entity, id);
        if (accInvComp == null) {
            return null;
        }
        ArrayList<MultipleSheetPropety> multipleData = new ArrayList<MultipleSheetPropety>(8);
        int index = 0;
        for (String suffix : suffixList) {
            String entryName = "entryentity" + suffix;
            List<? extends BaseRowModel> data = this.getExportData(accInvComp, entity, entryName, suffix);
            if (!CollectionUtils.isNotEmpty(data)) continue;
            MultipleSheetPropety multipleSheet = new MultipleSheetPropety();
            multipleSheet.setData(data);
            Sheet sheet = new Sheet(++index, 0);
            sheet.setSheetName(entryNameMap.getOrDefault(entity + "#" + entryName, entryName));
            sheet.setAutoWidth(Boolean.TRUE);
            multipleSheet.setSheet(sheet);
            multipleData.add(multipleSheet);
        }
        File file = ExportExcelUtils.exportExcelWithMultipleSheet(multipleData, null);
        if (file == null) {
            return null;
        }
        String fileName = accInvComp.getString("billno") + accInvComp.getString("org.name") + DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmssSS");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)fis, 5000);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
        return urls;
    }

    private List<BOSExpression> analysisFilter(DynamicObject writeOffType, List<QFilter> filters, String entityName) {
        String selectFields;
        ArrayList<BOSExpression> expressions = new ArrayList<BOSExpression>();
        writeOffType.getDynamicObjectCollection("writeoffbillentry").stream().filter(o -> o.getDynamicObject("writeoffbilltype") != null && o.getDynamicObject("writeoffbilltype").getString("number").equals(entityName)).forEach(o -> {
            BOSExpression cexpr;
            String cfilterJson = o.getString("cfilterconditiondesc_tag");
            QFilter cfilter = this.parseFilter(cfilterJson, entityName);
            if (cfilter != null) {
                filters.add(cfilter);
            }
            if ((cexpr = this.parseExpr(cfilterJson)) != null && CollectionUtils.isNotEmpty((Collection)cexpr.getVars())) {
                expressions.add(cexpr);
            }
        });
        if (CollectionUtils.isNotEmpty(expressions) && StringUtils.isNotBlank((CharSequence)(selectFields = this.parseFields(expressions, entityName)))) {
            DynamicObjectCollection collection = this.wfRecordDao.queryData(entityName, filters, selectFields);
            List ids = collection.stream().filter(o -> expressions.stream().allMatch(e -> this.exprFilter((BOSExpression)e, (DynamicObject)o))).map(o -> o.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("id", "in", ids));
        }
        return expressions;
    }

    public QFilter parseFilter(String jsonCondition, String entityName) {
        if (jsonCondition == null || jsonCondition.trim().isEmpty()) {
            return null;
        }
        JSONObject jsonObject = (JSONObject)SerializationUtils.fromJsonString((String)jsonCondition, JSONObject.class);
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)jsonObject.getJSONObject("filterCondition")), FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityName), condition);
        fb.setUserService((IUserService)new UserService());
        fb.buildFilter();
        return fb.getQFilter();
    }

    public BOSExpression parseExpr(String filterJson) {
        if (StringUtils.isNotBlank((CharSequence)filterJson)) {
            JSONObject jsonObject = (JSONObject)SerializationUtils.fromJsonString((String)filterJson, JSONObject.class);
            return new BOSExpression(jsonObject.getString("expression"));
        }
        return null;
    }

    public boolean exprFilter(BOSExpression expr, DynamicObject bill) {
        HashMap<String, Object> ctx = new HashMap<String, Object>(16);
        Set vars = expr.getVars();
        if (vars.isEmpty()) {
            return true;
        }
        for (String var : vars) {
            ctx.put(var, bill.get(var));
        }
        return (Boolean)FormulaEngine.execExcelFormula((Expr)expr.getExpr(), ctx, null);
    }

    private String parseFields(List<BOSExpression> expressions, String entityName) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        HashSet<String> fields = new HashSet<String>();
        for (BOSExpression expression : expressions) {
            Set vars = expression.getVars();
            for (String var : vars) {
                IDataEntityProperty property = entityType.findProperty(var);
                IDataEntityType parent = property.getParent();
                if (parent instanceof EntryType) {
                    fields.add(parent.getName() + "." + var + " as " + var);
                    continue;
                }
                fields.add(var);
            }
        }
        if (CollectionUtils.isNotEmpty(fields)) {
            return "id," + String.join((CharSequence)",", fields);
        }
        return null;
    }

    private List<? extends BaseRowModel> getExportData(DynamicObject data, String entityName, String entryName, String suffix) {
        DynamicObjectCollection col = data.getDynamicObjectCollection(entryName);
        String pluginName = "kd.taxc.tcvat.common.dto.wfrecord.AccInvCompareEntryExportDto";
        pluginName = pluginNameMap.getOrDefault(entityName + "#" + entryName, pluginName);
        List result = BeanUtils.dynamicToDto((String)pluginName, null, (DynamicObjectCollection)col, (String)suffix);
        return result;
    }

    private DynamicObjectCollection collectVoucherData(boolean isIn, String selectFields, List<QFilter> filters, Long writeOffTypeId, Date wfEndDate) {
        DynamicObjectCollection collection = this.wfRecordDao.queryVoucherData(selectFields, filters);
        List<Long> ids = collection.stream().map(dyo -> dyo.getLong("id")).collect(Collectors.toList());
        Map<String, List<DynamicObject>> map = this.queryWfEntryMap(isIn, writeOffTypeId, wfEndDate, "billid", ids);
        for (DynamicObject dyo2 : collection) {
            BigDecimal je = dyo2.getBigDecimal("debitlocalcurrency").add(dyo2.getBigDecimal("creditlocalcurrency"));
            BigDecimal writeoff = dyo2.getBigDecimal("writeoff");
            dyo2.set("je", (Object)je);
            if (BigDecimal.ZERO.compareTo(writeoff) == 0) {
                dyo2.set("nowriteoff", (Object)je);
                continue;
            }
            List<DynamicObject> wfRecords = map.getOrDefault(dyo2.getString("id"), (List<DynamicObject>)new DynamicObjectCollection());
            BigDecimal writeOffSum = wfRecords.stream().map(o -> o.getBigDecimal("nowriteoff")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            dyo2.set("nowriteoff", (Object)je.subtract(writeOffSum));
        }
        collection.removeIf(o -> BigDecimal.ZERO.compareTo(o.getBigDecimal("nowriteoff")) == 0);
        return collection;
    }

    private DynamicObjectCollection collectInvoiceData(List<QFilter> filters, Long writeOffTypeId, Date wfEndDate) {
        DynamicObjectCollection collection = this.wfRecordDao.queryData("sim_vatinvoice", filters, "items.id as id,invoicecode,invoiceno,issuetime as invoicedate,invoicetype,invoicestatus,buyername,items.goodsname as goodsname,items.amount as invoiceamount,items.taxrate as taxrate,items.tax as taxamount,items.writeoffamt as writeoffamt,0.0 as nowriteoff");
        List<Long> ids = collection.stream().map(dyo -> dyo.getLong("id")).collect(Collectors.toList());
        Map<String, List<DynamicObject>> map = this.queryWfEntryMap(Boolean.FALSE, writeOffTypeId, wfEndDate, "assbillentryid", ids);
        for (DynamicObject dyo2 : collection) {
            BigDecimal amount = dyo2.getBigDecimal("invoiceamount");
            BigDecimal writeoff = dyo2.getBigDecimal("writeoffamt");
            if (BigDecimal.ZERO.compareTo(writeoff) == 0) {
                dyo2.set("nowriteoff", (Object)amount);
                continue;
            }
            List<DynamicObject> wfRecords = map.getOrDefault(dyo2.getString("id"), (List<DynamicObject>)new DynamicObjectCollection());
            BigDecimal writeOffSum = wfRecords.stream().map(o -> o.getBigDecimal("curwfdata")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            dyo2.set("nowriteoff", (Object)amount.subtract(writeOffSum));
        }
        collection.removeIf(o -> BigDecimal.ZERO.compareTo(o.getBigDecimal("nowriteoff")) == 0);
        return collection;
    }

    private DynamicObjectCollection collectInInvoiceData(List<QFilter> filters, Long writeOffTypeId, Date wfEndDate) {
        DynamicObjectCollection collection = this.wfRecordDao.queryData("rim_invoice", filters, "id,invoice_code as invoicecode,invoice_no as invoiceno,original_time as originaltime,invoice_info as invoiceinfo,authenticate_flag as authenticateflag,saler_name as salername,invoice_amount as invoiceamount,total_tax_amount as taxamount,writeoffamt,writeofftax,0.0 as nowriteoff");
        List<Long> ids = collection.stream().map(dyo -> dyo.getLong("id")).collect(Collectors.toList());
        Map<String, List<DynamicObject>> map = this.queryWfEntryMap(Boolean.TRUE, writeOffTypeId, wfEndDate, "assbillentryid", ids);
        for (DynamicObject dyo2 : collection) {
            BigDecimal amount = dyo2.getBigDecimal("taxamount");
            BigDecimal writeoff = dyo2.getBigDecimal("writeofftax");
            if (BigDecimal.ZERO.compareTo(writeoff) == 0) {
                dyo2.set("nowriteoff", (Object)amount);
                continue;
            }
            List<DynamicObject> wfRecords = map.getOrDefault(dyo2.getString("id"), (List<DynamicObject>)new DynamicObjectCollection());
            BigDecimal writeOffSum = wfRecords.stream().map(o -> o.getBigDecimal("curwfdata")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            dyo2.set("nowriteoff", (Object)amount.subtract(writeOffSum));
        }
        collection.removeIf(o -> BigDecimal.ZERO.compareTo(o.getBigDecimal("nowriteoff")) == 0);
        return collection;
    }

    private Map<String, List<DynamicObject>> queryWfEntryMap(boolean isIn, Long writeOffTypeId, Date wfEndDate, String billIdName, List<Long> billIds) {
        QFilter writeOffTypeIdFilter = new QFilter("writeofftypeid", "=", (Object)writeOffTypeId);
        QFilter billIdFilter = new QFilter("entry." + billIdName, "in", billIds);
        QFilter wfDateFilter = new QFilter("createtime", "<=", (Object)DateUtils.getDayLast((Date)wfEndDate));
        QFilter notSingleWfFilter = new QFilter("entry.billid", ">", (Object)0L).and(new QFilter("entry.assbillid", ">", (Object)0L));
        DynamicObjectCollection wfRecords = isIn ? this.wfRecordDao.queryInWfEntryData("assbillentryid".equals(billIdName) ? Arrays.asList(writeOffTypeIdFilter, billIdFilter, wfDateFilter) : Arrays.asList(writeOffTypeIdFilter, billIdFilter, wfDateFilter, notSingleWfFilter)) : this.wfRecordDao.queryWfEntryData(Arrays.asList(writeOffTypeIdFilter, billIdFilter, wfDateFilter, notSingleWfFilter));
        return wfRecords.stream().collect(Collectors.groupingBy(o -> o.getString(billIdName)));
    }
}

