/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.wkpsr;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TcvatWkpsrService {
    private static final Log LOGGER = LogFactory.getLog(TcvatWkpsrService.class);
    private static final String WKPSR_DATA = "tcvat_wkpsr_data";
    private static volatile TcvatWkpsrService wkpsrService = null;

    private TcvatWkpsrService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TcvatWkpsrService getInstance() {
        if (wkpsrService != null) return wkpsrService;
        Class<TcvatWkpsrService> clazz = TcvatWkpsrService.class;
        synchronized (TcvatWkpsrService.class) {
            if (wkpsrService != null) return wkpsrService;
            wkpsrService = new TcvatWkpsrService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return wkpsrService;
        }
    }

    public void syncWkpsrData(String orgIdStr, String skssqqStr, String skssqzStr, String templateType, String sbbid) {
        if (orgIdStr == null || skssqqStr == null || skssqzStr == null || templateType == null || sbbid == null) {
            return;
        }
        long orgId = Long.parseLong(orgIdStr);
        Date skssqq = DateUtils.stringToDate((String)skssqqStr);
        Date skssqz = DateUtils.stringToDate((String)skssqzStr);
        DynamicObject declareMain = this.getDeclareMain(orgIdStr, skssqqStr, skssqzStr, templateType);
        QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)sbbid);
        QFilter ewblxhFilter = new QFilter("ewblxh", "!=", (Object)"1");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter sqFilter = new QFilter("skssqq", "=", (Object)skssqq).and("skssqz", "=", (Object)skssqz);
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(16);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)WKPSR_DATA);
        for (int i = 1; i < 14; ++i) {
            DynamicObject[] datas;
            String entityName = WKPSR_DATA + i;
            DynamicObjectCollection dataIds = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{sbbidFilter, ewblxhFilter});
            if (dataIds.isEmpty()) continue;
            for (DynamicObject data : datas = BusinessDataServiceHelper.load((Object[])dataIds.stream().map(o -> o.get("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName))) {
                DynamicObject save = new DynamicObject((DynamicObjectType)dataEntityType);
                save.set("org", (Object)orgId);
                save.set("skssqq", (Object)skssqq);
                save.set("skssqz", (Object)skssqz);
                save.set("billstatus", (Object)declareMain.getString("billstatus"));
                this.copyDynamicObject(data, save);
                saveList.add(save);
            }
        }
        if (!saveList.isEmpty()) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    DeleteServiceHelper.delete((String)WKPSR_DATA, (QFilter[])new QFilter[]{orgFilter, sqFilter});
                    SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
                }
                catch (Throwable t) {
                    LOGGER.error(t);
                    h.markRollback();
                }
            }
        }
    }

    public void updateWkpsrDataBillStatus(String sbbid, String billstatus) {
        if (sbbid == null || billstatus == null) {
            return;
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)WKPSR_DATA, (String)"id", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbid)});
        List ids = query.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        if (!ids.isEmpty()) {
            DynamicObject[] load;
            for (DynamicObject data : load = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)WKPSR_DATA))) {
                data.set("billstatus", (Object)billstatus);
            }
            SaveServiceHelper.update((DynamicObject[])load);
        }
    }

    public void deleteWkpsrDataSource(List<String> sbbidList) {
        DeleteServiceHelper.delete((String)WKPSR_DATA, (QFilter[])new QFilter[]{new QFilter("sbbid", "in", sbbidList)});
    }

    private void copyDynamicObject(DynamicObject source, DynamicObject target) {
        DataEntityPropertyCollection properties = source.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if ("id".equals(name)) continue;
            target.set(name, source.get(name));
        }
    }

    private DynamicObject getDeclareMain(String orgid, String startDate, String endDate, Object type) {
        QFilter q1 = new QFilter("org", "=", (Object)Long.valueOf(orgid));
        QFilter q2 = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)startDate));
        QFilter q3 = new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)endDate));
        QFilter q4 = new QFilter("type", "=", type);
        return QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id,billstatus,billno,zerodeclare", (QFilter[])new QFilter[]{q1, q2, q3, q4});
    }
}

