/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.common.enums;

import kd.taxc.tcvat.business.service.sjjt.provisionitem.ProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.ybnsr.ActualDeductionProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.ybnsr.DeductionProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.ybnsr.FjsfCswhjssProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.ybnsr.FjsfDfjyffjProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.ybnsr.FjsfJyffjProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.ybnsr.UnpaidVATProvisionItemStrategy;

public enum ProvisionItemStrategyEnum {
    ACTUALDEDUCTION("JTSX-0009", new ActualDeductionProvisionItemStrategy()),
    UNPAIDVAT("JTSX-0010", new UnpaidVATProvisionItemStrategy()),
    DEDUCTION("JTSX-0011", new DeductionProvisionItemStrategy()),
    ZZSFJ_CSWHJSS("JTSX-0012", new FjsfCswhjssProvisionItemStrategy()),
    ZZSFJ_JYFFJ("JTSX-0013", new FjsfJyffjProvisionItemStrategy()),
    ZZSFJ_DFJYFFJ("JTSX-0014", new FjsfDfjyffjProvisionItemStrategy());

    private String provisionItemNumber;
    private ProvisionItemStrategy strategy;

    private ProvisionItemStrategyEnum(String provisionItemNumber, ProvisionItemStrategy strategy) {
        this.provisionItemNumber = provisionItemNumber;
        this.strategy = strategy;
    }

    public String getProvisionItemNumber() {
        return this.provisionItemNumber;
    }

    public ProvisionItemStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(ProvisionItemStrategy strategy) {
        this.strategy = strategy;
    }

    public static ProvisionItemStrategy getStrategyByNumber(String provisionItemNumber) {
        for (ProvisionItemStrategyEnum value : ProvisionItemStrategyEnum.values()) {
            if (!value.getProvisionItemNumber().equals(provisionItemNumber)) continue;
            return value.getStrategy();
        }
        return null;
    }
}

