/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;

public enum RuleTypeStrategyEnum {
    INCOME("income", "tcvat_rule_income", "VAT-RULE-INCOME", 1870263476069751808L){

        @Override
        public List<IListColumn> getListColumnByRuleType() {
            HashMap<String, String> columnMap = new HashMap<String, String>(){
                {
                    this.put("taxation.name", ResManager.loadKDString((String)"\u5f81\u6536\u65b9\u5f0f", (String)"RuleTypeStrategyEnum_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                    this.put("taxrate.name", ResManager.loadKDString((String)"\u7a0e\u7387/\u5f81\u6536\u7387", (String)"RuleTypeStrategyEnum_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                    this.put("jzjt", ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u4e1a\u52a1", (String)"RuleTypeStrategyEnum_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
            };
            return 1.getiListColumnsList((Map<String, String>)columnMap);
        }
    }
    ,
    ROLLOUT("rollout", "tcvat_rule_rollout", "VAT-RULE-TOIT", 1870265525532515328L){

        @Override
        public List<IListColumn> getListColumnByRuleType() {
            HashMap<String, String> columnMap = new HashMap<String, String>(){
                {
                    this.put("rollouttype.value", ResManager.loadKDString((String)"\u8f6c\u51fa\u7c7b\u578b", (String)"RuleTypeStrategyEnum_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                    this.put("jzjt", ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u4e1a\u52a1", (String)"RuleTypeStrategyEnum_4", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
            };
            return 2.getiListColumnsList((Map<String, String>)columnMap);
        }
    }
    ,
    DEDUCT("deduct", "tcvat_rule_deduct", "VAT-RULE-INPUT", 1870264820906220544L){

        @Override
        public List<IListColumn> getListColumnByRuleType() {
            HashMap<String, String> columnMap = new HashMap<String, String>(){
                {
                    this.put("deducttype.name", ResManager.loadKDString((String)"\u62b5\u6263\u7c7b\u578b", (String)"RuleTypeStrategyEnum_5", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
            };
            return 3.getiListColumnsList((Map<String, String>)columnMap);
        }
    }
    ,
    JZJTJXSE("jzjtintax", "tcvat_rule_jzjt_jxse", "VAT-RULE-JZJT", 1952160271401603072L){

        @Override
        public List<IListColumn> getListColumnByRuleType() {
            HashMap<String, String> columnMap = new HashMap<String, String>(){
                {
                    this.put("jzjtlx", ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u7c7b\u578b", (String)"RuleTypeStrategyEnum_6", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
            };
            return 4.getiListColumnsList((Map<String, String>)columnMap);
        }
    }
    ,
    DIFF("diff", "tcvat_rule_diff", "VAT-RULE-DIFF", 1870264280101051392L){

        @Override
        public List<IListColumn> getListColumnByRuleType() {
            HashMap<String, String> columnMap = new HashMap<String, String>(){
                {
                    this.put("difftype.value", ResManager.loadKDString((String)"\u5dee\u989d\u6263\u9664\u7c7b\u578b", (String)"RuleTypeStrategyEnum_7", (String)"taxc-tcvat", (Object[])new Object[0]));
                    this.put("deductproject", ResManager.loadKDString((String)"\u6263\u9664\u9879\u76ee", (String)"RuleTypeStrategyEnum_19", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
            };
            return 5.getiListColumnsList((Map<String, String>)columnMap);
        }
    }
    ,
    PERPRE("perpre", "tcvat_rule_perpre", "VAT-RULE-PERPRE", 1870265821113505792L){

        @Override
        public List<IListColumn> getListColumnByRuleType() {
            HashMap<String, String> columnMap = new HashMap<String, String>(){
                {
                    this.put("perpreproduct.value", ResManager.loadKDString((String)"\u5206\u6b21\u9884\u7f34\u9879\u76ee\u7c7b\u578b", (String)"RuleTypeStrategyEnum_8", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
            };
            return 6.getiListColumnsList((Map<String, String>)columnMap);
        }
    }
    ,
    DEDUCTION("deduction", "tcvat_rule_deduction", "VAT-RULE-RELIEFS", 1870266078643771392L){

        @Override
        public List<IListColumn> getListColumnByRuleType() {
            HashMap<String, String> columnMap = new HashMap<String, String>(){
                {
                    this.put("reductiontype", ResManager.loadKDString((String)"\u51cf\u7a0e\u9879\u76ee\u7c7b\u578b", (String)"RuleTypeStrategyEnum_9", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
            };
            return 7.getiListColumnsList((Map<String, String>)columnMap);
        }
    }
    ,
    MDTS("mdts", "tcvat_rule_mdts", "VAT-RULE-ExportRefund", 1870266309020112896L){

        @Override
        public List<IListColumn> getListColumnByRuleType() {
            HashMap<String, String> columnMap = new HashMap<String, String>(){
                {
                    this.put("mdtype", ResManager.loadKDString((String)"\u9000\u7a0e\u7c7b\u578b", (String)"RuleTypeStrategyEnum_10", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
            };
            return 8.getiListColumnsList((Map<String, String>)columnMap);
        }
    }
    ,
    PREPAY("prepay", "tcvat_rule_prepay", "VAT-RULE-PRE", 1889922790833095680L){

        @Override
        public List<IListColumn> getListColumnByRuleType() {
            return new ArrayList<IListColumn>(0);
        }
    }
    ,
    APPORTION("apportion", "tcvat_rule_apportion", "VAT-Prorate", 1890543755803520000L){

        @Override
        public List<IListColumn> getListColumnByRuleType() {
            HashMap<String, String> columnMap = new HashMap<String, String>(){
                {
                    this.put("wfhfzclx", ResManager.loadKDString((String)"\u65e0\u6cd5\u5212\u5206\u8f6c\u51fa\u7c7b\u578b", (String)"RuleTypeStrategyEnum_11", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
            };
            return 10.getiListColumnsList((Map<String, String>)columnMap);
        }
    }
    ,
    WKPSR("wkpsr", "tcvat_rule_wkpsr", "VAT-UNINRE", 1890632930188217344L){

        @Override
        public List<IListColumn> getListColumnByRuleType() {
            HashMap<String, String> columnMap = new HashMap<String, String>(){
                {
                    this.put("rulename.taxation.name", ResManager.loadKDString((String)"\u5f81\u6536\u65b9\u5f0f", (String)"RuleTypeStrategyEnum_12", (String)"taxc-tcvat", (Object[])new Object[0]));
                    this.put("rulename.taxrate.name", ResManager.loadKDString((String)"\u7a0e\u7387/\u5f81\u6536\u7387", (String)"RuleTypeStrategyEnum_13", (String)"taxc-tcvat", (Object[])new Object[0]));
                    this.put("rulename.jzjt", ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u4e1a\u52a1", (String)"RuleTypeStrategyEnum_14", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
            };
            return 11.getiListColumnsList((Map<String, String>)columnMap);
        }
    }
    ,
    PRODUCT("product", "tcvat_ncp_product_rule", "VAT-RULE-FP", 1891260790015877120L){

        @Override
        public List<IListColumn> getListColumnByRuleType() {
            HashMap<String, String> columnMap = new HashMap<String, String>(){
                {
                    this.put("cpmc", ResManager.loadKDString((String)"\u4ea7\u54c1\u540d\u79f0", (String)"RuleTypeStrategyEnum_15", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
            };
            return 12.getiListColumnsList((Map<String, String>)columnMap);
        }
    }
    ,
    NCP("ncp", "tcvat_ncp_rule", "VAT-RULE-AP", 1891260951278477312L){

        @Override
        public List<IListColumn> getListColumnByRuleType() {
            HashMap<String, String> columnMap = new HashMap<String, String>(){
                {
                    this.put("ylfl", ResManager.loadKDString((String)"\u7528\u9014", (String)"RuleTypeStrategyEnum_16", (String)"taxc-tcvat", (Object[])new Object[0]));
                    this.put("hyncp", ResManager.loadKDString((String)"\u8017\u7528\u519c\u4ea7\u54c1\u540d\u79f0", (String)"RuleTypeStrategyEnum_17", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
            };
            return 13.getiListColumnsList((Map<String, String>)columnMap);
        }
    }
    ,
    LDTS("ldts", "tcvat_rule_refund", "VAT-RULE-LDTS", 1891379881984783360L){

        @Override
        public List<IListColumn> getListColumnByRuleType() {
            HashMap<String, String> columnMap = new HashMap<String, String>(){
                {
                    this.put("refundtype", ResManager.loadKDString((String)"\u9000\u7a0e\u4f01\u4e1a\u7c7b\u578b", (String)"RuleTypeStrategyEnum_18", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
            };
            return 14.getiListColumnsList((Map<String, String>)columnMap);
        }
    }
    ,
    refund("refund", "tcvat_rule_incomeproject", "VAT-RULE-refund", 1891408507782290432L){

        @Override
        public List<IListColumn> getListColumnByRuleType() {
            return new ArrayList<IListColumn>(0);
        }
    }
    ,
    JZJTXX("JZJTXX", "tcvat_rule_outputproject", "VAT-RULE-JZJTX", 1891408824250915840L){

        @Override
        public List<IListColumn> getListColumnByRuleType() {
            return new ArrayList<IListColumn>(0);
        }
    }
    ,
    DEFAULT("default", "", "", 0L){

        @Override
        public List<IListColumn> getListColumnByRuleType() {
            return new ArrayList<IListColumn>(0);
        }
    };

    private String ruleType;
    private String formId;
    private String ruleNumber;
    private Long groupId;

    public static List<IListColumn> getiListColumnsList(Map<String, String> columnMap) {
        ArrayList<IListColumn> list = new ArrayList<IListColumn>(5);
        for (Map.Entry<String, String> entry : columnMap.entrySet()) {
            ListColumn taxationColumn = new ListColumn();
            taxationColumn.setListFieldKey(entry.getKey());
            taxationColumn.setBlankFieldCanOrderAndFilter(true);
            taxationColumn.setCaption(new LocaleString(entry.getValue()));
            list.add((IListColumn)taxationColumn);
        }
        return list;
    }

    public String getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(String ruleType) {
        this.ruleType = ruleType;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public String getRuleNumber() {
        return this.ruleNumber;
    }

    public void setRuleNumber(String ruleNumber) {
        this.ruleNumber = ruleNumber;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    private RuleTypeStrategyEnum(String ruleType, String formId, String ruleNumber, Long groupId) {
        this.ruleType = ruleType;
        this.formId = formId;
        this.ruleNumber = ruleNumber;
        this.groupId = groupId;
    }

    public static RuleTypeStrategyEnum getStrategyByGroupId(String groupId) {
        for (RuleTypeStrategyEnum value : RuleTypeStrategyEnum.values()) {
            if (!value.groupId.toString().equals(groupId)) continue;
            return value;
        }
        return DEFAULT;
    }

    public static String getFormIdByBillNumber(String ruleNumber) {
        for (RuleTypeStrategyEnum value : RuleTypeStrategyEnum.values()) {
            if (!value.ruleNumber.equals(ruleNumber)) continue;
            return value.formId;
        }
        return RuleTypeStrategyEnum.DEFAULT.formId;
    }

    public static Long getGroupIdByFormId(String formId) {
        for (RuleTypeStrategyEnum value : RuleTypeStrategyEnum.values()) {
            if (!value.formId.equals(formId)) continue;
            return value.groupId;
        }
        return RuleTypeStrategyEnum.DEFAULT.groupId;
    }

    public abstract List<IListColumn> getListColumnByRuleType();
}

