/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.common.enums;

import kd.taxc.tcvat.business.service.draft.strategy.TcvatStrategy;
import kd.taxc.tcvat.business.service.draft.strategy.impl.XgmnsrStrategyImpl;
import kd.taxc.tcvat.business.service.draft.strategy.impl.YbhzStrategyImpl;
import kd.taxc.tcvat.business.service.draft.strategy.impl.YbhzZjgStrategyImpl;
import kd.taxc.tcvat.business.service.draft.strategy.impl.Ybhzyz3StrategyImpl;
import kd.taxc.tcvat.business.service.draft.strategy.impl.YbhzyzStrategyImpl;
import kd.taxc.tcvat.business.service.draft.strategy.impl.YbnsrStrategyImpl;

public enum StrategyEnum {
    ZZSYBNSR("zzsybnsr", new YbnsrStrategyImpl()),
    ZZSXGMNSR("zzsxgmnsr", new XgmnsrStrategyImpl()),
    DRAFT_ZZSXGMNSR("draft_zzsxgmnsr", new XgmnsrStrategyImpl()),
    ZZSYBNSR_YBHZ("zzsybnsr_ybhz", new YbhzStrategyImpl()),
    ZZSYBNSR_HZ_ZJG("zzsybnsr_hz_zjg", new YbhzZjgStrategyImpl()),
    ZZSYBNSR_HZ_FZJG("zzsybnsr_hz_fzjg", new YbhzZjgStrategyImpl()),
    ZZSYBNSR_YZ_ZJG("zzsybnsr_yz_zjg", new YbhzyzStrategyImpl()),
    ZZSYBNSR_YZ_ZJG3("zzsybnsr_yz_zjg", new Ybhzyz3StrategyImpl());

    private String taxPayerType;
    private TcvatStrategy strategy;

    private StrategyEnum(String taxPayerType, TcvatStrategy strategy) {
        this.taxPayerType = taxPayerType;
        this.strategy = strategy;
    }

    public String getTaxPayerType() {
        return this.taxPayerType;
    }

    public void setTaxPayerType(String taxPayerType) {
        this.taxPayerType = taxPayerType;
    }

    public TcvatStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(TcvatStrategy strategy) {
        this.strategy = strategy;
    }

    public static StrategyEnum getByTaxPayerType(String taxPayerType) {
        for (StrategyEnum value : StrategyEnum.values()) {
            if (!value.taxPayerType.equals(taxPayerType)) continue;
            return value;
        }
        return ZZSYBNSR;
    }
}

