/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.common.enums;

public enum TaxPayerTypeEnum {
    ZZSYBNSR("zzsybnsr", "tcvat_taxdata_tab", "tcvat_history_policy", "tcvat_policy_confirm"),
    ZZSYBNSR_YZ_FZJG("zzsybnsr_yz_fzjg", "tcvat_taxdata_tab", "tcvat_history_policy", "tcvat_policy_confirm"),
    ZZSXGMNSR("zzsxgmnsr", "tcvat_xgm_taxdata_tab", "tcvat_history_policy", "tcvat_xgm_policy_confirm"),
    ZZSXGMNSRJIDU("zzsxgmnsrjidu", "tcvat_taxdata_tab", "tcvat_history_policy", "tcvat_xgm_policy_confirm"),
    ZZSYBNSR_ZJG("zzsybnsr_zjg", "tcvat_hz_taxdata_tab", "tcvat_history_policy", "tcvat_hz_policy_confirm"),
    ZZSYBNSR_FZJG("zzsybnsr_fzjg", "tcvat_fz_taxdata_tab", "tcvat_history_policy", "tcvat_fz_policy_confirm"),
    ZZSYBNSR_YBHZ("zzsybnsr_ybhz", "tcvat_hz_taxdata_tab", "tcvat_ybhz_history_policy", "tcvat_ybhz_policy_confirm"),
    ZZSYBNSR_HZ_ZJG("zzsybnsr_hz_zjg", "tcvat_hz_taxdata_tab", "tcvat_ybhz_history_policy", "tcvat_ybhz_policy_confirm"),
    ZZSYBNSR_YZ_ZJG("zzsybnsr_yz_zjg", "tcvat_hz_taxdata_tab", "tcvat_ybhz_history_policy", "tcvat_ybhz_policy_confirm"),
    ZZSYJSKB("zzsyjskb", "tcvat_project_accountlist", "", "");

    private String taxPayerType;
    private String accountPage;
    private String policyConfirmHistoryPage;
    private String policyConfirmPage;

    private TaxPayerTypeEnum(String taxPayerType, String accountPage, String policyConfirmHistoryPage, String policyConfirmPage) {
        this.taxPayerType = taxPayerType;
        this.accountPage = accountPage;
        this.policyConfirmHistoryPage = policyConfirmHistoryPage;
        this.policyConfirmPage = policyConfirmPage;
    }

    public static TaxPayerTypeEnum getEnumByTaxPayerType(String taxPayerType) {
        for (TaxPayerTypeEnum taxPayerTypeEnum : TaxPayerTypeEnum.values()) {
            if (!taxPayerTypeEnum.getTaxPayerType().equals(taxPayerType)) continue;
            return taxPayerTypeEnum;
        }
        return ZZSYBNSR;
    }

    public String getTaxPayerType() {
        return this.taxPayerType;
    }

    public String getAccountPage() {
        return this.accountPage;
    }

    public String getPolicyConfirmHistoryPage() {
        return this.policyConfirmHistoryPage;
    }

    public String getPolicyConfirmPage() {
        return this.policyConfirmPage;
    }
}

