/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.common.formula;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.refactor.formula.context.Context;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractCodeGetValueBasePlugin;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.rule.RuleService;

public class TdssqbTdhyFetchPlugin
extends AbstractCodeGetValueBasePlugin {
    private static final Log logger = LogFactory.getLog(TdssqbTdhyFetchPlugin.class);
    public static final String CELL_TDHYZZSXSE = "jbxx#tdhyzzsxse";
    public static final String CELL_TDHYTQQBXSE = "jbxx#tdhytqqbxse";

    public void setContext(Context context) {
        this.context = context;
    }

    public String query(Map<String, Object> param) {
        String cellKey = (String)param.get("cellKey");
        if (CELL_TDHYZZSXSE.equals(cellKey) || CELL_TDHYTQQBXSE.equals(cellKey)) {
            return this.getTdhyAmount(param, CELL_TDHYZZSXSE.equals(cellKey) ? "1" : "2");
        }
        return null;
    }

    private String getTdhyAmount(Map<String, Object> param, String suffix) {
        BigDecimal result = BigDecimal.ZERO;
        String start = (String)param.get("codePluginParam0");
        String end = (String)param.get("codePluginParam1");
        String dateRegex = "\\d{4}\\-(0[1-9]|1[012])";
        if (!start.matches(dateRegex) || !end.matches(dateRegex)) {
            return result.toString();
        }
        String orgId = (String)param.get("orgId");
        Date skssqq = DateUtils.stringToDate((String)start, (String)"yyyy-MM");
        Date skssqz = DateUtils.stringToDate((String)end, (String)"yyyy-MM");
        Map sharingAndOrgRules = RuleUtils.getSharingAndOrgRules((Long)Long.valueOf(orgId), (RuleTypeEnum)RuleTypeEnum.REFUND, null, (String)"");
        List rules = (List)sharingAndOrgRules.get(RuleTypeEnum.REFUND);
        RuleService ruleService = new RuleService();
        ArrayList<String> errors = new ArrayList<String>(16);
        for (DynamicObject rule : rules) {
            List<Date> dateList = this.getDateList(skssqq, skssqz);
            for (Date date : dateList) {
                TcvatEngineModel model = new TcvatEngineModel(orgId, DateUtils.format((Date)date), DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)date)));
                try {
                    List<DynamicObject> list = ruleService.calRuleEntryentityEntity(model, "tcvat_taxrefund_detail", rule, rule.getDynamicObjectCollection("entryentity" + suffix), suffix);
                    result = list.stream().map(e -> e.getBigDecimal("amount")).reduce(result, BigDecimal::add);
                }
                catch (Exception e2) {
                    errors.add("cal Sndmzcze By Rule is error !!!" + e2.toString());
                }
            }
        }
        logger.error(((Object)errors).toString());
        return result.toString();
    }

    private List<Date> getDateList(Date currentDate, Date targetDate) {
        ArrayList<Date> list = new ArrayList<Date>();
        while (currentDate.getTime() <= targetDate.getTime()) {
            list.add(currentDate);
            currentDate = DateUtils.addMonth((Date)currentDate, (int)1);
        }
        return list;
    }
}

