/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class PrepayRuleUtils {
    public static List<DynamicObject> getSharingAndProjectRules(List<Long> projectIds, Long excludingPlanId, boolean includingDisable) {
        ArrayList<DynamicObject> rules = new ArrayList<DynamicObject>();
        List<DynamicObject> sharingRules = PrepayRuleUtils.getSharingRules(projectIds, excludingPlanId, includingDisable);
        List<DynamicObject> privateRules = PrepayRuleUtils.getPrivateRules(projectIds, includingDisable);
        rules.addAll(sharingRules);
        rules.addAll(privateRules);
        return rules;
    }

    public static List<DynamicObject> getSharingRules(List<Long> projectIds, Long excludingPlanId, boolean includingDisable) {
        ArrayList<QFilter> planQfilters = new ArrayList<QFilter>();
        QFilter sharingProject = new QFilter("orgentity.prepayproject", "in", projectIds);
        planQfilters.add(sharingProject);
        if (excludingPlanId != null && excludingPlanId != 0L) {
            QFilter planIdFilter = new QFilter("id", "!=", (Object)excludingPlanId);
            planQfilters.add(planIdFilter);
        }
        ArrayList<DynamicObject> rules = new ArrayList<DynamicObject>();
        DynamicObjectCollection sharingRules = QueryServiceHelper.query((String)"tcvat_prepay_shareplan", (String)"ruleentity.rule as ruleid", (QFilter[])planQfilters.toArray(new QFilter[0]));
        if (sharingRules.size() > 0) {
            List rulePublicIdList = sharingRules.stream().map(r -> r.getLong("ruleid")).collect(Collectors.toList());
            Object[] rulearray = BusinessDataServiceHelper.load((Object[])rulePublicIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcvat_rule_prepay"));
            CollectionUtils.addAll(rules, (Object[])rulearray);
            if (!includingDisable) {
                rules.removeIf(rule -> !rule.getBoolean("enable"));
            }
        }
        return rules;
    }

    public static List<DynamicObject> getPrivateRules(List<Long> projectIds, boolean includingDisable) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        ArrayList<DynamicObject> rules = new ArrayList<DynamicObject>();
        filterList.add(new QFilter("prepayproject", "in", projectIds));
        filterList.add(new QFilter("ruletype", "=", (Object)"private"));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tcvat_rule_prepay", (String)"id", (QFilter[])filterList.toArray(new QFilter[0]));
        if (dynamicObjects.size() > 0) {
            List rulePublicIdList = dynamicObjects.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            Object[] rulearray = BusinessDataServiceHelper.load((Object[])rulePublicIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcvat_rule_prepay"));
            CollectionUtils.addAll(rules, (Object[])rulearray);
            if (!includingDisable) {
                rules.removeIf(rule -> !rule.getBoolean("enable"));
            }
        }
        return rules;
    }
}

