/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tcvat.business.service.taxrefund.TaxRefundCal;
import kd.taxc.tcvat.common.dto.base.ResponseDto;
import kd.taxc.tcvat.common.util.TcvatCommonUtil;

public class DataInitializationPlugin
extends AbstractListPlugin {
    private static String entrykey = "tcvat_initialization";

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("taxrefundperiod");
    }

    public void initialize() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addPackageDataListener(event -> this.packageData((PackageDataEvent)event));
    }

    public void packageData(PackageDataEvent e) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        DynamicObject d = e.getRowData();
        if (columnDesc.getKey().equals("taxrebatesjudge") || columnDesc.getKey().equals("incrementamount") || columnDesc.getKey().equals("thantaxperiod") || columnDesc.getKey().equals("taxspecialtickets") || columnDesc.getKey().equals("allspecialtickets")) {
            String taxrefundperiod = d.getString("taxrefundperiod");
            String taxrefundenterprise = d.getString("taxrefundenterprise");
            if ("A".equals(taxrefundenterprise)) {
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)taxrefundperiod) && taxrefundperiod.startsWith("2019-03")) {
                    e.setFormatValue((Object)"--");
                }
            } else if ("B".equals(taxrefundenterprise) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)taxrefundperiod) && (taxrefundperiod.startsWith("2019-03") || taxrefundperiod.startsWith("2019-04") || taxrefundperiod.startsWith("2019-05"))) {
                e.setFormatValue((Object)"--");
            }
        } else if (columnDesc.getKey().equals("taxrefundallowed") || columnDesc.getKey().equals("actualfundallowed")) {
            String taxrebatesjudge;
            String taxrefundperiod = d.getString("taxrefundperiod");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)taxrefundperiod) && taxrefundperiod.startsWith("2019-03")) {
                e.setFormatValue((Object)"--");
            }
            if (!(taxrebatesjudge = d.getString("taxrebatesjudge")).equals("1")) {
                e.setFormatValue((Object)"--");
            }
        } else if (columnDesc.getKey().equals("inputisproportional")) {
            String taxrefundperiod = d.getString("taxrefundperiod");
            if (StringUtils.isNotEmpty((CharSequence)taxrefundperiod) && taxrefundperiod.startsWith("2019-03")) {
                e.setFormatValue((Object)"--");
            } else {
                String taxrebatesjudge = d.getString("taxrebatesjudge");
                if (!taxrebatesjudge.equals("1")) {
                    e.setFormatValue((Object)"--");
                } else {
                    DecimalFormat df = new DecimalFormat("#0.00");
                    String str = df.format(Double.parseDouble(d.getString("inputisproportional")) * 100.0);
                    e.setFormatValue((Object)(str + "%"));
                }
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        String init;
        super.filterContainerInit(args);
        List list = null;
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            if (!filterColumn.getFieldName().startsWith("org.") || !(filterColumn instanceof CommonFilterColumn)) continue;
            list = filterColumn.getDefaultValues();
            break;
        }
        if (null == (init = this.getPageCache().get("init")) && null != list) {
            this.check(list);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterMap = args.getSearchClickEvent().getFilterValues();
        List customList = (List)filterMap.get("customfilter");
        if (customList != null && customList.size() > 0) {
            for (Map maps : customList) {
                List fieldName = (List)maps.get("FieldName");
                if (null == fieldName || fieldName.size() <= 0 || !((String)fieldName.get(0)).startsWith("org")) continue;
                List value = (List)maps.get("Value");
                this.check(value);
            }
        }
    }

    private void check(List<Object> list) {
        list.stream().filter(o -> !"".equals(o)).collect(Collectors.toList());
        for (Object orgid : list) {
            ResponseDto<String> isybnsr = TcvatCommonUtil.isYbnsr(orgid);
            if (!isybnsr.getSuccess().booleanValue()) {
                TcvatCommonUtil.showDtoMsg(this.getView(), isybnsr);
                break;
            }
            TaxRefundCal.taxInitCal(orgid + "", "A");
        }
        if (list.size() > 0) {
            this.getPageCache().put("init", list.get(0) + "");
        }
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("initialize".equals(key)) {
            String init = this.getPageCache().get("init");
            QFilter org = new QFilter("org", "=", (Object)Long.parseLong(init));
            QFilter billstatus = new QFilter("billstatus", "=", (Object)"C");
            DynamicObjectCollection dot = QueryServiceHelper.query((String)entrykey, (String)" * ", (QFilter[])new QFilter[]{org, billstatus});
            if (dot.size() > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5df2\u7ed3\u675f\u521d\u59cb\u5316", (String)"DataInitializationPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            } else {
                billstatus = new QFilter("billstatus", "=", (Object)"A");
                DynamicObjectCollection orgdyo = QueryServiceHelper.query((String)entrykey, (String)" * ", (QFilter[])new QFilter[]{org, billstatus});
                ArrayList<Object> list = new ArrayList<Object>();
                for (DynamicObject[] d : orgdyo) {
                    list.add(d.get("id"));
                }
                if (list.size() > 0) {
                    DynamicObject[] result;
                    for (DynamicObject row : result = BusinessDataServiceHelper.load((Object[])list.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entrykey))) {
                        row.set("billstatus", (Object)"C");
                        row.set("refundstatus", (Object)"1");
                    }
                    SaveServiceHelper.save((DynamicObject[])result);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6210\u529f", (String)"DataInitializationPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                    this.getView().updateView();
                }
            }
        } else if ("anticloseinit".equals(key)) {
            String init = this.getPageCache().get("init");
            QFilter org = new QFilter("org", "=", (Object)Long.parseLong(init));
            QFilter billstatus = new QFilter("billstatus", "=", (Object)"A");
            DynamicObjectCollection dot = QueryServiceHelper.query((String)entrykey, (String)" * ", (QFilter[])new QFilter[]{org, billstatus});
            if (dot.size() > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5c1a\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u65e0\u9700\u53cd\u521d\u59cb\u5316", (String)"DataInitializationPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
            } else {
                QFilter status = new QFilter("refundstatus", "=", (Object)"1");
                DynamicObjectCollection refundstatus = QueryServiceHelper.query((String)entrykey, (String)" * ", (QFilter[])new QFilter[]{org, status});
                if (refundstatus.size() > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u521d\u59cb\u5316\u6570\u636e\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u53cd\u521d\u59cb\u5316", (String)"DataInitializationPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
                } else {
                    billstatus = new QFilter("billstatus", "=", (Object)"C");
                    DynamicObjectCollection orgdyo = QueryServiceHelper.query((String)entrykey, (String)" * ", (QFilter[])new QFilter[]{org, billstatus});
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (DynamicObject d : orgdyo) {
                        list.add(d.get("id"));
                    }
                    if (list.size() > 0) {
                        DynamicObject[] result;
                        for (DynamicObject row : result = BusinessDataServiceHelper.load((Object[])list.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entrykey))) {
                            row.set("billstatus", (Object)"A");
                            row.set("refundstatus", (Object)"2");
                        }
                        SaveServiceHelper.save((DynamicObject[])result);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u6210\u529f", (String)"DataInitializationPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
                        this.getView().updateView();
                    }
                }
            }
        } else if ("tblnew".equals(key)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
            ListSelectedRowCollection row = billList.getSelectedRows();
            if (row.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5bf9\u591a\u6761\u6570\u636e\u8fdb\u884c\u6279\u91cf\u8c03\u6574\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u8c03\u6574", (String)"DataInitializationPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]));
            } else if (row.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e", (String)"DataInitializationPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]));
            } else {
                Object value = currentSelectedRowInfo.getPrimaryKeyValue();
                DynamicObject dto = BusinessDataServiceHelper.loadSingle((Object)value, (String)entrykey);
                if ("C".equals(dto.getString("billstatus"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5df2\u5b8c\u6210\u6570\u636e\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u3002\u5982\u9700\u8c03\u6574\uff0c\u8bf7\u5148\u5bf9\u6570\u636e\u8fdb\u884c\u201c\u53cd\u521d\u59cb\u5316\u201d\u3002", (String)"DataInitializationPlugin_9", (String)"taxc-tcvat", (Object[])new Object[0]));
                } else {
                    BillShowParameter billShowParameter = new BillShowParameter();
                    billShowParameter.setStatus(OperationStatus.EDIT);
                    billShowParameter.setFormId(entrykey);
                    if (null != value) {
                        billShowParameter.setPkId(value);
                    }
                    CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "closeCallBack");
                    billShowParameter.setCloseCallBack(closeCallBack);
                    billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                    this.getView().showForm((FormShowParameter)billShowParameter);
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getActionId().equals("closeCallBack")) {
            this.getView().updateView();
        }
    }
}

