/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.history.BaseDataHistoryService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.rule.RuleHistoryService;
import kd.taxc.tcvat.common.enums.TaxPayerTypeEnum;

public class HistoryPolicyPlugin
extends AbstractFormPlugin {
    private static final String ORG = "orgid";
    public static final String SUMMARYSCHEME_KEY = "tctb_org_group_latest";

    public void initialize() {
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgId = (String)customParams.get(ORG);
        String skssqq = (String)customParams.get("skssqq");
        String skssqz = (String)customParams.get("skssqz");
        this.init(orgId, skssqq, skssqz);
    }

    private void init(String orgId, String start, String end) {
        Object obj;
        Date startDate = DateUtils.stringToDate((String)start, (String)"yyyy-MM-dd");
        Date endDate = DateUtils.stringToDate((String)end, (String)"yyyy-MM-dd");
        RuleHistoryService.initPolicy(orgId, startDate, endDate, this.getModel());
        String declareType = ResManager.loadKDString((String)"\u72ec\u7acb\u7533\u62a5", (String)"HistoryPolicyPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]);
        String dJson = BaseDataHistoryService.queryBaseDataHistory((long)Long.parseLong(orgId), (String)SUMMARYSCHEME_KEY, (Date)startDate, (Date)endDate);
        if (!dJson.isEmpty() && (obj = JSONObject.parse((String)dJson)) instanceof JSONArray) {
            JSONArray array = (JSONArray)obj;
            block0: for (int i = 0; i < array.size(); ++i) {
                JSONObject jo = array.getJSONObject(i);
                JSONArray orgrow = jo.getJSONArray("orgrow");
                for (int j = 0; j < orgrow.size(); ++j) {
                    JSONObject jorg = orgrow.getJSONObject(j);
                    JSONObject orgidObj = jorg.getJSONObject(ORG);
                    if (orgidObj == null || orgidObj.isEmpty() || !orgId.equals(orgidObj.getString("id"))) continue;
                    declareType = ResManager.loadKDString((String)"\u6c47\u603b\u7533\u62a5", (String)"HistoryPolicyPlugin_9", (String)"taxc-tcvat", (Object[])new Object[0]);
                    continue block0;
                }
            }
        }
        this.getModel().setValue("declareType", (Object)declareType);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String policyPage = TaxPayerTypeEnum.getEnumByTaxPayerType((String)customParams.get("taxPayerType")).getPolicyConfirmPage();
        boolean bol = "zzsybnsr".equals(customParams.get("taxPayerType")) || "zzsybnsr_yz_fzjg".equals(customParams.get("taxPayerType")) || "zzsxgmnsr".equals(customParams.get("taxPayerType")) || null == customParams.get("taxPayerType");
        String skssqq = bol ? "reportperiod" : "startdate";
        String skssqz = bol ? "reportperiod" : "enddate";
        DynamicObject policy = QueryServiceHelper.queryOne((String)policyPage, (String)"id", (QFilter[])new QFilter[]{new QFilter(ORG, "=", (Object)Long.parseLong(orgId)).and(skssqq, ">=", (Object)DateUtils.getDayFirst((Date)startDate)).and(skssqz, "<=", (Object)DateUtils.getDayLast((Date)endDate)).and("draftpurpose", "=", (Object)"nssb")});
        if (policy != null) {
            DynamicObject dispatchorder = BusinessDataServiceHelper.loadSingle((Object)policy.getLong("id"), (String)policyPage);
            String ruledata_tag = dispatchorder.getString("ruledata_tag");
            JSONObject object = JSONObject.parseObject((String)ruledata_tag);
            boolean isapplicableplus = false;
            boolean applicablediffer = false;
            if (null != object) {
                JSONArray diffs = object.getJSONArray(RuleTypeEnum.DIFF.name());
                if ("tcvat_policy_confirm".equals(policyPage)) {
                    String deductionrate = dispatchorder.getString("deductionrate");
                    isapplicableplus = !"N".equals(deductionrate);
                }
                applicablediffer = diffs.size() > 0;
            }
            Label codeTitle = (Label)this.getControl("labelaprule");
            if (isapplicableplus && applicablediffer) {
                codeTitle.setText(ResManager.loadKDString((String)"\u9002\u7528\uff1a\u52a0\u8ba1\u62b5\u51cf\u8fdb\u9879\u7a0e\uff0c\u5dee\u989d\u6263\u9664\u3002", (String)"HistoryPolicyPlugin_10", (String)"taxc-tcvat", (Object[])new Object[0]));
            } else if (isapplicableplus && !applicablediffer) {
                codeTitle.setText(ResManager.loadKDString((String)"\u9002\u7528\uff1a\u52a0\u8ba1\u62b5\u51cf\u8fdb\u9879\u7a0e\u3002", (String)"HistoryPolicyPlugin_11", (String)"taxc-tcvat", (Object[])new Object[0]));
            } else if (!isapplicableplus && applicablediffer) {
                codeTitle.setText(ResManager.loadKDString((String)"\u9002\u7528\uff1a\u5dee\u989d\u6263\u9664\u3002", (String)"HistoryPolicyPlugin_12", (String)"taxc-tcvat", (Object[])new Object[0]));
            } else {
                codeTitle.setText("");
            }
            this.getView().updateView();
        }
    }
}

