/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.DeclareStepsUtils;
import kd.taxc.bdtaxr.common.taxdeclare.TaxStepsConstant;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.account.PolicyConfirmService;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;

public class PolicyConfirmation
extends AbstractBillPlugIn {
    private static final String ORGID_KEY = "orgid";
    private static final String RULE_CONFIG = "tcvat_rule_configs";
    private static final String STATUS_KEY = "status";
    private IPageCache parentPageCache;
    private static final String DEDUCTION_RATE = "deductionrate";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.initDatas(customParams);
        this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
    }

    public void afterLoadData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.setSelectValue(customParams);
        PolicyConfirmService.controlEdit(customParams, this.getView());
        this.writeToParentCache();
        this.initDatas(customParams);
        this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
    }

    private void openRulesPage(String ruledata) {
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("ruledata", ruledata);
        PageShowCommon.showForm((String)"flexpanelap", (String)"tcvat_policy_rules", (IFormView)this.getView(), customParams);
    }

    public void setSelectValue(Map<String, Object> customParams) {
        ComboEdit deductionRateComboEdit = (ComboEdit)this.getControl(DEDUCTION_RATE);
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        String draftpurpose = (String)customParams.getOrDefault("draftpurpose", "nssb");
        Map<String, Date> map = PeriodService.getPreTaxPeriod(draftpurpose, (String)customParams.get(ORGID_KEY), skssqq);
        Date preStart = map.get("startDate");
        Date preEnd = map.get("endDate");
        if (preStart == null || preEnd == null) {
            return;
        }
        QFilter preDateFilter = new QFilter("reportperiod", ">=", (Object)DateUtils.getDayFirst((Date)preStart)).and(new QFilter("reportperiod", "<=", (Object)DateUtils.getDayLast((Date)preEnd)));
        ArrayList<ComboItem> items = PolicyConfirmService.setDeductionRateSelectValue(draftpurpose, customParams, this.getView(), this.getModel(), this.getPageCache(), preDateFilter);
        deductionRateComboEdit.setComboItems(items);
        Long id = (Long)this.getModel().getValue("id");
        if (id == null || id == 0L) {
            String bqsfsyjzzc = PolicyConfirmService.queryBqsfsyjzzcDefaultValue(draftpurpose, this.getView().getFormShowParameter().getFormId(), Long.parseLong((String)customParams.get(ORGID_KEY)), (String)customParams.get("skssqq"), (String)customParams.get("skssqz"), preDateFilter);
            this.getModel().setValue("bqsfsyjzzc", (Object)bqsfsyjzzc);
            this.getPageCache().put("bqsfsyjzzc", bqsfsyjzzc);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        PolicyConfirmService.resetDraftData(this.getView().getFormShowParameter().getCustomParams());
        DeclareStepsUtils.resetParentSteps((int)TaxStepsConstant.getTcvatDraftYbnsr().size(), (String)"1", (String)"1", (IFormView)this.getView());
    }

    public void itemClick(ItemClickEvent evt) {
        if (evt.getItemKey().equals("fastsetting")) {
            HashMap<String, String> customParams = new HashMap<String, String>();
            Object org = this.getModel().getValue(ORGID_KEY);
            if (org != null) {
                customParams.put(ORGID_KEY, ((DynamicObject)org).getString("id"));
            }
            PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)RULE_CONFIG, (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }

    public void initDatas(Map<String, Object> customParams) {
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaData((String)customParams.getOrDefault("draftpurpose", "nssb"), (String)customParams.getOrDefault("taxpayertype", "zzsybnsr"));
        IDataModel dataModel = this.getModel();
        String skssqq = (String)customParams.get("skssqq");
        String skssqz = (String)customParams.get("skssqz");
        String orgid = customParams.get(ORGID_KEY) != null ? (String)customParams.get(ORGID_KEY) : "0";
        dataModel.setValue(ORGID_KEY, (Object)orgid);
        Object status = customParams.get(STATUS_KEY);
        this.getModel().setValue("reportperiod", (Object)DateUtils.stringToDate((String)skssqq, (String)"yyyy-MM"));
        customParams.put("page", metaData.getPolicyConfirm().getAccountMetaDataName());
        this.setSelectValue(customParams);
        if ("1".equals(status)) {
            DynamicObject changetRecordObject = OrgChangeRecordUtil.loadChangeRecord((String)orgid, (Date)DateUtils.stringToDate((String)skssqq, (String)"yyyy-MM-dd"), (Date)DateUtils.stringToDate((String)skssqz, (String)"yyyy-MM-dd"));
            DynamicObject category = TaxBaseDataUtils.queryCategoryByTaxtype((Long)Long.parseLong(orgid), (String)"zzs");
            if (category != null) {
                DynamicObject taxMain = (DynamicObject)category.getParent();
                this.getModel().setValue("registertype", taxMain.get("registertype"));
                this.getModel().setValue("codeandname", taxMain.get("codeandname"));
                this.getModel().setValue("taxplayeraptitude", (Object)("zzs" + changetRecordObject.getString("taxpayertype")));
                this.getModel().setValue("levytype", (Object)changetRecordObject.getString("levytype"));
                this.getModel().setValue("deadline", (Object)TaxDeclareHelper.getDeadLine(metaData.getDraftPurpose(), orgid, DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz)));
            }
            this.getModel().setValue("draftpurpose", (Object)metaData.getDraftPurpose());
        }
        Map rules = RuleUtils.getSharingAndOrgRules((Long)Long.parseLong(orgid), (RuleTypeEnum)RuleTypeEnum.ALL, (String)"ybnsr", (String)metaData.getDraftPurpose());
        String ruledata = SerializationUtils.toJsonString((Object)rules);
        this.getModel().setValue("ruledata_tag", (Object)ruledata);
        this.getModel().setValue(STATUS_KEY, (Object)"1");
        this.openRulesPage(ruledata);
    }

    private void writeToParentCache() {
        IPageCache parentPageCache = this.getParentPageCache();
        if (null != parentPageCache) {
            parentPageCache.put(DEDUCTION_RATE, String.valueOf(this.getModel().getValue(DEDUCTION_RATE)));
        }
    }

    private IPageCache getParentPageCache() {
        if (this.parentPageCache == null && null != this.getView().getParentView()) {
            this.parentPageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        }
        return this.parentPageCache;
    }
}

