/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TzDialogValidHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.job.JobUtils;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.account.SaveFetchRuleService;
import kd.taxc.tcvat.business.service.account.SaveFetchRuleTask;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.enums.DraftFieldEnum;

public abstract class AbstractEditPopFormPlugin
extends AbstractFormPlugin
implements EntryGridBindDataListener,
HyperLinkClickListener {
    private static final Log LOGGER = LogFactory.getLog(AbstractEditPopFormPlugin.class);
    private static final String ENTRYENTITY_CARD = "entryentitycard";
    protected static final String DIFFERENCE_INVOICE = "differenceinvoice";
    private SaveFetchRuleService saveFetchRuleService;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        if (entryGrid != null) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.queryRightList(customParams);
        this.setCardContent(customParams);
    }

    public void afterBindData(EventObject e) {
        CardEntry entryentitycard = (CardEntry)this.getControl(ENTRYENTITY_CARD);
        entryentitycard.selectCard(Integer.valueOf(0));
        entryentitycard.selectRowsChanged(Collections.singletonList(0), null);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.getPageCache().put("isChanged", "1");
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if (DraftConstant.CARDADJUSTAMOUNT.equals(name) || DraftConstant.CARDTOTALAMOUNT.equals(name) || "otheradjustamount".equals(name)) {
            BigDecimal amount;
            if (DraftConstant.CARDADJUSTAMOUNT.equals(name)) {
                BigDecimal adjustamount = (BigDecimal)changeData.getNewValue();
                amount = (BigDecimal)this.getModel().getValue(DraftConstant.CARDORIGINAMOUNT, rowIndex);
                this.getModel().setValue(DraftConstant.CARDTOTALAMOUNT, (Object)adjustamount.add(amount), rowIndex);
            }
            if (DraftConstant.CARDTOTALAMOUNT.equals(name)) {
                BigDecimal totalamount = (BigDecimal)changeData.getNewValue();
                amount = (BigDecimal)this.getModel().getValue(DraftConstant.CARDORIGINAMOUNT, rowIndex);
                this.getModel().setValue(DraftConstant.CARDADJUSTAMOUNT, (Object)totalamount.subtract(amount), rowIndex);
            }
            this.refreshAdjustSumAmount();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if ("save".equals(((Donothing)args.getSource()).getOperateKey())) {
                if (!"1".equals(this.getPageCache().get("isChanged"))) {
                    this.close();
                    return;
                }
                this.getPageCache().remove("isChanged");
                if (!TzDialogValidHelper.validTzsmMustInput((AbstractFormPlugin)this, (String)ENTRYENTITY_CARD, (String)DraftConstant.CARDTZSM, (String)DraftConstant.CARDTOTALAMOUNT, (String)DraftConstant.CARDORIGINAMOUNT)) {
                    return;
                }
                if (this.check(customParams)) {
                    return;
                }
                HashMap<String, Object> params = new HashMap<String, Object>(16);
                params.put("customParams", customParams);
                params.put("modelParam", this.buildModelParam());
                params.put("formId", this.getView().getFormShowParameter().getFormId());
                String taskName = ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u6267\u884c\u8fdb\u5ea6", (String)"AbstractEditPopFormPlugin_11", (String)"taxc-tcvat", (Object[])new Object[0]);
                String taskClassName = SaveFetchRuleTask.class.getName();
                String taskId = JobUtils.dispatch((IFormView)this.getView(), params, (String)taskName, (String)taskClassName);
                this.getPageCache().put("taskId", taskId);
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u7a0d\u7b49......", (String)"AbstractEditPopFormPlugin_12", (String)"taxc-tcvat", (Object[])new Object[0])), 30000);
                this.getView().addClientCallBack("saveCallBack", Integer.valueOf(1000));
            } else if ("cancel".equals(((Donothing)args.getSource()).getOperateKey())) {
                this.close();
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (StringUtil.equals((CharSequence)e.getName(), (CharSequence)"saveCallBack")) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.getPageCache().get("taskId"));
            if (taskInfo != null && taskInfo.isTaskEnd()) {
                this.refresh();
                this.close();
                this.getView().hideLoading(true);
            } else {
                this.getView().addClientCallBack("saveCallBack", Integer.valueOf(500));
            }
        }
    }

    protected SaveFetchRuleService getSaveFetchRuleService() {
        if (this.saveFetchRuleService == null) {
            String formId = this.getView().getFormShowParameter().getFormId();
            this.saveFetchRuleService = new SaveFetchRuleService(formId);
        }
        return this.saveFetchRuleService;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        DynamicObject selectedRow = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        DynamicObject table = selectedRow.getDynamicObject("table");
        if (table != null) {
            DynamicObject amountfield;
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            FormShowParameter parameter = new FormShowParameter();
            String entityname = table.getString("entityname");
            if (StringUtils.isEmpty((CharSequence)entityname)) {
                String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u6570\u636e\u6e90\u5b9e\u4f53\u540d\u79f0\u3002", (String)"AbstractEditPopFormPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                return;
            }
            parameter.setCustomParam("entityname", (Object)entityname);
            parameter.setCustomParam("entityid", (Object)table.getString("id"));
            parameter.setCustomParam("conditionjson", (Object)selectedRow.getString("conditionjson"));
            if (selectedRow.containsProperty(DIFFERENCE_INVOICE)) {
                parameter.setCustomParam(DIFFERENCE_INVOICE, (Object)selectedRow.getBoolean(DIFFERENCE_INVOICE));
            }
            parameter.setCustomParam("datasourceid", (Object)table.getLong("id"));
            parameter.setCustomParam("serialno", customParams.get("taxaccountserialno"));
            String updateDraft = (String)customParams.get("updateDraft");
            parameter.setCustomParam("draftEntry", (Object)updateDraft);
            parameter.setCustomParam("entityType", customParams.get("entry"));
            Object taxPayerType = customParams.get("taxPayerType");
            if (Objects.isNull(taxPayerType)) {
                taxPayerType = customParams.get("taxpayertype");
            }
            parameter.setCustomParam("taxPayerType", taxPayerType);
            parameter.setCustomParam("fieldName", customParams.get("fieldName"));
            if (StringUtils.equals((CharSequence)"tcvat_hz_deduction_sum", (CharSequence)updateDraft)) {
                parameter.setCustomParam("orgid", (Object)selectedRow.getString("suborg.id"));
            } else if (StringUtils.equals((CharSequence)"tcvat_hz_wait_deduct_sum", (CharSequence)updateDraft) || StringUtils.equals((CharSequence)"tcvat_hzwaitdeduct_sum_jt", (CharSequence)updateDraft) || Objects.equals(DraftConstant.YBHZ_JZJT_JXSE_SUMMARY_SJJT, updateDraft) || Objects.equals(DraftConstant.YBHZ_JZJT_JXSE_SUMMARY, updateDraft)) {
                parameter.setCustomParam("orgid", (Object)selectedRow.getString("org.id"));
            } else if (StringUtils.equals((CharSequence)"tcvat_hz_account_summary", (CharSequence)updateDraft) || StringUtils.equals((CharSequence)"tcvat_hz_account_sum_sjjt", (CharSequence)updateDraft)) {
                String nsrmc = selectedRow.getString("nsrmc");
                TaxResult taxcOrg = TaxcOrgDataServiceHelper.queryTaxcOrgByTaxpayer((String)nsrmc);
                if (taxcOrg != null && taxcOrg.isSuccess() && ((DynamicObject)taxcOrg.getData()).get("org.id") != null) {
                    parameter.setCustomParam("orgid", (Object)((DynamicObject)taxcOrg.getData()).getString("org.id"));
                } else {
                    parameter.setCustomParam("orgid", (Object)customParams.get("orgid").toString());
                }
            } else {
                parameter.setCustomParam("orgid", (Object)customParams.get("orgid").toString());
            }
            this.setPereiod(selectedRow, parameter);
            if (selectedRow.getDynamicObjectType().getProperties().containsKey((Object)"amountfield") && (amountfield = selectedRow.getDynamicObject("amountfield")) != null) {
                parameter.setCustomParam("amountName", (Object)amountfield.getString("fieldname"));
            }
            this.addCustomParams(parameter.getCustomParams());
            if (this.getView().getParentView() != null && this.getView().getParentView().getParentView() != null) {
                Map pParms = this.getView().getParentView().getParentView().getFormShowParameter().getCustomParams();
                parameter.setCustomParam("startDate", pParms.get("startDate"));
                parameter.setCustomParam("endDate", pParms.get("endDate"));
                parameter.setFormId("tcvat_draft_detail_list");
                parameter.getOpenStyle().setShowType(ShowType.NonModal);
                this.getView().showForm(parameter);
            }
        }
    }

    protected void setPereiod(DynamicObject selectedRow, FormShowParameter parameter) {
        DynamicObjectType dot = selectedRow.getDynamicObjectType();
        String tp = null;
        String periodKey = null;
        if (dot.getProperties().containsKey((Object)"taxperiod")) {
            periodKey = "taxperiod";
        } else if (dot.getProperties().containsKey((Object)"startdate")) {
            periodKey = "startdate";
        }
        if (StringUtils.isNotBlank((CharSequence)periodKey)) {
            Object taxperiod = selectedRow.get(periodKey);
            tp = taxperiod instanceof Date ? DateUtils.formatMonth((Date)selectedRow.getDate(periodKey)) : selectedRow.getString(periodKey);
        }
        parameter.setCustomParam("taxperiod", tp);
    }

    protected void addCustomParams(Map<String, Object> customParams) {
    }

    protected boolean check(Map<String, Object> customParams) {
        DynamicObject draftObject;
        QFilter draftNumberFilter;
        String templateType;
        String draftnumber = (String)customParams.get("draftnumber");
        if ("zzsyjskb".equals(customParams.get("taxpayertype"))) {
            templateType = "zzsyjskb";
            draftNumberFilter = new QFilter("declareserialno", "=", (Object)draftnumber);
            draftObject = QueryServiceHelper.queryOne((String)"tcvat_prepay_declare_bill", (String)"id,org,billstatus,skssqq as startdate,skssqz as enddate", (QFilter[])new QFilter[]{draftNumberFilter});
        } else {
            draftNumberFilter = new QFilter("billno", "=", (Object)draftnumber);
            draftObject = QueryServiceHelper.queryOne((String)TaxDeclareHelper.getDraftQueryPage(draftnumber), (String)TaxDeclareHelper.getDraftQueryFileds(draftnumber), (QFilter[])new QFilter[]{draftNumberFilter});
            String string = templateType = draftObject != null ? draftObject.getString("templatetype").replace("draft_", "") : null;
        }
        if (draftObject != null) {
            String billstatus = draftObject.getString("billstatus");
            if ("C".equals(billstatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6570\u636e\u5df2\u5ba1\u6838\uff0c\u4e0d\u652f\u6301\u4fee\u6539", (String)"AbstractEditPopFormPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                return true;
            }
            if ("B".equals(billstatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6570\u636e\u5df2\u63d0\u4ea4\uff0c\u4e0d\u652f\u6301\u4fee\u6539", (String)"AbstractEditPopFormPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
                return true;
            }
            DynamicObject declareReportStatus = null;
            declareReportStatus = "zzsyjskb".equals(customParams.get("taxpayertype")) ? QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("serialno", "=", (Object)draftnumber)}) : StatusUtils.queryDeclareReport((String)templateType, (String)draftObject.getString("org"), (String)draftObject.getString("startdate"), (String)draftObject.getString("enddate"));
            if (declareReportStatus != null && ("B".equals(billstatus = declareReportStatus.getString("billstatus")) || "C".equals(billstatus))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u6216\u5ba1\u6838\uff0c\u4e0d\u652f\u6301\u4fee\u6539", (String)"AbstractEditPopFormPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
                return true;
            }
        }
        BigDecimal bigDecimal = new BigDecimal(this.getModel().getValue(DraftConstant.ADJUSTSUMAMOUNT).toString());
        if (bigDecimal.doubleValue() < 0.0) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("save", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractEditPopFormPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"AbstractEditPopFormPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u8c03\u6574\u540e\u7684\u503c\u4e3a\u8d1f\u503c\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed", (String)"AbstractEditPopFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        if ("save".equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            this.getSaveFetchRuleService().txUpdate(customParams, this.buildModelParam());
            this.refreshAndClose();
        }
    }

    protected Map<String, Object> buildModelParam() {
        HashMap<String, Object> modelParam = new HashMap<String, Object>(16);
        modelParam.put("oldRuleAdjustAmount", this.getView().getPageCache().get("oldRuleAdjustAmount"));
        modelParam.put(DraftConstant.CARDADJUSTAMOUNT, this.getModel().getValue(DraftConstant.CARDADJUSTAMOUNT, 0));
        modelParam.put("oldManualAdjustAmount", this.getView().getPageCache().get("oldManualAdjustAmount"));
        modelParam.put("manualAdjustAmount", this.getModel().getValue(DraftConstant.CARDADJUSTAMOUNT, 1));
        modelParam.put("tzsm0", this.getModel().getValue(DraftConstant.CARDTZSM, 0));
        modelParam.put("oldRuleTzsm", this.getView().getPageCache().get("oldRuleTzsm"));
        modelParam.put("oldManualTzsm", this.getView().getPageCache().get("oldManualTzsm"));
        modelParam.put(DraftConstant.CARDORIGINAMOUNT, this.getModel().getValue(DraftConstant.CARDORIGINAMOUNT, 0));
        modelParam.put("tzsm1", this.getModel().getValue(DraftConstant.CARDTZSM, 1));
        modelParam.put(DraftConstant.ADJUSTSUMAMOUNT, this.getModel().getValue(DraftConstant.ADJUSTSUMAMOUNT));
        return modelParam;
    }

    protected abstract void queryRightList(Map<String, Object> var1);

    private void queryAdjustAmount(Map<String, Object> customParams) {
        QFilter draftTypeFilter = new QFilter("drafttype", "=", customParams.get("drafttype"));
        QFilter draftIdFilter = new QFilter("draftid", "=", customParams.get("id"));
        String fieldName = DraftFieldEnum.mapping((String)customParams.get("drafttype"), (String)customParams.get("fieldName"));
        QFilter rowFilter = new QFilter("rowcode", "=", (Object)fieldName);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)DraftConstant.TCVAT_DRAFT_EDIT, (String)"id,adjusttype,itemname,taxorg,tzszq,tzszh,tzsm,draftid,rowcode,originamount,draftnumber,drafttype,creator,createtime,taxorg_id,creator_id", (QFilter[])new QFilter[]{draftTypeFilter, draftIdFilter, rowFilter});
        BigDecimal ruleAdjust = BigDecimal.ZERO;
        BigDecimal manualAdjust = BigDecimal.ZERO;
        BigDecimal originAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)collect)) {
            Map<String, List<DynamicObject>> adjustTypeMap = collect.stream().collect(Collectors.groupingBy(o -> o.getString("adjusttype")));
            List<DynamicObject> ruleList = adjustTypeMap.get("1");
            List<DynamicObject> manualList = adjustTypeMap.get("2");
            if (!CollectionUtils.isEmpty(ruleList)) {
                DynamicObject ruleObj = (DynamicObject)ruleList.stream().sorted((d1, d2) -> {
                    Long id1 = d1.getLong("id");
                    Long id2 = d2.getLong("id");
                    return id2.compareTo(id1);
                }).findFirst().get();
                ruleAdjust = ruleObj.getBigDecimal("tzszh");
                originAmount = ruleObj.getBigDecimal("originamount");
                this.getView().getPageCache().put("oldRuleTzsm", ruleObj.getString("tzsm"));
            }
            if (!CollectionUtils.isEmpty(manualList)) {
                DynamicObject manualObj = (DynamicObject)manualList.stream().sorted((d1, d2) -> {
                    Long id1 = d1.getLong("id");
                    Long id2 = d2.getLong("id");
                    return id2.compareTo(id1);
                }).findFirst().get();
                manualAdjust = manualObj.getBigDecimal("tzszh");
                originAmount = manualObj.getBigDecimal("originamount");
                this.getView().getPageCache().put("oldManualTzsm", manualObj.getString("tzsm"));
            }
            this.getView().getPageCache().put("originAmount", String.valueOf(originAmount));
        } else if (customParams.get("amount") != null) {
            this.getView().getPageCache().put("originAmount", customParams.get("amount").toString());
        } else {
            this.getView().getPageCache().put("originAmount", BigDecimal.ZERO.toString());
        }
        this.getView().getPageCache().put("oldRuleAdjustAmount", String.valueOf(ruleAdjust));
        this.getView().getPageCache().put("oldManualAdjustAmount", String.valueOf(manualAdjust));
    }

    private void setCardContent(Map<String, Object> customParams) {
        this.queryAdjustAmount(customParams);
        BigDecimal ruleAdjust = new BigDecimal(this.getView().getPageCache().get("oldRuleAdjustAmount"));
        String oldRuleTzsm = this.getView().getPageCache().get("oldRuleTzsm");
        BigDecimal manualAdjust = new BigDecimal(this.getView().getPageCache().get("oldManualAdjustAmount"));
        String oldManualTzsm = this.getView().getPageCache().get("oldManualTzsm");
        BigDecimal originAmount = new BigDecimal(this.getView().getPageCache().get("originAmount"));
        int index = this.getModel().createNewEntryRow(ENTRYENTITY_CARD);
        this.getModel().setValue(DraftConstant.CARDCELLNAME, customParams.get("cellName"), index);
        this.getModel().setValue(DraftConstant.CARDITEMNAME, customParams.get("description"), index);
        this.getModel().setValue(DraftConstant.CARDTAXORG, customParams.get("orgid"), index);
        this.getModel().setValue(DraftConstant.CARDORIGINAMOUNT, (Object)originAmount, index);
        this.getModel().setValue(DraftConstant.CARDADJUSTAMOUNT, (Object)ruleAdjust, index);
        this.getModel().setValue(DraftConstant.CARDTOTALAMOUNT, (Object)originAmount.add(ruleAdjust), index);
        this.getModel().setValue(DraftConstant.CARDTZSM, (Object)oldRuleTzsm, index);
        int index1 = this.getModel().createNewEntryRow(ENTRYENTITY_CARD);
        this.getModel().setValue(DraftConstant.CARDCELLNAME, (Object)ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u6570\u503c", (String)"AbstractEditPopFormPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]), index1);
        this.getModel().setValue(DraftConstant.CARDADJUSTAMOUNT, (Object)manualAdjust, index1);
        this.getModel().setValue(DraftConstant.CARDTOTALAMOUNT, (Object)manualAdjust, index1);
        this.getModel().setValue(DraftConstant.CARDTZSM, (Object)oldManualTzsm, index1);
        this.getModel().setValue(DraftConstant.SUMAMOUNT, (Object)originAmount);
        this.getModel().setValue(DraftConstant.ADJUSTSUMAMOUNT, (Object)originAmount.add(ruleAdjust).add(manualAdjust));
    }

    private void close() {
        IFormView parentView = this.getView().getParentView();
        parentView.close();
        this.getView().sendFormAction(parentView);
        this.getView().close();
    }

    private void refresh() {
        IFormView parentView = this.getView().getParentView();
        IFormView grandparentView = parentView.getParentView();
        grandparentView.invokeOperation("refresh");
        this.getView().sendFormAction(grandparentView);
    }

    private void refreshAndClose() {
        this.refresh();
        this.close();
    }

    private void refreshAdjustSumAmount() {
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        BigDecimal adjustsumamount = entryentitycard.stream().map(s -> s.getBigDecimal(DraftConstant.CARDTOTALAMOUNT)).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue(DraftConstant.ADJUSTSUMAMOUNT, (Object)adjustsumamount);
    }
}

