/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.DraftExportConstant;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.account.DeductionService;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.dto.draft.DraftDto;

public class DeductFormPlugin
extends AbstractListPlugin
implements HyperLinkClickListener {
    static final String PAGE_TAB = "tcvat_income_invoice_tab";
    public static final String ENTRYENTITY = "entryentity";
    public static final String ENTRYENTITY1 = "entryentity1";
    private DeductionService deductionService = new DeductionService();

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.summary();
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryGrid1 = (EntryGrid)this.getControl(ENTRYENTITY1);
        entryGrid1.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO draftMetaDataDTO = DraftMetaDataDTO.getMetaDataByCustomParam(customParams);
        DraftMetaDataInfo deductionMetaData = draftMetaDataDTO.getDeduction();
        Object orgid = customParams.get("orgid");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)((String)customParams.get("skssqz"))));
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid.toString()));
        QFilter taxPeriodFilter = new QFilter("taxperiod", "in", PeriodService.getPeriodList(skssqq, skssqz));
        String deadLine = TaxDeclareHelper.getDeadLine(draftMetaDataDTO.getDraftPurpose(), orgid.toString(), skssqq, skssqz);
        DraftDto draftDto = new DraftDto();
        draftDto.setOrgId(Long.valueOf(orgid.toString()));
        draftDto.setStartDate(skssqq);
        draftDto.setEndDate(DateUtils.getLastDateOfMonth((Date)skssqz));
        draftDto.setDraftPurpose((String)customParams.get("draftpurpose"));
        draftDto.setTaxPayerType((String)customParams.get("taxpayertype"));
        DynamicObjectCollection genericObjects = this.deductionService.queryYbnsrDeductionDraftData(draftDto);
        if (genericObjects.size() > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow(ENTRYENTITY, genericObjects.size());
            int rowIndex = 0;
            for (DynamicObject dynamicObject : genericObjects) {
                for (Object property : dynamicObject.getDynamicObjectType().getProperties()) {
                    model.setValue(property.getName(), dynamicObject.get(property.getName()), rowIndex);
                }
                this.markEditCell(model, rowIndex, "");
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView(ENTRYENTITY);
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tpo_tcvat_bizdef", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", DeductionService.DOWN_DEDUCTION)});
        QFilter qFilter = new QFilter("deductiontype", "in", query.stream().map(o -> o.getLong("id")).collect(Collectors.toList()));
        DynamicObjectCollection gjbdcObjects = QueryServiceHelper.query((String)draftMetaDataDTO.getWaitDeduction().getAccountMetaDataName(), (String)"id,org,taxperiod,serialno,count,amount,taxamount,deductiontype.number as deductiontype", (QFilter[])new QFilter[]{qFilter, orgFilter, taxPeriodFilter}, (String)"taxperiod,deductiontype");
        if (!gjbdcObjects.isEmpty()) {
            model.batchCreateNewEntryRow(ENTRYENTITY1, gjbdcObjects.size());
            int rowIndex = 0;
            for (DynamicObject gjbdcObject : gjbdcObjects) {
                for (IDataEntityProperty property : gjbdcObject.getDynamicObjectType().getProperties()) {
                    model.setValue(property.getName() + "1", gjbdcObject.get(property.getName()), rowIndex);
                }
                this.markEditCell(model, rowIndex, "1");
                ++rowIndex;
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{ENTRYENTITY1});
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.setCollapse(true);
        EntryGrid entryGrid1 = (EntryGrid)this.getControl(ENTRYENTITY1);
        entryGrid1.setCollapse(true);
        boolean readonly = (Boolean)this.getView().getFormShowParameter().getCustomParam("readonly");
        if (readonly) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ENTRYENTITY});
            this.getView().setEnable(Boolean.FALSE, new String[]{ENTRYENTITY1});
        }
        this.getView().setVisible(Boolean.valueOf("ajsb".equalsIgnoreCase(deadLine)), new String[]{"taxperiod", "taxperiod1"});
        String entityId = this.getView().getEntityId();
        String pluginName = DraftExportConstant.getClassName((String)entityId);
        IPageCache parentPageCache = null;
        if (this.getView().getParentView() != null && this.getView().getParentView().getParentView() != null) {
            parentPageCache = this.getView().getParentView().getParentView().getPageCache();
        }
        if (parentPageCache != null) {
            parentPageCache.put("draftPageId", this.getView().getPageId());
            parentPageCache.put("entryEntityName", ENTRYENTITY);
            parentPageCache.put("pluginFeildExpandStr", "1");
            parentPageCache.put("draftDataDtoPluginName", pluginName);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String entryKey = ((EntryGrid)evt.getSource()).getEntryKey();
        int rowIndex = evt.getRowIndex();
        DynamicObject selectedRow = this.getModel().getEntryRowEntity(entryKey, rowIndex);
        String fieldName = evt.getFieldName();
        Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
        customParamMap.put("id", this.getModel().getValue("id", rowIndex));
        customParamMap.put("id1", this.getModel().getValue("id1", rowIndex));
        customParamMap.put("amount", this.getModel().getValue(fieldName, rowIndex));
        Map<String, Object> customParams = this.deductionService.createPageShowParams(customParamMap, selectedRow, fieldName, entryKey);
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)PAGE_TAB, (IFormView)this.getView(), customParams, (IFormPlugin)this);
    }

    private void markEditCell(IDataModel model, int rowIndex, String suffix) {
        QFilter draftTypeFilter = new QFilter("drafttype", "=", (Object)model.getDataEntityType().getName());
        QFilter draftIdFilter = new QFilter("draftid", "=", model.getValue("id" + suffix, rowIndex));
        DynamicObjectCollection editList = QueryServiceHelper.query((String)DraftConstant.TCVAT_DRAFT_EDIT, (String)"rowcode", (QFilter[])new QFilter[]{draftTypeFilter, draftIdFilter});
        if (!CollectionUtils.isEmpty((Collection)editList)) {
            Set<String> rowCodeSet = editList.stream().map(d -> d.getString("rowcode")).collect(Collectors.toSet());
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY + suffix);
            rowCodeSet.forEach(r -> MetadataUtil.setCellColor((Control)entryGrid, (int)rowIndex, (String)(r + suffix), (String)"#DCFAE4"));
        }
    }
}

