/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.DraftExportConstant;
import kd.taxc.bdtaxr.common.util.KdToolUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.account.AddDeductionService;
import kd.taxc.tcvat.business.service.account.DeductionService;
import kd.taxc.tcvat.business.service.account.RecordDraftModifyDataService;
import kd.taxc.tcvat.business.service.account.StatusService;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.engine.impl.utils.DeductEngineService;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.dto.TcvatDraftEditRecordEntity;
import kd.taxc.tcvat.common.dto.draft.DraftDto;
import kd.taxc.tcvat.common.enums.DeductiontypeEnum;

public class DeductionFormPlugin
extends AbstractListPlugin
implements HyperLinkClickListener,
TreeNodeQueryListener {
    static final String PAGE_TAB = "tcvat_income_invoice_tab";
    public static final String TREEENTRYENTITY = "treeentryentity";
    public static final String TREEENTRYENTITY1 = "treeentryentity1";
    public static final String CACHE_KEY = "key";
    public static final String FIRST_COLUMN = "id";
    public static final String LAST_COLUMN = "serialno";
    private AddDeductionService addDeductionService = new AddDeductionService();
    private DeductionService deductionService = new DeductionService();
    private DeductEngineService deductEngineService = new DeductEngineService();

    public void initialize() {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        entryGrid.summary();
        entryGrid.addPackageDataListener(this::packageData);
    }

    public void registerListener(EventObject e) {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addCellClickListener((TreeNodeQueryListener)this);
        TreeEntryGrid entryGrid1 = (TreeEntryGrid)this.getControl(TREEENTRYENTITY1);
        entryGrid1.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid1.addCellClickListener((TreeNodeQueryListener)this);
    }

    public void packageData(PackageDataEvent e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        BigDecimal oldVal;
        BigDecimal newVal;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO deductionMateData = DraftMetaDataDTO.getMetaDataByCustomParam(customParams);
        String suffix = e.getProperty().getParent().getName().replace(TREEENTRYENTITY, "");
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (this.isExpandRow(propertyName)) {
            return;
        }
        DynamicObject dataEntity = changeData.getDataEntity();
        String deductiontype = dataEntity.getString("deductiontype" + suffix);
        if (deductiontype == null) {
            return;
        }
        BigDecimal amount = dataEntity.getBigDecimal("taxamount" + suffix);
        BigDecimal inputtaxamount = dataEntity.getBigDecimal("inputtaxamount" + suffix);
        String message = this.deductionService.validateChange(dataEntity, propertyName, inputtaxamount, amount);
        if (StringUtil.isNotBlank((CharSequence)message)) {
            this.getView().showErrorNotification(message);
            return;
        }
        DynamicObject object = null;
        object = "1".equals(suffix) ? BusinessDataServiceHelper.loadSingle((Object)dataEntity.get(FIRST_COLUMN + suffix), (String)deductionMateData.getWaitDeduction().getAccountMetaDataName()) : BusinessDataServiceHelper.loadSingle((Object)dataEntity.get(FIRST_COLUMN + suffix), (String)deductionMateData.getDeduction().getAccountMetaDataName());
        object.set(propertyName.replace(suffix, ""), newValue);
        String org = dataEntity.getString("org" + suffix);
        String taxperiod = dataEntity.getString("taxperiod" + suffix);
        try (TXHandle h = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
                StatusService.updateStatus(org, taxperiod, "2", deductionMateData.getPolicyConfirm().getAccountMetaDataName(), deductionMateData.getDraftPurpose());
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
        if (propertyName.equals("taxamount") || propertyName.equals("amount") || propertyName.equals("inputtaxamount")) {
            this.addDeductionService.executeAddDeductionEngine(customParams, deductionMateData, org);
        }
        String drafttype = (String)customParams.get("drafttype");
        String draftnumber = (String)customParams.get("draftnumber");
        String orgid = (String)customParams.get("orgid");
        Object oldValue = changeData.getOldValue();
        if ("count".equals(e.getProperty().getName())) {
            newVal = newValue == null ? BigDecimal.ZERO : new BigDecimal((Integer)newValue);
            oldVal = oldValue == null ? BigDecimal.ZERO : new BigDecimal((Integer)oldValue);
        } else {
            newVal = newValue == null ? BigDecimal.ZERO : (BigDecimal)newValue;
            oldVal = oldValue == null ? BigDecimal.ZERO : (BigDecimal)oldValue;
        }
        DynamicObject changeDataEntity = changeData.getDataEntity();
        TcvatDraftEditRecordEntity entity = new TcvatDraftEditRecordEntity("2", dataEntity.getString("deductiontype"), orgid, oldVal, newVal, "", changeDataEntity.getString(FIRST_COLUMN), drafttype, e.getProperty().getName(), draftnumber);
        RecordDraftModifyDataService.recordModify(entity);
        this.getView().invokeOperation("refresh");
        this.getPageCache().remove(CACHE_KEY);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DeductionFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
    }

    private boolean isExpandRow(String propertyName) {
        if (propertyName.equals(FIRST_COLUMN)) {
            this.getPageCache().put(CACHE_KEY, propertyName);
            return true;
        }
        if (propertyName.equals(LAST_COLUMN)) {
            this.getPageCache().remove(CACHE_KEY);
            return true;
        }
        return this.getPageCache().get(CACHE_KEY) != null;
    }

    private boolean validateChange(DynamicObject dataEntity, String propertyName, BigDecimal inputtaxamount, BigDecimal taxamount) {
        BigDecimal changeValue = dataEntity.getBigDecimal(propertyName);
        if (changeValue.compareTo(BigDecimal.ZERO) < 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91d1\u989d\u4e0d\u53ef\u4ee5\u4e3a\u8d1f\u6570\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"DeductionFormPlugin_23", (String)"taxc-tcvat", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection query;
        QFilter qFilter;
        DynamicObjectCollection gjbdcObjects;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("orgid");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid.toString()));
        QFilter taxPeriodFilter = new QFilter("taxperiod", "in", PeriodService.getPeriodList(skssqq, skssqz));
        String deadLine = TaxDeclareHelper.getDeadLine((String)customParams.get("draftpurpose"), orgid.toString(), skssqq, skssqz);
        IDataModel model = this.getModel();
        DraftDto draftDto = new DraftDto();
        draftDto.setOrgId(Long.valueOf(orgid.toString()));
        draftDto.setStartDate(skssqq);
        draftDto.setEndDate(DateUtils.getLastDateOfMonth((Date)skssqz));
        draftDto.setDraftPurpose((String)customParams.get("draftpurpose"));
        draftDto.setTaxPayerType((String)customParams.get("taxpayertype"));
        DynamicObjectCollection genericObjects = this.deductionService.queryYbnsrDeductionDraftData(draftDto);
        if (genericObjects.size() > 0) {
            genericObjects = KdToolUtils.customSortList((String)"deductiontype", new ArrayList<String>(this.deductEngineService.getDeductTypeMap().values()), (String)"taxperiod", (DynamicObjectCollection)genericObjects);
            model.beginInit();
            model.batchCreateNewEntryRow(TREEENTRYENTITY, genericObjects.size());
            int rowIndex = 0;
            for (DynamicObject dynamicObject : genericObjects) {
                model.setValue(FIRST_COLUMN, dynamicObject.get(FIRST_COLUMN), rowIndex);
                model.setValue("org", dynamicObject.get("org"), rowIndex);
                model.setValue("taxperiod", dynamicObject.get("taxperiod"), rowIndex);
                model.setValue(LAST_COLUMN, dynamicObject.get(LAST_COLUMN), rowIndex);
                model.setValue("deductiontype", dynamicObject.get("deductiontype"), rowIndex);
                Object count = dynamicObject.get("count");
                Object amount = dynamicObject.get("amount");
                Object taxamount = dynamicObject.get("taxamount");
                Object inputtaxamount = dynamicObject.get("inputtaxamount");
                model.setValue("count", count, rowIndex);
                model.setValue("amount", amount, rowIndex);
                model.setValue("taxamount", taxamount, rowIndex);
                model.setValue("inputtaxamount", inputtaxamount, rowIndex);
                this.markEditCell(model, rowIndex, "");
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView(TREEENTRYENTITY);
        }
        if (!(gjbdcObjects = QueryServiceHelper.query((String)"tcvat_wait_deduct_summary", (String)"id,org,serialno,taxperiod,count,amount,taxamount,deductiontype,deadline,deductiontype.number", (QFilter[])new QFilter[]{qFilter = new QFilter("deductiontype", "in", (query = QueryServiceHelper.query((String)"tpo_tcvat_bizdef", (String)FIRST_COLUMN, (QFilter[])new QFilter[]{new QFilter("number", "in", DeductionService.DOWN_DEDUCTION)})).stream().map(o -> o.getLong(FIRST_COLUMN)).collect(Collectors.toList())), orgFilter, taxPeriodFilter}, (String)"taxperiod,deductiontype.number")).isEmpty()) {
            model.batchCreateNewEntryRow(TREEENTRYENTITY1, gjbdcObjects.size());
            int rowIndex = 0;
            for (DynamicObject gjbdcObject : gjbdcObjects) {
                model.setValue("id1", gjbdcObject.get(FIRST_COLUMN), rowIndex);
                model.setValue("org1", gjbdcObject.get("org"), rowIndex);
                model.setValue("taxperiod1", gjbdcObject.get("taxperiod"), rowIndex);
                model.setValue("serialno1", gjbdcObject.get(LAST_COLUMN), rowIndex);
                model.setValue("deductiontype1", (Object)gjbdcObject.getString("deductiontype.number"), rowIndex);
                Object count = gjbdcObject.get("count");
                Object amount = gjbdcObject.get("amount");
                Object taxamount = gjbdcObject.get("taxamount");
                model.setValue("count1", count, rowIndex);
                model.setValue("amount1", amount, rowIndex);
                model.setValue("taxamount1", taxamount, rowIndex);
                this.markEditCell(model, rowIndex, "1");
                ++rowIndex;
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{TREEENTRYENTITY1});
        }
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        treeEntryGrid.setCollapse(true);
        TreeEntryGrid treeEntryGrid1 = (TreeEntryGrid)this.getControl(TREEENTRYENTITY1);
        treeEntryGrid1.setCollapse(true);
        boolean readonly = (Boolean)this.getView().getFormShowParameter().getCustomParam("readonly");
        if (readonly) {
            this.getView().setEnable(Boolean.FALSE, new String[]{TREEENTRYENTITY});
            this.getView().setEnable(Boolean.FALSE, new String[]{TREEENTRYENTITY1});
        }
        this.getView().setVisible(Boolean.valueOf("ajsb".equalsIgnoreCase(deadLine)), new String[]{"taxperiod", "taxperiod1"});
        String entityId = this.getView().getEntityId();
        String pluginName = DraftExportConstant.getClassName((String)entityId);
        IPageCache parentPageCache = null;
        if (this.getView().getParentView() != null && this.getView().getParentView().getParentView() != null && this.getView().getParentView().getParentView().getParentView() != null) {
            parentPageCache = this.getView().getParentView().getParentView().getParentView().getPageCache();
        }
        if (parentPageCache != null) {
            parentPageCache.put("draftPageId", this.getView().getPageId());
            parentPageCache.put("entryEntityName", TREEENTRYENTITY);
            parentPageCache.put("pluginFeildExpandStr", "1");
            parentPageCache.put("draftDataDtoPluginName", pluginName);
        }
    }

    private void markEditCell(IDataModel model, int rowIndex, String suffix) {
        QFilter draftTypeFilter = new QFilter("drafttype", "=", (Object)model.getDataEntityType().getName());
        QFilter draftIdFilter = new QFilter("draftid", "=", model.getValue(FIRST_COLUMN + suffix, rowIndex));
        DynamicObjectCollection editList = QueryServiceHelper.query((String)DraftConstant.TCVAT_DRAFT_EDIT, (String)"rowcode", (QFilter[])new QFilter[]{draftTypeFilter, draftIdFilter});
        if (!CollectionUtils.isEmpty((Collection)editList)) {
            Set<String> rowCodeSet = editList.stream().map(d -> d.getString("rowcode")).collect(Collectors.toSet());
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(TREEENTRYENTITY + suffix);
            rowCodeSet.forEach(r -> {
                CellStyle cellStyle = new CellStyle();
                cellStyle.setRow(rowIndex);
                cellStyle.setFieldKey(r + suffix);
                cellStyle.setBackColor("#DCFAE4");
                entryGrid.setCellStyle(Collections.singletonList(cellStyle));
            });
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String entryKey = ((EntryGrid)evt.getSource()).getEntryKey();
        String suffix = entryKey.replace(TREEENTRYENTITY, "");
        int rowIndex = evt.getRowIndex();
        DynamicObject selectedRow = this.getModel().getEntryRowEntity(entryKey, rowIndex);
        String fieldName = evt.getFieldName();
        Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO deductionMetaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParamMap);
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        String deductiontype = selectedRow.getString("deductiontype" + suffix);
        customParams.put("draftpurpose", customParamMap.get("draftpurpose"));
        customParams.put("updateDraft", deductionMetaData.getDeduction().getAccountMetaDataName());
        customParams.put("orgid", customParamMap.get("orgid"));
        customParams.put(FIRST_COLUMN, this.getModel().getValue(FIRST_COLUMN, rowIndex));
        customParams.put("fieldName", fieldName);
        customParams.put("type", fieldName.replace("1", ""));
        customParams.put("deductiontype", deductiontype);
        customParams.put("cellName", DeductionService.getCellName(fieldName, suffix));
        customParams.put("description", DeductiontypeEnum.getNameByValue(deductiontype));
        customParams.put("amount", this.getModel().getValue(fieldName, rowIndex));
        customParams.put("draftnumber", customParamMap.get("draftnumber"));
        customParams.put("drafttype", customParamMap.get("drafttype"));
        customParams.put("billstatus", customParamMap.get("billstatus"));
        customParams.put("taxaccountserialno", selectedRow.getString(LAST_COLUMN + suffix));
        customParams.put("entry", deductionMetaData.getDeduction().getDetailMetaDataNameMap().get(DraftConstant.YBNSR_DEDUCTION_DETAIL_BILL));
        if (deductiontype.equals("1") || deductiontype.equals("2")) {
            customParams.put("customCaption", deductiontype.startsWith("1") ? ResManager.loadKDString((String)"\u672c\u671f\u8ba4\u8bc1\u76f8\u7b26\u7684\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u62b5\u6263\u660e\u7ec6\u5217\u8868", (String)"DeductionFormPlugin_24", (String)"taxc-tcvat", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672c\u671f\u8ba4\u8bc1\u76f8\u7b26\u7684\u901a\u884c\u8d39\u53d1\u7968\u62b5\u6263\u660e\u7ec6\u5217\u8868", (String)"DeductionFormPlugin_25", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else if ("7".equals(deductiontype)) {
            customParams.put("type", fieldName);
            customParams.put("customCaption", ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u670d\u52a1\u6263\u7a0e\u51ed\u8bc1\u62b5\u6263\u660e\u7ec6\u5217\u8868", (String)"DeductionFormPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else if ("5".equals(deductiontype)) {
            customParams.put("period", selectedRow.getString("taxperiod"));
            customParams.put("customCaption", ResManager.loadKDString((String)"\u4ee3\u6263\u4ee3\u7f34\u7a0e\u6536\u7f34\u6b3e\u51ed\u8bc1\u62b5\u6263\u660e\u7ec6\u5217\u8868", (String)"DeductionFormPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else if ("3".equals(deductiontype) || "21".equals(deductiontype)) {
            customParams.put("period", selectedRow.getString("taxperiod"));
            customParams.put("deductiontype", deductiontype);
            customParams.put("customCaption", ResManager.loadKDString((String)"\u6d77\u5173\u8fdb\u53e3\u589e\u503c\u7a0e\u4e13\u7528\u7f34\u6b3e\u4e66\u62b5\u6263\u660e\u7ec6\u5217\u8868", (String)"DeductionFormPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else if ("4".equals(deductiontype)) {
            customParams.put("customCaption", ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968\u6216\u8005\u9500\u552e\u53d1\u7968\u62b5\u6263\u660e\u7ec6\u5217\u8868", (String)"DeductionFormPlugin_26", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else if ("9".equals(deductiontype)) {
            customParams.put("customCaption", ResManager.loadKDString((String)"\u672c\u671f\u8ba4\u8bc1\u76f8\u7b26\u7684\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\u62b5\u6263\u660e\u7ec6\u5217\u8868", (String)"DeductionFormPlugin_21", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else if ("8".equals(deductiontype)) {
            customParams.put("customCaption", ResManager.loadKDString((String)"\u5176\u4ed6\u62b5\u6263\u660e\u7ec6\u5217\u8868", (String)"DeductionFormPlugin_27", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else if ("6".equals(deductiontype)) {
            customParams.put("customCaption", ResManager.loadKDString((String)"\u52a0\u8ba1\u6263\u9664\u519c\u4ea7\u54c1\u8fdb\u9879\u7a0e\u989d\u62b5\u6263\u660e\u7ec6\u5217\u8868", (String)"DeductionFormPlugin_28", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else if ("10".equals(deductiontype)) {
            customParams.put("customCaption", ResManager.loadKDString((String)"\u524d\u671f\u8ba4\u8bc1\u76f8\u7b26\u7684\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u62b5\u6263\u660e\u7ec6\u5217\u8868", (String)"DeductionFormPlugin_29", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else if ("11".equals(deductiontype)) {
            customParams.put("customCaption", ResManager.loadKDString((String)"\u524d\u671f\u8ba4\u8bc1\u76f8\u7b26\u7684\u901a\u884c\u8d39\u53d1\u7968\u62b5\u6263\u660e\u7ec6\u5217\u8868", (String)"DeductionFormPlugin_30", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else if ("12".equals(deductiontype)) {
            customParams.put("customCaption", ResManager.loadKDString((String)"\u524d\u671f\u8ba4\u8bc1\u76f8\u7b26\u7684\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\u62b5\u6263\u660e\u7ec6\u5217\u8868", (String)"DeductionFormPlugin_31", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else if ("VAT_JXDK_BQDK_11".equals(deductiontype)) {
            customParams.put(FIRST_COLUMN, this.getModel().getValue("id1", rowIndex));
            customParams.put("entry", deductionMetaData.getWaitDeduction().getDetailMetaDataNameMap().get(DraftConstant.PAGE_WAIT_DEDUCTION_DETAIL));
            customParams.put("fieldName", fieldName.replace("1", ""));
            customParams.put("taxaccountserialno", selectedRow.getString("serialno1"));
            customParams.put("customCaption", ResManager.loadKDString((String)"\u672c\u671f\u7528\u4e8e\u8d2d\u5efa\u4e0d\u52a8\u4ea7\u7684\u6263\u7a0e\u51ed\u8bc1\u62b5\u6263\u660e\u7ec6\u5217\u8868", (String)"DeductionFormPlugin_22", (String)"taxc-tcvat", (Object[])new Object[0]));
            customParams.put("updateDraft", deductionMetaData.getWaitDeduction().getAccountMetaDataName());
        } else if ("VAT_JXDK_BQDK_15".equals(deductiontype)) {
            customParams.put(FIRST_COLUMN, this.getModel().getValue("id1", rowIndex));
            customParams.put("entry", deductionMetaData.getWaitDeduction().getDetailMetaDataNameMap().get(DraftConstant.PAGE_WAIT_DEDUCTION_DETAIL));
            customParams.put("fieldName", fieldName.replace("1", ""));
            customParams.put("taxaccountserialno", selectedRow.getString("serialno1"));
            customParams.put("customCaption", ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u670d\u52a1\u6263\u7a0e\u51ed\u8bc1_\u589e\u503c\u7a0e\uff08\u7535\u5b50\uff09\u666e\u901a\u53d1\u7968\u62b5\u6263\u660e\u7ec6\u5217\u8868", (String)"DeductionFormPlugin_32", (String)"taxc-tcvat", (Object[])new Object[0]));
            customParams.put("updateDraft", deductionMetaData.getWaitDeduction().getAccountMetaDataName());
        } else if ("VAT_JXDK_BQDK_16".equals(deductiontype)) {
            customParams.put(FIRST_COLUMN, this.getModel().getValue("id1", rowIndex));
            customParams.put("entry", deductionMetaData.getWaitDeduction().getDetailMetaDataNameMap().get(DraftConstant.PAGE_WAIT_DEDUCTION_DETAIL));
            customParams.put("fieldName", fieldName.replace("1", ""));
            customParams.put("taxaccountserialno", selectedRow.getString("serialno1"));
            customParams.put("customCaption", ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u670d\u52a1\u6263\u7a0e\u51ed\u8bc1_\u6ce8\u660e\u65c5\u5ba2\u8eab\u4efd\u4fe1\u606f\u7684\u822a\u7a7a\u8fd0\u8f93\u7535\u5b50\u5ba2\u7968\u884c\u7a0b\u5355\u62b5\u6263\u660e\u7ec6\u5217\u8868", (String)"DeductionFormPlugin_33", (String)"taxc-tcvat", (Object[])new Object[0]));
            customParams.put("updateDraft", deductionMetaData.getWaitDeduction().getAccountMetaDataName());
        } else if ("VAT_JXDK_BQDK_17".equals(deductiontype)) {
            customParams.put(FIRST_COLUMN, this.getModel().getValue("id1", rowIndex));
            customParams.put("entry", deductionMetaData.getWaitDeduction().getDetailMetaDataNameMap().get(DraftConstant.PAGE_WAIT_DEDUCTION_DETAIL));
            customParams.put("fieldName", fieldName.replace("1", ""));
            customParams.put("taxaccountserialno", selectedRow.getString("serialno1"));
            customParams.put("customCaption", ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u670d\u52a1\u6263\u7a0e\u51ed\u8bc1_\u94c1\u8def\u65c5\u5ba2\u8fd0\u8f93\u7968\u636e\u62b5\u6263\u660e\u7ec6\u5217\u8868", (String)"DeductionFormPlugin_34", (String)"taxc-tcvat", (Object[])new Object[0]));
            customParams.put("updateDraft", deductionMetaData.getWaitDeduction().getAccountMetaDataName());
        } else if ("VAT_JXDK_BQDK_18".equals(deductiontype)) {
            customParams.put(FIRST_COLUMN, this.getModel().getValue("id1", rowIndex));
            customParams.put("entry", deductionMetaData.getWaitDeduction().getDetailMetaDataNameMap().get(DraftConstant.PAGE_WAIT_DEDUCTION_DETAIL));
            customParams.put("fieldName", fieldName.replace("1", ""));
            customParams.put("taxaccountserialno", selectedRow.getString("serialno1"));
            customParams.put("customCaption", ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u670d\u52a1\u6263\u7a0e\u51ed\u8bc1_\u6ce8\u660e\u65c5\u5ba2\u8eab\u4efd\u4fe1\u606f\u7684\u516c\u8def\u3001\u6c34\u8def\u5176\u4ed6\u5ba2\u7968\u62b5\u6263\u660e\u7ec6\u5217\u8868", (String)"DeductionFormPlugin_35", (String)"taxc-tcvat", (Object[])new Object[0]));
            customParams.put("updateDraft", deductionMetaData.getWaitDeduction().getAccountMetaDataName());
        }
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)PAGE_TAB, (IFormView)this.getView(), customParams, (IFormPlugin)this);
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
    }
}

