/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.FlexListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.ListColumnContext;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.events.ListRowSortEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineCalcFilterService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.RuleConfigUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.task.util.InvoiceTaskUtils;
import kd.taxc.tcvat.business.service.engine.task.util.NewRuleSettingUtils;
import kd.taxc.tcvat.business.service.engine.task.util.RuleSettingUtils;
import kd.taxc.tcvat.business.service.engine.task.util.strategy.DefaultStraegy;
import kd.taxc.tcvat.business.service.engine.task.util.strategy.InvoiceContext;
import kd.taxc.tcvat.business.service.rule.RuleService;
import org.apache.commons.collections4.CollectionUtils;

public class DraftAmountDetailFormPlugin
extends AbstractFormPlugin
implements CreateListColumnsListener,
CreateListDataProviderListener,
Consumer<ListRowSortEvent> {
    private static final Log logger = LogFactory.getLog(DraftAmountDetailFormPlugin.class);
    private RuleService ruleService = new RuleService();
    private final Set<String> TEMPLATETYPE = Sets.newHashSet((Object[])new String[]{"zzsybnsr", "zzsybnsr_hz_zjg", "zzsybnsr_ybhz", "zzsybnsr_yz_zjg"});

    public void initialize() {
        List detailIds;
        super.initialize();
        BillList billlistap = (BillList)this.getControl("billlistap");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entryName = (String)customParams.get("entityname");
        String entryId = (String)customParams.get("entityid");
        billlistap.setEntityId(entryName);
        String serialno = (String)customParams.get("serialno");
        String draftEntry = (String)customParams.get("draftEntry");
        String ruleEntry = (String)customParams.get("ruleEntry");
        String conditionjson = (String)customParams.get("conditionjson");
        String startDate = (String)customParams.get("startDate");
        String endDate = (String)customParams.get("endDate");
        String fieldName = (String)customParams.get("fieldName");
        String amountName = (String)customParams.get("amountName");
        String taxperiod = (String)customParams.get("taxperiod");
        Boolean differenceInvoice = null != customParams.get("differenceinvoice") ? (Boolean)customParams.get("differenceinvoice") : Boolean.FALSE;
        String taxPayerType = (String)customParams.get("taxPayerType");
        taxperiod = taxperiod != null ? taxperiod : startDate;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        Date start = DateUtils.stringToDate((String)startDate);
        Date end = DateUtils.stringToDate((String)endDate);
        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM"));
        Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM"));
        Long datasourceid = (Long)customParams.get("datasourceid");
        if (datasourceid == null || datasourceid == 0L) {
            return;
        }
        Map fieldMap = RuleConfigUtils.get((Long)datasourceid);
        this.addDateFilter(fieldMap, firstDateOfMonth, lastDateOfMonth, filterList);
        DynamicObject ruleObj = this.ruleService.queryRuleBySerialNo(ruleEntry, draftEntry, serialno);
        String taxRate = null;
        if (ruleObj != null && ruleObj.containsProperty("taxrate")) {
            taxRate = ruleObj.getString("taxrate");
        }
        if (this.ruleService.isPatialPerpayRuleSumEntry(draftEntry) && "tcvat_prepay_declare_bill".equals(entryName)) {
            String perpreprojectnumber = (String)customParams.get("perpreprojectnumber");
            RuleSettingUtils.addPartialPerpayDefaultFilter(filterList, perpreprojectnumber);
        }
        this.addOrgFilter(fieldMap, datasourceid, start, end, filterList);
        String filterIdName = "id";
        if (Arrays.asList("specialinvoiceamount", "specialtaxamount").contains(fieldName) && Arrays.asList("sim_vatinvoice", "sim_vatinvoice_vehicles").contains(entryName)) {
            taxRate = NewRuleSettingUtils.trimTaxRate(taxRate);
            BigDecimal rate = new BigDecimal(taxRate.replaceAll("%", "")).divide(new BigDecimal("100"));
            InvoiceTaskUtils.setRateFilter(filterList, "items.taxrate", rate, differenceInvoice, entryName);
            DynamicObject rule = BusinessDataServiceHelper.newDynamicObject((String)ruleEntry);
            DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("invoiceentity");
            DynamicObject setting = entryentity.addNew();
            DynamicObjectType dynamicObjectType = new DynamicObjectType();
            DynamicObject table12 = new DynamicObject(dynamicObjectType);
            if (!table12.getDynamicObjectType().getProperties().containsKey((Object)"name")) {
                DynamicSimpleProperty property = new DynamicSimpleProperty("name", String.class, (Object)"");
                table12.getDynamicObjectType().getProperties().add((Object)property);
                table12.set("name", (Object)entryName);
                DynamicSimpleProperty idProperty = new DynamicSimpleProperty("id", String.class, (Object)"");
                table12.getDynamicObjectType().getProperties().add((Object)idProperty);
                table12.set("id", (Object)entryId);
            }
            setting.set("table12", (Object)table12);
            setting.set("invoiceconditionjson", (Object)conditionjson);
            DynamicObjectCollection invoiceOutputList = InvoiceTaskUtils.queryInvoiceOutPutList(filterList, taxPayerType, setting, filterIdName, null != ruleObj ? ruleObj.getString("jzjt") : "", customParams);
            detailIds = invoiceOutputList.stream().map(o -> o.getLong("itemid")).collect(Collectors.toList());
            if ("sim_vatinvoice".equals(entryName)) {
                filterIdName = "items.id";
                DynamicObjectCollection detailCollection = this.simVatInvoiceHandler(entryId, entryName, ruleEntry, taxPayerType, "itemid", ruleObj, invoiceOutputList);
                detailIds = detailCollection.stream().map(ids -> ids.getLong("itemid")).collect(Collectors.toList());
            }
        } else {
            InvoiceContext context = new InvoiceContext(new DefaultStraegy());
            filterIdName = this.ruleService.getBillListIdName(amountName, entryName);
            DynamicObjectCollection detailCollection = context.executeStrategy(ruleObj, filterList, taxRate, filterIdName, filterIdName, customParams);
            String finalFilterIdName = filterIdName;
            detailIds = detailCollection.stream().map(id -> id.getLong(finalFilterIdName)).collect(Collectors.toList());
        }
        FilterParameter filterParameter = billlistap.getFilterParameter();
        filterParameter.getQFilters().add(new QFilter(filterIdName, "in", detailIds));
        billlistap.addCreateListColumnsListener((CreateListColumnsListener)this);
    }

    public void registerListener(EventObject e) {
        BillList billlistap = (BillList)this.getControl("billlistap");
        billlistap.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        billlistap.addListRowSortListeners((Consumer)this);
    }

    public DynamicObjectCollection simVatInvoiceHandler(String entryId, String entryName, String ruleEntry, String taxPayerType, String filterIdName, DynamicObject ruleObj, DynamicObjectCollection detailCollection) {
        if (entryName.equals("sim_vatinvoice") && "tcvat_rule_income".equals(ruleEntry) && this.TEMPLATETYPE.contains(taxPayerType) && "1835580761286481920".equals(entryId)) {
            detailCollection = InvoiceTaskUtils.jzjtStrategy(detailCollection, filterIdName, "subinvoiceid", null != ruleObj ? ruleObj.getString("jzjt") : "");
        }
        return detailCollection;
    }

    private void addDateFilter(Map<String, String> fieldMap, Date firstDateOfMonth, Date lastDateOfMonth, List<QFilter> filterList) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entryName = (String)customParams.get("entityname");
        String entityType = (String)customParams.get("entityType");
        String startDate = (String)customParams.get("startDate");
        String dataField = fieldMap.get("datastate");
        this.ruleService.setDateFilter(dataField, entityType, entryName, startDate, firstDateOfMonth, lastDateOfMonth, filterList);
    }

    private void addOrgFilter(Map<String, String> fieldMap, Long datasourceid, Date start, Date end, List<QFilter> filterList) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entryName = (String)customParams.get("entityname");
        String orgid = (String)customParams.get("orgid");
        String startDate = (String)customParams.get("startDate");
        String endDate = (String)customParams.get("endDate");
        String taxperiod = (String)customParams.get("taxperiod");
        String draftEntry = (String)customParams.get("draftEntry");
        taxperiod = taxperiod != null ? taxperiod : startDate;
        TcvatEngineModel model = new TcvatEngineModel(orgid, startDate, endDate);
        model.addCustom("taxorg", orgid);
        model.addCustom("draftEntry", draftEntry);
        Map orgRelationMap = TaxOrgTakeRelationServiceHelper.getOrgRelationMapByTaxOrgs(Collections.singletonList(Long.parseLong(orgid)), (Date)start, (Date)end);
        model.addCustom("OrgRelationMap", orgRelationMap);
        NewRuleSettingUtils.setFilter(null, fieldMap, (EngineModel)model, filterList, taxperiod, entryName);
        Date firstDayOfMonth = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM"));
        Date lastDayOfMonth = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM"));
        QFilter mappingQfilter = EngineCalcFilterService.getMappingQfilter((Long)DeclareTaxType.ZZS.getBaseTaxId(), (Long)datasourceid, Collections.singletonList(Long.valueOf(model.getOrgId())), (Date)firstDayOfMonth, (Date)lastDayOfMonth);
        if (mappingQfilter != null) {
            filterList.add(mappingQfilter);
        }
    }

    public void createListColumns(BeforeCreateListColumnsArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long datasourceid = (Long)customParams.get("datasourceid");
        if (datasourceid == null || datasourceid == 0L) {
            return;
        }
        String amountName = (String)customParams.get("amountName");
        DynamicObjectCollection dataSource = this.ruleService.queryCustomSourceById(datasourceid);
        if (CollectionUtils.isNotEmpty((Collection)dataSource)) {
            args.getListColumns().clear();
            ListColumn seqColumn = new ListColumn();
            seqColumn.setKey("seq");
            seqColumn.setListFieldKey("fseq");
            seqColumn.setUserConfigColumnSettings(null);
            seqColumn.setSeqColumnType("EntitySeq");
            seqColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"DraftAmountDetailFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0])));
            args.getListColumns().add(seqColumn);
            for (DynamicObject object : dataSource) {
                boolean mark;
                String fieldName = object.getString("fieldname");
                String entityname = object.getString("entityname");
                MainEntityType det = MetadataServiceHelper.getDataEntityType((String)entityname);
                if ("gl_balance".equals(entityname) && "period.begindate".equals(fieldName)) {
                    fieldName = "period";
                }
                ListColumn e = new ListColumn();
                DynamicProperty property = (DynamicProperty)det.getAllFields().get(fieldName);
                if (property != null && StringUtils.isBlank((CharSequence)property.getAlias())) continue;
                if (property instanceof DecimalProp) {
                    e = new DecimalListColumn();
                    ((DecimalListColumn)e).setZeroShow(true);
                } else if (property instanceof FlexProp) {
                    e = new FlexListColumn();
                } else if (property instanceof BasedataProp) {
                    fieldName = fieldName + "." + ((BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)((BasedataProp)property).getBaseEntityId())).getNameProperty();
                }
                e.setCaption(new LocaleString(object.getString("bizsubname")));
                e.setKey(fieldName);
                e.setListFieldKey(fieldName);
                boolean bl = mark = "gl_balance".equals(entityname) && StringUtils.startsWith((CharSequence)amountName, (CharSequence)"begin");
                if (StringUtils.equals((CharSequence)fieldName, (CharSequence)amountName) || mark && amountName.replace("begin", "end").equals(fieldName)) {
                    e.setBackColor("#DCFAE4");
                }
                e.setContext(new ListColumnContext(Collections.singletonList(fieldName), false));
                e.setUserConfigColumnSettings(null);
                args.getListColumns().add(e);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u7684\u6570\u636e\u6e90\u672a\u914d\u7f6e\u4e0b\u94bb\u5c55\u793a\u5b57\u6bb5\uff0c\u5982\u9700\u4e0b\u94bb\u5c55\u793a\u660e\u7ec6\u8bf7\u5728\u81ea\u5b9a\u4e49\u6570\u636e\u6e90\u4e2d\u8fdb\u884c\u914d\u7f6e", (String)"DraftAmountDetailFormPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
    }

    @Override
    public void accept(ListRowSortEvent evt) {
        evt.getSource();
    }
}

