/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account;

import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.tcvat.business.service.account.AccountSelectFormService;
import kd.taxc.tcvat.common.constant.DraftConstant;

public class EditSelectFormPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String TABAP = "tabap";
    private static final Set<String> HZ_TAXPAYER_TYPE = Sets.newHashSet((Object[])new String[]{"zzsybnsr_yz_zjg", "zzsybnsr_ybhz", "zzsybnsr_hz_zjg"});

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addTabSelectListener(this, TABAP);
    }

    public void afterCreateNewData(EventObject e) {
        Tab tab = (Tab)this.getControl(TABAP);
        if (null != tab) {
            this.showPage(tab.getCurrentTab());
        }
    }

    private void showPage(String currentTab) {
        Object taxpayerType;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String fieldName = (String)customParams.get("fieldName");
        if ("tcvat_wait_deduct_summary".equals(customParams.get("updateDraft")) || "tcvat_hz_wait_deduct_sum".equals(customParams.get("updateDraft")) || "tcvat_waitdeduct_sum_sjjt".equals(customParams.get("updateDraft")) || DraftConstant.YBHZ_HZ_WAIT_DEDUCT_SUM_SJJT.equals(customParams.get("updateDraft"))) {
            fieldName = "waitdeduction";
        }
        if (HZ_TAXPAYER_TYPE.contains(taxpayerType = customParams.get("taxpayertype"))) {
            AccountSelectFormService.showPopPage("Hz_EditSelectFormPlugin", this.getView(), this.getPageCache(), "record".equals(currentTab) ? currentTab : fieldName);
            return;
        }
        if ("zzsyjskb".equals(taxpayerType)) {
            AccountSelectFormService.showPopPage("Yjskb_EditSelectFormPlugin", this.getView(), this.getPageCache(), "record".equals(currentTab) ? currentTab : fieldName);
            return;
        }
        if ("zzsxgmnsr".equals(taxpayerType)) {
            AccountSelectFormService.showPopPage("Small_EditSelectFormPlugin", this.getView(), this.getPageCache(), "record".equals(currentTab) ? currentTab : fieldName);
        } else {
            AccountSelectFormService.showPopPage("EditSelectFormPlugin", this.getView(), this.getPageCache(), "record".equals(currentTab) ? currentTab : fieldName);
        }
    }

    public void addTabSelectListener(TabSelectListener form, String ... tabName) {
        for (int i = 0; i < tabName.length; ++i) {
            Tab tab = (Tab)this.getControl(tabName[i]);
            if (tab == null) continue;
            tab.addTabSelectListener(form);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        this.showPage(evt.getTabKey());
    }
}

