/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcvat.formplugin.account.AbstractEditPopFormPlugin;

public class InvoiceDetailsFormPlugin
extends AbstractEditPopFormPlugin
implements EntryGridBindDataListener {
    private static DecimalFormat format = new DecimalFormat("#%");
    private static final String entityName = "tcvat_income_invoice";

    @Override
    protected void queryRightList(Map<String, Object> customParams) {
        QFilter qFilter = new QFilter("taxaccountserialno", "=", customParams.get("taxaccountserialno"));
        IDataModel model = this.getModel();
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityName, (String)"taxperiod,invoiceamount,table,taxrate,taxamount,filtercondition,conditionjson,differenceinvoice", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObjects.size() > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", dynamicObjects.size());
            int rowIndex = 0;
            for (DynamicObject dynamicObject : dynamicObjects) {
                model.setValue("taxperiod", dynamicObject.get("taxperiod"), rowIndex);
                model.setValue("invoiceamount", dynamicObject.get("invoiceamount"), rowIndex);
                model.setValue("table", dynamicObject.get("table"), rowIndex);
                model.setValue("taxrate", (Object)this.format1(dynamicObject.getBigDecimal("taxrate")), rowIndex);
                model.setValue("taxamount", dynamicObject.get("taxamount"), rowIndex);
                model.setValue("filtercondition", dynamicObject.get("filtercondition"), rowIndex);
                model.setValue("conditionjson", dynamicObject.get("conditionjson"), rowIndex);
                model.setValue("differenceinvoice", dynamicObject.get("differenceinvoice"), rowIndex);
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    @Override
    protected void addCustomParams(Map<String, Object> customParams) {
        super.addCustomParams(customParams);
        customParams.put("entityType", entityName);
        customParams.put("ruleEntry", "tcvat_rule_income");
    }

    private synchronized String format1(BigDecimal taxrate) {
        return format.format(taxrate);
    }
}

