/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.constant.DraftExportConstant;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.formplugin.account.AbstractAccountingPlugin;

public class PerprePlugin
extends AbstractAccountingPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.init();
        boolean readonly = (Boolean)this.getView().getFormShowParameter().getCustomParam("readonly");
        if (readonly) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        }
    }

    private void init() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataInfo perpreDraftMetaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParams).getPerpre();
        Object orgid = customParams.get("orgid");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        String deadLine = (String)customParams.get("deadLine");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid.toString()));
        QFilter taxPeriodFilter = new QFilter("taxperiod", "in", PeriodService.getPeriodList(skssqq, skssqz));
        QFilter deadLineFilter = new QFilter("deadline", "=", (Object)deadLine);
        DynamicObject[] dObjects = BusinessDataServiceHelper.load((String)perpreDraftMetaData.getAccountMetaDataName(), (String)"id,serialno,taxperiod,bizname,perpreproject,currentamount", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, deadLineFilter}, (String)"taxperiod,perpreproject.number");
        if (dObjects.length > 0) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", dObjects.length);
            int rowIndex = 0;
            for (DynamicObject dynamicObject : dObjects) {
                model.setValue("id", dynamicObject.get("id"), rowIndex);
                model.setValue("serialno", dynamicObject.get("serialno"), rowIndex);
                model.setValue("taxperiod", dynamicObject.get("taxperiod"), rowIndex);
                model.setValue("bizname", dynamicObject.get("bizname"), rowIndex);
                model.setValue("perpreproject", dynamicObject.get("perpreproject"), rowIndex);
                model.setValue("currentamount", dynamicObject.get("currentamount"), rowIndex);
                this.markEditCell(model, rowIndex, "entryentity");
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
        this.getView().setVisible(Boolean.valueOf("ajsb".equalsIgnoreCase(deadLine)), new String[]{"taxperiod"});
        this.setParentCache();
    }

    private void setParentCache() {
        String entityId = this.getView().getEntityId();
        String pluginName = DraftExportConstant.getClassName((String)entityId);
        IPageCache parentPageCache = null;
        if (this.getView().getParentView() != null && this.getView().getParentView().getParentView() != null && this.getView().getParentView().getParentView().getParentView() != null) {
            parentPageCache = this.getView().getParentView().getParentView().getParentView().getPageCache();
        }
        if (parentPageCache != null) {
            parentPageCache.put("draftPageId", this.getView().getPageId());
            parentPageCache.put("entryEntityName", "entryentity");
            parentPageCache.put("pluginFeildExpandStr", "");
            parentPageCache.put("draftDataDtoPluginName", pluginName);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataInfo draftMetaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParamMap).getPerpre();
        int rowIndex = evt.getRowIndex();
        String fieldName = evt.getFieldName();
        DynamicObject perpreproject = (DynamicObject)this.getModel().getValue("perpreproject", rowIndex);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("tcvat_income_invoice_tab");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("id", this.getModel().getValue("id", rowIndex));
        parameter.setCustomParam("orgid", customParamMap.get("orgid"));
        parameter.setCustomParam("fieldName", (Object)fieldName);
        parameter.setCustomParam("type", (Object)fieldName);
        parameter.setCustomParam("description", this.getModel().getValue("bizname", rowIndex));
        parameter.setCustomParam("amount", this.getModel().getValue(fieldName, rowIndex));
        parameter.setCustomParam("draftnumber", customParamMap.get("draftnumber"));
        parameter.setCustomParam("drafttype", customParamMap.get("drafttype"));
        parameter.setCustomParam("billstatus", customParamMap.get("billstatus"));
        parameter.setCustomParam("draftpurpose", customParamMap.get("draftpurpose"));
        parameter.setCustomParam("taxPayerType", customParamMap.get("taxpayertype"));
        parameter.setCustomParam("taxaccountserialno", this.getModel().getValue("serialno", rowIndex));
        parameter.setCustomParam("entry", (Object)draftMetaData.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_PERPRE_DETAIL));
        parameter.setCustomParam("updateDraft", (Object)draftMetaData.getAccountMetaDataName());
        parameter.setCustomParam("perpreprojectnumber", (Object)perpreproject.getString("number"));
        if ("currentamount".equals(fieldName)) {
            String caption = ResManager.loadKDString((String)"\u5206\u6b21\u9884\u7f34\u9879\u76ee\u672c\u671f\u53d1\u751f\u989d\u53d6\u6570\u660e\u7ec6\u8868", (String)"PerprePlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]);
            parameter.setCaption(caption);
            parameter.setCustomParam("cellName", (Object)ResManager.loadKDString((String)"\u672c\u671f\u53d1\u751f\u989d", (String)"PerprePlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        this.getView().showForm(parameter);
    }
}

