/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcvat.business.service.account.AccountSelectFormService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.common.enums.TaxdataTabEnum;

public class SmallScaleAccountSelectFormPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String TABAP = "tabap";
    private static final String BTN_FASTSETTING = "btnfastsetting";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addTabSelectListener(this, TABAP);
        this.addClickListeners(new String[]{BTN_FASTSETTING});
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Button && ((Button)evt.getSource()).getKey().equals(BTN_FASTSETTING)) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            Tab tab = (Tab)this.getControl(TABAP);
            String tabKey = tab.getCurrentTab();
            HashMap customParams = new HashMap();
            customParams.put("orgid", params.get("orgid"));
            customParams.put("ruletype", "private");
            if ("income".equals(tabKey)) {
                customParams.put("CURRENT_TAB", "incomeruletab");
            }
            if ("diff".equals(tabKey)) {
                customParams.put("CURRENT_TAB", "diffruletab");
            }
            if ("taxreduction".equals(tabKey)) {
                customParams.put("CURRENT_TAB", "taxdeductiontab");
            }
            PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)"tcvat_rule_configs", (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.setTabVisible(customParams);
        Tab tab = (Tab)this.getControl(TABAP);
        if (null != tab) {
            AccountSelectFormService.showPage("SmallScaleAccountSelectFormPlugin", this.getView(), this.getPageCache(), tab.getCurrentTab());
            this.setParenCache(tab.getCurrentTab());
        }
    }

    private void setTabVisible(Map<String, Object> customParams) {
        DraftMetaDataDTO metaDataDTO;
        QFilter draftPurposeFilter;
        QFilter taxPayerTypeFilter;
        QFilter reportPeriodFilter;
        QFilter orgidFilter = new QFilter("orgid", "=", (Object)Long.parseLong((String)customParams.get("orgid")));
        DynamicObject polciyConfirm = QueryServiceHelper.queryOne((String)"tcvat_xgm_policy_confirm", (String)"ruledata_tag", (QFilter[])new QFilter[]{orgidFilter, reportPeriodFilter = new QFilter("reportperiod", ">=", (Object)DateUtils.getDayFirst((Date)DateUtils.stringToDate((String)((String)customParams.get("skssqq"))))).and(new QFilter("reportperiod", "<=", (Object)DateUtils.getDayLast((Date)DateUtils.stringToDate((String)((String)customParams.get("skssqz")))))), taxPayerTypeFilter = new QFilter("taxplayeraptitude", "=", (Object)"zzsxgmnsr"), draftPurposeFilter = new QFilter("draftpurpose", "=", (Object)(metaDataDTO = DraftMetaDataDTO.getMetaDataByCustomParam(customParams)).getDraftPurpose())});
        if (null == polciyConfirm) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"diff", "rollout", "taxreduction", "deductionrate"});
            return;
        }
        String ruledata_tag = polciyConfirm.getString("ruledata_tag");
        JSONObject object = JSONObject.parseObject((String)ruledata_tag);
        if (null == object) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"diff", "decrease"});
            return;
        }
        JSONArray diffs = object.getJSONArray(RuleTypeEnum.DIFF.name());
        this.getView().setVisible(Boolean.valueOf(diffs.size() > 0), new String[]{"diff"});
        JSONArray deducts = object.getJSONArray(RuleTypeEnum.REDUCE.name());
        this.getView().setVisible(Boolean.valueOf(deducts.size() > 0), new String[]{"taxreduction"});
    }

    public void addTabSelectListener(TabSelectListener form, String ... tabName) {
        for (int i = 0; i < tabName.length; ++i) {
            Tab tab = (Tab)this.getControl(tabName[i]);
            if (tab == null) continue;
            tab.addTabSelectListener(form);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        AccountSelectFormService.setVisibleForFastSetting(this.getView(), evt.getTabKey());
        AccountSelectFormService.showPage("SmallScaleAccountSelectFormPlugin", this.getView(), this.getPageCache(), evt.getTabKey());
        this.setParenCache(evt.getTabKey());
    }

    private void setParenCache(String sheetName) {
        IPageCache parentPageCache;
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && (parentPageCache = (IPageCache)parentView.getService(IPageCache.class)) != null) {
            parentPageCache.put("sheetName", TaxdataTabEnum.getNameByValue(sheetName));
        }
    }
}

