/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.DraftExportConstant;
import kd.taxc.bdtaxr.common.db.DataSaveService;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.formula.biz.FormulaService;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.account.RecordDraftModifyDataService;

public class SmallScaleCurrentPayFormPlugin
extends AbstractFormPlugin
implements TreeNodeQueryListener {
    public static final String treeentryentity = "treeentryentity";

    public void registerListener(EventObject e) {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(treeentryentity);
        entryGrid.addCellClickListener((TreeNodeQueryListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object startDate = customParams.get("startDate");
        Object endDate = customParams.get("endDate");
        Object orgid = customParams.get("orgid");
        String deadLine = (String)customParams.get("deadLine");
        String draftpurpose = (String)customParams.get("draftpurpose");
        String templateType = TaxDeclareHelper.getXgmTemplateType(deadLine, draftpurpose);
        String dataName = "sjjt".equals(draftpurpose) ? "tcvat_xgm_current_pay_jt" : "tcvat_xgm_current_payment";
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldObjValue = changeData.getOldValue();
        BigDecimal nValue = BigDecimal.ZERO;
        BigDecimal oldValue = BigDecimal.ZERO;
        if (oldObjValue instanceof String && newValue instanceof String) {
            String oldValueStr;
            String newValueStr = ((String)newValue).replace(",", "");
            if (newValueStr.matches("[-+]?\\d+(?:\\.\\d+)?")) {
                nValue = new BigDecimal(newValueStr);
            }
            if ((oldValueStr = ((String)oldObjValue).replace(",", "")).matches("[-+]?\\d+(?:\\.\\d+)?")) {
                oldValue = new BigDecimal(oldValueStr);
            }
        }
        if (oldObjValue instanceof BigDecimal && newValue instanceof BigDecimal) {
            nValue = (BigDecimal)newValue;
            oldValue = (BigDecimal)oldObjValue;
        }
        int rowNo = changeData.getRowIndex() + 1;
        String cellId = dataName + "#" + rowNo + "#" + propertyName;
        Map valueMap = FormulaService.query((IPageCache)this.getPageCache(), (String)templateType, (String)orgid.toString(), (String)startDate.toString(), (String)endDate.toString(), (boolean)false);
        Map newData = FormulaService.cal((IPageCache)this.getPageCache(), (String)cellId, (String)newValue.toString());
        DataSaveService.mapToTable((String)"tcvat_nsrxx", (Map)newData);
        String drafttype = (String)customParams.get("drafttype");
        String draftnumber = (String)customParams.get("draftnumber");
        RecordDraftModifyDataService.recordModify((String)orgid, oldValue, nValue, "0", drafttype, draftnumber);
        this.getView().invokeOperation("refresh");
        this.getView().sendFormAction(this.getView());
    }

    public void afterCreateNewData(EventObject e) {
        QFilter sbbidFilter;
        String dataName;
        DynamicObjectCollection genericObjects;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgid = (String)customParams.get("orgid");
        Object startDate = customParams.get("startDate");
        Object endDate = customParams.get("endDate");
        String deadLine = (String)customParams.get("deadLine");
        String draftpurpose = (String)customParams.get("draftpurpose");
        String templateType = TaxDeclareHelper.getXgmTemplateType(deadLine, draftpurpose);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        QFilter deadLineFilter = new QFilter("deadline", "=", (Object)deadLine);
        DynamicObject dyo = YbnsrService.queryYbnsr((String)orgid, (String)templateType, (String)startDate.toString(), (String)endDate.toString(), null);
        String id = "";
        if (null != dyo && (genericObjects = QueryServiceHelper.query((String)(dataName = "sjjt".equals(draftpurpose) ? "tcvat_xgm_current_pay_jt" : "tcvat_xgm_current_payment"), (String)"id,org,pid,serialno,ewblxh,sbbid,taxperiod,description,incomeincludtax,specialincludtax,diffammount,salesincludtax,taxrate,salesexcludtax,taxableamount,taxfreeamount", (QFilter[])new QFilter[]{deadLineFilter, orgFilter, sbbidFilter = new QFilter("sbbid", "=", (Object)(id = dyo.getString("id")))})).size() > 0) {
            EntityField field = new EntityField();
            field.setFieldType("Decimal");
            field.setScale(2);
            IDataModel model = this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow(treeentryentity, genericObjects.size());
            for (DynamicObject dynamicObject : genericObjects) {
                int index = Integer.parseInt(dynamicObject.get("ewblxh").toString()) - 1;
                model.setValue("id", dynamicObject.get("id"), index);
                model.setValue("org", dynamicObject.get("org"), index);
                if (24 != index) {
                    model.setValue("taxperiod", dynamicObject.get("taxperiod"), index);
                }
                model.setValue("serialno", dynamicObject.get("serialno"), index);
                model.setValue("description", dynamicObject.get("description"), index);
                model.setValue("incomeincludtax", (Object)TemplateUtils.dataFormat((Object)dynamicObject.getBigDecimal("incomeincludtax").setScale(2, 4), (EntityField)field), index);
                model.setValue("specialincludtax", (Object)TemplateUtils.dataFormat((Object)dynamicObject.getBigDecimal("specialincludtax").setScale(2, 4), (EntityField)field), index);
                model.setValue("diffammount", (Object)TemplateUtils.dataFormat((Object)dynamicObject.getBigDecimal("diffammount").setScale(2, 4), (EntityField)field), index);
                model.setValue("salesincludtax", (Object)TemplateUtils.dataFormat((Object)dynamicObject.getBigDecimal("salesincludtax").setScale(2, 4), (EntityField)field), index);
                if (dynamicObject.getBigDecimal("taxrate").compareTo(new BigDecimal("103")) != 0) {
                    model.setValue("taxrate", (Object)(dynamicObject.getBigDecimal("taxrate").setScale(0, 4) + "%"), index);
                } else {
                    String taxrate = ResManager.loadKDString((String)"1%\u62163%", (String)"SmallScaleCurrentPayFormPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]);
                    model.setValue("taxrate", (Object)taxrate, index);
                }
                model.setValue("salesexcludtax", (Object)dynamicObject.getBigDecimal("salesexcludtax").setScale(2, 4), index);
                model.setValue("taxableamount", (Object)TemplateUtils.dataFormat((Object)dynamicObject.getBigDecimal("taxableamount").setScale(2, 4), (EntityField)field), index);
                model.setValue("taxfreeamount", (Object)TemplateUtils.dataFormat((Object)dynamicObject.getBigDecimal("taxfreeamount").setScale(2, 4), (EntityField)field), index);
                this.setEnable(index, model);
            }
            model.endInit();
            this.getView().updateView(treeentryentity);
        }
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(treeentryentity);
        treeEntryGrid.setCollapse(false);
        boolean readonly = (Boolean)this.getView().getFormShowParameter().getCustomParam("readonly");
        if (readonly) {
            this.getView().setEnable(Boolean.FALSE, new String[]{treeentryentity});
        }
        String entityId = this.getView().getEntityId();
        String pluginName = DraftExportConstant.getClassName((String)entityId);
        IPageCache parentPageCache = null;
        if (this.getView().getParentView() != null && this.getView().getParentView().getParentView() != null) {
            parentPageCache = this.getView().getParentView().getParentView().getPageCache();
        }
        if (parentPageCache != null) {
            parentPageCache.put("draftPageId", this.getView().getPageId());
            parentPageCache.put("entryEntityName", treeentryentity);
            parentPageCache.put("pluginFeildExpandStr", "");
            parentPageCache.put("draftDataDtoPluginName", pluginName);
        }
    }

    private void setEnable(int index, IDataModel model) {
        if (4 != index && 12 != index && 20 != index) {
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"specialincludtax"});
        }
        if (3 != index && 11 != index && 19 != index) {
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"diffammount"});
        }
        if (5 == index || 13 == index || 21 == index) {
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"salesexcludtax"});
        }
        if (7 == index || 15 == index || 23 == index || 24 == index) {
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"salesexcludtax"});
        }
        if (6 <= index && 7 >= index || 14 <= index && 15 >= index || 22 <= index && 24 >= index) {
            model.setValue("incomeincludtax", (Object)"\u2014\u2014", index);
        }
        if (5 <= index && 7 >= index || 13 <= index && 15 >= index || 21 <= index && 24 >= index) {
            model.setValue("specialincludtax", (Object)"\u2014\u2014", index);
        }
        if (0 == index || 4 == index || 6 <= index && 8 >= index || 12 == index || 14 <= index && 16 >= index || 20 == index || 22 <= index && 24 >= index) {
            model.setValue("diffammount", (Object)"\u2014\u2014", index);
            model.setValue("salesincludtax", (Object)"\u2014\u2014", index);
        }
        if (0 == index || 4 <= index && 8 >= index || 12 <= index && 16 >= index || 20 <= index && 24 >= index) {
            model.setValue("taxrate", (Object)"\u2014\u2014", index);
        }
        if (5 <= index && 6 >= index || 13 <= index && 14 >= index || 21 <= index && 22 >= index) {
            model.setValue("taxableamount", (Object)"\u2014\u2014", index);
            model.setValue("taxfreeamount", (Object)"\u2014\u2014", index);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
    }
}

