/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.PartitionSaveTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.utils.ReductionUtils;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.formplugin.account.AbstractAccountingPlugin;

public class TaxReductionAccountFormPlugin
extends AbstractAccountingPlugin
implements HyperLinkClickListener {
    private static final String FIELD_CURRENT_AMOUNT = "currentamount";

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataInfo taxReductionMetaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParams).getTaxReduction();
        String taxPayerType = (String)customParams.get("taxpayertype");
        Object orgid = customParams.get("orgid");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        Object deadLine = customParams.get("deadLine");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid.toString()));
        QFilter deadLineFilter = new QFilter("deadline", "=", (Object)(Objects.isNull(deadLine) ? "" : deadLine));
        QFilter taxPeriodFilter = new QFilter("taxperiod", "in", PeriodService.getPeriodList(skssqq, skssqz));
        QFilter taxPayerTypeFilter = new QFilter("taxpayertype", "in", Arrays.asList(taxPayerType, taxPayerType.replace("zzs", "")));
        IDataModel model = this.getModel();
        DynamicObject[] genericObjects = BusinessDataServiceHelper.load((String)taxReductionMetaData.getAccountMetaDataName(), (String)"id,taxperiod,serialno,description,taxreductioncode,taxreductionname,taxreductiontype,currentamount", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, deadLineFilter, taxPayerTypeFilter}, (String)"taxperiod,taxreductioncode");
        if (genericObjects.length > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", genericObjects.length);
            int rowIndex = 0;
            for (DynamicObject dynamicObject : genericObjects) {
                model.setValue("id", dynamicObject.get("id"), rowIndex);
                model.setValue("taxperiod", dynamicObject.get("taxperiod"), rowIndex);
                model.setValue("serialno", dynamicObject.get("serialno"), rowIndex);
                model.setValue("description", dynamicObject.get("description"), rowIndex);
                model.setValue("taxreductioncode", dynamicObject.get("taxreductioncode"), rowIndex);
                model.setValue("taxreductionname", dynamicObject.get("taxreductionname"), rowIndex);
                model.setValue("taxreductiontype", dynamicObject.get("taxreductiontype"), rowIndex);
                model.setValue(FIELD_CURRENT_AMOUNT, dynamicObject.get(FIELD_CURRENT_AMOUNT), rowIndex);
                this.markEditCell(model, rowIndex, "entryentity");
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
        this.getView().setVisible(Boolean.valueOf("ajsb".equalsIgnoreCase(Objects.isNull(deadLine) ? "" : String.valueOf(deadLine))), new String[]{"taxperiod"});
        super.afterCreateData(null);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("hyperLinkClick".endsWith(actionId)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String orgidStr = (String)customParams.get("orgid");
            String skssqqStr = (String)customParams.get("skssqq");
            String skssqzStr = (String)customParams.get("skssqz");
            String taxPayerType = (String)customParams.get("taxpayertype");
            Date skssqq = DateUtils.stringToDate((String)skssqqStr);
            Date skssqz = DateUtils.stringToDate((String)skssqzStr);
            Object deadLine = customParams.get("deadLine");
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgidStr));
            QFilter deadLineFilter = new QFilter("deadline", "=", (Object)(deadLine == null ? "" : deadLine));
            QFilter taxPeriodFilter = new QFilter("taxperiod", "in", PeriodService.getPeriodList(skssqq, skssqz));
            QFilter taxPayerTypeFilter = new QFilter("taxpayertype", "in", Arrays.asList(taxPayerType, taxPayerType.replace("zzs", "")));
            TcvatEngineModel model = TaxDeclareHelper.buildEngineModel(orgidStr, skssqqStr, skssqzStr, taxPayerType, null, (String)customParams.get("draftpurpose"));
            DynamicObjectCollection genericObjects = QueryServiceHelper.query((String)model.getDraftMetaDataDTO().getTaxReduction().getAccountMetaDataName(), (String)MetadataUtil.getAllFieldToQuery((String)model.getDraftMetaDataDTO().getTaxReduction().getAccountMetaDataName()), (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, deadLineFilter, taxPayerTypeFilter}, (String)"taxperiod");
            if (genericObjects.size() > 0) {
                List<DynamicObject> groupSummaryDataList;
                String taxperiod = skssqqStr.substring(0, 7);
                QFilter periodFilter = new QFilter("taxperiod", "=", (Object)taxperiod);
                DeleteServiceHelper.delete((String)model.getDraftMetaDataDTO().getTaxReduction().getDetailMetaDataNameMap().get(DraftConstant.YBNSR_TAX_REDUCETION_SUM), (QFilter[])new QFilter[]{orgFilter, periodFilter, deadLineFilter});
                String templateType = "zzsybnsr";
                if (taxPayerType != null) {
                    templateType = taxPayerType.startsWith("zzs") ? taxPayerType : "zzs" + taxPayerType;
                }
                if (!(groupSummaryDataList = ReductionUtils.groupSummaryData(templateType, model, (List<DynamicObject>)genericObjects)).isEmpty()) {
                    ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(groupSummaryDataList));
                }
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String serialno = (String)this.getModel().getValue("serialno", rowIndex);
        String fieldName = evt.getFieldName();
        Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParamMap);
        if (FIELD_CURRENT_AMOUNT.equals(fieldName)) {
            String caption = ResManager.loadKDString((String)"\u51cf\u514d\u7a0e\u53f0\u8d26\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"TaxReductionAccountFormPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCaption(caption);
            parameter.setFormId("tcvat_income_invoice_tab");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("taxaccountserialno", (Object)serialno);
            parameter.setCustomParam("entry", (Object)metaData.getTaxReduction().getDetailMetaDataNameMap().get(DraftConstant.YBNSR_TAX_REDUCTION_DETAIL));
            parameter.setCustomParam("updateDraft", (Object)metaData.getTaxReduction().getAccountMetaDataName());
            parameter.setCustomParam("orgid", customParamMap.get("orgid"));
            parameter.setCustomParam("id", this.getModel().getValue("id", rowIndex));
            parameter.setCustomParam("fieldName", (Object)fieldName);
            parameter.setCustomParam("cellName", (Object)ResManager.loadKDString((String)"\u672c\u671f\u53d1\u751f\u989d", (String)"TaxReductionAccountFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            parameter.setCustomParam("description", this.getModel().getValue("description", rowIndex));
            parameter.setCustomParam("amount", this.getModel().getValue(fieldName, rowIndex));
            parameter.setCustomParam("draftnumber", customParamMap.get("draftnumber"));
            parameter.setCustomParam("drafttype", customParamMap.get("drafttype"));
            parameter.setCustomParam("billstatus", customParamMap.get("billstatus"));
            parameter.setCustomParam("draftpurpose", customParamMap.get("draftpurpose"));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "hyperLinkClick");
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameter);
        }
    }
}

