/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account.fdckf;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.outputtax.fdckf.EstateSalesConfirmLedgerService;

public class DeductDetailDiagoPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit base = (BasedataEdit)this.getView().getControl("org");
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1));
        this.getModel().setValue("skssqq", (Object)firstDateOfMonth);
        List orgs = (List)this.getView().getFormShowParameter().getCustomParam("orgids");
        if (orgs != null) {
            Object[] collect = orgs.stream().filter(a -> a != null && StringUtil.isNotEmpty((CharSequence)a)).map(a -> Long.parseLong(a)).toArray();
            this.getModel().setValue("org", (Object)collect);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String itemKey = control.getKey();
        if ("btnok".equals(itemKey)) {
            Date skssqq = (Date)this.getModel().getValue("skssqq");
            Date skssqz = (Date)this.getModel().getValue("skssqz");
            Map<String, Object> validSkssq = EstateSalesConfirmLedgerService.validSkssq(skssqq, skssqz, null);
            if (Boolean.FALSE.toString().equals(validSkssq.get("success"))) {
                this.getView().showTipNotification((String)validSkssq.get("msg"));
                return;
            }
            HashMap<String, String> returnData = new HashMap<String, String>();
            returnData.put("skssqq", DateUtils.format((Date)skssqq));
            returnData.put("skssqz", DateUtils.format((Date)skssqz));
            DynamicObjectCollection orgid = this.getOrgid();
            DynamicObjectCollection projectid = (DynamicObjectCollection)this.getModel().getValue("project");
            String orgids = orgid.stream().map(a -> a.getString("fbasedataid_id")).collect(Collectors.joining(","));
            String projectids = projectid.stream().map(a -> a.getString("fbasedataid_id")).collect(Collectors.joining(","));
            for (DynamicObject dynamicObject : orgid) {
                DynamicObject fbasedataid = dynamicObject.getDynamicObject("fbasedataid");
                long id = fbasedataid.getLong("id");
                String name = fbasedataid.getString("name");
                validSkssq = EstateSalesConfirmLedgerService.validSkssqTaxLimit(skssqq, skssqz, id, name);
                if (!Boolean.FALSE.toString().equals(validSkssq.get("success"))) continue;
                this.getView().showTipNotification((String)validSkssq.get("msg"));
                return;
            }
            returnData.put("orgids", orgids);
            returnData.put("projectids", projectids);
            this.getView().setReturnData(returnData);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("skssqq".equals(name) || "skssqz".equals(name)) {
            Date skssqq = (Date)this.getModel().getValue("skssqq");
            Date skssqz = (Date)this.getModel().getValue("skssqz");
            Map<String, Object> validSkssq = EstateSalesConfirmLedgerService.validSkssq(skssqq, skssqz, null);
            if (Boolean.FALSE.toString().equals(validSkssq.get("success"))) {
                this.getView().showTipNotification((String)validSkssq.get("msg"));
            }
        } else if ("org".equals(name)) {
            DynamicObjectCollection orgid = this.getOrgid();
            Set orgids = orgid.stream().map(a -> a.getLong("fbasedataid_id")).collect(Collectors.toSet());
            DynamicObjectCollection project = (DynamicObjectCollection)this.getModel().getValue("project");
            if (project.size() > 0) {
                Iterator iterator = project.iterator();
                while (iterator.hasNext()) {
                    DynamicObject next = (DynamicObject)iterator.next();
                    DynamicObject fbasedataid = next.getDynamicObject("fbasedataid");
                    long porg = fbasedataid.getLong("taxorg.id");
                    if (orgids.contains(porg)) continue;
                    iterator.remove();
                }
                this.getModel().setValue("project", (Object)project);
                this.getView().updateView("project");
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (name.startsWith("project")) {
            DynamicObjectCollection orgid = this.getOrgid();
            if (orgid == null || orgid.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"DeductDetailDiagoPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Set orgids = orgid.stream().map(a -> a.getLong("fbasedataid_id")).collect(Collectors.toSet());
            QFilter qFilter3 = new QFilter("taxorg", "in", orgids);
            beforeF7SelectEvent.getCustomQFilters().add(qFilter3);
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.getTreeFilterParameter().getQFilters().add(new QFilter("number", "in", (Object)"001"));
            listShowParameter.getListFilterParameter().setFilter(new QFilter("group.number", "=", (Object)"001"));
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("focusNodeId", (Object)"1888314377338207232");
        }
    }

    public DynamicObjectCollection getOrgid() {
        DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org");
        return org;
    }
}

