/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account.fdckf;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckBillPlugin;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.outputtax.fdckf.EstateSalesConfirmLedgerService;

public class EstateSalesConfirmLedgerEditPlugin
extends AbstractLicenseCheckBillPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit base = (BasedataEdit)this.getView().getControl("org");
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit stage = (BasedataEdit)this.getView().getControl("stage");
        stage.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterCreateNewData(EventObject e) {
        if (!"true".equals(this.getModel().getContextVariable("isChangingMainOrg"))) {
            DynamicObject defaultorg = (DynamicObject)this.getModel().getValue("org");
            Long org = defaultorg != null ? defaultorg.getLong("id") : RequestContext.get().getOrgId();
            DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)PermissionUtils.getAllPermOrgs((IFormView)this.getView()), (boolean)true);
            Long orgid = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)org, (DynamicObjectCollection)col);
            if (orgid == null) return;
            Boolean approve = (Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgIdAndIsTaxpayer((Long)orgid).getData();
            if (!approve.booleanValue()) {
                this.getModel().setValue("org", null);
                return;
            }
            this.setDefaultInfoByOrg(orgid);
            return;
        } else {
            Long orgid = this.getOrgid();
            if (orgid == null) return;
            this.setDefaultInfoByOrg(orgid);
        }
    }

    public void afterBindData(EventObject e) {
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
    }

    public void setDefaultInfoByOrg(Long orgid) {
        Long project = EstateSalesConfirmLedgerService.queryFirstProjectByOrg(orgid);
        this.getModel().setValue("project", (Object)project);
        Map<String, Date> map = PeriodService.preTaxPeriod(orgid.toString(), new Date());
        Date startDate = map.get("startDate");
        Date endDate = map.get("endDate");
        this.getModel().setValue("skssqq", (Object)startDate);
        if (endDate != null) {
            this.getModel().setValue("skssqz", (Object)DateUtils.trunc((Date)endDate));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("recalc".equals(operateKey) && this.calcBaseChangeFire()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97\u6210\u529f\u3002", (String)"EstateSalesConfirmLedgerEditPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (name.startsWith("org")) {
            List<Long> permOrgs = EstateSalesConfirmLedgerService.getPermOrgs(this.getView());
            QFilter qFilter2 = new QFilter("id", "in", permOrgs);
            beforeF7SelectEvent.getCustomQFilters().add(qFilter2);
        } else if (name.startsWith("stage")) {
            Long projectId = this.getProjectId();
            if (projectId == null || projectId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u9879\u76ee\u3002", (String)"EstateSalesConfirmLedgerEditPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter qFilter3 = new QFilter("taxproject", "=", (Object)projectId);
            beforeF7SelectEvent.getCustomQFilters().add(qFilter3);
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u5de5\u7a0b\u9879\u76ee\u5206\u671f", (String)"EstateSalesConfirmLedgerEditPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            listShowParameter.setShowApproved(false);
        } else if (name.startsWith("project")) {
            Long orgid = this.getOrgid();
            if (orgid == null || orgid == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"EstateSalesConfirmLedgerEditPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter qFilter3 = new QFilter("taxorg", "=", (Object)orgid);
            beforeF7SelectEvent.getCustomQFilters().add(qFilter3);
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.getTreeFilterParameter().getQFilters().add(new QFilter("number", "in", (Object)"001"));
            listShowParameter.getListFilterParameter().setFilter(new QFilter("group.number", "=", (Object)"001"));
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("focusNodeId", (Object)"1888314377338207232");
        }
    }

    public Long getOrgid() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        return org == null ? null : Long.valueOf(org.getLong("id"));
    }

    public Long getProjectId() {
        DynamicObject houseproject = (DynamicObject)this.getModel().getValue("project");
        return houseproject == null ? null : Long.valueOf(houseproject.getLong("id"));
    }

    public Long getStage() {
        DynamicObject houseproject = (DynamicObject)this.getModel().getValue("stage");
        return houseproject == null ? null : Long.valueOf(houseproject.getLong("id"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        IDataModel model = this.getModel();
        if ("org".equals(name)) {
            model.beginInit();
            Long orgid = this.getOrgid();
            if (orgid == null || orgid == 0L) {
                model.setValue("project", null);
                model.setValue("skssqq", null);
                model.setValue("skssqz", null);
            } else {
                this.setDefaultInfoByOrg(orgid);
            }
            model.setValue("stage", null);
            this.getModel().deleteEntryData("entryentity");
            model.endInit();
            this.getView().updateView();
        } else if ("project".equals(name)) {
            model.beginInit();
            model.setValue("stage", null);
            this.getModel().deleteEntryData("entryentity");
            model.endInit();
            this.getView().updateView();
        } else if ("stage".equals(name)) {
            this.calcBaseChangeFire();
        } else if ("skssqq".equals(name) || "skssqz".equals(name)) {
            Date skssqq = (Date)this.getModel().getValue("skssqq");
            Date skssqz = (Date)this.getModel().getValue("skssqz");
            Long orgid = this.getOrgid();
            Map<String, Object> validSkssq = EstateSalesConfirmLedgerService.validSkssq(skssqq, skssqz, orgid);
            if (Boolean.FALSE.toString().equals(validSkssq.get("success"))) {
                this.getView().showTipNotification((String)validSkssq.get("msg"));
            } else {
                this.calcBaseChangeFire();
            }
        } else if ("dqkpxse".equals(name)) {
            BigDecimal dqkpxse = (BigDecimal)this.getModel().getValue("dqkpxse", rowIndex);
            this.calcLinked(rowIndex, model, dqkpxse, dqkpxse);
        } else if (Arrays.asList("qyjebhs", "ljskjebhs", "wqkpxse", "wqwkpxse", "dqskjebhs", "dqkpxse", "dqqrxse").contains(name)) {
            BigDecimal dqkpxse = (BigDecimal)this.getModel().getValue("dqkpxse", rowIndex);
            BigDecimal dqqrxse = (BigDecimal)this.getModel().getValue("dqqrxse", rowIndex);
            this.calcLinked(rowIndex, model, dqkpxse, dqqrxse);
        }
    }

    public boolean calcBaseChangeFire() {
        Long projectId = this.getProjectId();
        Long stage = this.getStage();
        Long orgid = this.getOrgid();
        if (projectId != null && projectId != 0L && stage != null && stage != 0L) {
            Date skssqq = (Date)this.getModel().getValue("skssqq");
            Date skssqz = (Date)this.getModel().getValue("skssqz");
            List<Map<String, Object>> result = EstateSalesConfirmLedgerService.calcEntryDefaultData(orgid, projectId, stage, skssqq, skssqz);
            this.setTzEntryData(result);
            return true;
        }
        return false;
    }

    public void calcLinked(int rowIndex, IDataModel model, BigDecimal dqkpxse, BigDecimal dqqrxse) {
        model.beginInit();
        BigDecimal dqwkpxse = dqqrxse.subtract(dqkpxse);
        this.getModel().setValue("dqqrxse", (Object)dqqrxse, rowIndex);
        this.getModel().setValue("dqwkpxse", (Object)dqwkpxse, rowIndex);
        BigDecimal qyjebhs = (BigDecimal)this.getModel().getValue("qyjebhs", rowIndex);
        BigDecimal dqqrxsebl = qyjebhs.compareTo(BigDecimal.ZERO) > 0 ? dqqrxse.divide(qyjebhs, 4, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        this.getModel().setValue("dqqrxsebl", (Object)dqqrxsebl, rowIndex);
        BigDecimal wqkpxse = (BigDecimal)this.getModel().getValue("wqkpxse", rowIndex);
        BigDecimal ljkpxse = dqkpxse.add(wqkpxse);
        this.getModel().setValue("ljkpxse", (Object)ljkpxse, rowIndex);
        BigDecimal wqwkpxse = (BigDecimal)this.getModel().getValue("wqwkpxse", rowIndex);
        BigDecimal ljwkpxse = wqwkpxse.add(dqwkpxse);
        this.getModel().setValue("ljwkpxse", (Object)ljwkpxse, rowIndex);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void setTzEntryData(List<Map<String, Object>> result) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        if (result.size() > 0) {
            model.batchCreateNewEntryRow("entryentity", result.size());
            for (int i = 0; i < result.size(); ++i) {
                Map<String, Object> objectMap = result.get(i);
                for (Map.Entry<String, Object> objectEntry : objectMap.entrySet()) {
                    model.setValue(objectEntry.getKey(), objectEntry.getValue(), i);
                    model.setValue(objectEntry.getKey(), objectEntry.getValue(), i);
                }
            }
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }
}

