/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account.fpisa;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.fpisa.FpisaService;

public class FpisaAccountListPlugin
extends AbstractListPlugin {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                String orderByExpr = super.getOrderByExpr();
                String orderBy = "entryentity.incometype desc";
                if (orderByExpr == null) {
                    super.setOrderByExpr("id desc," + orderBy);
                } else {
                    super.setOrderByExpr(orderByExpr + "," + orderBy);
                }
                DynamicObjectCollection data = super.getData(start, limit);
                HashMap<String, DynamicObject> dataMap = new HashMap<String, DynamicObject>();
                DynamicObjectType dot = data.getDynamicObjectType();
                DynamicObjectCollection showData = new DynamicObjectCollection(dot, data.getParent());
                for (DynamicObject row : data) {
                    DataEntityPropertyCollection properties = row.getDynamicObjectType().getProperties();
                    if (!properties.containsKey((Object)"entryentity.incometype")) continue;
                    String uniqueKey = row.getString("id") + row.getString("entryentity.incometype");
                    DynamicObject show = dataMap.computeIfAbsent(uniqueKey, k -> {
                        DynamicObject d = new DynamicObject(dot);
                        showData.add((Object)d);
                        return d;
                    });
                    FpisaService.updateShowData(row, show);
                }
                this.getQueryResult().setDataCount(showData.size());
                this.getQueryResult().setCollection(showData);
                return showData;
            }
        });
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        String fieldKey = columnDesc.getFieldKey();
        DataEntityPropertyCollection properties = data.getDynamicObjectType().getProperties();
        if (("totalrevenueexcltax".equals(fieldKey) || "totalcostexcltax".equals(fieldKey)) && properties.containsKey((Object)"entryentity.incometype") && properties.containsKey((Object)("entryentity." + fieldKey))) {
            String incometype = data.getString("entryentity.incometype");
            BigDecimal amt = data.getBigDecimal("entryentity." + fieldKey);
            if ("mssr".equals(incometype) && BigDecimal.ZERO.compareTo(amt) == 0) {
                e.setFormatValue((Object)"\u2014\u2014");
            }
        }
        if ("period".equals(columnDesc.getKey())) {
            String date = DateUtils.getStartToEndDate((Date)data.getDate("periodfrom"), (Date)data.getDate("periodto"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            e.setFormatValue((Object)date);
        }
    }
}

