/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account.hzsb;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.taxc.tcvat.business.dao.draft.TcvatHzIncomeInvoiceDao;
import kd.taxc.tcvat.formplugin.account.AbstractEditPopFormPlugin;

public class HzInvoiceDetailsFormPlugin
extends AbstractEditPopFormPlugin
implements EntryGridBindDataListener {
    private static DecimalFormat format = new DecimalFormat("#%");
    private TcvatHzIncomeInvoiceDao tcvatHzIncomeInvoiceDao = new TcvatHzIncomeInvoiceDao();

    @Override
    public void queryRightList(Map<String, Object> customParams) {
        IDataModel model = this.getModel();
        DynamicObjectCollection dynamicObjects = this.tcvatHzIncomeInvoiceDao.queryBySerialno(customParams.get("taxaccountserialno"));
        if (dynamicObjects.size() > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", dynamicObjects.size());
            int rowIndex = 0;
            for (DynamicObject dynamicObject : dynamicObjects) {
                model.setValue("startdate", dynamicObject.get("startdate"), rowIndex);
                model.setValue("suborg", (Object)dynamicObject.getLong("suborg"), rowIndex);
                model.setValue("invoiceamount", dynamicObject.get("invoiceamount"), rowIndex);
                model.setValue("table", dynamicObject.get("table"), rowIndex);
                model.setValue("taxrate", (Object)this.format1(dynamicObject.getBigDecimal("taxrate")), rowIndex);
                model.setValue("taxamount", dynamicObject.get("taxamount"), rowIndex);
                model.setValue("filtercondition", dynamicObject.get("filtercondition"), rowIndex);
                model.setValue("conditionjson", dynamicObject.get("conditionjson"), rowIndex);
                model.setValue("differenceinvoice", dynamicObject.get("differenceinvoice"), rowIndex);
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    @Override
    protected void addCustomParams(Map<String, Object> customParams) {
        super.addCustomParams(customParams);
        customParams.put("entityType", "tcvat_hz_income_invoice");
        customParams.put("ruleEntry", "tcvat_rule_income");
    }

    public synchronized String format1(BigDecimal taxrate) {
        return format.format(taxrate);
    }
}

