/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account.hzsb;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.formplugin.account.AbstractAccountingPlugin;

public class HzPerprePlugin
extends AbstractAccountingPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.init();
        boolean readonly = (Boolean)this.getView().getFormShowParameter().getCustomParam("readonly");
        if (readonly) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        }
        super.afterCreateData(null);
    }

    private void init() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParams);
        DraftMetaDataInfo perpre = metaData.getPerpre();
        IDataModel model = this.getModel();
        Object orgid = customParams.get("orgid");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid.toString()));
        QFilter SkssqFilter = new QFilter("startdate", ">=", (Object)DateUtils.getDayFirst((Date)skssqq)).and(new QFilter("enddate", "<=", (Object)DateUtils.getDayLast((Date)skssqz)));
        QFilter taxpayertypeFilter = new QFilter("taxpayertype", "=", customParams.get("taxpayertype"));
        DynamicObject[] dObjects = BusinessDataServiceHelper.load((String)perpre.getAccountMetaDataName(), (String)"suborg,levelname,declaretype,id,serialno,bizname,perpreproject,currentamount", (QFilter[])new QFilter[]{orgFilter, SkssqFilter, taxpayertypeFilter}, (String)"levelname,suborg,perpreproject.number");
        if (dObjects.length > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", dObjects.length);
            int rowIndex = 0;
            for (DynamicObject dynamicObject : dObjects) {
                model.setValue("id", dynamicObject.get("id"), rowIndex);
                model.setValue("suborg", dynamicObject.getDynamicObject("suborg").get("id"), rowIndex);
                model.setValue("levelname", (Object)dynamicObject.getString("levelname"), rowIndex);
                model.setValue("declaretype", dynamicObject.get("declaretype"), rowIndex);
                model.setValue("serialno", dynamicObject.get("serialno"), rowIndex);
                model.setValue("bizname", dynamicObject.get("bizname"), rowIndex);
                model.setValue("perpreproject", dynamicObject.get("perpreproject"), rowIndex);
                model.setValue("currentamount", dynamicObject.get("currentamount"), rowIndex);
                this.markEditCell(model, rowIndex, "entryentity");
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParamMap);
        DraftMetaDataInfo perpre = metaData.getPerpre();
        int rowIndex = evt.getRowIndex();
        String serialno = (String)this.getModel().getValue("serialno", rowIndex);
        DynamicObject perpreproject = (DynamicObject)this.getModel().getValue("perpreproject", rowIndex);
        DynamicObject suborg = (DynamicObject)this.getModel().getValue("suborg", rowIndex);
        String fieldName = evt.getFieldName();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("tcvat_income_invoice_tab");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("perpreprojectnumber", (Object)perpreproject.getString("number"));
        parameter.setCustomParam("taxaccountserialno", (Object)serialno);
        parameter.setCustomParam("entry", (Object)perpre.getDetailMetaDataNameMap().get(DraftConstant.YBHZ_PERPRE_DET));
        parameter.setCustomParam("updateDraft", (Object)perpre.getAccountMetaDataName());
        parameter.setCustomParam("taxpayertype", customParamMap.get("taxpayertype"));
        parameter.setCustomParam("orgid", suborg.get("id"));
        parameter.setCustomParam("mainorgid", customParamMap.get("orgid"));
        parameter.setCustomParam("id", this.getModel().getValue("id", rowIndex));
        parameter.setCustomParam("fieldName", (Object)fieldName);
        parameter.setCustomParam("type", (Object)fieldName);
        parameter.setCustomParam("cellName", (Object)ResManager.loadKDString((String)"\u672c\u671f\u53d1\u751f\u989d", (String)"HzPerprePlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        parameter.setCustomParam("description", this.getModel().getValue("bizname", rowIndex));
        parameter.setCustomParam("amount", this.getModel().getValue(fieldName, rowIndex));
        parameter.setCustomParam("draftnumber", customParamMap.get("draftnumber"));
        parameter.setCustomParam("drafttype", customParamMap.get("drafttype"));
        parameter.setCustomParam("billstatus", customParamMap.get("billstatus"));
        parameter.setCustomParam("taxperiod", (Object)((String)customParamMap.get("skssqq")).substring(0, 7));
        parameter.setCustomParam("draftpurpose", customParamMap.get("draftpurpose"));
        if ("currentamount".equals(fieldName)) {
            String caption = ResManager.loadKDString((String)"\u5206\u6b21\u9884\u7f34\u672c\u671f\u53d1\u751f\u989d\u53d6\u6570\u660e\u7ec6\u8868", (String)"HzPerprePlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]);
            parameter.setCaption(caption);
            parameter.setCustomParam("cellName", (Object)ResManager.loadKDString((String)"\u672c\u671f\u53d1\u751f\u989d", (String)"HzPerprePlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        this.getView().showForm(parameter);
    }
}

